/*
 * Decompiled with CFR 0.152.
 */
package net.sf.extcos.internal;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.annotation.Inherited;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.sf.extcos.internal.ArraySet;
import net.sf.extcos.spi.AnnotationMetadata;
import net.sf.extcos.spi.QueryContext;
import net.sf.extcos.spi.ResourceAccessor;
import net.sf.extcos.util.Assert;
import net.sf.extcos.util.ClassUtils;
import net.sf.extcos.util.StringUtils;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaResourceAccessor
implements ResourceAccessor {
    private static Logger logger = LoggerFactory.getLogger(JavaResourceAccessor.class);
    private static Method defineClass;
    private static Method resolveClass;
    private static final int ASM_FLAGS = 7;
    private byte[] resourceBytes;
    private URL resourceUrl;
    private String className;
    private Map<String, AnnotationMetadata> annotations;
    private Set<String> interfaces;
    private Set<String> superClasses;
    private boolean isClass;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Class<?> generateClass() {
        if (!this.isClass) {
            return null;
        }
        Class clazz = null;
        ClassLoader loader = QueryContext.getInstance().getClassLoader();
        try {
            defineClass.setAccessible(true);
            resolveClass.setAccessible(true);
            clazz = (Class)defineClass.invoke((Object)loader, this.className, this.resourceBytes, 0, this.resourceBytes.length);
            resolveClass.invoke((Object)loader, clazz);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof LinkageError) {
                try {
                    clazz = Class.forName(this.className, true, loader);
                }
                catch (ClassNotFoundException e1) {
                    logger.error(StringUtils.append("Error creating class from URL [", this.resourceUrl.toString(), "]"), e1);
                }
            } else {
                logger.error(StringUtils.append("Error creating class from URL [", this.resourceUrl.toString(), "]"), e.getCause());
            }
        }
        catch (Exception e) {
            logger.error(StringUtils.append("Error creating class from URL [", this.resourceUrl.toString(), "]"), e);
        }
        finally {
            defineClass.setAccessible(false);
            resolveClass.setAccessible(false);
        }
        return clazz;
    }

    @Override
    public AnnotationMetadata getAnnotationMetadata(Class<? extends Annotation> annotation) {
        if (this.isClass && this.annotations != null && this.annotations.containsKey(annotation.getCanonicalName())) {
            return this.annotations.get(annotation.getCanonicalName());
        }
        return null;
    }

    @Override
    public boolean hasInterface(Class<?> interfaze) {
        if (this.isClass && this.interfaces != null) {
            return this.interfaces.contains(interfaze.getCanonicalName());
        }
        return false;
    }

    @Override
    public boolean isClass() {
        return this.isClass;
    }

    @Override
    public boolean isSubclassOf(Class<?> clazz) {
        if (clazz == Object.class) {
            return true;
        }
        if (this.isClass && this.superClasses != null) {
            return this.superClasses.contains(clazz.getCanonicalName());
        }
        return false;
    }

    @Override
    public void setResourceUrl(URL resourceUrl) {
        Assert.notNull(resourceUrl, Assert.iae());
        try {
            this.resourceBytes = this.readBytes(resourceUrl);
            this.resourceUrl = resourceUrl;
            this.readClassData();
        }
        catch (IOException e) {
            this.isClass = false;
            logger.error("Error reading resource", e);
        }
    }

    private byte[] readBytes(URL resourceUrl) throws IOException {
        int readByte;
        BufferedInputStream classStream = new BufferedInputStream(resourceUrl.openStream());
        ArrayList<Byte> buffer = new ArrayList<Byte>();
        while ((readByte = ((InputStream)classStream).read()) != -1) {
            buffer.add((byte)readByte);
        }
        byte[] bytes = new byte[buffer.size()];
        for (int i = 0; i < buffer.size(); ++i) {
            bytes[i] = (Byte)buffer.get(i);
        }
        return bytes;
    }

    private void readClassData() {
        BooleanHolder isClassHolder = new BooleanHolder();
        NameHolder nameHolder = new NameHolder();
        ClassReader reader = new ClassReader(this.resourceBytes);
        reader.accept(new GeneralVisitor(nameHolder, isClassHolder), 7);
        this.isClass = isClassHolder.value;
        if (this.isClass) {
            this.className = ClassUtils.convertResourcePathToClassName(nameHolder.name);
        } else {
            this.annotations = null;
            this.interfaces = null;
            this.superClasses = null;
            this.resourceBytes = null;
            this.resourceUrl = null;
        }
    }

    private void readSuperClasses(String superName) {
        block4: {
            if (!"java/lang/Object".equals(superName)) {
                if (this.superClasses == null) {
                    this.superClasses = new ArraySet<String>();
                }
                String superClass = ClassUtils.convertResourcePathToClassName(superName);
                this.superClasses.add(superClass);
                try {
                    ClassReader reader = new ClassReader(QueryContext.getInstance().getClassLoader().getResourceAsStream(superName + ".class"));
                    reader.accept(new AnnotatedClassVisitor(){

                        @Override
                        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                            JavaResourceAccessor.this.readSuperClasses(superName);
                        }

                        @Override
                        protected boolean shouldVisitAnnotation(boolean visible) {
                            return visible;
                        }

                        @Override
                        protected boolean shouldAcceptInheritedAnnotationsOnly() {
                            return true;
                        }
                    }, 7);
                }
                catch (Exception e) {
                    if (!logger.isErrorEnabled()) break block4;
                    logger.error("Unable to read super class [" + superClass + "]", e);
                }
            }
        }
    }

    private void readInterfaces(String superName, String[] interfaces) {
        if (this.interfaces == null && interfaces.length > 0) {
            this.interfaces = new ArraySet<String>();
        }
        for (String interfaze : interfaces) {
            this.interfaces.add(ClassUtils.convertResourcePathToClassName(interfaze));
            this.readSuperInterfaces(interfaze);
        }
        this.readInheritedInterfaces(superName);
    }

    private void readInheritedInterfaces(String superName) {
        if ("java/lang/Object".equals(superName)) {
            return;
        }
        this.readSuperInterfaces(superName);
    }

    private void readSuperInterfaces(String type) {
        block2: {
            String interfaze = ClassUtils.convertResourcePathToClassName(type);
            try {
                ClassReader reader = new ClassReader(QueryContext.getInstance().getClassLoader().getResourceAsStream(type + ".class"));
                reader.accept(new ClassVisitor(262144){

                    @Override
                    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                        JavaResourceAccessor.this.readInterfaces(superName, interfaces);
                    }
                }, 7);
            }
            catch (Exception e) {
                if (!logger.isErrorEnabled()) break block2;
                logger.error("Unable to read interface [" + interfaze + "]", e);
            }
        }
    }

    static {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    Class<?> cl = Class.forName("java.lang.ClassLoader");
                    defineClass = cl.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE);
                    resolveClass = cl.getDeclaredMethod("resolveClass", Class.class);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw new RuntimeException("cannot initialize Java Resource Accessor", pae.getException());
        }
    }

    private class AnnotationMetadataImpl
    implements AnnotationMetadata {
        private final Map<String, Object> parameters = new HashMap<String, Object>();

        private AnnotationMetadataImpl() {
        }

        @Override
        public Object getValue(String key) {
            return this.parameters.get(key);
        }

        @Override
        public boolean hasKey(String key) {
            return this.parameters.containsKey(key);
        }

        protected void putParameter(String key, Object value) {
            this.parameters.put(key, value);
        }
    }

    private class AnnotationVisitorImpl
    extends AnnotationVisitor {
        private final AnnotationMetadataImpl metadata;
        private final String className;
        private final boolean inheritedOnly;

        private AnnotationVisitorImpl(String desc, boolean inheritedOnly) {
            super(262144);
            this.metadata = new AnnotationMetadataImpl();
            this.className = Type.getType(desc).getClassName();
            this.inheritedOnly = inheritedOnly;
        }

        @Override
        public void visit(String name, Object value) {
            this.metadata.putParameter(name, value);
        }

        @Override
        public void visitEnum(String name, String desc, String value) {
            try {
                String enumName = Type.getType(desc).getClassName();
                Class<?> enumClass = QueryContext.getInstance().getClassLoader().loadClass(enumName);
                Method valueOf = enumClass.getDeclaredMethod("valueOf", String.class);
                Object object = valueOf.invoke(null, value);
                this.metadata.putParameter(name, object);
            }
            catch (Exception ex) {
                logger.warn("An exception occurred", ex);
            }
        }

        @Override
        public void visitEnd() {
            try {
                Class<?> annotationClass = QueryContext.getInstance().getClassLoader().loadClass(this.className);
                if (this.inheritedOnly && annotationClass.isAnnotationPresent(Inherited.class) || !this.inheritedOnly) {
                    Method[] annotationAttributes;
                    for (Method annotationAttribute : annotationAttributes = annotationClass.getMethods()) {
                        String attributeName = annotationAttribute.getName();
                        Object defaultValue = annotationAttribute.getDefaultValue();
                        if (defaultValue == null || this.metadata.hasKey(attributeName)) continue;
                        this.metadata.putParameter(attributeName, defaultValue);
                    }
                    JavaResourceAccessor.this.annotations.put(this.className, this.metadata);
                }
            }
            catch (ClassNotFoundException ex) {
                logger.error("Class not found - can't determine meta-annotations", ex);
            }
        }
    }

    private class GeneralVisitor
    extends AnnotatedClassVisitor {
        private final NameHolder nameHolder;
        private final BooleanHolder isClassHolder;

        private GeneralVisitor(NameHolder nameHolder, BooleanHolder isClassHolder) {
            this.nameHolder = nameHolder;
            this.isClassHolder = isClassHolder;
        }

        @Override
        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            if (!(Modifier.isAbstract(access) || Modifier.isInterface(access) || this.excludeBecauseIsEnum(version, superName))) {
                this.isClassHolder.value = true;
                this.nameHolder.name = name;
                JavaResourceAccessor.this.readInterfaces(superName, interfaces);
                JavaResourceAccessor.this.readSuperClasses(superName);
            }
        }

        private boolean excludeBecauseIsEnum(int version, String superName) {
            boolean isEnum = false;
            if (version >= 49 && "java/lang/Enum".equals(superName)) {
                isEnum = true;
            }
            return isEnum && !QueryContext.getInstance().isIncludeEnums();
        }

        @Override
        public void visitInnerClass(String name, String outerName, String innerName, int access) {
            if (this.isClassHolder.value && this.nameHolder.name != null && this.nameHolder.name.equals(name)) {
                this.isClassHolder.value = false;
            }
        }

        @Override
        public void visitOuterClass(String owner, String name, String desc) {
            this.isClassHolder.value = false;
        }

        @Override
        protected boolean shouldVisitAnnotation(boolean visible) {
            return this.isClassHolder.value && visible;
        }

        @Override
        protected boolean shouldAcceptInheritedAnnotationsOnly() {
            return false;
        }
    }

    private abstract class AnnotatedClassVisitor
    extends ClassVisitor {
        private AnnotatedClassVisitor() {
            super(262144);
        }

        @Override
        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            if (this.shouldVisitAnnotation(visible)) {
                if (JavaResourceAccessor.this.annotations == null) {
                    JavaResourceAccessor.this.annotations = new HashMap();
                }
                return new AnnotationVisitorImpl(desc, this.shouldAcceptInheritedAnnotationsOnly());
            }
            return null;
        }

        protected abstract boolean shouldVisitAnnotation(boolean var1);

        protected abstract boolean shouldAcceptInheritedAnnotationsOnly();
    }

    private class NameHolder {
        String name;

        private NameHolder() {
        }
    }

    private class BooleanHolder {
        boolean value;

        private BooleanHolder() {
        }
    }
}

