/*
 * Decompiled with CFR 0.152.
 */
package net.sf.extcos.selector;

import net.sf.extcos.util.Assert;
import net.sf.extcos.util.StringUtils;

public class Package {
    private final String name;
    private final String basePath;
    private final String subPathPattern;

    public Package(String name) {
        Assert.notNull(name, IllegalArgumentException.class);
        Assert.isTrue(StringUtils.isJavaPackageWithWildcards(name) && !name.startsWith("*"), IllegalArgumentException.class, StringUtils.append(name, " is not a valid base package name"));
        this.name = name;
        this.basePath = this.determineBasePath(this.name);
        this.subPathPattern = this.determineSubPathPattern(this.normalizeName(this.name), this.basePath);
    }

    private String normalizeName(String name) {
        for (String suffix : new String[]{".*", ".**"}) {
            if (!name.endsWith(suffix)) continue;
            return name.substring(0, name.length() - suffix.length());
        }
        return name;
    }

    private String determineBasePath(String name) {
        String[] nameParts = name.split("\\.");
        StringBuilder basePath = new StringBuilder();
        for (String namePart : nameParts) {
            if (namePart.startsWith("*")) break;
            basePath.append(namePart).append("/");
        }
        return basePath.toString();
    }

    private String determineSubPathPattern(String name, String basePath) {
        if (name.length() <= basePath.length()) {
            return ".*";
        }
        String subPath = name.substring(basePath.length());
        StringBuilder pattern = new StringBuilder();
        for (String subPathElement : subPath.split("\\.")) {
            if ("*".equals(subPathElement)) {
                pattern.append("[_$a-zA-Z][_$a-zA-Z0-9]*").append("/");
                continue;
            }
            if ("**".equals(subPathElement)) {
                pattern.append("(?:").append("[_$a-zA-Z][_$a-zA-Z0-9]*").append("/)+");
                continue;
            }
            pattern.append(subPathElement).append("/");
        }
        return pattern.toString();
    }

    public String getName() {
        return this.name;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public String getSubPathPattern() {
        return this.subPathPattern;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Package [name=").append(this.name).append("]");
        return builder.toString();
    }
}

