/*
 * Decompiled with CFR 0.152.
 */
package net.sf.extcos.util;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import net.sf.extcos.util.Assert;

public class ReflectionUtils {
    private ReflectionUtils() {
    }

    public static Object getField(Field field, Object target) {
        try {
            return field.get(target);
        }
        catch (IllegalAccessException ex) {
            ReflectionUtils.handleReflectionException(ex);
            throw new IllegalStateException("Unexpected reflection exception - " + ex.getClass().getName() + ": " + ex.getMessage());
        }
    }

    public static Field findField(Class<?> clazz, String name) {
        return ReflectionUtils.findField(clazz, name, null);
    }

    public static Field findField(Class<?> clazz, String name, Class<?> type) {
        Assert.notNull(clazz, Assert.iae(), "Class must not be null");
        Assert.isTrue(name != null || type != null, Assert.iae(), "Either name or type of the field must be specified");
        for (Class<?> searchType = clazz; !Object.class.equals(searchType) && searchType != null; searchType = searchType.getSuperclass()) {
            Field[] fields;
            for (Field field : fields = searchType.getDeclaredFields()) {
                if (name != null && !name.equals(field.getName()) || type != null && !type.equals(field.getType())) continue;
                return field;
            }
        }
        return null;
    }

    public static Method findMethod(Class<?> clazz, String name, Class<?> ... paramTypes) {
        Assert.notNull(clazz, Assert.iae(), "Class must not be null");
        Assert.notNull(name, Assert.iae(), "Method name must not be null");
        for (Class<?> searchType = clazz; searchType != null; searchType = searchType.getSuperclass()) {
            Method[] methods;
            for (Method method : methods = searchType.isInterface() ? searchType.getMethods() : searchType.getDeclaredMethods()) {
                if (!name.equals(method.getName()) || paramTypes != null && !Arrays.equals(paramTypes, method.getParameterTypes())) continue;
                return method;
            }
        }
        return null;
    }

    public static Object invokeMethod(Method method, Object target) {
        return ReflectionUtils.invokeMethod(method, target, new Object[0]);
    }

    public static Object invokeMethod(Method method, Object target, Object[] args) {
        try {
            return method.invoke(target, args);
        }
        catch (Exception ex) {
            ReflectionUtils.handleReflectionException(ex);
            throw new IllegalStateException("Should never get here");
        }
    }

    public static void handleReflectionException(Exception ex) {
        if (ex instanceof NoSuchMethodException) {
            throw new IllegalStateException("Method not found: " + ex.getMessage());
        }
        if (ex instanceof IllegalAccessException) {
            throw new IllegalStateException("Could not access method: " + ex.getMessage());
        }
        if (ex instanceof InvocationTargetException) {
            ReflectionUtils.handleInvocationTargetException((InvocationTargetException)ex);
        }
        if (ex instanceof RuntimeException) {
            throw (RuntimeException)ex;
        }
        ReflectionUtils.handleUnexpectedException(ex);
    }

    public static void handleInvocationTargetException(InvocationTargetException ex) {
        ReflectionUtils.rethrowRuntimeException(ex.getTargetException());
    }

    public static void rethrowRuntimeException(Throwable ex) {
        if (ex instanceof RuntimeException) {
            throw (RuntimeException)ex;
        }
        if (ex instanceof Error) {
            throw (Error)ex;
        }
        ReflectionUtils.handleUnexpectedException(ex);
    }

    private static void handleUnexpectedException(Throwable ex) {
        IllegalStateException isex = new IllegalStateException("Unexpected exception thrown");
        isex.initCause(ex);
        throw isex;
    }
}

