/*
 * Decompiled with CFR 0.152.
 */
package net.sf.extcos.util;

public class StringUtils {
    public static final String SINGLE_SUBPACKAGE_PATTERN = "[_$a-zA-Z][_$a-zA-Z0-9]*";

    private StringUtils() {
    }

    public static String append(String ... strings) {
        StringBuffer result = new StringBuffer();
        for (String string : strings) {
            result.append(string);
        }
        return result.toString();
    }

    public static String append(Object ... objects) {
        StringBuffer result = new StringBuffer();
        for (Object object : objects) {
            result.append(object);
        }
        return result.toString();
    }

    public static boolean isJavaPackage(String string) {
        return string.matches(StringUtils.packagePattern(false));
    }

    public static boolean isJavaPackageWithWildcards(String string) {
        return string.matches(StringUtils.packagePattern(true));
    }

    private static String packagePattern(boolean withWildcards) {
        String identifierPattern = withWildcards ? "(?:(?:[_$a-zA-Z][_$a-zA-Z0-9]*)|\\*{1,2})" : SINGLE_SUBPACKAGE_PATTERN;
        String separator = "\\.";
        return StringUtils.append(identifierPattern, "(?:", separator, identifierPattern, ")*");
    }

    public static char fileSeparator() {
        return System.getProperty("file.separator").charAt(0);
    }

    public static String replace(String inString, String oldPattern, String newPattern) {
        if (!StringUtils.hasLength(inString) || !StringUtils.hasLength(oldPattern) || newPattern == null) {
            return inString;
        }
        StringBuffer sbuf = new StringBuffer();
        int pos = 0;
        int index = inString.indexOf(oldPattern);
        int patLen = oldPattern.length();
        while (index >= 0) {
            sbuf.append(inString.substring(pos, index));
            sbuf.append(newPattern);
            pos = index + patLen;
            index = inString.indexOf(oldPattern, pos);
        }
        sbuf.append(inString.substring(pos));
        return sbuf.toString();
    }

    public static boolean hasLength(CharSequence str) {
        return str != null && str.length() > 0;
    }

    public static boolean hasLength(String str) {
        return StringUtils.hasLength((CharSequence)str);
    }
}

