/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.site.decoration.io.xpp3;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.maven.doxia.site.decoration.Banner;
import org.apache.maven.doxia.site.decoration.Body;
import org.apache.maven.doxia.site.decoration.DecorationModel;
import org.apache.maven.doxia.site.decoration.LinkItem;
import org.apache.maven.doxia.site.decoration.Logo;
import org.apache.maven.doxia.site.decoration.Menu;
import org.apache.maven.doxia.site.decoration.MenuItem;
import org.apache.maven.doxia.site.decoration.PublishDate;
import org.apache.maven.doxia.site.decoration.Skin;
import org.apache.maven.doxia.site.decoration.Version;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.codehaus.plexus.util.xml.pull.EntityReplacementMap;
import org.codehaus.plexus.util.xml.pull.MXParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class DecorationXpp3Reader {
    private boolean addDefaultEntities = true;

    private boolean checkFieldWithDuplicate(XmlPullParser parser, String tagName, String alias, Set parsed) throws XmlPullParserException {
        if (!parser.getName().equals(tagName) && !parser.getName().equals(alias)) {
            return false;
        }
        if (!parsed.add(tagName)) {
            throw new XmlPullParserException("Duplicated tag: '" + tagName + "'", parser, null);
        }
        return true;
    }

    private void checkUnknownAttribute(XmlPullParser parser, String attribute, String tagName, boolean strict) throws XmlPullParserException, IOException {
        if (strict) {
            throw new XmlPullParserException("Unknown attribute '" + attribute + "' for tag '" + tagName + "'", parser, null);
        }
    }

    private void checkUnknownElement(XmlPullParser parser, boolean strict) throws XmlPullParserException, IOException {
        if (strict) {
            throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
        }
        int unrecognizedTagCount = 1;
        while (unrecognizedTagCount > 0) {
            int eventType = parser.next();
            if (eventType == 2) {
                ++unrecognizedTagCount;
                continue;
            }
            if (eventType != 3) continue;
            --unrecognizedTagCount;
        }
    }

    public boolean getAddDefaultEntities() {
        return this.addDefaultEntities;
    }

    private boolean getBooleanValue(String s, String attribute, XmlPullParser parser) throws XmlPullParserException {
        return this.getBooleanValue(s, attribute, parser, null);
    }

    private boolean getBooleanValue(String s, String attribute, XmlPullParser parser, String defaultValue) throws XmlPullParserException {
        if (s != null && s.length() != 0) {
            return Boolean.valueOf(s);
        }
        if (defaultValue != null) {
            return Boolean.valueOf(defaultValue);
        }
        return false;
    }

    private byte getByteValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Byte.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a byte", parser, nfe);
                }
            }
        }
        return 0;
    }

    private char getCharacterValue(String s, String attribute, XmlPullParser parser) throws XmlPullParserException {
        if (s != null) {
            return s.charAt(0);
        }
        return '\u0000';
    }

    private Date getDateValue(String s, String attribute, XmlPullParser parser) throws XmlPullParserException {
        return this.getDateValue(s, attribute, null, parser);
    }

    private Date getDateValue(String s, String attribute, String dateFormat, XmlPullParser parser) throws XmlPullParserException {
        if (s != null) {
            String effectiveDateFormat = dateFormat;
            if (dateFormat == null) {
                effectiveDateFormat = "yyyy-MM-dd'T'HH:mm:ss.SSS";
            }
            if ("long".equals(effectiveDateFormat)) {
                try {
                    return new Date(Long.parseLong(s));
                }
                catch (NumberFormatException e) {
                    throw new XmlPullParserException(e.getMessage(), parser, e);
                }
            }
            try {
                SimpleDateFormat dateParser = new SimpleDateFormat(effectiveDateFormat, Locale.US);
                return dateParser.parse(s);
            }
            catch (ParseException e) {
                throw new XmlPullParserException(e.getMessage(), parser, e);
            }
        }
        return null;
    }

    private double getDoubleValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Double.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a floating point number", parser, nfe);
                }
            }
        }
        return 0.0;
    }

    private float getFloatValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Float.valueOf(s).floatValue();
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a floating point number", parser, nfe);
                }
            }
        }
        return 0.0f;
    }

    private int getIntegerValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Integer.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be an integer", parser, nfe);
                }
            }
        }
        return 0;
    }

    private long getLongValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Long.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a long integer", parser, nfe);
                }
            }
        }
        return 0L;
    }

    private String getRequiredAttributeValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        if (s == null && strict) {
            throw new XmlPullParserException("Missing required value for attribute '" + attribute + "'", parser, null);
        }
        return s;
    }

    private short getShortValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Short.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a short integer", parser, nfe);
                }
            }
        }
        return 0;
    }

    private String getTrimmedValue(String s) {
        if (s != null) {
            s = s.trim();
        }
        return s;
    }

    private int nextTag(XmlPullParser parser) throws IOException, XmlPullParserException {
        int eventType = parser.next();
        if (eventType == 4) {
            eventType = parser.next();
        }
        if (eventType != 2 && eventType != 3) {
            throw new XmlPullParserException("expected START_TAG or END_TAG not " + XmlPullParser.TYPES[eventType], parser, null);
        }
        return eventType;
    }

    public DecorationModel read(Reader reader, boolean strict) throws IOException, XmlPullParserException {
        MXParser parser = this.addDefaultEntities ? new MXParser(EntityReplacementMap.defaultEntityReplacementMap) : new MXParser();
        parser.setInput(reader);
        return this.read(parser, strict);
    }

    public DecorationModel read(Reader reader) throws IOException, XmlPullParserException {
        return this.read(reader, true);
    }

    public DecorationModel read(InputStream in, boolean strict) throws IOException, XmlPullParserException {
        return this.read(ReaderFactory.newXmlReader(in), strict);
    }

    public DecorationModel read(InputStream in) throws IOException, XmlPullParserException {
        return this.read(ReaderFactory.newXmlReader(in));
    }

    private Banner parseBanner(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        Banner banner = new Banner();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "name", null, parsed)) {
                banner.setName(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "src", null, parsed)) {
                banner.setSrc(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "alt", null, parsed)) {
                banner.setAlt(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "href", null, parsed)) {
                banner.setHref(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "border", null, parsed)) {
                banner.setBorder(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "width", null, parsed)) {
                banner.setWidth(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "height", null, parsed)) {
                banner.setHeight(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "title", null, parsed)) {
                banner.setTitle(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return banner;
    }

    private Body parseBody(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        Body body = new Body();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "head", null, parsed)) {
                body.setHead(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "links", null, parsed)) {
                ArrayList<LinkItem> links = new ArrayList<LinkItem>();
                body.setLinks(links);
                while (parser.nextTag() == 2) {
                    if ("item".equals(parser.getName())) {
                        links.add(this.parseLinkItem(parser, strict));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "breadcrumbs", null, parsed)) {
                ArrayList<LinkItem> breadcrumbs = new ArrayList<LinkItem>();
                body.setBreadcrumbs(breadcrumbs);
                while (parser.nextTag() == 2) {
                    if ("item".equals(parser.getName())) {
                        breadcrumbs.add(this.parseLinkItem(parser, strict));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                continue;
            }
            if ("menu".equals(parser.getName())) {
                List<Menu> menus = body.getMenus();
                if (menus == null) {
                    menus = new ArrayList<Menu>();
                    body.setMenus(menus);
                }
                menus.add(this.parseMenu(parser, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "footer", null, parsed)) {
                body.setFooter(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return body;
    }

    private DecorationModel parseDecorationModel(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        DecorationModel decorationModel = new DecorationModel();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0 || "xmlns".equals(name)) continue;
            if ("name".equals(name)) {
                decorationModel.setName(this.getTrimmedValue(value));
                continue;
            }
            if ("combine.self".equals(name)) {
                decorationModel.setCombineSelf(this.getTrimmedValue(value));
                continue;
            }
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "bannerLeft", null, parsed)) {
                decorationModel.setBannerLeft(this.parseBanner(parser, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "bannerRight", null, parsed)) {
                decorationModel.setBannerRight(this.parseBanner(parser, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "googleAdSenseClient", null, parsed)) {
                decorationModel.setGoogleAdSenseClient(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "googleAdSenseSlot", null, parsed)) {
                decorationModel.setGoogleAdSenseSlot(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "googleAnalyticsAccountId", null, parsed)) {
                decorationModel.setGoogleAnalyticsAccountId(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "publishDate", null, parsed)) {
                decorationModel.setPublishDate(this.parsePublishDate(parser, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "version", null, parsed)) {
                decorationModel.setVersion(this.parseVersion(parser, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "poweredBy", null, parsed)) {
                ArrayList<Logo> poweredBy = new ArrayList<Logo>();
                decorationModel.setPoweredBy(poweredBy);
                while (parser.nextTag() == 2) {
                    if ("logo".equals(parser.getName())) {
                        poweredBy.add(this.parseLogo(parser, strict));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "skin", null, parsed)) {
                decorationModel.setSkin(this.parseSkin(parser, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "body", null, parsed)) {
                decorationModel.setBody(this.parseBody(parser, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "custom", null, parsed)) {
                decorationModel.setCustom(Xpp3DomBuilder.build(parser, true));
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return decorationModel;
    }

    private LinkItem parseLinkItem(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        LinkItem linkItem = new LinkItem();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            if ("name".equals(name)) {
                linkItem.setName(this.getTrimmedValue(value));
                continue;
            }
            if ("href".equals(name)) {
                linkItem.setHref(this.getTrimmedValue(value));
                continue;
            }
            if ("img".equals(name)) {
                linkItem.setImg(this.getTrimmedValue(value));
                continue;
            }
            if ("position".equals(name)) {
                linkItem.setPosition(this.getTrimmedValue(value));
                continue;
            }
            if ("alt".equals(name)) {
                linkItem.setAlt(this.getTrimmedValue(value));
                continue;
            }
            if ("border".equals(name)) {
                linkItem.setBorder(this.getTrimmedValue(value));
                continue;
            }
            if ("width".equals(name)) {
                linkItem.setWidth(this.getTrimmedValue(value));
                continue;
            }
            if ("height".equals(name)) {
                linkItem.setHeight(this.getTrimmedValue(value));
                continue;
            }
            if ("target".equals(name)) {
                linkItem.setTarget(this.getTrimmedValue(value));
                continue;
            }
            if ("title".equals(name)) {
                linkItem.setTitle(this.getTrimmedValue(value));
                continue;
            }
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            this.checkUnknownElement(parser, strict);
        }
        return linkItem;
    }

    private Logo parseLogo(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        Logo logo = new Logo();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            if ("name".equals(name)) {
                logo.setName(this.getTrimmedValue(value));
                continue;
            }
            if ("href".equals(name)) {
                logo.setHref(this.getTrimmedValue(value));
                continue;
            }
            if ("img".equals(name)) {
                logo.setImg(this.getTrimmedValue(value));
                continue;
            }
            if ("position".equals(name)) {
                logo.setPosition(this.getTrimmedValue(value));
                continue;
            }
            if ("alt".equals(name)) {
                logo.setAlt(this.getTrimmedValue(value));
                continue;
            }
            if ("border".equals(name)) {
                logo.setBorder(this.getTrimmedValue(value));
                continue;
            }
            if ("width".equals(name)) {
                logo.setWidth(this.getTrimmedValue(value));
                continue;
            }
            if ("height".equals(name)) {
                logo.setHeight(this.getTrimmedValue(value));
                continue;
            }
            if ("target".equals(name)) {
                logo.setTarget(this.getTrimmedValue(value));
                continue;
            }
            if ("title".equals(name)) {
                logo.setTitle(this.getTrimmedValue(value));
                continue;
            }
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            this.checkUnknownElement(parser, strict);
        }
        return logo;
    }

    private Menu parseMenu(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        Menu menu = new Menu();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            if ("name".equals(name)) {
                menu.setName(this.getTrimmedValue(value));
                continue;
            }
            if ("inherit".equals(name)) {
                menu.setInherit(this.getTrimmedValue(value));
                continue;
            }
            if ("inheritAsRef".equals(name)) {
                menu.setInheritAsRef(this.getBooleanValue(this.getTrimmedValue(value), "inheritAsRef", parser, "false"));
                continue;
            }
            if ("ref".equals(name)) {
                menu.setRef(this.getTrimmedValue(value));
                continue;
            }
            if ("img".equals(name)) {
                menu.setImg(this.getTrimmedValue(value));
                continue;
            }
            if ("alt".equals(name)) {
                menu.setAlt(this.getTrimmedValue(value));
                continue;
            }
            if ("position".equals(name)) {
                menu.setPosition(this.getTrimmedValue(value));
                continue;
            }
            if ("border".equals(name)) {
                menu.setBorder(this.getTrimmedValue(value));
                continue;
            }
            if ("width".equals(name)) {
                menu.setWidth(this.getTrimmedValue(value));
                continue;
            }
            if ("height".equals(name)) {
                menu.setHeight(this.getTrimmedValue(value));
                continue;
            }
            if ("title".equals(name)) {
                menu.setTitle(this.getTrimmedValue(value));
                continue;
            }
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if ("item".equals(parser.getName())) {
                List<MenuItem> items = menu.getItems();
                if (items == null) {
                    items = new ArrayList<MenuItem>();
                    menu.setItems(items);
                }
                items.add(this.parseMenuItem(parser, strict));
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return menu;
    }

    private MenuItem parseMenuItem(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        MenuItem menuItem = new MenuItem();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            if ("collapse".equals(name)) {
                menuItem.setCollapse(this.getBooleanValue(this.getTrimmedValue(value), "collapse", parser, "false"));
                continue;
            }
            if ("ref".equals(name)) {
                menuItem.setRef(this.getTrimmedValue(value));
                continue;
            }
            if ("name".equals(name)) {
                menuItem.setName(this.getTrimmedValue(value));
                continue;
            }
            if ("href".equals(name)) {
                menuItem.setHref(this.getTrimmedValue(value));
                continue;
            }
            if ("img".equals(name)) {
                menuItem.setImg(this.getTrimmedValue(value));
                continue;
            }
            if ("position".equals(name)) {
                menuItem.setPosition(this.getTrimmedValue(value));
                continue;
            }
            if ("alt".equals(name)) {
                menuItem.setAlt(this.getTrimmedValue(value));
                continue;
            }
            if ("border".equals(name)) {
                menuItem.setBorder(this.getTrimmedValue(value));
                continue;
            }
            if ("width".equals(name)) {
                menuItem.setWidth(this.getTrimmedValue(value));
                continue;
            }
            if ("height".equals(name)) {
                menuItem.setHeight(this.getTrimmedValue(value));
                continue;
            }
            if ("target".equals(name)) {
                menuItem.setTarget(this.getTrimmedValue(value));
                continue;
            }
            if ("title".equals(name)) {
                menuItem.setTitle(this.getTrimmedValue(value));
                continue;
            }
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "description", null, parsed)) {
                menuItem.setDescription(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if ("item".equals(parser.getName())) {
                List<MenuItem> items = menuItem.getItems();
                if (items == null) {
                    items = new ArrayList<MenuItem>();
                    menuItem.setItems(items);
                }
                items.add(this.parseMenuItem(parser, strict));
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return menuItem;
    }

    private PublishDate parsePublishDate(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        PublishDate publishDate = new PublishDate();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            if ("position".equals(name)) {
                publishDate.setPosition(this.getTrimmedValue(value));
                continue;
            }
            if ("format".equals(name)) {
                publishDate.setFormat(this.getTrimmedValue(value));
                continue;
            }
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            this.checkUnknownElement(parser, strict);
        }
        return publishDate;
    }

    private Skin parseSkin(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        Skin skin = new Skin();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "groupId", null, parsed)) {
                skin.setGroupId(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "artifactId", null, parsed)) {
                skin.setArtifactId(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "version", null, parsed)) {
                skin.setVersion(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return skin;
    }

    private Version parseVersion(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        Version version = new Version();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            if ("position".equals(name)) {
                version.setPosition(this.getTrimmedValue(value));
                continue;
            }
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            this.checkUnknownElement(parser, strict);
        }
        return version;
    }

    private DecorationModel read(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        int eventType = parser.getEventType();
        while (eventType != 1) {
            if (eventType == 2) {
                if (strict && !"project".equals(parser.getName())) {
                    throw new XmlPullParserException("Expected root element 'project' but found '" + parser.getName() + "'", parser, null);
                }
                DecorationModel decorationModel = this.parseDecorationModel(parser, strict);
                decorationModel.setModelEncoding(parser.getInputEncoding());
                return decorationModel;
            }
            eventType = parser.next();
        }
        throw new XmlPullParserException("Expected root element 'project' but found no element at all: invalid XML document", parser, null);
    }

    public void setAddDefaultEntities(boolean addDefaultEntities) {
        this.addDefaultEntities = addDefaultEntities;
    }
}

