/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.repository.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.repository.metadata.Snapshot;
import org.apache.maven.artifact.repository.metadata.SnapshotVersion;
import org.apache.maven.artifact.repository.metadata.Versioning;
import org.apache.maven.artifact.repository.metadata.io.xpp3.MetadataXpp3Reader;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;
import org.sonatype.aether.ConfigurationProperties;
import org.sonatype.aether.RepositoryCache;
import org.sonatype.aether.RepositoryListener;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.impl.MetadataResolver;
import org.sonatype.aether.impl.VersionResolver;
import org.sonatype.aether.impl.internal.CacheUtils;
import org.sonatype.aether.metadata.Metadata;
import org.sonatype.aether.repository.ArtifactRepository;
import org.sonatype.aether.repository.RemoteRepository;
import org.sonatype.aether.repository.WorkspaceReader;
import org.sonatype.aether.repository.WorkspaceRepository;
import org.sonatype.aether.resolution.MetadataRequest;
import org.sonatype.aether.resolution.MetadataResult;
import org.sonatype.aether.resolution.VersionRequest;
import org.sonatype.aether.resolution.VersionResolutionException;
import org.sonatype.aether.resolution.VersionResult;
import org.sonatype.aether.spi.locator.Service;
import org.sonatype.aether.spi.locator.ServiceLocator;
import org.sonatype.aether.spi.log.Logger;
import org.sonatype.aether.spi.log.NullLogger;
import org.sonatype.aether.util.artifact.SubArtifact;
import org.sonatype.aether.util.listener.DefaultRepositoryEvent;
import org.sonatype.aether.util.metadata.DefaultMetadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=VersionResolver.class)
public class DefaultVersionResolver
implements VersionResolver,
Service {
    private static final String MAVEN_METADATA_XML = "maven-metadata.xml";
    private static final String RELEASE = "RELEASE";
    private static final String LATEST = "LATEST";
    private static final String SNAPSHOT = "SNAPSHOT";
    @Requirement
    private Logger logger = NullLogger.INSTANCE;
    @Requirement
    private MetadataResolver metadataResolver;

    @Override
    public void initService(ServiceLocator locator) {
        this.setLogger(locator.getService(Logger.class));
        this.setMetadataResolver(locator.getService(MetadataResolver.class));
    }

    public DefaultVersionResolver setLogger(Logger logger) {
        this.logger = logger != null ? logger : NullLogger.INSTANCE;
        return this;
    }

    public DefaultVersionResolver setMetadataResolver(MetadataResolver metadataResolver) {
        if (metadataResolver == null) {
            throw new IllegalArgumentException("metadata resolver has not been specified");
        }
        this.metadataResolver = metadataResolver;
        return this;
    }

    @Override
    public VersionResult resolveVersion(RepositorySystemSession session, VersionRequest request) throws VersionResolutionException {
        DefaultMetadata metadata;
        Object obj;
        Artifact artifact = request.getArtifact();
        String version = artifact.getVersion();
        VersionResult result = new VersionResult(request);
        Key cacheKey = null;
        RepositoryCache cache = session.getCache();
        if (cache != null && !ConfigurationProperties.get(session, "aether.versionResolver.noCache", false) && (obj = cache.get(session, cacheKey = new Key(session, request))) instanceof Record) {
            Record record = (Record)obj;
            result.setVersion(record.version);
            result.setRepository(CacheUtils.getRepository(session, request.getRepositories(), record.repoClass, record.repoId));
            return result;
        }
        if (RELEASE.equals(version)) {
            metadata = new DefaultMetadata(artifact.getGroupId(), artifact.getArtifactId(), MAVEN_METADATA_XML, Metadata.Nature.RELEASE);
        } else if (LATEST.equals(version)) {
            metadata = new DefaultMetadata(artifact.getGroupId(), artifact.getArtifactId(), MAVEN_METADATA_XML, Metadata.Nature.RELEASE_OR_SNAPSHOT);
        } else if (version.endsWith(SNAPSHOT)) {
            WorkspaceReader workspace = session.getWorkspaceReader();
            if (workspace != null && workspace.findVersions(artifact).contains(version)) {
                metadata = null;
                result.setRepository(workspace.getRepository());
            } else {
                metadata = new DefaultMetadata(artifact.getGroupId(), artifact.getArtifactId(), version, MAVEN_METADATA_XML, Metadata.Nature.SNAPSHOT);
            }
        } else {
            metadata = null;
        }
        if (metadata == null) {
            result.setVersion(version);
        } else {
            ArrayList<MetadataRequest> metadataRequests = new ArrayList<MetadataRequest>(request.getRepositories().size());
            metadataRequests.add(new MetadataRequest(metadata, null, request.getRequestContext()));
            for (RemoteRepository repository : request.getRepositories()) {
                MetadataRequest metadataRequest = new MetadataRequest(metadata, repository, request.getRequestContext());
                metadataRequest.setDeleteLocalCopyIfMissing(true);
                metadataRequest.setFavorLocalRepository(true);
                metadataRequests.add(metadataRequest);
            }
            List<MetadataResult> metadataResults = this.metadataResolver.resolveMetadata(session, metadataRequests);
            HashMap<String, VersionInfo> infos = new HashMap<String, VersionInfo>();
            for (MetadataResult metadataResult : metadataResults) {
                result.addException(metadataResult.getException());
                ArtifactRepository repository = metadataResult.getRequest().getRepository();
                if (repository == null) {
                    repository = session.getLocalRepository();
                }
                Versioning versioning = this.readVersions(session, metadataResult.getMetadata(), repository, result);
                this.merge(artifact, infos, versioning, repository);
            }
            if (RELEASE.equals(version)) {
                this.resolve(result, infos, RELEASE);
            } else if (LATEST.equals(version)) {
                if (!this.resolve(result, infos, LATEST)) {
                    this.resolve(result, infos, RELEASE);
                }
                if (result.getVersion() != null && result.getVersion().endsWith(SNAPSHOT)) {
                    VersionRequest subRequest = new VersionRequest();
                    subRequest.setArtifact(artifact.setVersion(result.getVersion()));
                    if (result.getRepository() instanceof RemoteRepository) {
                        subRequest.setRepositories(Collections.singletonList((RemoteRepository)result.getRepository()));
                    } else {
                        subRequest.setRepositories(request.getRepositories());
                    }
                    VersionResult subResult = this.resolveVersion(session, subRequest);
                    result.setVersion(subResult.getVersion());
                    result.setRepository(subResult.getRepository());
                    for (Exception exception : subResult.getExceptions()) {
                        result.addException(exception);
                    }
                }
            } else if (!this.resolve(result, infos, SNAPSHOT + this.getKey(artifact.getClassifier(), artifact.getExtension())) && !this.resolve(result, infos, SNAPSHOT)) {
                result.setVersion(version);
            }
            if (StringUtils.isEmpty(result.getVersion())) {
                throw new VersionResolutionException(result);
            }
        }
        if (cacheKey != null && metadata != null && this.isSafelyCacheable(session, artifact)) {
            cache.put(session, cacheKey, new Record(result.getVersion(), result.getRepository()));
        }
        return result;
    }

    private boolean resolve(VersionResult result, Map<String, VersionInfo> infos, String key) {
        VersionInfo info = infos.get(key);
        if (info != null) {
            result.setVersion(info.version);
            result.setRepository(info.repository);
        }
        return info != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private Versioning readVersions(RepositorySystemSession session, Metadata metadata, ArtifactRepository repository, VersionResult result) {
        FileInputStream fis;
        Versioning versioning2;
        block6: {
            versioning2 = null;
            fis = null;
            try {
                if (metadata == null || metadata.getFile() == null) break block6;
                fis = new FileInputStream(metadata.getFile());
                org.apache.maven.artifact.repository.metadata.Metadata m = new MetadataXpp3Reader().read(fis, false);
                versioning2 = m.getVersioning();
            }
            catch (FileNotFoundException e) {
                IOUtil.close(fis);
            }
            catch (Exception e2) {
                this.invalidMetadata(session, metadata, repository, e2);
                result.addException(e2);
                {
                    catch (Throwable throwable) {
                        IOUtil.close(fis);
                        throw throwable;
                    }
                }
                IOUtil.close(fis);
            }
        }
        IOUtil.close(fis);
        return versioning2 != null ? versioning2 : new Versioning();
    }

    private void invalidMetadata(RepositorySystemSession session, Metadata metadata, ArtifactRepository repository, Exception exception) {
        RepositoryListener listener = session.getRepositoryListener();
        if (listener != null) {
            DefaultRepositoryEvent event = new DefaultRepositoryEvent(session, metadata);
            event.setException(exception);
            event.setRepository(repository);
            listener.metadataInvalid(event);
        }
    }

    private void merge(Artifact artifact, Map<String, VersionInfo> infos, Versioning versioning, ArtifactRepository repository) {
        if (StringUtils.isNotEmpty(versioning.getRelease())) {
            this.merge(RELEASE, infos, versioning.getLastUpdated(), versioning.getRelease(), repository);
        }
        if (StringUtils.isNotEmpty(versioning.getLatest())) {
            this.merge(LATEST, infos, versioning.getLastUpdated(), versioning.getLatest(), repository);
        }
        for (SnapshotVersion sv : versioning.getSnapshotVersions()) {
            if (!StringUtils.isNotEmpty(sv.getVersion())) continue;
            String key = this.getKey(sv.getClassifier(), sv.getExtension());
            this.merge(SNAPSHOT + key, infos, sv.getUpdated(), sv.getVersion(), repository);
        }
        Snapshot snapshot = versioning.getSnapshot();
        if (snapshot != null) {
            String version = artifact.getVersion();
            if (snapshot.getTimestamp() != null && snapshot.getBuildNumber() > 0) {
                String qualifier = snapshot.getTimestamp() + '-' + snapshot.getBuildNumber();
                version = version.substring(0, version.length() - SNAPSHOT.length()) + qualifier;
            }
            this.merge(SNAPSHOT, infos, versioning.getLastUpdated(), version, repository);
        }
    }

    private void merge(String key, Map<String, VersionInfo> infos, String timestamp, String version, ArtifactRepository repository) {
        VersionInfo info = infos.get(key);
        if (info == null) {
            info = new VersionInfo(timestamp, version, repository);
            infos.put(key, info);
        } else if (info.isOutdated(timestamp)) {
            info.version = version;
            info.repository = repository;
        }
    }

    private String getKey(String classifier, String extension) {
        return StringUtils.clean(classifier) + ':' + StringUtils.clean(extension);
    }

    private boolean isSafelyCacheable(RepositorySystemSession session, Artifact artifact) {
        WorkspaceReader workspace = session.getWorkspaceReader();
        if (workspace == null) {
            return true;
        }
        Artifact pomArtifact = artifact;
        if (pomArtifact.getClassifier().length() > 0 || !"pom".equals(pomArtifact.getExtension())) {
            pomArtifact = new SubArtifact(artifact, "", "pom");
        }
        return workspace.findArtifact(pomArtifact) == null;
    }

    private static class Record {
        final String version;
        final String repoId;
        final Class<?> repoClass;

        public Record(String version, ArtifactRepository repository) {
            this.version = version;
            if (repository != null) {
                this.repoId = repository.getId();
                this.repoClass = repository.getClass();
            } else {
                this.repoId = null;
                this.repoClass = null;
            }
        }
    }

    private static class Key {
        private final String groupId;
        private final String artifactId;
        private final String classifier;
        private final String extension;
        private final String version;
        private final String context;
        private final File localRepo;
        private final WorkspaceRepository workspace;
        private final List<RemoteRepository> repositories;
        private final int hashCode;

        public Key(RepositorySystemSession session, VersionRequest request) {
            Artifact artifact = request.getArtifact();
            this.groupId = artifact.getGroupId();
            this.artifactId = artifact.getArtifactId();
            this.classifier = artifact.getClassifier();
            this.extension = artifact.getExtension();
            this.version = artifact.getVersion();
            this.context = request.getRequestContext();
            this.localRepo = session.getLocalRepository().getBasedir();
            this.workspace = CacheUtils.getWorkspace(session);
            this.repositories = new ArrayList<RemoteRepository>(request.getRepositories().size());
            for (RemoteRepository repository : request.getRepositories()) {
                if (repository.isRepositoryManager()) {
                    this.repositories.addAll(repository.getMirroredRepositories());
                    continue;
                }
                this.repositories.add(repository);
            }
            int hash = 17;
            hash = hash * 31 + this.groupId.hashCode();
            hash = hash * 31 + this.artifactId.hashCode();
            hash = hash * 31 + this.classifier.hashCode();
            hash = hash * 31 + this.extension.hashCode();
            hash = hash * 31 + this.version.hashCode();
            hash = hash * 31 + this.localRepo.hashCode();
            this.hashCode = hash = hash * 31 + CacheUtils.repositoriesHashCode(this.repositories);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || !this.getClass().equals(obj.getClass())) {
                return false;
            }
            Key that = (Key)obj;
            return this.artifactId.equals(that.artifactId) && this.groupId.equals(that.groupId) && this.classifier.equals(that.classifier) && this.extension.equals(that.extension) && this.version.equals(that.version) && this.context.equals(that.context) && this.localRepo.equals(that.localRepo) && CacheUtils.eq(this.workspace, that.workspace) && CacheUtils.repositoriesEquals(this.repositories, that.repositories);
        }

        public int hashCode() {
            return this.hashCode;
        }
    }

    private static class VersionInfo {
        String timestamp;
        String version;
        ArtifactRepository repository;

        public VersionInfo(String timestamp, String version, ArtifactRepository repository) {
            this.timestamp = timestamp != null ? timestamp : "";
            this.version = version;
            this.repository = repository;
        }

        public boolean isOutdated(String timestamp) {
            return timestamp != null && timestamp.compareTo(this.timestamp) > 0;
        }
    }
}

