/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.components.io.attributes;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.codehaus.plexus.components.io.attributes.FileAttributes;
import org.codehaus.plexus.components.io.attributes.PlexusIoResourceAttributeUtils;
import org.codehaus.plexus.components.io.attributes.PlexusIoResourceAttributes;
import org.codehaus.plexus.components.io.attributes.proxy.PlexusIoProxyResourceAttributes;
import org.codehaus.plexus.util.cli.StreamConsumer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AttributeParser
implements StreamConsumer {
    protected static final Pattern LINE_SPLITTER = Pattern.compile("\\s+");
    protected static final int[] LS_LAST_DATE_PART_INDICES = new int[]{7, 7, 7, 7, 6, 7, 7, 7, 7};
    protected final Map<String, PlexusIoResourceAttributes> attributesByPath = new LinkedHashMap<String, PlexusIoResourceAttributes>();
    private final StreamConsumer logger;
    private boolean nextIsPathPrefix = false;
    private String pathPrefix = "";
    private final SimpleDateFormat[] LS_DATE_FORMATS;

    public AttributeParser(@Nonnull StreamConsumer logger) {
        this.logger = logger;
        this.LS_DATE_FORMATS = new SimpleDateFormat[]{new SimpleDateFormat("MMM dd yyyy"), new SimpleDateFormat("MMM dd yyyy", Locale.ENGLISH), new SimpleDateFormat("MMM dd HH:mm"), new SimpleDateFormat("MMM dd HH:mm", Locale.ENGLISH), new SimpleDateFormat("yyyy-MM-dd HH:mm"), new SimpleDateFormat("dd MMM HH:mm"), new SimpleDateFormat("dd MMM HH:mm", Locale.ENGLISH), new SimpleDateFormat("dd MMM yyyy"), new SimpleDateFormat("dd MMM yyyy", Locale.ENGLISH)};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void consumeLine(@Nonnull String line) {
        if (!PlexusIoResourceAttributeUtils.totalLinePattern.matcher(line).matches()) {
            if (line.trim().length() == 0) {
                this.nextIsPathPrefix = true;
            } else if (this.nextIsPathPrefix) {
                if (line.endsWith(":")) {
                    this.nextIsPathPrefix = false;
                    this.pathPrefix = line.substring(0, line.length() - 1);
                    if (!this.pathPrefix.endsWith("/")) {
                        this.pathPrefix = this.pathPrefix + "/";
                    }
                }
            } else {
                String[] parts = LINE_SPLITTER.split(line);
                int lastDatePart = this.verifyParsability(line, parts, this.logger);
                if (lastDatePart > 0) {
                    int idx = line.indexOf(parts[lastDatePart]) + parts[lastDatePart].length() + 1;
                    String path = this.pathPrefix + line.substring(idx);
                    while (path.length() > 0 && Character.isWhitespace(path.charAt(0))) {
                        path = path.substring(1);
                    }
                    Map<String, PlexusIoResourceAttributes> map = this.attributesByPath;
                    synchronized (map) {
                        FileAttributes attributes = new FileAttributes(parts[0]);
                        this.attributesByPath.put(path, attributes);
                        this.processAttributes(attributes, parts);
                    }
                }
            }
        }
        this.logger.consumeLine(line);
    }

    protected abstract void processAttributes(@Nonnull FileAttributes var1, @Nonnull String[] var2);

    public Map<String, PlexusIoResourceAttributes> getAttributesByPath() {
        return this.attributesByPath;
    }

    private int verifyParsability(String line, @Nonnull String[] parts, @Nonnull StreamConsumer logger) {
        if (parts.length > 7) {
            String dateCandidate = parts[5] + " " + parts[6] + " " + parts[7];
            for (int i = 0; i < this.LS_DATE_FORMATS.length; ++i) {
                try {
                    this.LS_DATE_FORMATS[i].parse(dateCandidate);
                    return LS_LAST_DATE_PART_INDICES[i];
                }
                catch (ParseException parseException) {
                    continue;
                }
            }
        }
        logger.consumeLine("Unparseable line: '" + line + "'\nReason: unrecognized date format; ambiguous start-index for path in listing.");
        return -1;
    }

    static class MergedAttributes
    extends PlexusIoProxyResourceAttributes {
        PlexusIoResourceAttributes otherAttr;

        public MergedAttributes(PlexusIoResourceAttributes thisAttr, PlexusIoResourceAttributes otherAttr) {
            super(thisAttr);
            this.otherAttr = otherAttr;
        }

        @Nullable
        public Integer getGroupId() {
            return this.otherAttr.getGroupId();
        }

        public Integer getUserId() {
            return this.otherAttr.getUserId();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SymbolicUserIDAttributeParser
    extends AttributeParser {
        SymbolicUserIDAttributeParser(StreamConsumer logger) {
            super(logger);
        }

        @Override
        protected void processAttributes(@Nonnull FileAttributes attributes, @Nonnull String[] parts) {
            attributes.setUserName(parts[2]);
            attributes.setGroupName(parts[3]);
        }

        public Map<String, PlexusIoResourceAttributes> merge(NumericUserIDAttributeParser otherParser) {
            Map<String, PlexusIoResourceAttributes> attributes = this.getAttributesByPath();
            if (otherParser == null) {
                return attributes;
            }
            HashMap<String, PlexusIoResourceAttributes> result = new HashMap<String, PlexusIoResourceAttributes>();
            Map<String, PlexusIoResourceAttributes> otherAttributes = otherParser.getAttributesByPath();
            HashSet<String> allKeys = new HashSet<String>(attributes.keySet());
            allKeys.addAll(otherAttributes.keySet());
            for (String key : allKeys) {
                PlexusIoResourceAttributes thisAttribute = attributes.get(key);
                PlexusIoResourceAttributes otherAttribute = otherAttributes.get(key);
                if (thisAttribute == null) {
                    thisAttribute = otherAttribute;
                    result.put(key, thisAttribute);
                }
                if (thisAttribute == null || otherAttribute == null) continue;
                result.put(key, new MergedAttributes(thisAttribute, otherAttribute));
            }
            return result;
        }
    }

    static class NumericUserIDAttributeParser
    extends AttributeParser {
        NumericUserIDAttributeParser(StreamConsumer logger) {
            super(logger);
        }

        protected void processAttributes(@Nonnull FileAttributes attributes, @Nonnull String[] parts) {
            attributes.setUserId((int)Long.parseLong(parts[2]));
            attributes.setGroupId((int)Long.parseLong(parts[3]));
        }
    }
}

