/*
 * Decompiled with CFR 0.152.
 */
package bbd.jportal2.generators;

import bbd.jportal2.BaseGenerator;
import bbd.jportal2.Database;
import bbd.jportal2.Enum;
import bbd.jportal2.Field;
import bbd.jportal2.IBuiltInSIProcessor;
import bbd.jportal2.PlaceHolder;
import bbd.jportal2.PlaceHolderPairs;
import bbd.jportal2.Proc;
import bbd.jportal2.Table;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaJCCode
extends BaseGenerator
implements IBuiltInSIProcessor {
    private static final Logger logger = LoggerFactory.getLogger(JavaJCCode.class);
    public static final String GENERATE_PROCS_IO_ERROR = "Generate Procs IO Error";
    public static final String FLAG_UTILIZE_ENUMS = "utilizeenums";
    public static final String FLAG_GEN_LOMBOK = "generatelombok";
    public static final String ENTITY_CLASS_SUFFIX = "Struct";
    private Set<String> flags = new HashSet<String>();
    private String extendsName;
    private PlaceHolder placeHolders;

    public JavaJCCode() {
        super(JavaJCCode.class);
    }

    @Override
    public String description() {
        return "generate Java code for jdbc and crackle consumption - separates structs and others from main";
    }

    @Override
    public String documentation() {
        return "generate Java code for jdbc and crackle consumption - separates structs and others from main";
    }

    @Override
    public void generate(Database database, String output) {
        this.flags = database.getFlags().stream().map(String::toLowerCase).collect(Collectors.toSet());
        for (int i = 0; i < database.tables.size(); ++i) {
            Table table = database.tables.elementAt(i);
            this.generateStructs(table, output);
            this.generate(table, output);
        }
    }

    private void generate(Table table, String output) {
        this.generateStdProcs(table, output);
        this.generateOtherProcs(table, output);
    }

    private void generateStructs(Table table, String output) {
        this.generateStdProcStruct(table, output);
        this.generateOtherProcStructs(table, output);
    }

    private void generateStdProcStruct(Table table, String output) {
        String fileName = output + table.useName() + ENTITY_CLASS_SUFFIX + ".java";
        logger.info("Code: {}", (Object)fileName);
        try (PrintWriter outData = this.openOutputFileForGeneration("Java", fileName);){
            int i;
            int i2;
            if (table.database.packageName.length() > 0) {
                outData.println("package " + table.database.packageName + ";");
                outData.println();
            }
            outData.println("import java.io.Serializable;");
            outData.println("import java.sql.*;");
            outData.println("import java.math.*;");
            this.generateLombokImport(outData);
            outData.println();
            outData.println("/**");
            for (i2 = 0; i2 < table.comments.size(); ++i2) {
                String s = table.comments.elementAt(i2);
                outData.println(" *" + s);
            }
            outData.println(" * This code was generated, do not modify it, modify it at source and regenerate it.");
            outData.println(" * Does not use inner public classes and separates structs out.");
            outData.println(" */");
            this.generateLombokAnnotations(outData);
            outData.println("public class " + table.useName() + ENTITY_CLASS_SUFFIX + " implements Serializable");
            outData.println("{");
            outData.println("  public static final long serialVersionUID = 1L;");
            this.generateEnum(table, outData);
            for (i2 = 0; i2 < table.fields.size(); ++i2) {
                Field field = table.fields.elementAt(i2);
                if (!field.comments.isEmpty()) {
                    outData.println("  /**");
                    for (int c = 0; c < field.comments.size(); ++c) {
                        String s = field.comments.elementAt(c);
                        outData.println("   *" + s);
                    }
                    outData.println("   */");
                }
                outData.println("  protected " + this.javaVar(field) + ";");
                outData.println("  public " + this.getterSetter(field));
            }
            outData.println("  public " + table.useName() + ENTITY_CLASS_SUFFIX + "()");
            outData.println("  {");
            int maxSize = 0;
            for (i = 0; i < table.fields.size(); ++i) {
                Field field = table.fields.elementAt(i);
                if (field.useName().length() > maxSize) {
                    maxSize = field.useName().length();
                }
                outData.println("    " + this.initJavaVar(field));
            }
            outData.println("  }");
            outData.println("  public String toString()");
            outData.println("  {");
            outData.println("    String CRLF = System.lineSeparator();");
            for (i = 0; i < table.fields.size(); ++i) {
                if (i == 0) {
                    outData.print("    return ");
                } else {
                    outData.print("         + ");
                }
                Field field = table.fields.elementAt(i);
                int no = maxSize - field.useName().length();
                outData.println("\"  " + field.useLowerName() + this.padded(no + 1) + ": \" + " + field.useLowerName() + " + CRLF");
            }
            outData.println("    ;");
            outData.println("  }");
            outData.println("}");
            outData.flush();
        }
        catch (IOException e1) {
            logger.error(GENERATE_PROCS_IO_ERROR, e1);
        }
    }

    private void generateOtherProcStructs(Table table, String output) {
        for (int i = 0; i < table.procs.size(); ++i) {
            Proc proc = table.procs.elementAt(i);
            if (proc.isData || proc.isStd || proc.hasNoData()) continue;
            this.generateOtherProcStruct(table, proc, output);
        }
    }

    private void generateOtherProcStruct(Table table, Proc proc, String output) {
        String fileName = output + table.useName() + proc.upperFirst() + ENTITY_CLASS_SUFFIX + ".java";
        logger.info("Code: {}", (Object)fileName);
        try (PrintWriter outData = this.openOutputFileForGeneration("Java", fileName);){
            int j;
            String s;
            String s2;
            int c;
            Field field;
            int j2;
            if (table.database.packageName.length() > 0) {
                outData.println("package " + table.database.packageName + ";");
                outData.println();
            }
            outData.println("import java.io.Serializable;");
            outData.println("import java.sql.*;");
            outData.println("import java.math.*;");
            this.generateEnumImports(table, outData);
            this.generateLombokImport(outData);
            outData.println();
            outData.println("/**");
            for (int j3 = 0; j3 < proc.comments.size(); ++j3) {
                String comment = proc.comments.elementAt(j3);
                outData.println(" *" + comment);
            }
            outData.println(" */");
            this.generateLombokAnnotations(outData);
            outData.println("public class " + table.useName() + proc.upperFirst() + ENTITY_CLASS_SUFFIX + " implements Serializable");
            outData.println("{");
            outData.println("    private static final long serialVersionUID = 1L;");
            int maxSize = 0;
            for (j2 = 0; j2 < proc.inputs.size(); ++j2) {
                field = proc.inputs.elementAt(j2);
                if (field.useName().length() > maxSize) {
                    maxSize = field.useName().length();
                }
                outData.println("  /**");
                for (c = 0; c < field.comments.size(); ++c) {
                    s2 = field.comments.elementAt(c);
                    outData.println("   *" + s2);
                }
                if (!proc.hasOutput(field.name)) {
                    outData.println("   * (input)");
                } else {
                    outData.println("   * (input/output)");
                }
                outData.println("   */");
                outData.println("  protected " + this.javaVar(field) + ";");
                outData.println("  public " + this.getterSetter(field));
            }
            for (j2 = 0; j2 < proc.outputs.size(); ++j2) {
                field = proc.outputs.elementAt(j2);
                if (field.useName().length() > maxSize) {
                    maxSize = field.useName().length();
                }
                if (proc.hasInput(field.name)) continue;
                outData.println("  /**");
                for (c = 0; c < field.comments.size(); ++c) {
                    s2 = field.comments.elementAt(c);
                    outData.println("   *" + s2);
                }
                outData.println("   * (output)");
                outData.println("   */");
                outData.println("  protected " + this.javaVar(field) + ";");
                outData.println("  public " + this.getterSetter(field));
            }
            for (j2 = 0; j2 < proc.dynamics.size(); ++j2) {
                s = proc.dynamics.elementAt(j2);
                if (s.length() > maxSize) {
                    maxSize = s.length();
                }
                outData.println("  /**");
                outData.println("   * (dynamic)");
                outData.println("   */");
                outData.println("  public String " + s + ";");
            }
            outData.println("  public " + table.useName() + proc.upperFirst() + ENTITY_CLASS_SUFFIX + "()");
            outData.println("  {");
            for (j2 = 0; j2 < proc.inputs.size(); ++j2) {
                field = proc.inputs.elementAt(j2);
                outData.println("    " + this.initJavaVar(field));
            }
            for (j2 = 0; j2 < proc.outputs.size(); ++j2) {
                field = proc.outputs.elementAt(j2);
                if (proc.hasInput(field.name)) continue;
                outData.println("    " + this.initJavaVar(field));
            }
            for (j2 = 0; j2 < proc.dynamics.size(); ++j2) {
                s = proc.dynamics.elementAt(j2);
                outData.println("    " + s + " = \"\";");
            }
            outData.println("  }");
            outData.println("  public String toString()");
            outData.println("  {");
            outData.println("    String CRLF = System.lineSeparator();");
            String ret = "    return ";
            for (j = 0; j < proc.inputs.size(); ++j) {
                outData.print(ret);
                ret = "         + ";
                Field field2 = proc.inputs.elementAt(j);
                int no = maxSize - field2.useName().length();
                outData.println("\"  " + field2.useLowerName() + this.padded(no + 1) + ": \" + " + field2.useLowerName() + " + CRLF");
            }
            for (j = 0; j < proc.outputs.size(); ++j) {
                Field field3 = proc.outputs.elementAt(j);
                if (proc.hasInput(field3.name)) continue;
                outData.print(ret);
                ret = "         + ";
                int no = maxSize - field3.useName().length();
                outData.println("\"  " + field3.useLowerName() + this.padded(no + 1) + ": \" + " + field3.useLowerName() + " + CRLF");
            }
            for (j = 0; j < proc.dynamics.size(); ++j) {
                String s3 = proc.dynamics.elementAt(j);
                outData.print(ret);
                ret = "         + ";
                int no = maxSize - s3.length();
                outData.println("\"  " + s3 + this.padded(no + 1) + ": \" + " + s3 + " + CRLF");
            }
            outData.println("    ;");
            outData.println("  }");
            outData.println("}");
            outData.flush();
        }
        catch (IOException e1) {
            logger.error(GENERATE_PROCS_IO_ERROR, e1);
        }
    }

    private void generateStdProcs(Table table, String output) {
        String fileName = output + table.useName() + ".java";
        logger.info("Code: {}", (Object)fileName);
        try (PrintWriter outData = this.openOutputFileForGeneration("Java", fileName);){
            int i;
            if (table.database.packageName.length() > 0) {
                outData.println("package " + table.database.packageName + ";");
                outData.println("");
            }
            outData.println("import bbd.jportal2.util.*;");
            outData.println("import java.sql.*;");
            outData.println("import java.math.*;");
            outData.println("import java.util.*;");
            outData.println("");
            outData.println("/**");
            for (i = 0; i < table.comments.size(); ++i) {
                String s = table.comments.elementAt(i);
                outData.println(" *" + s);
            }
            outData.println(" * This code was generated, do not modify it, modify it at source and regenerate it.");
            outData.println(" */");
            this.extendsName = table.useName() + ENTITY_CLASS_SUFFIX;
            outData.println("public class " + table.useName() + " extends " + this.extendsName);
            outData.println("{");
            outData.println("  private static final long serialVersionUID = 1L;");
            outData.println("  Connector connector;");
            outData.println("  Connection connection;");
            outData.println("  public " + table.useName() + "()");
            outData.println("  {");
            outData.println("    super();");
            outData.println("  }");
            outData.println("  /**");
            outData.println("   * @param conn for specific database");
            outData.println("   */");
            outData.println("  public void setConnector(Connector conn)");
            outData.println("  {");
            outData.println("    this.connector = conn;");
            outData.println("    connection = connector.connection;");
            outData.println("  }");
            outData.println("  /**");
            outData.println("   * @param connector for specific database");
            outData.println("   */");
            outData.println("  public " + table.useName() + "(Connector connector)");
            outData.println("  {");
            outData.println("    super();");
            outData.println("    this.connector = connector;");
            outData.println("    connection = connector.connection;");
            outData.println("  }");
            for (i = 0; i < table.procs.size(); ++i) {
                Proc proc = table.procs.elementAt(i);
                if (proc.isData) continue;
                if (proc.isStd) {
                    this.emitProc(proc, outData);
                    continue;
                }
                if (!proc.hasNoData()) continue;
                this.emitStaticProc(proc, outData);
            }
            outData.println("}");
            outData.flush();
        }
        catch (IOException e1) {
            logger.error(GENERATE_PROCS_IO_ERROR, e1);
        }
    }

    private void generateOtherProcs(Table table, String output) {
        for (int i = 0; i < table.procs.size(); ++i) {
            Proc proc = table.procs.elementAt(i);
            if (proc.isData || proc.isStd || proc.hasNoData()) continue;
            this.generateOtherProc(table, proc, output);
        }
    }

    private void generateOtherProc(Table table, Proc proc, String output) {
        String fileName = output + table.useName() + proc.upperFirst() + ".java";
        logger.info("Code: {}", (Object)fileName);
        try (PrintWriter outData = this.openOutputFileForGeneration("Java", fileName);){
            if (table.database.packageName.length() > 0) {
                outData.println("package " + table.database.packageName + ";");
                outData.println("");
            }
            outData.println("import bbd.jportal2.util.*;");
            outData.println("import java.sql.*;");
            outData.println("import java.util.*;");
            outData.println("import java.math.*;");
            this.generateEnumImports(table, outData);
            outData.println("");
            outData.println("/**");
            for (int j = 0; j < proc.comments.size(); ++j) {
                String comment = proc.comments.elementAt(j);
                outData.println(" *" + comment);
            }
            outData.println(" */");
            this.extendsName = table.useName() + proc.upperFirst() + ENTITY_CLASS_SUFFIX;
            outData.println("public class " + table.useName() + proc.upperFirst() + " extends " + this.extendsName);
            outData.println("{");
            outData.println("  private static final long serialVersionUID = 1L;");
            outData.println("  Connector connector;");
            outData.println("  Connection connection;");
            outData.println("  public " + table.useName() + proc.upperFirst() + "()");
            outData.println("  {");
            outData.println("    super();");
            outData.println("  }");
            outData.println("  public void setConnector(Connector conn)");
            outData.println("  {");
            outData.println("    this.connector = conn;");
            outData.println("    connection = connector.connection;");
            outData.println("  }");
            outData.println("  public " + table.useName() + proc.upperFirst() + "(Connector connector)");
            outData.println("  {");
            outData.println("    super();");
            outData.println("    this.connector = connector;");
            outData.println("    connection = connector.connection;");
            outData.println("  }");
            this.emitProc(proc, outData);
            outData.println("}");
            outData.flush();
        }
        catch (IOException e1) {
            logger.error(GENERATE_PROCS_IO_ERROR, e1);
        }
    }

    private void emitStaticProc(Proc proc, PrintWriter outData) {
        outData.println("  /**");
        outData.println("   * class method as it has no input or output.");
        outData.println("   * @exception SQLException is passed through");
        outData.println("   */");
        outData.println("  public static void " + proc.lowerFirst() + "(Connector connector) throws SQLException");
        outData.println("  {");
        this.placeHolders = new PlaceHolder(proc, 1, "");
        Vector<String> lines = this.placeHolders.getLines();
        outData.println("    String statement = ");
        String plus = "    ";
        for (int i = 0; i < lines.size(); ++i) {
            outData.println(plus + lines.elementAt(i));
            plus = "    +";
        }
        outData.println("    ;");
        outData.println("    PreparedStatement prep = connector.prepareStatement(statement);");
        outData.println("    prep.executeUpdate();");
        outData.println("    prep.close();");
        outData.println("  }");
    }

    private void emitProc(Proc proc, PrintWriter outData) {
        Field field;
        Field field2;
        int i;
        int i2;
        outData.println("  /**");
        if (proc.comments.size() > 0) {
            for (int i3 = 0; i3 < proc.comments.size(); ++i3) {
                String comment = proc.comments.elementAt(i3);
                outData.println("    *" + comment);
            }
        }
        if (proc.outputs.isEmpty()) {
            outData.println("   * Returns no output.");
        } else if (proc.isSingle) {
            outData.println("   * Returns at most one record.");
            outData.println("   * @return true if a record is found");
        } else {
            outData.println("   * Returns any number of records.");
            outData.println("   * @return result set of records found");
        }
        outData.println("   * @exception SQLException is passed through");
        outData.println("   */");
        String procName = proc.lowerFirst();
        if (proc.outputs.isEmpty()) {
            outData.println("  public void " + procName + "() throws SQLException");
        } else if (proc.isSingle) {
            outData.println("  public boolean " + procName + "() throws SQLException");
        } else {
            outData.println("  public Query " + procName + "() throws SQLException");
        }
        outData.println("  {");
        this.placeHolders = new PlaceHolder(proc, 1, "");
        Vector<String> lines = this.placeHolders.getLines();
        Field primaryKeyField = null;
        for (int i4 = 0; i4 < proc.table.fields.size() && primaryKeyField == null; ++i4) {
            Field fEval = proc.table.fields.get(i4);
            if (!fEval.isPrimaryKey) continue;
            primaryKeyField = fEval;
        }
        if (proc.hasReturning) {
            outData.println("Connector.Returning _ret = connector.getReturning(\"" + proc.table.name + "\",\"" + primaryKeyField.useName() + "\");");
        }
        outData.println("    String statement = ");
        String plus = "      ";
        for (i2 = 0; i2 < lines.size(); ++i2) {
            outData.println(plus + lines.elementAt(i2));
            plus = "    + ";
        }
        outData.println("    ;");
        outData.println("    PreparedStatement prep = connector.prepareStatement(statement);");
        for (i2 = 0; i2 < proc.inputs.size(); ++i2) {
            Field field3 = proc.inputs.elementAt(i2);
            if (proc.isInsert) {
                if (field3.type == 24) {
                    outData.println("    " + field3.useLowerName() + " = connector.getBigSequence(\"" + proc.table.name + "\");");
                } else if (field3.type == 14) {
                    outData.println("    " + field3.useLowerName() + " = connector.getSequence(\"" + proc.table.name + "\");");
                }
            }
            if (field3.type == 18) {
                outData.println("    " + field3.useLowerName() + " = connector.getTimestamp();");
            }
            if (field3.type != 20) continue;
            outData.println("    " + field3.useLowerName() + " = connector.getUserstamp();");
        }
        Vector<PlaceHolderPairs> pairs = this.placeHolders.getPairs();
        for (i = 0; i < pairs.size(); ++i) {
            PlaceHolderPairs pair = pairs.elementAt(i);
            field2 = pair.field;
            if (field2.isNull) {
                outData.println("    if(" + field2.useLowerName() + " == null) {");
                outData.print("        prep.setNull(");
                outData.print(i + 1);
                outData.println(", java.sql.Types.NULL);");
                outData.println("    } else {");
                outData.print("    ");
            }
            String enumToInt = "%s";
            if (this.shouldUtilizeEnums() && this.hasEnums(field2)) {
                enumToInt = "%s.key";
            }
            String prepSet = "    prep.set%s(%d, %s);";
            outData.println(String.format(prepSet, this.setType(field2), i + 1, String.format(enumToInt, field2.useLowerName())));
            if (!field2.isNull) continue;
            outData.println("    };");
        }
        if (!proc.outputs.isEmpty()) {
            outData.println("    ResultSet result = prep.executeQuery();");
            if (!proc.isSingle) {
                outData.println("    Query query = new Query(prep, result);");
                outData.println("    return query;");
                outData.println("  }");
                outData.println("  /**");
                outData.println("   * Returns the next record in a result set.");
                outData.println("   * @param query The result set for the query.");
                outData.println("   * @return true while records are found.");
                outData.println("   * @exception SQLException is passed through");
                outData.println("   */");
                outData.println("  public boolean " + procName + "(Query query) throws SQLException");
                outData.println("  {");
                outData.println("    if (!query.result.next())");
                outData.println("    {");
                outData.println("      query.close();");
                outData.println("      return false;");
                outData.println("    }");
                outData.println("    ResultSet result = query.result;");
            } else {
                outData.println("    if (!result.next())");
                outData.println("    {");
                outData.println("      result.close();");
                outData.println("      prep.close();");
                outData.println("      return false;");
                outData.println("    }");
            }
            for (i = 0; i < proc.outputs.size(); ++i) {
                field = proc.outputs.elementAt(i);
                String enumWrappedResultGet = "%s;";
                if (this.shouldUtilizeEnums() && this.hasEnums(field)) {
                    enumWrappedResultGet = field.useUpperName() + ".get(%s);";
                }
                String resultGet = "result.get%s(%d)";
                enumWrappedResultGet = String.format(enumWrappedResultGet, String.format(resultGet, this.setType(field), i + 1));
                if (!field.isNull) {
                    outData.print("    " + field.useLowerName() + " =  ");
                } else {
                    outData.print("    " + field.useLowerName() + " =  result.getObject(");
                    outData.print(i + 1);
                    outData.print(") == null?null:");
                }
                outData.println(enumWrappedResultGet);
            }
            if (proc.isSingle) {
                outData.println("    result.close();");
                outData.println("    prep.close();");
            }
            outData.println("    return true;");
        } else {
            outData.println("    prep.executeUpdate();");
            outData.println("    prep.close();");
        }
        outData.println("  }");
        if (!proc.outputs.isEmpty() && !proc.isSingle) {
            outData.println("  /**");
            outData.println("   * Returns all the records in a result set as array of " + this.extendsName + ".");
            outData.println("   * @return array of " + this.extendsName + ".");
            outData.println("   * @exception SQLException is passed through");
            outData.println("   */");
            outData.println("  public " + this.extendsName + "[] " + procName + "Load() throws SQLException");
            outData.println("  {");
            outData.println("    Vector<" + this.extendsName + "> recs = new Vector<>();");
            outData.println("    Query query = " + procName + "();");
            outData.println("    while (" + procName + "(query) == true)");
            outData.println("    {");
            outData.println("      " + this.extendsName + " rec = new " + this.extendsName + "();");
            for (i = 0; i < proc.outputs.size(); ++i) {
                field = proc.outputs.elementAt(i);
                outData.println("      rec." + field.useLowerName() + " = " + field.useLowerName() + ";");
            }
            outData.println("      recs.addElement(rec);");
            outData.println("    }");
            outData.println("    " + this.extendsName + "[] result = new " + this.extendsName + "[recs.size()];");
            outData.println("    for (int i=0; i<recs.size();i++)");
            outData.println("      result[i] = recs.elementAt(i); ");
            outData.println("    return result;");
            outData.println("  }");
        }
        if (!proc.inputs.isEmpty() || !proc.dynamics.isEmpty()) {
            String name;
            int i5;
            outData.println("  /**");
            if (proc.outputs.isEmpty()) {
                outData.println("   * Returns no records.");
            } else if (proc.isSingle) {
                outData.println("   * Returns at most one record.");
                outData.println("   * @return true if a record is returned.");
            } else {
                outData.println("   * Returns any number of records.");
                outData.println("   * @return result set of records found");
            }
            for (i = 0; i < proc.inputs.size(); ++i) {
                field = proc.inputs.elementAt(i);
                if (field.isSequence && proc.isInsert || field.type == 18 || field.type == 20 || !field.isPrimaryKey) continue;
                outData.println("   * @param " + field.useLowerName() + " key input.");
            }
            for (i = 0; i < proc.inputs.size(); ++i) {
                field = proc.inputs.elementAt(i);
                if (field.isSequence && proc.isInsert || field.type == 18 || field.type == 20 || field.isPrimaryKey) continue;
                outData.println("   * @param " + field.useLowerName() + " input.");
            }
            for (i = 0; i < proc.dynamics.size(); ++i) {
                outData.println("   * @param " + proc.name + " dynamic input.");
            }
            outData.println("   * @exception SQLException is passed through");
            outData.println("   */");
            if (proc.outputs.isEmpty()) {
                outData.println("  public void " + procName + "(");
            } else if (proc.isSingle) {
                outData.println("  public boolean " + procName + "(");
            } else {
                outData.println("  public Query " + procName + "(");
            }
            String comma = "    ";
            for (i5 = 0; i5 < proc.inputs.size(); ++i5) {
                field2 = proc.inputs.elementAt(i5);
                if (field2.isSequence && proc.isInsert || field2.type == 18 || field2.type == 20 || !field2.isPrimaryKey) continue;
                outData.println(comma + this.javaVar(field2));
                comma = "  , ";
            }
            for (i5 = 0; i5 < proc.inputs.size(); ++i5) {
                field2 = proc.inputs.elementAt(i5);
                if (field2.isSequence && proc.isInsert || field2.type == 18 || field2.type == 20 || field2.isPrimaryKey) continue;
                outData.println(comma + this.javaVar(field2));
                comma = "  , ";
            }
            for (i5 = 0; i5 < proc.dynamics.size(); ++i5) {
                name = proc.dynamics.elementAt(i5);
                outData.println(comma + "String " + name);
                comma = "  , ";
            }
            outData.println("  ) throws SQLException");
            outData.println("  {");
            for (i5 = 0; i5 < proc.inputs.size(); ++i5) {
                field2 = proc.inputs.elementAt(i5);
                if (field2.isSequence && proc.isInsert || field2.type == 18 || field2.type == 20) continue;
                String usename = field2.useLowerName();
                outData.println("    this." + usename + " = " + usename + ";");
            }
            for (i5 = 0; i5 < proc.dynamics.size(); ++i5) {
                name = proc.dynamics.elementAt(i5);
                outData.println("    this." + name + " = " + name + ";");
            }
            if (!proc.outputs.isEmpty()) {
                outData.println("    return " + procName + "();");
            } else {
                outData.println("    " + procName + "();");
            }
            outData.println("  }");
        }
    }

    private String javaVar(Field field) {
        switch (field.type) {
            case 3: {
                return "Byte " + field.useLowerName();
            }
            case 15: {
                return "Short " + field.useLowerName();
            }
            case 24: {
                return "Long " + field.useLowerName();
            }
            case 11: {
                if (this.shouldUtilizeEnums() && this.hasEnums(field)) {
                    return this.getEnumTypeName(field) + " " + field.useLowerName();
                }
            }
            case 10: 
            case 14: {
                return "Integer " + field.useLowerName();
            }
            case 12: {
                return "Long " + field.useLowerName();
            }
            case 4: 
            case 21: {
                return "String " + field.useLowerName();
            }
            case 5: {
                return "java.sql.Date " + field.useLowerName();
            }
            case 6: {
                return "Timestamp " + field.useLowerName();
            }
            case 17: {
                return "Time " + field.useLowerName();
            }
            case 18: {
                return "Timestamp " + field.useLowerName();
            }
            case 7: 
            case 9: {
                return "BigDecimal " + field.useLowerName();
            }
            case 1: {
                return "byte[] " + field.useLowerName();
            }
            case 19: {
                return "String " + field.useLowerName();
            }
            case 13: {
                return "BigDecimal " + field.useLowerName();
            }
            case 20: {
                return "String " + field.useLowerName();
            }
        }
        return "unknown";
    }

    private String getterSetter(Field field) {
        String type = null;
        switch (field.type) {
            case 3: {
                type = "Byte ";
                break;
            }
            case 15: {
                type = "Short ";
                break;
            }
            case 24: {
                type = "Long ";
                break;
            }
            case 11: {
                if (this.shouldUtilizeEnums() && this.hasEnums(field)) {
                    type = this.getEnumTypeName(field) + " ";
                    break;
                }
            }
            case 10: 
            case 14: {
                type = "Integer ";
                break;
            }
            case 12: {
                type = "Long ";
                break;
            }
            case 4: 
            case 21: {
                type = "String ";
                break;
            }
            case 5: {
                type = "java.sql.Date ";
                break;
            }
            case 6: {
                type = "Timestamp ";
                break;
            }
            case 17: {
                type = "Time ";
                break;
            }
            case 18: {
                type = "Timestamp ";
                break;
            }
            case 7: 
            case 9: {
                type = "BigDecimal ";
                break;
            }
            case 1: {
                type = "byte[] ";
                break;
            }
            case 19: {
                type = "String ";
                break;
            }
            case 13: {
                type = "BigDecimal ";
                break;
            }
            case 20: {
                type = "String ";
            }
        }
        if (type == null) {
            return "unknown";
        }
        return type + "get" + field.useName() + "(){ return " + field.useLowerName() + "; } \n  public void set" + field.useName() + "(" + type + " " + field.useLowerName() + "){ this." + field.useLowerName() + " = " + field.useLowerName() + "; }\n";
    }

    private String initJavaVar(Field field) {
        switch (field.type) {
            case 3: {
                return field.useLowerName() + " = null;";
            }
            case 4: 
            case 21: {
                return field.useLowerName() + " = null;";
            }
            case 5: {
                return field.useLowerName() + " = new Date(0);";
            }
            case 6: {
                return field.useLowerName() + " = new Timestamp(0);";
            }
            case 7: 
            case 9: {
                return field.useLowerName() + " = null;";
            }
            case 1: 
            case 19: {
                return field.useLowerName() + " = null;";
            }
            case 24: {
                return field.useLowerName() + " = null;";
            }
            case 11: {
                if (this.shouldUtilizeEnums() && this.hasEnums(field)) {
                    return field.useLowerName() + " = null;";
                }
            }
            case 10: 
            case 14: {
                return field.useLowerName() + " = null;";
            }
            case 12: {
                return field.useLowerName() + " = null;";
            }
            case 13: {
                return field.useLowerName() + " = null;";
            }
            case 15: {
                return field.useLowerName() + " = null;";
            }
            case 17: {
                return field.useLowerName() + " = new Time(0);";
            }
            case 18: {
                return field.useLowerName() + " = new Timestamp(0);";
            }
            case 20: {
                return field.useLowerName() + " = null;";
            }
        }
        return "unknown";
    }

    private String setType(Field field) {
        switch (field.type) {
            case 3: {
                return "Byte";
            }
            case 4: 
            case 21: {
                return "String";
            }
            case 5: {
                return "Date";
            }
            case 6: {
                return "Timestamp";
            }
            case 7: 
            case 9: {
                return "BigDecimal";
            }
            case 1: {
                return "Bytes";
            }
            case 19: {
                return "String";
            }
            case 24: {
                return "Long";
            }
            case 10: 
            case 11: 
            case 14: {
                return "Int";
            }
            case 12: {
                return "Long";
            }
            case 13: {
                return "BigDecimal";
            }
            case 15: {
                return "Short";
            }
            case 17: {
                return "Time";
            }
            case 18: {
                return "Timestamp";
            }
            case 20: {
                return "String";
            }
        }
        return "unknown";
    }

    private String padded(int size) {
        String padString = "                                                         ";
        if (size == 0) {
            return "";
        }
        if (size > padString.length()) {
            size = padString.length();
        }
        return padString.substring(0, size);
    }

    private String underScoreWords(String input) {
        char[] bits = input.toCharArray();
        StringBuilder builder = new StringBuilder();
        builder.append(bits[0]);
        for (int i = 1; i < bits.length; ++i) {
            if ("ABCDEFGHIJKLMNOPQRSTUVWXYZ".indexOf(bits[i]) >= 0 && bits[i - 1] != ' ') {
                builder.append('_');
                builder.append(bits[i]);
                continue;
            }
            builder.append(bits[i]);
        }
        return builder.toString();
    }

    private String splitWords(String input) {
        char[] bits = this.underScoreWords(input).toCharArray();
        StringBuilder builder = new StringBuilder();
        builder.append(bits[0]);
        for (int i = 1; i < bits.length; ++i) {
            if (bits[i] == '_') {
                builder.append(' ');
                continue;
            }
            builder.append(bits[i]);
        }
        return builder.toString();
    }

    private void generateEnum(Table table, PrintWriter outData) {
        for (int i = 0; i < table.fields.size(); ++i) {
            Field field = table.fields.elementAt(i);
            if (field.enums.isEmpty()) continue;
            outData.println("  public enum " + this.getEnumTypeName(field));
            outData.println("  {");
            for (int j = 0; j < field.enums.size(); ++j) {
                Enum element = field.enums.elementAt(j);
                String evalue = "" + element.value;
                if (field.type == 21 && field.length == 1) {
                    evalue = "'" + (char)element.value + "'";
                }
                String keyName = this.underScoreWords(element.name).toUpperCase();
                outData.println("    " + keyName + "(" + evalue + ", \"" + this.splitWords(element.name) + "\")" + (j + 1 < field.enums.size() ? "," : ";"));
            }
            outData.println("    public int key;");
            outData.println("    public String value;");
            outData.println("    " + field.useUpperName() + "(int key, String value)");
            outData.println("    {");
            outData.println("      this.key = key;");
            outData.println("      this.value = value;");
            outData.println("    }");
            outData.println("    public static " + field.useUpperName() + " get(int key)");
            outData.println("    {");
            outData.println("      for (" + field.useUpperName() + " op : values())");
            outData.println("        if (op.key == key) return op;");
            outData.println("      return null;");
            outData.println("    }");
            outData.println("    public String toString()");
            outData.println("    {");
            outData.println("      return value;");
            outData.println("    }");
            outData.println("  }");
        }
    }

    private boolean hasEnums(Field field) {
        return field.getEnums() != null && !field.getEnums().isEmpty();
    }

    private boolean hasEnums(Table table) {
        return table.getFields().stream().anyMatch(this::hasEnums);
    }

    public List<Field> getAllEnumFields(Table table) {
        return table.getFields().stream().filter(this::hasEnums).collect(Collectors.toList());
    }

    private void generateEnumImports(Table table, PrintWriter outData) {
        String enumImport = "import %s.%s%s.%s;";
        if (this.shouldUtilizeEnums() && this.hasEnums(table)) {
            for (Field field : this.getAllEnumFields(table)) {
                outData.println(String.format(enumImport, table.getDatabase().getPackageName(), table.getName(), ENTITY_CLASS_SUFFIX, this.getEnumTypeName(field)));
            }
        }
    }

    private void generateLombokImport(PrintWriter outData) {
        if (this.shouldGenerateLombok()) {
            outData.println("import lombok.*;");
        }
    }

    private void generateLombokAnnotations(PrintWriter outData) {
        if (this.shouldGenerateLombok()) {
            outData.println("@Data");
            outData.println("@Builder");
            outData.println("@AllArgsConstructor");
        }
    }

    private String getEnumTypeName(Field field) {
        if (field.getEnumType() != null && !field.getEnumType().isEmpty()) {
            return field.getEnumType();
        }
        return field.useUpperName();
    }

    private boolean shouldUtilizeEnums() {
        return this.flags.contains(FLAG_UTILIZE_ENUMS);
    }

    private boolean shouldGenerateLombok() {
        return this.flags.contains(FLAG_GEN_LOMBOK);
    }
}

