/*
 * Decompiled with CFR 0.152.
 */
package net.sf.extcos.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.sf.extcos.collection.MultiplexingSet;
import net.sf.extcos.util.Assert;

public class BlockingCopyMultiplexingSet<E>
implements MultiplexingSet<E> {
    private Set<E> master;
    private final List<Set<? super E>> slaves = new ArrayList<Set<? super E>>();

    @Override
    public boolean addSlaveSet(Set<? super E> slave) {
        Assert.notNull(slave, Assert.iae());
        Assert.state(this.master != null);
        slave.clear();
        return this.slaves.add(slave);
    }

    @Override
    public void removeSets() {
        this.master = null;
        this.slaves.clear();
    }

    @Override
    public boolean removeSlaveSet(Set<? super E> slave) {
        Assert.notNull(slave, Assert.iae());
        Assert.state(this.master != null);
        return this.slaves.remove(slave);
    }

    @Override
    public void setMasterSet(Set<E> master) {
        Assert.notNull(master, Assert.iae());
        master.clear();
        this.master = master;
    }

    @Override
    public boolean add(E e) {
        Assert.state(this.master != null);
        if (this.master.add(e)) {
            for (Set<E> slave : this.slaves) {
                slave.add(e);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        Assert.state(this.master != null);
        if (this.master.addAll(c)) {
            for (Set<? extends E> set : this.slaves) {
                set.addAll(c);
            }
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        Assert.state(this.master != null);
        this.master.clear();
        for (Set<E> slave : this.slaves) {
            slave.clear();
        }
    }

    @Override
    public boolean contains(Object obj) {
        Assert.state(this.master != null);
        return this.master.contains(obj);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        Assert.state(this.master != null);
        return this.master.containsAll(c);
    }

    @Override
    public boolean isEmpty() {
        Assert.state(this.master != null);
        return this.master.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        Assert.state(this.master != null);
        return this.master.iterator();
    }

    @Override
    public boolean remove(Object obj) {
        Assert.state(this.master != null);
        if (this.master.remove(obj)) {
            for (Set<E> slave : this.slaves) {
                slave.remove(obj);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        Assert.state(this.master != null);
        if (this.master.removeAll(c)) {
            for (Set<E> slave : this.slaves) {
                slave.removeAll(c);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        Assert.state(this.master != null);
        ArrayList<E> remove = new ArrayList<E>();
        for (E e : this.master) {
            if (c.contains(e)) continue;
            remove.add(e);
        }
        if (remove.isEmpty()) {
            return false;
        }
        return this.removeAll(remove);
    }

    @Override
    public int size() {
        Assert.state(this.master != null);
        return this.master.size();
    }

    @Override
    public Object[] toArray() {
        Assert.state(this.master != null);
        return this.master.toArray();
    }

    @Override
    public <T> T[] toArray(T[] array) {
        Assert.state(this.master != null);
        return this.master.toArray(array);
    }
}

