/*
 * Decompiled with CFR 0.152.
 */
package net.sf.extcos.internal;

import java.util.Set;
import net.sf.extcos.ComponentQuery;
import net.sf.extcos.filter.Filter;
import net.sf.extcos.internal.ArraySet;
import net.sf.extcos.internal.BuildContext;
import net.sf.extcos.internal.DefaultResourceResolver;
import net.sf.extcos.internal.FilterChainBuilder;
import net.sf.extcos.resource.Resource;
import net.sf.extcos.selector.BasePackageSelector;
import net.sf.extcos.selector.ForwardingBuilder;
import net.sf.extcos.selector.Package;
import net.sf.extcos.selector.ResourceTypeSelector;
import net.sf.extcos.selector.StoreBinding;
import net.sf.extcos.selector.StoreReturning;
import net.sf.extcos.spi.QueryContext;
import net.sf.extcos.spi.ResourceResolver;
import net.sf.extcos.spi.ResourceType;
import net.sf.extcos.util.Assert;

public class ComponentSelectionProcessor {
    private final ComponentQuery componentSelector;
    private final ResourceTypeSelector resourceTypeSelector = new ResourceTypeSelector();
    private final FilterChainBuilder filterChainBuilder = new FilterChainBuilder();
    private final Set<Resource> resources = new ArraySet<Resource>();
    private final Set<Resource> filtered = new ArraySet<Resource>();
    private final Set<Class<?>> classes = new ArraySet();
    private Set<ResourceResolver> resourceResolvers;
    private Set<ResourceType> resourceTypes;
    private Set<Package> basePackages;
    private Set<StoreBinding> storeBindings;
    private StoreReturning returning;

    public ComponentSelectionProcessor(ComponentQuery componentSelector) {
        Assert.notNull(componentSelector, Assert.iae());
        this.componentSelector = componentSelector;
    }

    public Set<Class<?>> process() {
        this.init();
        for (Package basePackage : this.basePackages) {
            for (ResourceResolver resourceResolver : this.resourceResolvers) {
                this.resources.addAll(resourceResolver.getResources(this.resourceTypes, basePackage));
            }
        }
        if (!this.resources.isEmpty()) {
            Filter filter = this.filterChainBuilder.build(this.storeBindings, this.returning, this.filtered, this.classes);
            filter.filter(this.resources);
            for (Resource resource : this.filtered) {
                resource.generateAndDispatchClass();
            }
        }
        BuildContext.getInstance().reset();
        QueryContext.getInstance().reset();
        return this.classes;
    }

    private void init() {
        this.componentSelector.configure(this.resourceTypeSelector);
        this.resourceTypes = this.resourceTypeSelector.getResourceTypes();
        BasePackageSelector basePackageSelector = this.resourceTypeSelector.getBasePackageSelector();
        this.basePackages = basePackageSelector.getBasePackages();
        QueryContext.getInstance().setIncludeEnums(basePackageSelector.isIncludingEnums());
        ForwardingBuilder forwardingBuilder = basePackageSelector.getForwardingBuilder();
        this.resourceResolvers = forwardingBuilder.getResourceResolvers();
        if (this.resourceResolvers.isEmpty()) {
            this.resourceResolvers.add(new DefaultResourceResolver());
        }
        this.storeBindings = forwardingBuilder.getStoreBindings();
        this.returning = forwardingBuilder.getReturning();
    }
}

