/*
 * Decompiled with CFR 0.152.
 */
package net.sf.extcos.internal;

import java.lang.reflect.Modifier;
import net.sf.extcos.exception.ConcurrentInspectionException;
import net.sf.extcos.filter.ResourceMatcher;
import net.sf.extcos.resource.Resource;
import net.sf.extcos.util.Assert;

public class ExtendingResourceMatcher
implements ResourceMatcher {
    private final Class<?> clazz;

    public ExtendingResourceMatcher(Class<?> clazz) {
        Assert.notNull(clazz, IllegalArgumentException.class);
        Assert.isFalse(clazz.isInterface(), IllegalArgumentException.class);
        Assert.isFalse(Modifier.isFinal(clazz.getModifiers()), IllegalArgumentException.class);
        this.clazz = clazz;
    }

    @Override
    public boolean matches(Resource resource) throws ConcurrentInspectionException {
        Assert.notNull(resource, IllegalArgumentException.class);
        return resource.isSubclassOf(this.clazz);
    }

    @Override
    public boolean isMatcherFor(Object obj) {
        return this.clazz.equals(obj);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.clazz == null ? 0 : this.clazz.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExtendingResourceMatcher other = (ExtendingResourceMatcher)obj;
        return !(this.clazz == null ? other.clazz != null : !this.clazz.equals(other.clazz));
    }
}

