/*
 * Decompiled with CFR 0.152.
 */
package net.sf.extcos.internal;

import java.util.LinkedHashSet;
import java.util.Set;
import net.sf.extcos.filter.Filter;
import net.sf.extcos.filter.ImmediateConnector;
import net.sf.extcos.filter.ResultSetProvider;
import net.sf.extcos.internal.BlockingCopyMultiplexingSet;
import net.sf.extcos.internal.BuildContext;
import net.sf.extcos.internal.BuildSupport;
import net.sf.extcos.internal.EnumBasedReturning;
import net.sf.extcos.internal.FilterObjects;
import net.sf.extcos.internal.ImmediateConnectorImpl;
import net.sf.extcos.internal.Returning;
import net.sf.extcos.internal.RootFilter;
import net.sf.extcos.internal.StandardMultiplexingConnector;
import net.sf.extcos.internal.StandardResultSetProvider;
import net.sf.extcos.internal.TypeFilterBasedReturning;
import net.sf.extcos.resource.Resource;
import net.sf.extcos.selector.StoreBinding;
import net.sf.extcos.selector.StoreReturning;
import net.sf.extcos.selector.TypeFilter;
import net.sf.extcos.util.Assert;

public class FilterChainBuilder {
    private final ResultSetProvider standardProvider = new StandardResultSetProvider();
    private final BuildContext buildContext = BuildContext.getInstance();
    private final BuildSupport buildSupport = new BuildSupport();
    private Set<StoreBinding> storeBindings;
    private StoreReturning returning;
    private Set<Resource> filtered;
    private Set<Class<?>> returnClasses;

    public Filter build(Set<StoreBinding> storeBindings, StoreReturning returning, Set<Resource> filtered, Set<Class<?>> returnClasses) {
        this.init(storeBindings, returning, filtered, returnClasses);
        this.processStoreBindings();
        this.optimizeFilterObjects();
        this.finalizeImmediateConnectors();
        return this.generateRootFilter();
    }

    private void init(Set<StoreBinding> storeBindings, StoreReturning returning, Set<Resource> filtered, Set<Class<?>> returnClasses) {
        Assert.notNull(returning, Assert.iae());
        Assert.notNull(filtered, Assert.iae());
        Assert.notNull(returnClasses, Assert.iae());
        if (returning instanceof TypeFilterBasedReturning) {
            TypeFilter returningFilter = ((TypeFilterBasedReturning)returning).getTypeFilter();
            StoreBinding returningBinding = new StoreBinding(returningFilter, returnClasses);
            storeBindings.add(returningBinding);
        }
        this.storeBindings = storeBindings;
        this.returning = returning;
        this.filtered = filtered;
        this.returnClasses = returnClasses;
    }

    private void processStoreBindings() {
        for (StoreBinding storeBinding : this.storeBindings) {
            ImmediateConnectorImpl ic = new ImmediateConnectorImpl();
            ic.setReceivingSet(storeBinding.getStore());
            this.buildContext.addImmediateConnector(ic);
            this.buildSupport.buildFilterObjects(storeBinding.getTypeFilter(), ic);
        }
    }

    private void optimizeFilterObjects() {
        this.optimizeExtendingFilterObjects();
        this.optimizeImplementingFilterObjects();
    }

    private void optimizeExtendingFilterObjects() {
    }

    private void optimizeImplementingFilterObjects() {
    }

    private void finalizeImmediateConnectors() {
        Iterable<ImmediateConnector> connectors = this.buildContext.getImmediateConnectors();
        for (ImmediateConnector connector : connectors) {
            connector.setFilteredRegistry(this.filtered);
        }
        if (this.returningAllMerged()) {
            for (ImmediateConnector connector : connectors) {
                Set<Class<?>> receivingSet = connector.getReceivingSet();
                BlockingCopyMultiplexingSet multiSet = new BlockingCopyMultiplexingSet();
                multiSet.setMasterSet(receivingSet);
                multiSet.addSlaveSet(this.returnClasses);
                connector.setReceivingSet(multiSet);
            }
        }
    }

    private Filter generateRootFilter() {
        Set<FilterObjects> filterObjectss = this.buildContext.getAllFilterObjects();
        RootFilter rootFilter = new RootFilter();
        if (!filterObjectss.isEmpty()) {
            LinkedHashSet<Filter> filters = new LinkedHashSet<Filter>();
            for (FilterObjects filterObjects : filterObjectss) {
                filters.add(filterObjects.buildFilter());
            }
            rootFilter.setResultSetProvider(this.standardProvider);
            rootFilter.setChildFilters(filters);
        }
        if (this.returningAll()) {
            ImmediateConnectorImpl connector = new ImmediateConnectorImpl();
            connector.setFilteredRegistry(this.filtered);
            connector.setReceivingSet(this.returnClasses);
            StandardMultiplexingConnector dispatcher = new StandardMultiplexingConnector();
            dispatcher.addConnector(connector);
            rootFilter.setResourceDispatcher(dispatcher);
        }
        return this.buildContext.prependInterceptors(rootFilter);
    }

    private boolean returningAll() {
        if (this.returning instanceof EnumBasedReturning) {
            return ((EnumBasedReturning)this.returning).getReturningType() == Returning.ALL;
        }
        return false;
    }

    private boolean returningAllMerged() {
        if (this.returning instanceof EnumBasedReturning) {
            return ((EnumBasedReturning)this.returning).getReturningType() == Returning.ALL_MERGED;
        }
        return false;
    }
}

