/*
 * Decompiled with CFR 0.152.
 */
package net.sf.extcos.internal;

import net.sf.extcos.filter.Filter;
import net.sf.extcos.filter.FilterInterceptor;
import net.sf.extcos.internal.ThreadManager;
import net.sf.extcos.resource.Resource;
import net.sf.extcos.util.Assert;
import net.sf.extcos.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadingFilterInterceptor
implements FilterInterceptor {
    private static Logger logger = LoggerFactory.getLogger(ThreadingFilterInterceptor.class);
    private final ThreadManager threadManager = ThreadManager.getInstance();
    private Filter filter;

    public ThreadingFilterInterceptor() {
        this.threadManager.register();
    }

    @Override
    public void setInterceptedFilter(Filter filter) {
        try {
            Assert.notNull(filter, IllegalArgumentException.class, "filter must not be null");
            this.filter = filter;
            if (logger.isTraceEnabled()) {
                logger.trace(StringUtils.append("successfully set intercepted filter to ", filter));
            }
        }
        catch (IllegalArgumentException e) {
            logger.debug("couldn't set intercepted filter", e);
        }
    }

    @Override
    public void filter(final Iterable<Resource> resources) {
        if (this.filter == null) {
            logger.warn("intercepted filter is not set, hence nothing to intercept");
            return;
        }
        this.threadManager.invoke(new Runnable(){

            @Override
            public void run() {
                ThreadingFilterInterceptor.this.filter.filter(resources);
            }
        });
    }
}

