/*
 * Decompiled with CFR 0.152.
 */
package net.sf.extcos.util;

import java.util.Collection;
import java.util.Map;
import net.sf.extcos.util.PropertyInjector;

public class Assert {
    private Assert() {
    }

    public static void containsOnly(Collection<?> collection, Class<?> valueType, Class<? extends RuntimeException> exceptionType) {
        Assert.containsOnly(collection, valueType, exceptionType, null);
    }

    public static void containsOnly(Collection<?> collection, Class<?> valueType, Class<? extends RuntimeException> exceptionType, String message) {
        Assert.notEmpty(collection, exceptionType, message);
        for (Object object : collection) {
            Assert.instanceOf(object, valueType, exceptionType, message);
        }
    }

    public static void greaterThan(int a, int b, Class<? extends RuntimeException> exceptionType) {
        Assert.greaterThan(a, b, exceptionType, null);
    }

    public static void greaterThan(int a, int b, Class<? extends RuntimeException> exceptionType, String message) {
        if (a <= b) {
            throw Assert.createException(exceptionType, message, null);
        }
    }

    public static void identical(Object a, Object b, Class<? extends RuntimeException> exceptionType) {
        Assert.identical(a, b, exceptionType, null);
    }

    public static void identical(Object a, Object b, Class<? extends RuntimeException> exceptionType, String message) {
        if (a != b) {
            throw Assert.createException(exceptionType, message, null);
        }
    }

    public static void instanceOf(Object o, Class<?> c, Class<? extends RuntimeException> exceptionType) {
        Assert.instanceOf(o, c, exceptionType, null);
    }

    public static void instanceOf(Object o, Class<?> c, Class<? extends RuntimeException> exceptionType, String message) {
        if (o == null || c == null || !c.isAssignableFrom(o.getClass())) {
            throw Assert.createException(exceptionType, message, null);
        }
    }

    public static void isFalse(boolean b, Class<? extends RuntimeException> exceptionType) {
        Assert.isFalse(b, exceptionType, null);
    }

    public static void isFalse(boolean b, Class<? extends RuntimeException> exceptionType, String message) {
        if (b) {
            throw Assert.createException(exceptionType, message, null);
        }
    }

    public static void isNull(Object o, Class<? extends RuntimeException> exceptionType) {
        Assert.isNull(o, exceptionType, null);
    }

    public static void isNull(Object o, Class<? extends RuntimeException> exceptionType, String message) {
        if (o != null) {
            throw Assert.createException(exceptionType, message, null);
        }
    }

    public static void isTrue(boolean b, Class<? extends RuntimeException> exceptionType) {
        Assert.isTrue(b, exceptionType, null);
    }

    public static void isTrue(boolean b, Class<? extends RuntimeException> exceptionType, String message) {
        if (!b) {
            throw Assert.createException(exceptionType, message, null);
        }
    }

    public static <T> void notEmpty(T[] array, Class<? extends RuntimeException> exceptionType) {
        Assert.notEmpty(array, exceptionType, null);
    }

    public static <T> void notEmpty(T[] array, Class<? extends RuntimeException> exceptionType, String message) {
        if (array == null || array.length == 0) {
            throw Assert.createException(exceptionType, message, null);
        }
    }

    public static void notEmpty(Collection<?> collection, Class<? extends RuntimeException> exceptionType) {
        Assert.notEmpty(collection, exceptionType, null);
    }

    public static void notEmpty(Collection<?> collection, Class<? extends RuntimeException> exceptionType, String message) {
        if (collection == null || collection.isEmpty()) {
            throw Assert.createException(exceptionType, message, null);
        }
    }

    public static void notEmpty(Map<?, ?> map, Class<? extends RuntimeException> exceptionType) {
        Assert.notEmpty(map, exceptionType, null);
    }

    public static void notEmpty(Map<?, ?> map, Class<? extends RuntimeException> exceptionType, String message) {
        if (map == null || map.isEmpty()) {
            throw Assert.createException(exceptionType, message, null);
        }
    }

    public static void notEmpty(String string, Class<? extends RuntimeException> exceptionType) {
        Assert.notEmpty(string, exceptionType, null);
    }

    public static void notEmpty(String string, Class<? extends RuntimeException> exceptionType, String message) {
        if (string == null || string.equals("")) {
            throw Assert.createException(exceptionType, message, null);
        }
    }

    public static void notNull(Object o, Class<? extends RuntimeException> exceptionType) {
        Assert.notNull(o, exceptionType, null);
    }

    public static void notNull(Object o, Class<? extends RuntimeException> exceptionType, String message) {
        if (o == null) {
            throw Assert.createException(exceptionType, message, null);
        }
    }

    public static void state(boolean state) {
        if (!state) {
            throw new IllegalStateException();
        }
    }

    public static void state(boolean state, String message) {
        if (!state) {
            throw new IllegalStateException(message);
        }
    }

    public static void subclassOf(Class<?> a, Class<?> b, Class<? extends RuntimeException> exceptionType) {
        Assert.subclassOf(a, b, exceptionType, null);
    }

    public static void subclassOf(Class<?> a, Class<?> b, Class<? extends RuntimeException> exceptionType, String message) {
        if (a == null || b == null || !b.isAssignableFrom(a)) {
            throw Assert.createException(exceptionType, message, null);
        }
    }

    public static Class<IllegalArgumentException> iae() {
        return IllegalArgumentException.class;
    }

    public static Class<IllegalStateException> ise() {
        return IllegalStateException.class;
    }

    public static Class<AssertionError> ae() {
        return AssertionError.class;
    }

    private static RuntimeException createException(Class<? extends RuntimeException> exceptionType, String message, Throwable cause) {
        RuntimeException re;
        try {
            re = exceptionType.newInstance();
        }
        catch (Exception e) {
            re = new RuntimeException();
        }
        if (message != null || cause != null) {
            try {
                PropertyInjector injector = new PropertyInjector();
                injector.setTarget(re);
                if (message != null) {
                    injector.inject("detailMessage", message);
                }
                if (cause != null) {
                    injector.inject("cause", cause);
                }
            }
            catch (NoSuchFieldException ignored) {
                // empty catch block
            }
        }
        return re;
    }
}

