/*
 * Decompiled with CFR 0.152.
 */
package net.sf.extcos.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import net.sf.extcos.util.Assert;
import net.sf.extcos.util.StringUtils;

public class ResourceUtils {
    public static final String FILE_URL_PREFIX = "file:";
    public static final String URL_PROTOCOL_FILE = "file";
    public static final String URL_PROTOCOL_JAR = "jar";
    public static final String URL_PROTOCOL_ZIP = "zip";
    public static final String URL_PROTOCOL_VFSZIP = "vfszip";
    public static final String URL_PROTOCOL_VFS = "vfs";
    public static final String URL_PROTOCOL_WSJAR = "wsjar";
    public static final String URL_PROTOCOL_CODE_SOURCE = "code-source";
    public static final String JAR_URL_SEPARATOR = "!/";

    private ResourceUtils() {
    }

    public static boolean isJarURL(URL url) {
        String protocol = url.getProtocol();
        return URL_PROTOCOL_JAR.equals(protocol) || URL_PROTOCOL_ZIP.equals(protocol) || URL_PROTOCOL_WSJAR.equals(protocol) || URL_PROTOCOL_CODE_SOURCE.equals(protocol) && url.getPath().indexOf(JAR_URL_SEPARATOR) != -1;
    }

    public static boolean isVirtualFileSystemURL(URL url) {
        return url.getProtocol().startsWith(URL_PROTOCOL_VFS);
    }

    public static File getFile(URL resourceUrl) throws FileNotFoundException {
        return ResourceUtils.getFile(resourceUrl, StringUtils.append("URL [", resourceUrl, "]"));
    }

    public static File getFile(URL resourceUrl, String description) throws FileNotFoundException {
        Assert.notNull(resourceUrl, IllegalArgumentException.class, "Resource URL must not be null");
        if (!URL_PROTOCOL_FILE.equals(resourceUrl.getProtocol())) {
            throw new FileNotFoundException(StringUtils.append(description, " cannot be resolved to absolute file path ", "because it does not reside in the file system: ", resourceUrl));
        }
        try {
            return new File(ResourceUtils.toURI(resourceUrl).getSchemeSpecificPart());
        }
        catch (URISyntaxException ex) {
            return new File(resourceUrl.getFile());
        }
    }

    public static URI toURI(URL url) throws URISyntaxException {
        return ResourceUtils.toURI(url.toString());
    }

    public static URI toURI(String location) throws URISyntaxException {
        return new URI(StringUtils.replace(location, " ", "%20"));
    }

    public static URL toURL(File file) throws MalformedURLException {
        return file.toURI().toURL();
    }

    public static boolean matches(URL rootDirectory, String basePath, List<String> subPathElements) {
        if (subPathElements.isEmpty()) {
            return true;
        }
        StringBuilder pattern = new StringBuilder(".*").append(basePath);
        for (String subPathElement : subPathElements) {
            if ("*".equals(subPathElement)) {
                pattern.append("[_$a-zA-Z][_$a-zA-Z0-9]*").append("/");
                continue;
            }
            if ("**".equals(subPathElement)) {
                pattern.append("(?:").append("[_$a-zA-Z][_$a-zA-Z0-9]*").append("/)+");
                continue;
            }
            pattern.append(subPathElement).append("/");
        }
        pattern.append(".*");
        return rootDirectory.toString().matches(pattern.toString());
    }
}

