/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.artifact.filter.resolve.transform;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.shared.artifact.filter.resolve.AbstractFilter;
import org.apache.maven.shared.artifact.filter.resolve.AndFilter;
import org.apache.maven.shared.artifact.filter.resolve.ExclusionsFilter;
import org.apache.maven.shared.artifact.filter.resolve.FilterTransformer;
import org.apache.maven.shared.artifact.filter.resolve.OrFilter;
import org.apache.maven.shared.artifact.filter.resolve.PatternExclusionsFilter;
import org.apache.maven.shared.artifact.filter.resolve.PatternInclusionsFilter;
import org.apache.maven.shared.artifact.filter.resolve.ScopeFilter;
import org.apache.maven.shared.artifact.filter.resolve.TransformableFilter;
import org.apache.maven.shared.artifact.filter.resolve.transform.SonatypeAetherNode;
import org.sonatype.aether.graph.DependencyFilter;
import org.sonatype.aether.graph.DependencyNode;
import org.sonatype.aether.util.filter.AndDependencyFilter;
import org.sonatype.aether.util.filter.ExclusionsDependencyFilter;
import org.sonatype.aether.util.filter.OrDependencyFilter;
import org.sonatype.aether.util.filter.PatternExclusionsDependencyFilter;
import org.sonatype.aether.util.filter.PatternInclusionsDependencyFilter;
import org.sonatype.aether.util.filter.ScopeDependencyFilter;

public class SonatypeAetherFilterTransformer
implements FilterTransformer<DependencyFilter> {
    @Override
    public AndDependencyFilter transform(AndFilter filter) {
        ArrayList<DependencyFilter> filters = new ArrayList<DependencyFilter>(filter.getFilters().size());
        for (TransformableFilter dependencyFilter : filter.getFilters()) {
            filters.add(dependencyFilter.transform(this));
        }
        return new AndDependencyFilter(filters);
    }

    @Override
    public ExclusionsDependencyFilter transform(ExclusionsFilter filter) {
        return new ExclusionsDependencyFilter(filter.getExcludes());
    }

    @Override
    public OrDependencyFilter transform(OrFilter filter) {
        ArrayList<DependencyFilter> filters = new ArrayList<DependencyFilter>(filter.getFilters().size());
        for (TransformableFilter dependencyFilter : filter.getFilters()) {
            filters.add(dependencyFilter.transform(this));
        }
        return new OrDependencyFilter(filters);
    }

    @Override
    public ScopeDependencyFilter transform(ScopeFilter filter) {
        return new ScopeDependencyFilter(filter.getIncluded(), filter.getExcluded());
    }

    @Override
    public DependencyFilter transform(PatternExclusionsFilter filter) {
        return new PatternExclusionsDependencyFilter(filter.getExcludes());
    }

    @Override
    public DependencyFilter transform(PatternInclusionsFilter filter) {
        return new PatternInclusionsDependencyFilter(filter.getIncludes());
    }

    @Override
    public DependencyFilter transform(final AbstractFilter filter) {
        return new DependencyFilter(){

            @Override
            public boolean accept(DependencyNode node, List<DependencyNode> parents) {
                return filter.accept(new SonatypeAetherNode(node), null);
            }
        };
    }
}

