/* JPortal.java */
/* Generated by: ParserGeneratorCC: Do not edit this line. JPortal.java */
/// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
/// Copyright (c) from 1996 Vincent Risi
///
/// All rights reserved.
/// This program and the accompanying materials are made available
/// under the terms of the Common Public License v1.0
/// which accompanies this distribution and is available at
/// http://www.eclipse.org/legal/cpl-v10.html
/// Contributors:
///    Vincent Risi, Hennie Hammann
///    Dieter Rosch
///    Zoran Pavlovic
/// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
package bbd.jportal2;

import java.util.*;
import java.io.*;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
* JDBC Database Definition Compiler and Generator
*/
public class JPortal implements JPortalConstants {
  private static final Logger logger = LoggerFactory.getLogger(JPortal.class);

  protected static Database  database;
  protected static Table     table;
  protected static Enum      entry;
  protected static Field     field;
  protected static Const     constant;
  protected static Value     value;
  protected static Grant     grant;
  protected static Key       key;
  protected static Link      link;
  protected static View      view;
  protected static Proc      proc;
  protected static Parameter parameter;
  protected static String    perm;
  protected static String    user;
  protected static String    line;
  protected static String    inDir;
  static private boolean parser_initialised = false;
  static private boolean fieldsNullByDefault = false;
  static private boolean isLiteral = false;
  static private String literal = "";

  /**
  * Reads input from standard input
  */
  public static void main(String args[])
  {
    try
    {
      for (int i = 0; i <args.length; i++)
      {
        System.out.println(args[i]+": Parsing ...");
        setFieldsNullState(false);
        run(args[i]);
      }
    }
    catch (Exception e)
    {
      e.printStackTrace();
    }
  }
  /**
  * Reads input from supplied file
  * @param  inFile is the input file to parse
  * @return Table from jbdcdef package
  */
  public static Database run(String inFile)
  {
    return run(inFile);
  }
  public static Database run(String inFile, String inNub, JPortalTemplateOutputOptions options)
  {
    try
    {
      FileReader reader = new FileReader(inFile);
      try
      {
        return run(inFile, inNub, reader, options);
      }
      finally
      {
        reader.close();
      }
    }
    catch (Exception e)
    {
      e.printStackTrace();
    }
    return null;
  }
  private static void setupNub(String inNub)
  {
    inDir = inNub;
  }

  public static void clearDatabase() {
      database = null;
  }

  public static Database run(String inFile, Reader reader, JPortalTemplateOutputOptions options)
  {
    return run(inFile, "", reader, options);
  }
  public static Database run(String inFile, String inNub, Reader reader, JPortalTemplateOutputOptions options)
  {
    setupNub(inNub);
    try
    {
      if (!parser_initialised)
      {
        new JPortal(reader);
        parser_initialised = true;
      }
      else
        JPortal.ReInit(reader);
      table = null;
      entry = null;
      field = null;
      constant = null;
      value = null;
      grant = null;
      key = null;
      link = null;
      view = null;
      proc = null;
      parameter = null;
      perm = null;
      user = null;
      line = null;
      isLiteral = false;
      literal = "";
      if (database == null) {
        database = new Database();
      }
      database.templateOutputOptions = options;
      JPortal.jInput();
      return database;
    }
    catch (ParseException e)
    {
      logger.error("ParseException",e);
      e.printStackTrace();
    }
    catch (Exception e)
    {
      e.printStackTrace();
    }
    return null;
  }
  /**
  * How to create tables null field state
  */
  public static void setFieldsNullState(boolean state)
  {
    fieldsNullByDefault = state;
  }
  public static Database loadBinFile(String inFile)
  {
    return database;
  }
  static String fixString(String s)
  {
    return s.substring(1, s.length()-1);
  }
  static String parseConsts(String s)
  {
    StringBuffer buffer = new StringBuffer();
    for (int cB = s.indexOf("%"); cB != -1; cB = s.indexOf("%"))
    {
      if (cB > 0)
      {
        buffer.append(s.substring(0,cB));
        s = s.substring(cB+1);
      }
      // Looking for %xxx%
      int cE = s.indexOf("%");
      // If no closing % - use % asis and finish
      if (cE == -1)
      {
        buffer.append('%');
        break;
      }
      // Treat %% as an escape for %
      if (cE == 0)
      {
        buffer.append('%');
        s = s.substring(1);
        continue;
      }
      // Check for Const in form fieldName.enumName
      String lookup = s.substring(0,cE);
      int cP = lookup.indexOf(".");
      if (cP > 0)
      {
        String fieldName = lookup.substring(0,cP);
        String enumName = lookup.substring(cP+1);
        Field field = table.getField(fieldName);
        if (field != null)
        {
          boolean done = false;
          for (int i=0; i < field.enums.size(); i++)
          {
            Enum entry = (Enum) field.enums.elementAt(i);
            if (entry.name.equalsIgnoreCase(enumName))
            {
              String evalue = ""+entry.value;
              if (field.type == Field.ANSICHAR &&  field.length == 1)
                 evalue = "'"+(char)entry.value+"'";
              buffer.append(evalue);
              s = s.substring(cE+1);
              done = true;
              break;
            }
          }
          if (done == true)
            continue;
        }
      }
      // pass %xxx% through asis
      buffer.append('%');
      buffer.append(lookup);
      buffer.append('%');
      s = s.substring(cE+1);
    }
    buffer.append(s);
    return buffer.toString();
  }
  static String parseDynamics(String s)
  {
    s = parseConsts(s);
    Line line;
    Integer size;
    for (int dB = s.indexOf("&"); dB != -1; dB = s.indexOf("&"))
    {
      if (dB > 0)
      {
        line = new Line(database.templateOutputOptions, new SQLProcStringToken(s.substring(0, dB)),new SQLProcStringToken(" "));
        proc.lines.addElement(line);
        s = s.substring(dB);
      }
      int dE;
      boolean strung = false;
      int addB = 0;
      int addE = 0;
      char c = 0;
      for (dE=1; dE < s.length(); dE++)
      {
        c = s.charAt(dE);
        if (dE == 1 && c == '\'')
        {
          strung = true;
          addB = 1;
          continue;
        }
        String valid = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789_()";
        if (valid.indexOf(c) == -1)
          break;
      }
      if (strung == true && c == '\'')
      {
        addE = 1;
        dE++;
      }
      String dVar = s.substring(1+addB, dE-addB);
      s = s.substring(dE);
      int sB = dVar.indexOf("(");
      int sE = dVar.indexOf(")");
      size = new Integer(256);
      if (sB > 0)
      {
        //int sE = dVar.indexOf(")");
        if (sE > sB)
        {
          String dSize = dVar.substring(sB+1, sE);
          size = new Integer(dSize);
        }
        dVar = dVar.substring(0, sB);
      }
      else if (sE > 0)
      {
        s = dVar.substring(sE) + s;
        dVar = dVar.substring(0, sE);
      }
      line = new Line(database.templateOutputOptions, new SQLProcDynamicSQLVariableToken(dVar), true);
      proc.lines.addElement(line);
      if (!proc.hasDynamic(dVar))
      {
        if (proc.extendsStd == true)
          proc.useStd = false;
        proc.dynamics.addElement(dVar);
        proc.dynamicSizes.addElement(size);
        proc.dynamicStrung.addElement(new Boolean(strung));
      }
    }
    return s;
  }
  static void loadTableModule(String s, Vector<String> useProcs)
  {
    try
    {
      String importFile = inDir  + s + ".nub";
      String workDir = inDir;
      int sep = workDir.indexOf(';');
      boolean found = false;
      while (sep > 0)
      {
        importFile = workDir.substring(0, sep) + s + ".nub";
        if (new File(importFile).exists() == true)
        {
          found = true;
          break;
        }
        if (sep >= workDir.length())
          break;
        workDir = workDir.substring(sep+1);
        sep = workDir.indexOf(';');
      }
      if (found == false)
        found = new File(importFile).exists();
      if (found == true)
      {
        logger.info("Inputting " + importFile);
        DataInputStream ids = new DataInputStream(new FileInputStream(importFile));
        table = new Table();
        table.reader(ids, useProcs);
        ids.close();
        table.database = database;
      }
      else
        logger.warn("Import of " + s + ".nub failed");
    }
    catch (Exception e)
    {
      logger.warn("Table nub " + s + ".nub failed to read (" + e.getMessage() + ")");
      e.printStackTrace();
    }
  }
  static String replaceAllLiteral(String haystack)
  {
    String s = "\\[]\'\" ";
    for(int i = 0; i < s.length(); i++)
    {
       String c = "" + s.charAt(i);
       haystack = replaceAll(haystack, c, "");
    }
    return haystack;
  }
  static String replaceAll(
    String haystack,              // String to search in
    String needle,                // Substring to find
    String replacement)
  {
    int i = haystack.lastIndexOf(needle);
    if (i != -1)
    {
      StringBuffer buffer = new StringBuffer(haystack);
      buffer.replace(i, i + needle.length(), replacement);
      while ((i = haystack.lastIndexOf(needle, i - 1)) != -1)
      {
        buffer.replace(i, i + needle.length(), replacement);
      }
      haystack = buffer.toString();
    }
    return haystack;
  }
  static void saveTableModule()
  {
    try
    {
      String outDir = inDir;
      int sep = inDir.indexOf(';');
      if (sep > 0)
        outDir = inDir.substring(0, sep);
      if (outDir.length() > 0)
      {
        logger.info("Outputting " + outDir + table.name + ".nub");
        DataOutputStream ods = new DataOutputStream(new FileOutputStream(outDir + table.name + ".nub"));
        table.database = null;
        table.writer(ods);
        ods.close();
        table.database = database;
      }
    }
    catch (Exception e)
    {
      logger.error("Table nub " + inDir + table.name + ".nub failed to write",e);
    }
  }

// Parser starting point
  static final public void jInput() throws ParseException {String s;
    jj_consume_token(DATABASE);
    s = jIdent();
database.name = s;
    database.userid = "";
    database.password = "";
    label_1:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case FLAGS:{
        break;
        }
      default:
        jj_la1[0] = jj_gen;
        break label_1;
      }
      jj_consume_token(FLAGS);
      label_2:
      while (true) {
        s = jString();
database.flags.addElement(s);
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case STRING:{
          break;
          }
        default:
          jj_la1[1] = jj_gen;
          break label_2;
        }
      }
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case PACKAGE:{
      jj_consume_token(PACKAGE);
      s = jPackageIdent();
database.packageName = s;
      break;
      }
    default:
      jj_la1[2] = jj_gen;
      ;
    }
    label_3:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case IMPORT:
      case OUTPUT:{
        break;
        }
      default:
        jj_la1[3] = jj_gen;
        break label_3;
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case OUTPUT:{
        jj_consume_token(OUTPUT);
        s = jIdentOrString();
database.output = s;
        break;
        }
      case IMPORT:{
        jj_consume_token(IMPORT);
        s = jIdentOrString();
database.imports.addElement(s);
        break;
        }
      default:
        jj_la1[4] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    jConnect();
    label_4:
    while (true) {
      jTables();
if (database.hasTable(table.name))
        logger.warn
        (table.name+" is already present");
      else
        database.tables.addElement(table);
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case IMPORT:
      case TABLE:{
        break;
        }
      default:
        jj_la1[5] = jj_gen;
        break label_4;
      }
    }
    label_5:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case VIEW:{
        break;
        }
      default:
        jj_la1[6] = jj_gen;
        break label_5;
      }
      jView();
database.views.addElement(view);
    }
    jj_consume_token(0);
}

// This is only used for table generation code.
  static final public void jConnect() throws ParseException {String s;
    jj_consume_token(SERVER);
    s = jIdentOrString();
database.server = s;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case SCHEMA:{
      jj_consume_token(SCHEMA);
      s = jIdentOrString();
database.schema = s;
      break;
      }
    default:
      jj_la1[7] = jj_gen;
      ;
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case USERID:{
      jj_consume_token(USERID);
      s = jIdent();
database.userid = s;
      jj_consume_token(PASSWORD);
      s = jIdent();
database.password = s;
      break;
      }
    default:
      jj_la1[8] = jj_gen;
      ;
    }
}

// A package can contain dotted notation
  static final public String jPackageIdent() throws ParseException {String s, n;
    s = jIdent();
    label_6:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case 149:{
        break;
        }
      default:
        jj_la1[9] = jj_gen;
        break label_6;
      }
      jj_consume_token(149);
      n = jIdent();
s = s + "." + n;
    }
{if ("" != null) return s;}
    throw new IllegalStateException ("Missing return statement in function");
}

// The server may be a standard variable or a string
  static final public String jIdentOrString() throws ParseException {Token t;
  String s;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case IDENTIFIER:
    case LIDENTIFIER:{
      s = jIdent();
{if ("" != null) return s;}
      break;
      }
    case STRING:{
      t = jj_consume_token(STRING);
s = t.image;
    {if ("" != null) return fixString(s);}
      break;
      }
    default:
      jj_la1[10] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new IllegalStateException ("Missing return statement in function");
}

// Identifiers may be DEF keywords if they are escaped using L'x'
  static final public String jIdent() throws ParseException {Token t;
  String s;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case IDENTIFIER:{
      t = jj_consume_token(IDENTIFIER);
isLiteral = false;
    literal = "";
    {if ("" != null) return t.image;}
      break;
      }
    case LIDENTIFIER:{
      t = jj_consume_token(LIDENTIFIER);
s = t.image;
    isLiteral = true;
    literal = s.substring(2, s.length()-1);
    {if ("" != null) return replaceAllLiteral(s.substring(2, s.length()-1));}
      break;
      }
    default:
      jj_la1[11] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new IllegalStateException ("Missing return statement in function");
}

  static final public void jTables() throws ParseException {boolean save = false;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case TABLE:{
      jTable();
      label_7:
      while (true) {
        if (jj_2_1(2)) {
        } else {
          break label_7;
        }
        jExtras();
      }
save = true;
      break;
      }
    case IMPORT:{
      jTableImport();
save = false;
      break;
      }
    default:
      jj_la1[12] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    label_8:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case PROC:
      case SPROC:
      case DATA:
      case DATALINE:
      case IDLLINE:{
        break;
        }
      default:
        jj_la1[13] = jj_gen;
        break label_8;
      }
      jProc();
    }
    label_9:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case PARM:{
        break;
        }
      default:
        jj_la1[14] = jj_gen;
        break label_9;
      }
      jj_consume_token(PARM);
parameter = new Parameter();
      table.parameters.addElement(parameter);
      jParm();
    }
if (save == true)
      saveTableModule();
}

  static final public void jTableImport() throws ParseException {String s;
  String p;
  Vector v = new Vector<String>();
    jj_consume_token(IMPORT);
    s = jIdentOrString();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case LEFTBRACK:{
      jj_consume_token(LEFTBRACK);
      label_10:
      while (true) {
        p = jIdent();
v.addElement(p);
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case IDENTIFIER:
        case LIDENTIFIER:{
          break;
          }
        default:
          jj_la1[15] = jj_gen;
          break label_10;
        }
      }
      jj_consume_token(RIGHTBRACK);
      break;
      }
    default:
      jj_la1[16] = jj_gen;
      ;
    }
loadTableModule(s, v);
    table.database = database;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case LEFTPAREN:{
      s = jAlias();
table.alias = s;
      break;
      }
    default:
      jj_la1[17] = jj_gen;
      ;
    }
}

  static final public void jTable() throws ParseException {Token t;
  String s;
    t = jj_consume_token(TABLE);
    s = jIdent();
table = new Table();
    table.database = database;
    table.name = s;
    table.isLiteral = isLiteral;
    table.literalName = literal;
    table.start = t.beginLine;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case LEFTPAREN:{
      s = jAlias();
table.alias = s;
      break;
      }
    default:
      jj_la1[18] = jj_gen;
      ;
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case CHECK:{
      jj_consume_token(CHECK);
      t = jj_consume_token(STRING);
s = t.image; table.check = fixString(s);
      break;
      }
    default:
      jj_la1[19] = jj_gen;
      ;
    }
    label_11:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case COMMENT:{
        break;
        }
      default:
        jj_la1[20] = jj_gen;
        break label_11;
      }
      s = jComment();
table.comments.addElement(s);
    }
    label_12:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case OPTIONS:{
        break;
        }
      default:
        jj_la1[21] = jj_gen;
        break label_12;
      }
      jj_consume_token(OPTIONS);
      label_13:
      while (true) {
        s = jString();
table.options.addElement(s);
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case STRING:{
          break;
          }
        default:
          jj_la1[22] = jj_gen;
          break label_13;
        }
      }
    }
    label_14:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case IDENTIFIER:
      case LIDENTIFIER:{
        break;
        }
      default:
        jj_la1[23] = jj_gen;
        break label_14;
      }
      jField();
if (table.hasField(field.name))
        logger.warn(field.name+" is already present");
      else
        table.fields.addElement(field);
    }
}

  static final public void jPackageField() throws ParseException {String s;
  Token t;
  boolean state;
    s = jPackageIdent();
field = new Field();
    field.name = s;
    field.isLiteral = isLiteral;
    field.literalName = literal;
    field.isNull = fieldsNullByDefault;
    state = true;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case LEFTPAREN:{
      s = jAlias();
field.alias = s;
      break;
      }
    default:
      jj_la1[24] = jj_gen;
      ;
    }
    jDatatype();
    label_15:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case CALC:
      case CHECK:
      case DEFAULTV:
      case NOT:
      case NULL:{
        break;
        }
      default:
        jj_la1[25] = jj_gen;
        break label_15;
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case DEFAULTV:{
        jj_consume_token(DEFAULTV);
        t = jj_consume_token(STRING);
s = t.image;
      field.defaultValue = fixString(s);
        break;
        }
      case NOT:
      case NULL:{
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case NOT:{
          jj_consume_token(NOT);
state = false;
          break;
          }
        default:
          jj_la1[26] = jj_gen;
          ;
        }
        jj_consume_token(NULL);
field.isNull = state;
        break;
        }
      case CALC:{
        jj_consume_token(CALC);
field.isCalc = state;
        break;
        }
      case CHECK:{
        jj_consume_token(CHECK);
        t = jj_consume_token(STRING);
s = t.image;
      field.checkValue = fixString(s);
        break;
        }
      default:
        jj_la1[27] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    label_16:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case COMMENT:{
        break;
        }
      default:
        jj_la1[28] = jj_gen;
        break label_16;
      }
      s = jComment();
field.comments.addElement(s);
    }
}

  static final public void jField() throws ParseException {String s;
  Token t;
  boolean state;
    s = jIdent();
field = new Field();
    field.name = s;
    field.isLiteral = isLiteral;
    field.literalName = literal;
    field.isNull = fieldsNullByDefault;
    state = true;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case LEFTPAREN:{
      s = jAlias();
field.alias = s;
      break;
      }
    default:
      jj_la1[29] = jj_gen;
      ;
    }
    jDatatype();
    label_17:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case CALC:
      case CHECK:
      case DEFAULTV:
      case NOT:
      case NULL:{
        break;
        }
      default:
        jj_la1[30] = jj_gen;
        break label_17;
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case DEFAULTV:{
        jj_consume_token(DEFAULTV);
        t = jj_consume_token(STRING);
s = t.image;
      field.defaultValue = fixString(s);
        break;
        }
      case NOT:
      case NULL:{
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case NOT:{
          jj_consume_token(NOT);
state = false;
          break;
          }
        default:
          jj_la1[31] = jj_gen;
          ;
        }
        jj_consume_token(NULL);
field.isNull = state;
        break;
        }
      case CALC:{
        jj_consume_token(CALC);
field.isCalc = state;
        break;
        }
      case CHECK:{
        jj_consume_token(CHECK);
        t = jj_consume_token(STRING);
s = t.image;
      field.checkValue = fixString(s);
        break;
        }
      default:
        jj_la1[32] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    label_18:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case COMMENT:{
        break;
        }
      default:
        jj_la1[33] = jj_gen;
        break label_18;
      }
      s = jComment();
field.comments.addElement(s);
    }
}

  static final public String jAlias() throws ParseException {String alias;
    jj_consume_token(LEFTPAREN);
    alias = jIdent();
    jj_consume_token(RIGHTPAREN);
//field.alias = alias;
    {if ("" != null) return alias;}
    throw new IllegalStateException ("Missing return statement in function");
}

  static final public void jDatatype() throws ParseException {
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case BLOB:{
      jj_consume_token(BLOB);
field.type = Field.BLOB;
    field.length = 0;
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case LEFTBRACK:
      case LEFTPAREN:
      case NUMBER:{
        jCharsize();
        break;
        }
      default:
        jj_la1[34] = jj_gen;
        ;
      }
      break;
      }
    case BOOLEAN:{
      jj_consume_token(BOOLEAN);
field.type = Field.BOOLEAN;
    field.length = 1;
      break;
      }
    case BYTE:{
      jj_consume_token(BYTE);
field.type = Field.BYTE;
    field.length = 1;
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case LEFTBRACE:
      case LEFTPAREN:{
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case LEFTPAREN:{
          jEnumValue();
          break;
          }
        case LEFTBRACE:{
          jCharList();
          break;
          }
        default:
          jj_la1[35] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[36] = jj_gen;
        ;
      }
      break;
      }
    case CHAR:{
      jj_consume_token(CHAR);
field.type = Field.CHAR;
    field.length = 1;
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case LEFTBRACK:
      case LEFTPAREN:
      case NUMBER:{
        jCharsize();
        break;
        }
      default:
        jj_la1[37] = jj_gen;
        ;
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case LEFTBRACE:{
        jCharList();
        break;
        }
      default:
        jj_la1[38] = jj_gen;
        ;
      }
      break;
      }
    case ANSICHAR:{
      jj_consume_token(ANSICHAR);
field.type = Field.ANSICHAR;
    field.length = 1;
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case LEFTBRACK:
      case LEFTPAREN:
      case NUMBER:{
        jEnumChar();
        break;
        }
      default:
        jj_la1[39] = jj_gen;
        ;
      }
      break;
      }
    case WCHAR:{
      jj_consume_token(WCHAR);
field.type = Field.WCHAR;
    field.length = 1;
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case LEFTBRACK:
      case LEFTPAREN:
      case NUMBER:{
        jCharsize();
        break;
        }
      default:
        jj_la1[40] = jj_gen;
        ;
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case LEFTBRACE:{
        jCharList();
        break;
        }
      default:
        jj_la1[41] = jj_gen;
        ;
      }
      break;
      }
    case WANSICHAR:{
      jj_consume_token(WANSICHAR);
field.type = Field.WANSICHAR;
    field.length = 1;
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case LEFTBRACK:
      case LEFTPAREN:
      case NUMBER:{
        jEnumChar();
        break;
        }
      default:
        jj_la1[42] = jj_gen;
        ;
      }
      break;
      }
    case UTF8:{
      jj_consume_token(UTF8);
field.type = Field.UTF8;
    field.length = 1;
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case LEFTBRACK:
      case LEFTPAREN:
      case NUMBER:{
        jCharsize();
        break;
        }
      default:
        jj_la1[43] = jj_gen;
        ;
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case LEFTBRACE:{
        jCharList();
        break;
        }
      default:
        jj_la1[44] = jj_gen;
        ;
      }
      break;
      }
    case SHORT:{
      jj_consume_token(SHORT);
field.type = Field.SHORT;
    field.length = 2;
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case LEFTBRACE:
      case LEFTPAREN:{
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case LEFTPAREN:{
          jEnumValue();
          break;
          }
        case LEFTBRACE:{
          jCharList();
          break;
          }
        default:
          jj_la1[45] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[46] = jj_gen;
        ;
      }
      break;
      }
    case INT:{
      jj_consume_token(INT);
field.type = Field.INT;
    field.length = 4;
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case LEFTBRACE:
      case LEFTPAREN:{
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case LEFTPAREN:{
          jEnumValue();
          break;
          }
        case LEFTBRACE:{
          jCharList();
          break;
          }
        default:
          jj_la1[47] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[48] = jj_gen;
        ;
      }
      break;
      }
    case LONG:{
      jj_consume_token(LONG);
field.type = Field.LONG;
    field.length = 8;
      break;
      }
    case UID:{
      jj_consume_token(UID);
field.type = Field.UID;
    field.length = 16;
      break;
      }
    case DATE:{
      jj_consume_token(DATE);
field.type = Field.DATE;
    field.length = 8;
      break;
      }
    case DATETIME:{
      jj_consume_token(DATETIME);
field.type = Field.DATETIME;
    field.length = 14;
      break;
      }
    case TIME:{
      jj_consume_token(TIME);
field.type = Field.TIME;
    field.length = 6;
      break;
      }
    case TIMESTAMP:{
      jj_consume_token(TIMESTAMP);
field.type = Field.TIMESTAMP;
    table.hasTimeStamp = true;
    field.length = 14;
      break;
      }
    case AUTOTIMESTAMP:{
      jj_consume_token(AUTOTIMESTAMP);
field.type = Field.AUTOTIMESTAMP;
    table.hasAutoTimeStamp = true;
    field.length = 14;
      break;
      }
    case TLOB:{
      jj_consume_token(TLOB);
field.type = Field.TLOB;
    field.length = 0;
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case LEFTBRACK:
      case LEFTPAREN:
      case NUMBER:{
        jCharsize();
        break;
        }
      default:
        jj_la1[49] = jj_gen;
        ;
      }
      break;
      }
    case XML:{
      jj_consume_token(XML);
field.type = Field.XML;
    field.length = Field.DEFAULT_XML;
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case LEFTBRACK:
      case LEFTPAREN:
      case NUMBER:{
        jCharsize();
        break;
        }
      default:
        jj_la1[50] = jj_gen;
        ;
      }
      break;
      }
    case BIGXML:{
      jj_consume_token(BIGXML);
field.type = Field.BIGXML;
    field.length = Field.DEFAULT_BIG_XML;
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case LEFTBRACK:
      case LEFTPAREN:
      case NUMBER:{
        jCharsize();
        break;
        }
      default:
        jj_la1[51] = jj_gen;
        ;
      }
      break;
      }
    case JSON:{
      jj_consume_token(JSON);
field.type = Field.JSON;
    field.length = Field.DEFAULT_JSON;
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case LEFTBRACK:
      case LEFTPAREN:
      case NUMBER:{
        jCharsize();
        break;
        }
      default:
        jj_la1[52] = jj_gen;
        ;
      }
      break;
      }
    case BIGJSON:{
      jj_consume_token(BIGJSON);
field.type = Field.BIGJSON;
    field.length = Field.DEFAULT_BIG_JSON;
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case LEFTBRACK:
      case LEFTPAREN:
      case NUMBER:{
        jCharsize();
        break;
        }
      default:
        jj_la1[53] = jj_gen;
        ;
      }
      break;
      }
    case USERSTAMP:{
      jj_consume_token(USERSTAMP);
field.type = Field.USERSTAMP;
    table.hasUserStamp = true;
    field.length = 50;
      break;
      }
    case SEQUENCE:{
      jj_consume_token(SEQUENCE);
field.type = Field.SEQUENCE;
    field.isSequence = true;
    table.hasSequence = true;
    field.length = 4;
      break;
      }
    case BIGSEQUENCE:{
      jj_consume_token(BIGSEQUENCE);
field.type = Field.BIGSEQUENCE;
    field.isSequence = true;
    table.hasSequence = true;
    field.length = 8;
      break;
      }
    case IDENTITY:{
      jj_consume_token(IDENTITY);
field.type = Field.IDENTITY;
    field.isSequence = true;
    table.hasSequence = true;
    field.length = 4;
      break;
      }
    case BIGIDENTITY:{
      jj_consume_token(BIGIDENTITY);
field.type = Field.BIGIDENTITY;
    field.isSequence = true;
    table.hasSequence = true;
    field.length = 8;
      break;
      }
    case DOUBLE:
    case FLOAT:{
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case DOUBLE:{
        jj_consume_token(DOUBLE);
        break;
        }
      case FLOAT:{
        jj_consume_token(FLOAT);
        break;
        }
      default:
        jj_la1[54] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
field.type = Field.DOUBLE;
    field.length = 8;
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case LEFTBRACK:
      case LEFTPAREN:{
        jFloatsize();
        break;
        }
      default:
        jj_la1[55] = jj_gen;
        ;
      }
      break;
      }
    case MONEY:{
      jj_consume_token(MONEY);
field.type = Field.MONEY;
    field.length = 8;
      break;
      }
    case EQUALS:{
      jLookup();
      break;
      }
    default:
      jj_la1[56] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
}

  static final public void jLookup() throws ParseException {String name = field.name;
  Field other;
    jj_consume_token(EQUALS);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case LEFTPAREN:{
      jj_consume_token(LEFTPAREN);
      name = jIdent();
      jj_consume_token(RIGHTPAREN);
      break;
      }
    default:
      jj_la1[57] = jj_gen;
      ;
    }
other = proc.getInput(name);
    if (other == null)
      other = proc.getOutput(name);
    if (other == null)
      other = table.getField(name);
    if (other == null)
    {
      logger.warn(field.name + " is not present for type usage. Resorting to int.");
      field.type = Field.INT;
      field.length = 4;
    }
    else
    {
      field.type = other.type;
      field.length = other.length;
      field.precision = other.precision;
      field.scale = other.scale;
      field.enums = other.enums;

      if (other.enums != null && !other.enums.isEmpty()){
        field.enumType = other.useUpperName();
      }
    }
}

  static final public void jEnumValue() throws ParseException {int n;
  String s;
    jj_consume_token(LEFTPAREN);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case LINK:{
      jj_consume_token(LINK);
      s = jIdent();
field.enumLink = s;
      break;
      }
    default:
      jj_la1[58] = jj_gen;
      ;
    }
    label_19:
    while (true) {
      s = jIdent();
      jj_consume_token(EQUALS);
      n = jNumber();
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case COMMA:{
        jj_consume_token(COMMA);
        break;
        }
      default:
        jj_la1[59] = jj_gen;
        ;
      }
entry = new Enum();
        entry.name = s;
        entry.value = n;
        field.enums.addElement(entry);
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case IDENTIFIER:
      case LIDENTIFIER:{
        break;
        }
      default:
        jj_la1[60] = jj_gen;
        break label_19;
      }
    }
    jj_consume_token(RIGHTPAREN);
}

  static final public void jFloatsize() throws ParseException {int n;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case LEFTBRACK:{
      jj_consume_token(LEFTBRACK);
      n = jNumber();
field.precision = n;
      jj_consume_token(COMMA);
      n = jNumber();
field.scale = n;
      jj_consume_token(RIGHTBRACK);
      break;
      }
    case LEFTPAREN:{
      jj_consume_token(LEFTPAREN);
      n = jNumber();
field.precision = n;
      jj_consume_token(COMMA);
      n = jNumber();
field.scale = n;
      jj_consume_token(RIGHTPAREN);
      break;
      }
    default:
      jj_la1[61] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
}

  static final public void jEnumChar() throws ParseException {int n;
  String s;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case LEFTBRACK:{
      jj_consume_token(LEFTBRACK);
      n = jNumber();
field.length = n;
      jj_consume_token(RIGHTBRACK);
      break;
      }
    case LEFTPAREN:{
      jj_consume_token(LEFTPAREN);
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case NUMBER:{
        n = jNumber();
field.length = n;
        break;
        }
      case LINK:
      case IDENTIFIER:
      case LIDENTIFIER:{
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case LINK:{
          jj_consume_token(LINK);
          s = jIdent();
field.enumLink = s;
          break;
          }
        default:
          jj_la1[62] = jj_gen;
          ;
        }
        label_20:
        while (true) {
          s = jIdent();
          jj_consume_token(EQUALS);
          n = jAsciiChar();
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case COMMA:{
            jj_consume_token(COMMA);
            break;
            }
          default:
            jj_la1[63] = jj_gen;
            ;
          }
entry = new Enum();
          entry.name = s;
          entry.value = n;
          field.enums.addElement(entry);
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case IDENTIFIER:
          case LIDENTIFIER:{
            break;
            }
          default:
            jj_la1[64] = jj_gen;
            break label_20;
          }
        }
        break;
        }
      default:
        jj_la1[65] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      jj_consume_token(RIGHTPAREN);
      break;
      }
    case NUMBER:{
      n = jNumber();
field.length = n;
      break;
      }
    default:
      jj_la1[66] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
}

  static final public void jCharsize() throws ParseException {int n;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case LEFTBRACK:{
      jj_consume_token(LEFTBRACK);
      n = jNumber();
field.length = n;
      jj_consume_token(RIGHTBRACK);
      break;
      }
    case LEFTPAREN:{
      jj_consume_token(LEFTPAREN);
      n = jNumber();
field.length = n;
      jj_consume_token(RIGHTPAREN);
      break;
      }
    case NUMBER:{
      n = jNumber();
field.length = n;
      break;
      }
    default:
      jj_la1[67] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
}

  static final public void jCharList() throws ParseException {String s;
    jj_consume_token(LEFTBRACE);
    label_21:
    while (true) {
      s = jIdent();
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case COMMA:{
        jj_consume_token(COMMA);
        break;
        }
      default:
        jj_la1[68] = jj_gen;
        ;
      }
field.valueList.addElement(s);
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case IDENTIFIER:
      case LIDENTIFIER:{
        break;
        }
      default:
        jj_la1[69] = jj_gen;
        break label_21;
      }
    }
    jj_consume_token(RIGHTBRACE);
}

  static final public int jNumber() throws ParseException {Token t;
  String s;
  Integer i;
    t = jj_consume_token(NUMBER);
s = t.image;
    i = new Integer(s);
    {if ("" != null) return i.intValue();}
    throw new IllegalStateException ("Missing return statement in function");
}

  static final public void jParm() throws ParseException {String s;
  Proc p;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case STRING:{
      s = jString();
parameter.title = s;
      break;
      }
    default:
      jj_la1[70] = jj_gen;
      ;
    }
    label_22:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case PARMSHOWS:
      case PARMVIEWONLY:
      case PARMCACHE:
      case PARMREADER:
      case PARMINSERT:
      case PARMDELETE:
      case PARMUPDATE:
      case PARMSUPPLIED:{
        break;
        }
      default:
        jj_la1[71] = jj_gen;
        break label_22;
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case PARMSHOWS:{
        jj_consume_token(PARMSHOWS);
        label_23:
        while (true) {
          s = jIdent();
if (table.hasField(s))
          parameter.shows.addElement(table.getField(s));
        else
          logger.warn(s + " is not present in table for show.");
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case IDENTIFIER:
          case LIDENTIFIER:{
            break;
            }
          default:
            jj_la1[72] = jj_gen;
            break label_23;
          }
        }
        break;
        }
      case PARMVIEWONLY:{
        jj_consume_token(PARMVIEWONLY);
parameter.isViewOnly = true;
        break;
        }
      case PARMSUPPLIED:{
        jj_consume_token(PARMSUPPLIED);
        label_24:
        while (true) {
          s = jIdent();
if (table.hasField(s))
          parameter.supplied.addElement(table.getField(s));
        else
          logger.warn(s+" is not present in table for supplied.");
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case IDENTIFIER:
          case LIDENTIFIER:{
            break;
            }
          default:
            jj_la1[73] = jj_gen;
            break label_24;
          }
        }
        break;
        }
      case PARMCACHE:{
        jj_consume_token(PARMCACHE);
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case IDENTIFIER:
        case LIDENTIFIER:{
          s = jIdent();
          break;
          }
        case SELECTALL:{
          jj_consume_token(SELECTALL);
s = "SelectAll";
          break;
          }
        default:
          jj_la1[74] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
p = table.getProc(s);
      if (p != null)
        parameter.cache = p;
      else
        logger.warn(s+" is not present in table as a cache reader.");
        label_25:
        while (true) {
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case IDENTIFIER:
          case LIDENTIFIER:{
            break;
            }
          default:
            jj_la1[75] = jj_gen;
            break label_25;
          }
          s = jIdent();
parameter.cacheExtras.addElement(s);
        }
        break;
        }
      case PARMREADER:{
        jj_consume_token(PARMREADER);
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case IDENTIFIER:
        case LIDENTIFIER:{
          s = jIdent();
          break;
          }
        case SELECTALL:{
          jj_consume_token(SELECTALL);
s = "SelectAll";
          break;
          }
        default:
          jj_la1[76] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
p = table.getProc(s);
      if (p != null)
        parameter.reader = p;
      else
        logger.warn(s+" is not present in table as a reader.");
        break;
        }
      case PARMINSERT:{
        jj_consume_token(PARMINSERT);
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case IDENTIFIER:
        case LIDENTIFIER:{
          s = jIdent();
          break;
          }
        case INSERT:{
          jj_consume_token(INSERT);
s = "Insert";
          break;
          }
        default:
          jj_la1[77] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
p = table.getProc(s);
      if (p != null)
        parameter.insert = p;
      else
        logger.warn(s+" is not present in table as an inserter.");
        break;
        }
      case PARMUPDATE:{
        jj_consume_token(PARMUPDATE);
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case IDENTIFIER:
        case LIDENTIFIER:{
          s = jIdent();
          break;
          }
        case UPDATE:{
          jj_consume_token(UPDATE);
s = "Update";
          break;
          }
        default:
          jj_la1[78] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
p = table.getProc(s);
      if (p != null)
        parameter.update = p;
      else
        logger.warn(s+" is not present in table as an updater.");
        break;
        }
      case PARMDELETE:{
        jj_consume_token(PARMDELETE);
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case IDENTIFIER:
        case LIDENTIFIER:{
          s = jIdent();
          break;
          }
        case DELETEONE:{
          jj_consume_token(DELETEONE);
s = "DeleteOne";
          break;
          }
        default:
          jj_la1[79] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
p = table.getProc(s);
      if (p != null)
        parameter.delete = p;
      else
        logger.warn(s+" is not present in table as a deleter.");
        break;
        }
      default:
        jj_la1[80] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
}

  static final public void jExtras() throws ParseException {
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case GRANT:{
      jGrant();
table.grants.addElement(grant);
      break;
      }
    case KEY:{
      jKey();
table.keys.addElement(key);
      break;
      }
    case LINK:{
      jLink();
table.links.addElement(link);
      break;
      }
    case VIEW:{
      jView();
table.views.addElement(view);
      break;
      }
    case CONST:{
      jConst();
table.consts.addElement(constant);
      break;
      }
    default:
      jj_la1[81] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
}

  static final public void jConst() throws ParseException {String s,v;
    jj_consume_token(CONST);
    s = jIdent();
constant = new Const();
    constant.name = s;
    label_26:
    while (true) {
      s = jIdent();
      jj_consume_token(EQUALS);
      v = jString();
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case COMMA:{
        jj_consume_token(COMMA);
        break;
        }
      default:
        jj_la1[82] = jj_gen;
        ;
      }
value = new Value();
      value.key = s;
      value.value = v;
      constant.values.addElement(value);
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case IDENTIFIER:
      case LIDENTIFIER:{
        break;
        }
      default:
        jj_la1[83] = jj_gen;
        break label_26;
      }
    }
}

  static final public void jGrant() throws ParseException {
    jj_consume_token(GRANT);
grant = new Grant();
    label_27:
    while (true) {
      jPermission();
if (grant.hasPerm(perm))
      logger.warn("perm "+perm+" already present in grant");
    else
      grant.perms.addElement(perm);
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case ALL:
      case DELETE:
      case EXECUTE:
      case INSERT:
      case SELECT:
      case UPDATE:{
        break;
        }
      default:
        jj_la1[84] = jj_gen;
        break label_27;
      }
    }
    jj_consume_token(TO);
    label_28:
    while (true) {
      jUser();
if (grant.hasUser(user))
      logger.warn("user "+user+" already present in grant");
    else
      grant.users.addElement(user);
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case IDENTIFIER:
      case LIDENTIFIER:{
        break;
        }
      default:
        jj_la1[85] = jj_gen;
        break label_28;
      }
    }
}

  static final public void jPermission() throws ParseException {
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ALL:{
      jj_consume_token(ALL);
table.hasExecute = true;
    table.hasSelect  = true;
    table.hasDelete  = true;
    table.hasInsert  = true;
    table.hasUpdate  = true;
    perm = "all";
      break;
      }
    case DELETE:{
      jj_consume_token(DELETE);
table.hasDelete  = true;
    perm = "delete";
      break;
      }
    case INSERT:{
      jj_consume_token(INSERT);
table.hasInsert  = true;
    perm = "insert";
      break;
      }
    case SELECT:{
      jj_consume_token(SELECT);
table.hasSelect  = true;
    perm = "select";
      break;
      }
    case UPDATE:{
      jj_consume_token(UPDATE);
table.hasUpdate  = true;
    perm = "update";
      break;
      }
    case EXECUTE:{
      jj_consume_token(EXECUTE);
table.hasExecute = true;
      break;
      }
    default:
      jj_la1[86] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
}

  static final public void jUser() throws ParseException {
    user = jIdent();
}

  static final public void jKey() throws ParseException {String s;
    jj_consume_token(KEY);
    s = jIdent();
key = new Key();
    key.name = s;
    label_29:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case OPTIONS:{
        break;
        }
      default:
        jj_la1[87] = jj_gen;
        break label_29;
      }
      jj_consume_token(OPTIONS);
      label_30:
      while (true) {
        s = jString();
key.options.addElement(s);
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case STRING:{
          break;
          }
        default:
          jj_la1[88] = jj_gen;
          break label_30;
        }
      }
    }
    label_31:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case PRIMARY:
      case UNIQUE:{
        break;
        }
      default:
        jj_la1[89] = jj_gen;
        break label_31;
      }
      jModifier();
    }
    label_32:
    while (true) {
      jColumn();
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case IDENTIFIER:
      case LIDENTIFIER:{
        break;
        }
      default:
        jj_la1[90] = jj_gen;
        break label_32;
      }
    }
}

  static final public void jModifier() throws ParseException {
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case UNIQUE:{
      jj_consume_token(UNIQUE);
key.isUnique = true;
      break;
      }
    case PRIMARY:{
      jj_consume_token(PRIMARY);
key.isPrimary = true;
    table.hasPrimaryKey = true;
      break;
      }
    default:
      jj_la1[91] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
}

  static final public void jColumn() throws ParseException {String s;
    s = jIdent();
if (!table.hasField(s))
      logger.warn(key.name+" field "+s+" not present in table");
    else if (key.hasField(s))
      logger.warn(key.name+" field "+s+" already present in key");
    else
    {
      if (key.isPrimary)
        table.setPrimary(s);
      key.fields.addElement(s);
    }
}

  static final public void jLink() throws ParseException {String s;
  Token t;
  Proc dproc = new Proc();
    jj_consume_token(LINK);
    s = jPackageIdent();
link = new Link();
    link.name = s;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case LEFTPAREN:{
      jj_consume_token(LEFTPAREN);
      label_33:
      while (true) {
        s = jIdent();
link.linkFields.addElement(s);
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case IDENTIFIER:
        case LIDENTIFIER:{
          break;
          }
        default:
          jj_la1[92] = jj_gen;
          break label_33;
        }
      }
      jj_consume_token(RIGHTPAREN);
      break;
      }
    default:
      jj_la1[93] = jj_gen;
      ;
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case DELETE:{
      jj_consume_token(DELETE);
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case CASCADE:{
        jj_consume_token(CASCADE);
        break;
        }
      default:
        jj_la1[94] = jj_gen;
        ;
      }
link.isDeleteCascade = true;
      break;
      }
    default:
      jj_la1[95] = jj_gen;
      ;
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case UPDATE:{
      jj_consume_token(UPDATE);
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case CASCADE:{
        jj_consume_token(CASCADE);
        break;
        }
      default:
        jj_la1[96] = jj_gen;
        ;
      }
link.isUpdateCascade = true;
      break;
      }
    default:
      jj_la1[97] = jj_gen;
      ;
    }
    label_34:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case OPTIONS:{
        break;
        }
      default:
        jj_la1[98] = jj_gen;
        break label_34;
      }
      jj_consume_token(OPTIONS);
      label_35:
      while (true) {
        s = jString();
link.options.addElement(s);
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case STRING:{
          break;
          }
        default:
          jj_la1[99] = jj_gen;
          break label_35;
        }
      }
    }
    label_36:
    while (true) {
      jLinkColumn();
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case IDENTIFIER:
      case LIDENTIFIER:{
        break;
        }
      default:
        jj_la1[100] = jj_gen;
        break label_36;
      }
    }
}

  static final public void jLinkColumn() throws ParseException {String s;
    s = jIdent();
if (!table.hasField(s))
      logger.warn(link.name+" field "+s+" not present in table");
    else if (link.hasField(s))
      logger.warn(link.name+" field "+s+" already present in link");
    else
      link.fields.addElement(s);
}

  static final public void jView() throws ParseException {Token t;
  String s;
    t = jj_consume_token(VIEW);
    s = jIdent();
view = new View();
    view.name = s;
    view.start = t.beginLine;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case TO:{
      jj_consume_token(TO);
      label_37:
      while (true) {
        jUser();
if (view.hasUser(user))
      logger.warn(view.name+" user "+user+" already present in view");
    else
      view.users.addElement(user);
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case IDENTIFIER:
        case LIDENTIFIER:{
          break;
          }
        default:
          jj_la1[101] = jj_gen;
          break label_37;
        }
      }
      break;
      }
    default:
      jj_la1[102] = jj_gen;
      ;
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case OUTPUT:{
      jj_consume_token(OUTPUT);
      label_38:
      while (true) {
        jViewAlias();
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case IDENTIFIER:
        case LIDENTIFIER:{
          break;
          }
        default:
          jj_la1[103] = jj_gen;
          break label_38;
        }
      }
      break;
      }
    default:
      jj_la1[104] = jj_gen;
      ;
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case CODE:{
      jOldViewCode();
      break;
      }
    default:
      jj_la1[105] = jj_gen;
      jNewViewCode();
    }
}

  static final public void jNewViewCode() throws ParseException {Token t;
    label_39:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case CODELINE:{
        break;
        }
      default:
        jj_la1[106] = jj_gen;
        break label_39;
      }
      t = jj_consume_token(CODELINE);
line = t.image.trim();
        view.lines.addElement(line);
    }
}

  static final public void jOldViewCode() throws ParseException {
    jj_consume_token(CODE);
    label_40:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case STRING:{
        break;
        }
      default:
        jj_la1[107] = jj_gen;
        break label_40;
      }
      jLine();
view.lines.addElement(line);
    }
    jj_consume_token(ENDCODE);
}

  static final public void jViewAlias() throws ParseException {String s;
    s = jIdent();
if (view.hasAlias(s))
      logger.warn(key.name+" alias "+s+" already present in view");
    else
    {
      view.aliases.addElement(s);
    }
}

  static final public void jLine() throws ParseException {Token t;
  String s;
    t = jj_consume_token(STRING);
s = t.image;
    line = fixString(s);
}

  static final public String jString() throws ParseException {Token t;
  String s;
    t = jj_consume_token(STRING);
s = t.image;
    {if ("" != null) return fixString(s);}
    throw new IllegalStateException ("Missing return statement in function");
}

  static final public int jAsciiChar() throws ParseException {String s;
    s = jString();
{if ("" != null) return (int)s.charAt(0);}
    throw new IllegalStateException ("Missing return statement in function");
}

  static final public void jProc() throws ParseException {Token t;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case PROC:
    case SPROC:{
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case PROC:{
        t = jj_consume_token(PROC);
proc = new Proc();
      proc.table = table;
      proc.start = t.beginLine;
      proc.isProc = true;
        break;
        }
      case SPROC:{
        t = jj_consume_token(SPROC);
proc = new Proc();
      proc.table = table;
      proc.start = t.beginLine;
      proc.isSProc = true;
        break;
        }
      default:
        jj_la1[108] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case BULKINSERT:
      case BULKUPDATE:
      case COUNT:
      case DELETEBY:
      case DELETEALL:
      case DELETEONE:
      case EXISTS:
      case INSERT:
      case MERGE:
      case SELECTALL:
      case SELECTBY:
      case SELECTONEBY:
      case SELECTONE:
      case UPDATE:
      case UPDATEFOR:
      case UPDATEBY:
      case MAXTMSTAMP:{
        jStdProc();
        break;
        }
      case IDENTIFIER:
      case LIDENTIFIER:{
        if (jj_2_2(3)) {
          jNewProc();
        } else {
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case IDENTIFIER:
          case LIDENTIFIER:{
            jUserProc();
            break;
            }
          default:
            jj_la1[109] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
        break;
        }
      default:
        jj_la1[110] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
if (table.hasProc(proc))
      logger.warn("proc "+proc.name+" already present in table");
    else
    {
      table.procs.addElement(proc);
      proc.checkPlaceHolders();
    }
      break;
      }
    case DATA:
    case DATALINE:
    case IDLLINE:{
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case DATA:{
        jOldData();
        break;
        }
      case DATALINE:{
        jNewData();
        break;
        }
      case IDLLINE:{
        jIdlCode();
        break;
        }
      default:
        jj_la1[111] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
table.procs.addElement(proc);
      break;
      }
    default:
      jj_la1[112] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
}

  static final public void jStdProc() throws ParseException {boolean forUpdate = false;
  boolean forReadOnly = false;
  boolean inOrder = false;
  boolean descending = false;
  boolean isStdProc = false;
  String s;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case INSERT:{
      jj_consume_token(INSERT);
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case RETURNING:{
        jj_consume_token(RETURNING);
proc.hasReturning = true;
        break;
        }
      default:
        jj_la1[113] = jj_gen;
        ;
      }
table.hasSequenceReturning = table.hasSequence;
      proc.name = "Insert";
      proc.isBuiltIn = true;
      table.buildInsert(proc);
      table.hasStdProcs = true;
      if (table.hasIdentity)
      {
        table.procs.addElement(proc);
        proc = new Proc();
        proc.table = table;
        proc.name = "Identity";
        table.buildIdentity(proc);
      }
      break;
      }
    case UPDATE:{
      jj_consume_token(UPDATE);
if (!table.hasPrimaryKey)
          logger.warn("proc Update requires a primary key");
        else
        {
          proc.name = "Update";
          proc.isBuiltIn = true;
          proc.isUpdate = true;
          table.buildUpdate(proc);
          table.hasStdProcs = true;
        }
      break;
      }
    case UPDATEFOR:{
      jj_consume_token(UPDATEFOR);
      label_41:
      while (true) {
        jProcColumn();
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case IDENTIFIER:
        case LIDENTIFIER:{
          break;
          }
        default:
          jj_la1[114] = jj_gen;
          break label_41;
        }
      }
proc.isUpdate = true;
        table.buildUpdateFor(proc);
        table.hasStdProcs = true;
      break;
      }
    case UPDATEBY:{
      jj_consume_token(UPDATEBY);
      label_42:
      while (true) {
        jProcUpdateByColumn();
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case IDENTIFIER:
        case LIDENTIFIER:{
          break;
          }
        default:
          jj_la1[115] = jj_gen;
          break label_42;
        }
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case SET:{
        jj_consume_token(SET);
        label_43:
        while (true) {
          jProcColumn();
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case IDENTIFIER:
          case LIDENTIFIER:{
            break;
            }
          default:
            jj_la1[116] = jj_gen;
            break label_43;
          }
        }
        break;
        }
      default:
        jj_la1[117] = jj_gen;
        ;
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case AS:{
        jj_consume_token(AS);
        s = jIdent();
//DGR: I think long term it would be better to follow the convention that when a user overrides (aliases)
          //     a PROC, we store the original name in proc.name and the alias in proc.username. But the original SelectBy
          //     just overrides the proc.name, so I am sticking to the convention.
          //proc.username = s;
          proc.name = s;
          proc.isBuiltIn = true;
        break;
        }
      default:
        jj_la1[118] = jj_gen;
        ;
      }
//proc.name is set by <AS> clause above
        if(proc.name == null || proc.name.trim().isEmpty())
        {
          proc.name = "UpdateBy";
          for (String fname : proc.fields)
          {
            proc.name += fname;
          }
        }
        proc.isUpdate = true;
        table.buildUpdateBy(proc);
        table.hasStdProcs = true;
      break;
      }
    case BULKINSERT:{
      jj_consume_token(BULKINSERT);
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case LEFTPAREN:{
        jRowCount();
        break;
        }
      default:
        jj_la1[119] = jj_gen;
        ;
      }
table.hasSequenceReturning = table.hasSequence;
      proc.name = "BulkInsert";
      proc.isBuiltIn = true;
      table.buildBulkInsert(proc);
      table.hasStdProcs = true;
      if (table.hasIdentity)
        {
          table.procs.addElement(proc);
          proc = new Proc();
          proc.table = table;
          proc.name = "Identity";
          table.buildIdentity(proc);
        }
      break;
      }
    case MAXTMSTAMP:{
      jj_consume_token(MAXTMSTAMP);
proc.name = "MaxTmStamp";
      table.buildMaxTmStamp(proc);
      table.hasStdProcs = true;
      break;
      }
    case BULKUPDATE:{
      jj_consume_token(BULKUPDATE);
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case LEFTPAREN:{
        jRowCount();
        break;
        }
      default:
        jj_la1[120] = jj_gen;
        ;
      }
if (!table.hasPrimaryKey)
        logger.warn("proc Update requires a primary key");
      else
      {
        proc.name = "BulkUpdate";
        proc.isBuiltIn = true;
        proc.isUpdate = true;
        table.buildBulkUpdate(proc);
        table.hasStdProcs = true;
      }
      break;
      }
    case DELETEONE:{
      jj_consume_token(DELETEONE);
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case LEFTPAREN:{
        jj_consume_token(LEFTPAREN);
        jj_consume_token(STANDARD);
        jj_consume_token(RIGHTPAREN);
proc.isStd = true;
        break;
        }
      default:
        jj_la1[121] = jj_gen;
        ;
      }
table.hasStdProcs = true;
if (!table.hasPrimaryKey)
        logger.warn("proc DeleteOne requires a primary key");
      else
      {
        proc.name = "DeleteOne";
        proc.isBuiltIn = true;
        table.buildDeleteOne(proc);
        table.hasStdProcs = true;
      }
      break;
      }
    case DELETEALL:{
      jj_consume_token(DELETEALL);
proc.name = "DeleteAll";
      proc.isBuiltIn = true;
      table.buildDeleteAll(proc);
      table.hasStdProcs = true;
      break;
      }
    case DELETEBY:{
      jj_consume_token(DELETEBY);
      label_44:
      while (true) {
        jProcColumn();
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case IDENTIFIER:
        case LIDENTIFIER:{
          break;
          }
        default:
          jj_la1[122] = jj_gen;
          break label_44;
        }
      }
proc.isBuiltIn = true;
        table.buildDeleteBy(proc);
        table.hasStdProcs = true;
      break;
      }
    case SELECTONE:{
      jj_consume_token(SELECTONE);
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case FOR:
      case READONLY:
      case UPDATE:{
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case FOR:{
          jj_consume_token(FOR);
          break;
          }
        default:
          jj_la1[123] = jj_gen;
          ;
        }
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case UPDATE:{
          jj_consume_token(UPDATE);
forUpdate = true;
          break;
          }
        case READONLY:{
          jj_consume_token(READONLY);
forReadOnly = true;
          break;
          }
        default:
          jj_la1[124] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[125] = jj_gen;
        ;
      }
if (!table.hasPrimaryKey)
        logger.warn("proc SelectOne requires a primary key");
      else
      {
        proc.name = "SelectOne";
        proc.isBuiltIn = true;
        if (forUpdate) proc.name = proc.name+"Upd";
        else if (forReadOnly) proc.name = proc.name+"ReadOnly";
        table.buildSelectOne(proc, forUpdate, forReadOnly);
        table.hasStdProcs = true;
      }
      break;
      }
    case SELECTONEBY:{
      jj_consume_token(SELECTONEBY);
      label_45:
      while (true) {
        jProcColumn();
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case IDENTIFIER:
        case LIDENTIFIER:{
          break;
          }
        default:
          jj_la1[126] = jj_gen;
          break label_45;
        }
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case IN:
      case ORDER:{
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case IN:{
          jj_consume_token(IN);
          break;
          }
        default:
          jj_la1[127] = jj_gen;
          ;
        }
        jj_consume_token(ORDER);
inOrder = true;
        break;
        }
      default:
        jj_la1[128] = jj_gen;
        ;
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case FOR:
      case READONLY:
      case UPDATE:{
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case FOR:{
          jj_consume_token(FOR);
          break;
          }
        default:
          jj_la1[129] = jj_gen;
          ;
        }
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case UPDATE:{
          jj_consume_token(UPDATE);
forUpdate = true;
          break;
          }
        case READONLY:{
          jj_consume_token(READONLY);
forReadOnly = true;
          break;
          }
        default:
          jj_la1[130] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[131] = jj_gen;
        ;
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case AS:{
        jj_consume_token(AS);
        s = jIdent();
//DGR: I think long term it would be better to follow the convention that when a user overrides (aliases)
        //     a PROC, we store the original name in proc.name and the alias in proc.username. But the original

        //     just overrides the proc.name, so I am sticking to the convention.
        //proc.username = s;
        proc.name = s;
        break;
        }
      default:
        jj_la1[132] = jj_gen;
        ;
      }
//proc.name is set by <AS> clause above
        if(proc.name == null || proc.name.trim().isEmpty())
        {
          proc.name = "SelectOneBy";
          for (String fname : proc.fields)
          {
            proc.name += fname;
          }
        }
        proc.isBuiltIn = true;
        proc.isSingle = true;
        table.buildSelectBy(proc, forUpdate, forReadOnly, inOrder, descending);
        table.hasStdProcs = true;
      break;
      }
    case SELECTBY:{
      jj_consume_token(SELECTBY);
      label_46:
      while (true) {
        jProcColumn();
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case IDENTIFIER:
        case LIDENTIFIER:{
          break;
          }
        default:
          jj_la1[133] = jj_gen;
          break label_46;
        }
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case IN:
      case ORDER:{
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case IN:{
          jj_consume_token(IN);
          break;
          }
        default:
          jj_la1[134] = jj_gen;
          ;
        }
        jj_consume_token(ORDER);
inOrder = true;
        label_47:
        while (true) {
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case IDENTIFIER:
          case LIDENTIFIER:{
            break;
            }
          default:
            jj_la1[135] = jj_gen;
            break label_47;
          }
          jOrderColumn();
        }
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case DESC:{
          jj_consume_token(DESC);
descending = true;
          break;
          }
        default:
          jj_la1[136] = jj_gen;
          ;
        }
        break;
        }
      default:
        jj_la1[137] = jj_gen;
        ;
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case FOR:
      case READONLY:
      case UPDATE:{
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case FOR:{
          jj_consume_token(FOR);
          break;
          }
        default:
          jj_la1[138] = jj_gen;
          ;
        }
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case UPDATE:{
          jj_consume_token(UPDATE);
forUpdate = true;
          break;
          }
        case READONLY:{
          jj_consume_token(READONLY);
forReadOnly = true;
          break;
          }
        default:
          jj_la1[139] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[140] = jj_gen;
        ;
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case AS:{
        jj_consume_token(AS);
        s = jIdent();
//DGR: I think long term it would be better to follow the convention that when a user overrides (aliases)
        //     a PROC, we store the original name in proc.name and the alias in proc.username. But the original SelectBy
        //     just overrides the proc.name, so I am sticking to the convention.
        //proc.username = s;
        proc.name = s;
        proc.isBuiltIn = true;
        break;
        }
      default:
        jj_la1[141] = jj_gen;
        ;
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case RETURNING:{
        jj_consume_token(RETURNING);
        label_48:
        while (true) {
          jProcReturningColumn();
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case IDENTIFIER:
          case LIDENTIFIER:{
            break;
            }
          default:
            jj_la1[142] = jj_gen;
            break label_48;
          }
        }
        break;
        }
      default:
        jj_la1[146] = jj_gen;
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case OUTPUT:{
          jj_consume_token(OUTPUT);
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case LEFTPAREN:{
            jOutputType();
            break;
            }
          default:
            jj_la1[143] = jj_gen;
            ;
          }
          label_49:
          while (true) {
            switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
            case IDENTIFIER:
            case LIDENTIFIER:{
              break;
              }
            default:
              jj_la1[144] = jj_gen;
              break label_49;
            }
            jField();
if (proc.isSProc == true)
                {
                  if (proc.hasInput(field.name))
                    field = proc.getInput(field.name);
                  else
                    proc.inputs.addElement(field);
                  field.isOut = true;
                }
                else
                {
                  if (proc.hasOutput(field.name))
                  {
                    if (proc.extendsStd == false)
                      logger.warn(proc.name+" field "+field.name+" already present as output");
                  }
                  else
                  {
                    if (proc.extendsStd == true)
                    {
                      proc.useStd = false;
                      isStdProc = false;
                    }
                    if (!field.isNull)
                      field.isNull = (table.hasFieldAsNull(field.name));
                    proc.outputs.addElement(field);
                  }
                }
          }
          break;
          }
        default:
          jj_la1[145] = jj_gen;
          ;
        }
      }
//proc.name is set by <AS> clause above
        if(proc.name == null || proc.name.trim().isEmpty())
        {
          proc.name = "SelectBy";
          for (String fname : proc.fields)
          {
            proc.name += fname;
          }
        }
        table.buildSelectBy(proc, forUpdate, forReadOnly, inOrder, descending);
        table.hasStdProcs = true;
      break;
      }
    case SELECTALL:{
      jj_consume_token(SELECTALL);
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case IN:
      case ORDER:{
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case IN:{
          jj_consume_token(IN);
          break;
          }
        default:
          jj_la1[147] = jj_gen;
          ;
        }
        jj_consume_token(ORDER);
inOrder = true;
        label_50:
        while (true) {
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case IDENTIFIER:
          case LIDENTIFIER:{
            break;
            }
          default:
            jj_la1[148] = jj_gen;
            break label_50;
          }
          jOrderColumn();
        }
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case DESC:{
          jj_consume_token(DESC);
descending = true;
          break;
          }
        default:
          jj_la1[149] = jj_gen;
          ;
        }
        break;
        }
      default:
        jj_la1[150] = jj_gen;
        ;
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case FOR:
      case READONLY:
      case UPDATE:{
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case FOR:{
          jj_consume_token(FOR);
          break;
          }
        default:
          jj_la1[151] = jj_gen;
          ;
        }
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case UPDATE:{
          jj_consume_token(UPDATE);
forUpdate = true;
          break;
          }
        case READONLY:{
          jj_consume_token(READONLY);
forReadOnly = true;
          break;
          }
        default:
          jj_la1[152] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[153] = jj_gen;
        ;
      }
if (table.hasBigXML)
        logger.warn("proc SelectAll is invalid with BigXML field");
      else if (table.hasBigJSON)
        logger.warn("proc SelectAll is invalid with BigJSON field");
      else
      {
        proc.name = "SelectAll";
        proc.isBuiltIn = true;
        if (inOrder) proc.name = proc.name+"Sorted";
        if (forUpdate) proc.name = proc.name+"Upd";
        else if (forReadOnly) proc.name = proc.name+"ReadOnly";
        table.buildSelectAll(proc, forUpdate, forReadOnly, inOrder, descending);
        table.hasStdProcs = true;
      }
      break;
      }
    case COUNT:{
      jj_consume_token(COUNT);
proc.name = "Count";
      proc.isBuiltIn = true;
      table.buildCount(proc);
      break;
      }
    case EXISTS:{
      jj_consume_token(EXISTS);
if (!table.hasPrimaryKey)
        logger.warn("proc Exists requires a primary key");
      else
      {
        proc.name = "Exists";
        proc.isBuiltIn = true;
        table.buildExists(proc);
      }
      break;
      }
    case MERGE:{
      jj_consume_token(MERGE);
if (!table.hasPrimaryKey)
        logger.warn("proc Merge requires a primary key");
      else if (table.hasSequence)
        logger.warn("proc Merge cannot be used on a table with a sequence");
      else
      {
        proc.name = "Merge";
        proc.isBuiltIn = true;
        table.buildMerge(proc);
      }
      break;
      }
    default:
      jj_la1[154] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    label_51:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case OPTIONS:{
        break;
        }
      default:
        jj_la1[155] = jj_gen;
        break label_51;
      }
      jj_consume_token(OPTIONS);
      label_52:
      while (true) {
        s = jString();
proc.options.addElement(s);
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case STRING:{
          break;
          }
        default:
          jj_la1[156] = jj_gen;
          break label_52;
        }
      }
    }
}

  static final public void jNewProc() throws ParseException {String s;
  boolean isStdProc = false;
  boolean forUpdate = false;
  boolean forReadOnly = false;
  boolean inOrder = false;
  boolean descending = false;
    s = jIdent();
proc.name = s;
    jj_consume_token(SELECT);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case LEFTPAREN:{
      jj_consume_token(LEFTPAREN);
      jj_consume_token(STANDARD);
      jj_consume_token(RIGHTPAREN);
proc.isStd = true;
      break;
      }
    default:
      jj_la1[157] = jj_gen;
      ;
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case INPUT:{
      jj_consume_token(INPUT);
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case LEFTPAREN:{
        jInputType();
        break;
        }
      default:
        jj_la1[158] = jj_gen;
        ;
      }
proc.extendsStd = true;
          proc.useStd = true;
          isStdProc = true;
          Integer size;
      label_53:
      while (true) {
        jField();
if (proc.hasInput(field.name))
            {
              //if (proc.extendsStd == false)
              logger.warn(proc.name+" field "+field.name+" already present as input");
            }
            else
            {
              if (proc.extendsStd == true && proc.hasOutput(field.name) == false)
              {
                proc.useStd = false;
                isStdProc = false;
              }
              if (!field.isNull)
                field.isNull = (table.hasFieldAsNull(field.name));
              field.isIn = true;
              proc.inputs.addElement(field);
            }
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case IDENTIFIER:
        case LIDENTIFIER:{
          break;
          }
        default:
          jj_la1[159] = jj_gen;
          break label_53;
        }
      }
      break;
      }
    default:
      jj_la1[160] = jj_gen;
      ;
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case OUTPUT:{
      jj_consume_token(OUTPUT);
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case LEFTPAREN:{
        jOutputType();
        break;
        }
      default:
        jj_la1[161] = jj_gen;
        ;
      }
      label_54:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case IDENTIFIER:
        case LIDENTIFIER:{
          break;
          }
        default:
          jj_la1[162] = jj_gen;
          break label_54;
        }
        jPackageField();
if (proc.isSProc == true)
            {
              if (proc.hasInput(field.name))
                field = proc.getInput(field.name);
              else
                proc.inputs.addElement(field);
              field.isOut = true;
            }
            else
            {
              if (proc.hasOutput(field.name))
              {
                if (proc.extendsStd == false)
                  logger.warn(proc.name+" field "+field.name+" already present as output");
              }
              else
              {
                if (proc.extendsStd == true)
                {
                  proc.useStd = false;
                  isStdProc = false;
                }
                if (!field.isNull)
                  field.isNull = (table.hasFieldAsNull(field.name));
                proc.outputs.addElement(field);
              }
            }
      }
      break;
      }
    default:
      jj_la1[163] = jj_gen;
      ;
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case SQL:
    case CODE:{
      jOldCode();
      break;
      }
    default:
      jj_la1[164] = jj_gen;
      jNewCode();
    }
//table.buildSelectFrom(proc, table);
        proc.useStd = true;
        isStdProc = true;
}

  static final public void jProcColumn() throws ParseException {String s;
    s = jIdent();
if (!table.hasField(s))
      logger.warn(proc.name+" field "+s+" not present in table");
    else if (proc.hasFields(s))
      logger.warn(proc.name+" field "+s+" already present");
    else if (proc.hasUpdateFields(s))
      logger.warn(proc.name+" field "+s+" cannot be set as well, already present as input");
    else
      proc.fields.addElement(s);
}

  static final public void jProcReturningColumn() throws ParseException {String s;
    s = jIdent();
if (!table.hasField(s))
      logger.warn(proc.name+" field "+s+" not present in table");
    else if (proc.hasOutput(s))
      logger.warn(proc.name+" output "+s+" already present");
//    else if (proc.hasUpdateFields(s))
//      logger.warn(proc.name+" field "+s+" cannot be set as well, already present as input");
    else {
        proc.outputs.addElement(table.getField(s));
      }
}

  static final public void jOrderColumn() throws ParseException {String s;
    s = jIdent();
if (!table.hasField(s))
      logger.warn(proc.name+" field "+s+" not present in table");
    else if (proc.hasOrders(s))
      logger.warn(proc.name+" field "+s+" already present");
    else
      proc.orderFields.addElement(table.getField(s));
}

  static final public void jProcUpdateByColumn() throws ParseException {String s;
    s = jIdent();
if (!table.hasField(s))
      logger.warn(proc.name+" field "+s+" not present in table");
    else if (proc.hasUpdateFields(s))
      logger.warn(proc.name+" field "+s+" already present");
    else
      proc.updateFields.addElement(s);
}

  static final public String jComment() throws ParseException {Token t;
  String s;
  int n;
    t = jj_consume_token(COMMENT);
s = t.image;
    while (s.indexOf('*') == 0)
      s = s.substring(1);
    n = s.indexOf('\r');
    if (n == -1)
    {
      n = s.indexOf('\n');
      if (n == -1)
        n = s.length()-1;
    }
    {if ("" != null) return s.substring(0, n);}
    throw new IllegalStateException ("Missing return statement in function");
}

  static final public void jRowCount() throws ParseException {int n;
    jj_consume_token(LEFTPAREN);
    n = jNumber();
    jj_consume_token(RIGHTPAREN);
proc.noRows = n;
}

  static final public void jUserProc() throws ParseException {String s;
  boolean isStdProc = false;
    s = jIdent();
proc.name = s;
    proc.isBuiltIn = false;
    Line l1 = new Line(database.templateOutputOptions, Misc.generateProcNameComment(proc));
    proc.lines.addElement(l1);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case LEFTPAREN:{
      jj_consume_token(LEFTPAREN);
      jj_consume_token(STANDARD);
      jj_consume_token(RIGHTPAREN);
proc.extendsStd = true;
      proc.useStd = true;
      isStdProc = true;
      //Fix from Vinny's repo
      for (int i=0; i<table.fields.size(); i++)
        proc.outputs.addElement(table.fields.elementAt(i));
      break;
      }
    default:
      jj_la1[165] = jj_gen;
      ;
    }
    label_55:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case COMMENT:{
        break;
        }
      default:
        jj_la1[166] = jj_gen;
        break label_55;
      }
      s = jComment();
proc.comments.addElement(s);
    }
    label_56:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case OPTIONS:{
        break;
        }
      default:
        jj_la1[167] = jj_gen;
        break label_56;
      }
      jj_consume_token(OPTIONS);
      label_57:
      while (true) {
        s = jString();
proc.options.addElement(s);
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case STRING:{
          break;
          }
        default:
          jj_la1[168] = jj_gen;
          break label_57;
        }
      }
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case INPUT:{
      jj_consume_token(INPUT);
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case LEFTPAREN:{
        jInputType();
        break;
        }
      default:
        jj_la1[169] = jj_gen;
        ;
      }
      label_58:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case IDENTIFIER:
        case LIDENTIFIER:{
          break;
          }
        default:
          jj_la1[170] = jj_gen;
          break label_58;
        }
        jField();
if (proc.hasInput(field.name))
        {
          //if (proc.extendsStd == false)
          logger.warn(proc.name+" field "+field.name+" already present as input");
        }
        else
        {
          if (proc.extendsStd == true && proc.hasOutput(field.name) == false)
          {
            proc.useStd = false;
            isStdProc = false;
          }
          if (!field.isNull)
            field.isNull = (table.hasFieldAsNull(field.name));
          field.isIn = true;
          proc.inputs.addElement(field);
        }
      }
      break;
      }
    default:
      jj_la1[171] = jj_gen;
      ;
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case INOUT:{
      jj_consume_token(INOUT);
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case LEFTPAREN:{
        jOutputType();
        break;
        }
      default:
        jj_la1[172] = jj_gen;
        ;
      }
      label_59:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case IDENTIFIER:
        case LIDENTIFIER:{
          break;
          }
        default:
          jj_la1[173] = jj_gen;
          break label_59;
        }
        jField();
if (proc.hasInput(field.name))
        {
          //if (proc.extendsStd == false)
          logger.warn(proc.name+" field "+field.name+" already present as input");
        }
        else if (proc.hasOutput(field.name))
        {
          if (proc.extendsStd == false)
            logger.warn(proc.name+" field "+field.name+" already present as output");
        }
        else
        {
          if (proc.extendsStd == true)
          {
            proc.useStd = false;
            isStdProc = false;
            proc.isProc = true;
          }
          if (!field.isNull)
            field.isNull = (table.hasFieldAsNull(field.name));
          field.isIn = true;
          field.isOut = true;
          proc.inputs.addElement(field);
          if (proc.isSProc == false)
            proc.outputs.addElement(field);
        }
      }
      break;
      }
    default:
      jj_la1[174] = jj_gen;
      ;
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case OUTPUT:{
      jj_consume_token(OUTPUT);
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case LEFTPAREN:{
        jOutputType();
        break;
        }
      default:
        jj_la1[175] = jj_gen;
        ;
      }
      label_60:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case IDENTIFIER:
        case LIDENTIFIER:{
          break;
          }
        default:
          jj_la1[176] = jj_gen;
          break label_60;
        }
        jField();
if (proc.isSProc == true)
        {
          if (proc.hasInput(field.name))
            field = proc.getInput(field.name);
          else
            proc.inputs.addElement(field);
          field.isOut = true;
        }
        else
        {
          if (proc.hasOutput(field.name))
          {
            if (proc.extendsStd == false)
              logger.warn(proc.name+" field "+field.name+" already present as output");
          }
          else
          {
            if (proc.extendsStd == true)
            {
              proc.useStd = false;
              isStdProc = false;
            }
            if (!field.isNull)
              field.isNull = (table.hasFieldAsNull(field.name));
            proc.outputs.addElement(field);
          }
        }
      }
      break;
      }
    default:
      jj_la1[177] = jj_gen;
      ;
    }
if (isStdProc == true)
      table.hasStdProcs = true;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case SQL:
    case CODE:{
      jOldCode();
      break;
      }
    default:
      jj_la1[178] = jj_gen;
      jNewCode();
    }
}

  static final public void jOldCode() throws ParseException {String s;
  Integer size;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case SQL:{
      jj_consume_token(SQL);
proc.isSql = true;
      break;
      }
    default:
      jj_la1[179] = jj_gen;
      ;
    }
    jj_consume_token(CODE);
    label_61:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case STRING:
      case IDENTIFIER:
      case LIDENTIFIER:{
        break;
        }
      default:
        jj_la1[180] = jj_gen;
        break label_61;
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case STRING:{
        jLine();
Line l1 = new Line(database.templateOutputOptions, new SQLProcStringToken(line));
      proc.lines.addElement(l1);
        break;
        }
      case IDENTIFIER:
      case LIDENTIFIER:{
        s = jIdent();
        size = jOptSize();
Line l2 = new Line(database.templateOutputOptions, new SQLProcStringToken(s), true);
      proc.lines.addElement(l2);
      if (!proc.hasDynamic(s))
      {
        if (proc.extendsStd == true)
          proc.useStd = false;
        proc.dynamics.addElement(s);
        proc.dynamicSizes.addElement(size);
      }
        break;
        }
      default:
        jj_la1[181] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    jj_consume_token(ENDCODE);
}

  static final public void jNewCode() throws ParseException {Token t;
  String s;
  Integer size;
  Line line;
    label_62:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case CODELINE:{
        break;
        }
      default:
        jj_la1[182] = jj_gen;
        break label_62;
      }
      t = jj_consume_token(CODELINE);
s = parseDynamics(t.image.trim() + " ");
        if (s.length() > 0)
        {
          line = new Line(database.templateOutputOptions, new SQLProcStringToken(s));
          proc.lines.addElement(line);
        }
    }
}

  static final public Integer jOptSize() throws ParseException {int n;
n = 256;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case LEFTPAREN:{
      jj_consume_token(LEFTPAREN);
      n = jNumber();
      jj_consume_token(RIGHTPAREN);
      break;
      }
    default:
      jj_la1[183] = jj_gen;
      ;
    }
{if ("" != null) return new Integer(n);}
    throw new IllegalStateException ("Missing return statement in function");
}

  static final public void jInputType() throws ParseException {int n;
    if (jj_2_3(2)) {
      jj_consume_token(LEFTPAREN);
      jj_consume_token(MULTIPLE);
      jj_consume_token(RIGHTPAREN);
proc.isMultipleInput = true;
    } else if (jj_2_4(2)) {
      jj_consume_token(LEFTPAREN);
      n = jNumber();
      jj_consume_token(RIGHTPAREN);
proc.noRows = n;
    proc.isMultipleInput = true;
    } else if (jj_2_5(2)) {
      jj_consume_token(LEFTPAREN);
      jj_consume_token(STANDARD);
for (int i=0; i<table.fields.size(); i++)
      proc.inputs.addElement(table.fields.elementAt(i));
      jj_consume_token(RIGHTPAREN);
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
}

  static final public void jOutputType() throws ParseException {int n;
    if (jj_2_6(2)) {
      jj_consume_token(LEFTPAREN);
      jj_consume_token(SINGLE);
proc.isSingle = true;
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case STANDARD:{
        jj_consume_token(STANDARD);
for (int i=0; i<table.fields.size(); i++)
        proc.outputs.addElement(table.fields.elementAt(i));
        break;
        }
      default:
        jj_la1[184] = jj_gen;
        ;
      }
      jj_consume_token(RIGHTPAREN);
    } else if (jj_2_7(2)) {
      jj_consume_token(LEFTPAREN);
      jj_consume_token(SINGLE);
proc.isSingle = true;
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case UPDATE:{
        jj_consume_token(UPDATE);
proc.hasUpdates = true;
        break;
        }
      default:
        jj_la1[185] = jj_gen;
        ;
      }
      jj_consume_token(RIGHTPAREN);
    } else if (jj_2_8(2)) {
      jj_consume_token(LEFTPAREN);
      n = jNumber();
      jj_consume_token(RIGHTPAREN);
proc.noRows = n;
    } else if (jj_2_9(2)) {
      jj_consume_token(LEFTPAREN);
      jj_consume_token(STANDARD);
for (int i=0; i<table.fields.size(); i++)
      proc.outputs.addElement(table.fields.elementAt(i));
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case SINGLE:{
        jj_consume_token(SINGLE);
proc.isSingle = true;
        break;
        }
      default:
        jj_la1[186] = jj_gen;
        ;
      }
      jj_consume_token(RIGHTPAREN);
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
}

  static final public void jOldData() throws ParseException {
    jj_consume_token(DATA);
proc = new Proc();
    proc.isData = true;
    label_63:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case STRING:{
        break;
        }
      default:
        jj_la1[187] = jj_gen;
        break label_63;
      }
      jLine();
Line l1 = new Line(database.templateOutputOptions, new SQLProcStringToken(line));
      proc.lines.addElement(l1);
    }
    jj_consume_token(ENDDATA);
}

  static final public void jNewData() throws ParseException {Token t;
    t = jj_consume_token(DATALINE);
proc = new Proc();
    proc.isData = true;
    Line l1 = new Line(database.templateOutputOptions, new SQLProcStringToken(t.image.trim()));
    proc.lines.addElement(l1);
    label_64:
    while (true) {
      if (jj_2_10(2)) {
      } else {
        break label_64;
      }
      t = jj_consume_token(DATALINE);
Line l2 = new Line(database.templateOutputOptions, new SQLProcStringToken(t.image.trim()));
      proc.lines.addElement(l2);
    }
}

  static final public void jIdlCode() throws ParseException {Token t;
    t = jj_consume_token(IDLLINE);
proc = new Proc();
    proc.isIdlCode = true;
    Line l1 = new Line(database.templateOutputOptions, new SQLProcStringToken(t.image.trim()));
    proc.lines.addElement(l1);
    label_65:
    while (true) {
      if (jj_2_11(2)) {
      } else {
        break label_65;
      }
      t = jj_consume_token(IDLLINE);
Line l2 = new Line(database.templateOutputOptions, new SQLProcStringToken(t.image.trim()));
      proc.lines.addElement(l2);
    }
}

  static private boolean jj_2_1(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_1()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  static private boolean jj_2_2(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_2()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(1, xla); }
  }

  static private boolean jj_2_3(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_3()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(2, xla); }
  }

  static private boolean jj_2_4(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_4()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(3, xla); }
  }

  static private boolean jj_2_5(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_5()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(4, xla); }
  }

  static private boolean jj_2_6(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_6()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(5, xla); }
  }

  static private boolean jj_2_7(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_7()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(6, xla); }
  }

  static private boolean jj_2_8(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_8()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(7, xla); }
  }

  static private boolean jj_2_9(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_9()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(8, xla); }
  }

  static private boolean jj_2_10(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_10()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(9, xla); }
  }

  static private boolean jj_2_11(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_11()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(10, xla); }
  }

  static private boolean jj_3R_71()
 {
    if (jj_3R_82()) return true;
    return false;
  }

  static private boolean jj_3R_92()
 {
    if (jj_scan_token(CODELINE)) return true;
    return false;
  }

  static private boolean jj_3R_93()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_94()) {
    jj_scanpos = xsp;
    if (jj_3R_95()) {
    jj_scanpos = xsp;
    if (jj_3R_96()) {
    jj_scanpos = xsp;
    if (jj_3R_97()) {
    jj_scanpos = xsp;
    if (jj_3R_98()) {
    jj_scanpos = xsp;
    if (jj_3R_99()) return true;
    }
    }
    }
    }
    }
    return false;
  }

  static private boolean jj_3R_94()
 {
    if (jj_scan_token(ALL)) return true;
    return false;
  }

  static private boolean jj_3_7()
 {
    if (jj_scan_token(LEFTPAREN)) return true;
    if (jj_scan_token(SINGLE)) return true;
    return false;
  }

  static private boolean jj_3R_72()
 {
    if (jj_3R_83()) return true;
    return false;
  }

  static private boolean jj_3R_79()
 {
    if (jj_3R_88()) return true;
    return false;
  }

  static private boolean jj_3R_73()
 {
    if (jj_3R_84()) return true;
    return false;
  }

  static private boolean jj_3R_95()
 {
    if (jj_scan_token(DELETE)) return true;
    return false;
  }

  static private boolean jj_3_8()
 {
    if (jj_scan_token(LEFTPAREN)) return true;
    if (jj_3R_68()) return true;
    return false;
  }

  static private boolean jj_3R_96()
 {
    if (jj_scan_token(INSERT)) return true;
    return false;
  }

  static private boolean jj_3_9()
 {
    if (jj_scan_token(LEFTPAREN)) return true;
    if (jj_scan_token(STANDARD)) return true;
    return false;
  }

  static private boolean jj_3_11()
 {
    if (jj_scan_token(IDLLINE)) return true;
    return false;
  }

  static private boolean jj_3R_84()
 {
    if (jj_scan_token(CONST)) return true;
    if (jj_3R_74()) return true;
    return false;
  }

  static private boolean jj_3R_68()
 {
    if (jj_scan_token(NUMBER)) return true;
    return false;
  }

  static private boolean jj_3R_97()
 {
    if (jj_scan_token(SELECT)) return true;
    return false;
  }

  static private boolean jj_3R_77()
 {
    if (jj_scan_token(OUTPUT)) return true;
    return false;
  }

  static private boolean jj_3R_98()
 {
    if (jj_scan_token(UPDATE)) return true;
    return false;
  }

  static private boolean jj_3R_87()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_91()) jj_scanpos = xsp;
    if (jj_scan_token(CODE)) return true;
    return false;
  }

  static private boolean jj_3R_74()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_85()) {
    jj_scanpos = xsp;
    if (jj_3R_86()) return true;
    }
    return false;
  }

  static private boolean jj_3R_85()
 {
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  static private boolean jj_3R_91()
 {
    if (jj_scan_token(SQL)) return true;
    return false;
  }

  static private boolean jj_3R_99()
 {
    if (jj_scan_token(EXECUTE)) return true;
    return false;
  }

  static private boolean jj_3_3()
 {
    if (jj_scan_token(LEFTPAREN)) return true;
    if (jj_scan_token(MULTIPLE)) return true;
    return false;
  }

  static private boolean jj_3R_86()
 {
    if (jj_scan_token(LIDENTIFIER)) return true;
    return false;
  }

  static private boolean jj_3R_83()
 {
    if (jj_scan_token(VIEW)) return true;
    if (jj_3R_74()) return true;
    return false;
  }

  static private boolean jj_3_4()
 {
    if (jj_scan_token(LEFTPAREN)) return true;
    if (jj_3R_68()) return true;
    return false;
  }

  static private boolean jj_3R_80()
 {
    if (jj_scan_token(GRANT)) return true;
    Token xsp;
    if (jj_3R_89()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_89()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  static private boolean jj_3R_67()
 {
    if (jj_3R_74()) return true;
    if (jj_scan_token(SELECT)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_75()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_76()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_77()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_78()) {
    jj_scanpos = xsp;
    if (jj_3R_79()) return true;
    }
    return false;
  }

  static private boolean jj_3_5()
 {
    if (jj_scan_token(LEFTPAREN)) return true;
    if (jj_scan_token(STANDARD)) return true;
    return false;
  }

  static private boolean jj_3R_82()
 {
    if (jj_scan_token(LINK)) return true;
    if (jj_3R_90()) return true;
    return false;
  }

  static private boolean jj_3R_89()
 {
    if (jj_3R_93()) return true;
    return false;
  }

  static private boolean jj_3_2()
 {
    if (jj_3R_67()) return true;
    return false;
  }

  static private boolean jj_3R_81()
 {
    if (jj_scan_token(KEY)) return true;
    if (jj_3R_74()) return true;
    return false;
  }

  static private boolean jj_3_1()
 {
    if (jj_3R_66()) return true;
    return false;
  }

  static private boolean jj_3R_75()
 {
    if (jj_scan_token(LEFTPAREN)) return true;
    return false;
  }

  static private boolean jj_3_6()
 {
    if (jj_scan_token(LEFTPAREN)) return true;
    if (jj_scan_token(SINGLE)) return true;
    return false;
  }

  static private boolean jj_3R_66()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_69()) {
    jj_scanpos = xsp;
    if (jj_3R_70()) {
    jj_scanpos = xsp;
    if (jj_3R_71()) {
    jj_scanpos = xsp;
    if (jj_3R_72()) {
    jj_scanpos = xsp;
    if (jj_3R_73()) return true;
    }
    }
    }
    }
    return false;
  }

  static private boolean jj_3R_69()
 {
    if (jj_3R_80()) return true;
    return false;
  }

  static private boolean jj_3R_78()
 {
    if (jj_3R_87()) return true;
    return false;
  }

  static private boolean jj_3R_90()
 {
    if (jj_3R_74()) return true;
    return false;
  }

  static private boolean jj_3R_76()
 {
    if (jj_scan_token(INPUT)) return true;
    return false;
  }

  static private boolean jj_3R_70()
 {
    if (jj_3R_81()) return true;
    return false;
  }

  static private boolean jj_3_10()
 {
    if (jj_scan_token(DATALINE)) return true;
    return false;
  }

  static private boolean jj_3R_88()
 {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_92()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private static boolean jj_initialized_once = false;
  /** Generated Token Manager. */
  static public JPortalTokenManager token_source;
  static SimpleCharStream jj_input_stream;
  /** Current token. */
  static public Token token;
  /** Next token. */
  static public Token jj_nt;
  static private int jj_ntk;
  static private Token jj_scanpos, jj_lastpos;
  static private int jj_la;
  static private int jj_gen;
  static final private int[] jj_la1 = new int[188];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static private int[] jj_la1_2;
  static private int[] jj_la1_3;
  static private int[] jj_la1_4;
  static {
	   jj_la1_init_0();
	   jj_la1_init_1();
	   jj_la1_init_2();
	   jj_la1_init_3();
	   jj_la1_init_4();
	}
	private static void jj_la1_init_0() {
	   jj_la1_0 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x800000,0x0,0x0,0x0,0x0,0x0,0x80900000,0x0,0x80900000,0x0,0x0,0x80900000,0x0,0x80900000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3049fd00,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2000000,0x0,0x0,0x80,0x0,0x80,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x200000,0x0,0x200000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1060000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x200,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x200,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x200,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1060000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
	}
	private static void jj_la1_init_1() {
	   jj_la1_1 = new int[] {0x200,0x0,0x0,0x4000,0x4000,0x4000,0x0,0x0,0x0,0x0,0x0,0x0,0x4000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40000000,0x0,0x0,0x0,0x30000000,0x10000000,0x30000000,0x0,0x0,0x30000000,0x10000000,0x30000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x420,0x0,0x2982420,0x0,0x400000,0x0,0x0,0x0,0x400000,0x0,0x0,0x400000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40000,0x0,0x8,0x0,0x601000,0x0,0x0,0x40081,0x0,0x40081,0x40000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1,0x0,0x0,0x40000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x104010e,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x800,0x0,0x800,0x0,0x8000,0x80008000,0x800,0x0,0x800,0x0,0x0,0x8000,0x0,0x10,0x80008000,0x800,0x0,0x800,0x0,0x0,0x0,0x0,0x0,0x0,0x8000,0x0,0x10,0x80008000,0x800,0x0,0x800,0x104010e,0x40000000,0x0,0x0,0x0,0x0,0x20000,0x0,0x0,0x0,0x0,0x0,0x0,0x40000000,0x0,0x0,0x0,0x20000,0x0,0x0,0x10000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
	}
	private static void jj_la1_init_2() {
	   jj_la1_2 = new int[] {0x0,0x0,0x2,0x1,0x1,0x800000,0x0,0x80,0x0,0x0,0x0,0x0,0x800000,0x200010,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x17048000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x200,0x0,0x200,0x0,0x40000000,0x0,0x0,0x0,0x0,0x0,0x40000100,0x0,0x40000100,0x0,0x0,0x20000008,0x0,0x20000008,0x0,0x0,0x0,0x0,0x0,0x40000000,0x0,0x0,0x0,0x0,0x8000000,0x0,0x1,0x0,0x0,0x0,0x200010,0x0,0xc0006600,0x0,0x200010,0x40,0x0,0x0,0x0,0x20000,0x0,0x0,0x0,0x0,0x0,0x0,0x40000020,0x40000020,0x0,0x0,0x0,0x0,0x40000020,0x40000020,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40000020,0x40000020,0x0,0x0,0x0,0x0,0x1,0x40,0x0,0x0,0x0,0x0,0x0,0x40000020,0x40000020,0xc0006600,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1,0x100000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1,0x100000,0x100000,0x0,0x0,0x0,0x0,0x400000,0x40000000,0x80000,0x0,};
	}
	private static void jj_la1_init_3() {
	   jj_la1_3 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x20,0x0,0x4,0x0,0x0,0x0,0x0,0x80000,0x200,0x0,0x10000000,0x20000000,0x20000000,0x0,0x400000,0x0,0x0,0x0,0x20000000,0x0,0x0,0x0,0x400000,0x20000000,0x0,0x0,0x0,0x400000,0x30000000,0x28000000,0x28000000,0x30000000,0x8000000,0x30000000,0x30000000,0x8000000,0x30000000,0x30000000,0x8000000,0x28000000,0x28000000,0x28000000,0x28000000,0x30000000,0x30000000,0x30000000,0x30000000,0x30000000,0x0,0x30000000,0x40001d8,0x20000000,0x0,0x2000000,0x0,0x30000000,0x0,0x2000000,0x0,0x0,0x30000000,0x30000000,0x2000000,0x0,0x0,0x3fc00,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3fc00,0x20,0x2000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40000,0x0,0x0,0x0,0x0,0x3,0x80000,0x80000,0x0,0x0,0x0,0x0,0x0,0x0,0x20000000,0x20000000,0x20000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3,0x0,0x0,0x20000000,0x20000000,0x0,0x0,0x20000000,0x0,0x0,0x40000,0x20000000,0x400000,0x0,0x0,0x20000000,0x0,0x0,0x20000000,0x0,0x0,0x20000000,0x0,0x0,0x40000,0x0,0x0,0x0,0x0,0x20000000,0x0,0x0,0x0,0x0,};
	}
	private static void jj_la1_init_4() {
	   jj_la1_4 = new int[] {0x0,0x8,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x200000,0xc8,0xc0,0x0,0x120000,0x0,0xc0,0x0,0x0,0x0,0x0,0x0,0x0,0x8,0xc0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4,0x0,0x0,0x4,0x0,0x4,0x4,0x0,0x4,0x4,0x0,0x0,0x0,0x0,0x0,0x4,0x4,0x4,0x4,0x4,0x0,0x0,0x0,0x0,0x0,0x0,0xc0,0x0,0x0,0x0,0xc0,0xc4,0x4,0x4,0x0,0xc0,0x8,0x0,0xc0,0xc0,0xc0,0xc0,0xc0,0xc0,0xc0,0xc0,0x0,0x0,0x0,0xc0,0x0,0xc0,0x0,0x0,0x8,0x0,0xc0,0x0,0xc0,0x0,0x0,0x0,0x0,0x0,0x0,0x8,0xc0,0xc0,0x0,0xc0,0x0,0x0,0x4000,0x8,0x0,0xc0,0xc0,0x120000,0x120000,0x0,0xc0,0xc0,0xc0,0x0,0x0,0x0,0x0,0x0,0xc0,0x0,0x0,0x0,0xc0,0x0,0x0,0x0,0x0,0x0,0x0,0xc0,0x0,0xc0,0x0,0x0,0x0,0x0,0x0,0x0,0xc0,0x0,0xc0,0x0,0x0,0x0,0xc0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8,0x0,0x0,0xc0,0x0,0x0,0xc0,0x0,0x0,0x0,0x0,0x0,0x8,0x0,0xc0,0x0,0x0,0xc0,0x0,0x0,0xc0,0x0,0x0,0x0,0xc8,0xc8,0x4000,0x0,0x0,0x0,0x0,0x8,};
	}
  static private final JJCalls[] jj_2_rtns = new JJCalls[11];
  static private boolean jj_rescan = false;
  static private int jj_gc = 0;

  /** Constructor with InputStream. */
  public JPortal(final java.io.InputStream stream) {
	  this(stream, null);
  }

  /** Constructor with InputStream and supplied encoding */
  public JPortal(final java.io.InputStream stream, final String encoding) {
	 if (jj_initialized_once) {
	   System.out.println("ERROR: Second call to constructor of static parser.  ");
	   System.out.println("	   You must either use ReInit() or set the JavaCC option STATIC to false");
	   System.out.println("	   during parser generation.");
	   throw new IllegalStateException ();
	 }
	 jj_initialized_once = true;
   try { jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1); } catch(final java.io.UnsupportedEncodingException e) { throw new IllegalStateException(e); }
	 token_source = new JPortalTokenManager(jj_input_stream);
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 188; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  static public void ReInit(final java.io.InputStream stream) {
	  ReInit(stream, null);
  }
  /** Reinitialise. */
  static public void ReInit(final java.io.InputStream stream, final String encoding) {
	 try { jj_input_stream.ReInit(stream, encoding, 1, 1); } catch(final java.io.UnsupportedEncodingException e) { throw new IllegalStateException(e); }
	 token_source.ReInit(jj_input_stream);
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 188; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor. */
  public JPortal(java.io.Reader stream) {
	 if (jj_initialized_once) {
	   System.out.println("ERROR: Second call to constructor of static parser. ");
	   System.out.println("	   You must either use ReInit() or set the JavaCC option STATIC to false");
	   System.out.println("	   during parser generation.");
	   throw new IllegalStateException ();
	 }
	 jj_initialized_once = true;
	 jj_input_stream = new SimpleCharStream(stream, 1, 1);
	 token_source = new JPortalTokenManager(jj_input_stream);
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 188; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  static public void ReInit(java.io.Reader stream) {
	if (jj_input_stream == null) {
	   jj_input_stream = new SimpleCharStream(stream, 1, 1);
	} else {
	   jj_input_stream.ReInit(stream, 1, 1);
	}
	if (token_source == null) {
 token_source = new JPortalTokenManager(jj_input_stream);
	}

	 token_source.ReInit(jj_input_stream);
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 188; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor with generated Token Manager. */
  public JPortal(JPortalTokenManager tm) {
	 if (jj_initialized_once) {
	   System.out.println("ERROR: Second call to constructor of static parser. ");
	   System.out.println("	   You must either use ReInit() or set the JavaCC option STATIC to false");
	   System.out.println("	   during parser generation.");
	   throw new IllegalStateException ();
	 }
	 jj_initialized_once = true;
	 token_source = tm;
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 188; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(JPortalTokenManager tm) {
	 token_source = tm;
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 188; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  static private Token jj_consume_token(final int kind) throws ParseException {
    final Token oldToken = token;
    if (token.next != null)
      token = token.next;
    else {
      token.next = token_source.getNextToken();
      token = token.next;
    }
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      if (++jj_gc > 100) {
        jj_gc = 0;
        for (int i = 0; i < jj_2_rtns.length; i++) {
          JJCalls c = jj_2_rtns[i];
          while (c != null) {
            if (c.gen < jj_gen)
              c.first = null;
            c = c.next;
          }
        }
      }
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  @SuppressWarnings("serial")
  private static final class LookaheadSuccess extends IllegalStateException { }
  static private final LookaheadSuccess jj_ls = new LookaheadSuccess();
  static private boolean jj_scan_token(int kind) {
	 if (jj_scanpos == jj_lastpos) {
	   jj_la--;
	   if (jj_scanpos.next == null) {
		   jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
	   } else {
		   jj_lastpos = jj_scanpos = jj_scanpos.next;
	   }
	 } else {
	   jj_scanpos = jj_scanpos.next;
	 }
	 if (jj_rescan) {
	   int i = 0; Token tok = token;
	   while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
	   if (tok != null) jj_add_error_token(kind, i);
	 }
	 if (jj_scanpos.kind != kind) return true;
	 if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
	 return false;
  }


  /** Get the next Token. */
  static public final Token getNextToken() {
	 if (token.next != null) token = token.next;
	 else token = token.next = token_source.getNextToken();
	 jj_ntk = -1;
	 jj_gen++;
	 return token;
  }

/** Get the specific Token. */
  static public final Token getToken(int index) {
    Token t = token;
    for (int i = 0; i < index; i++) {
      if (t.next == null)
        t.next = token_source.getNextToken();
      t = t.next;
    }
    return t;
  }

  static private int jj_ntk_f() {
    jj_nt = token.next;
    if (jj_nt == null) {
      token.next = token_source.getNextToken();
      jj_ntk = token.next.kind;
      return jj_ntk;
    }
    jj_ntk = jj_nt.kind;
    return jj_ntk;
  }

  static private java.util.List<int[]> jj_expentries = new java.util.ArrayList<int[]>();
  static private int[] jj_expentry;
  static private int jj_kind = -1;
  static private int[] jj_lasttokens = new int[100];
  static private int jj_endpos;

  static private void jj_add_error_token(int kind, int pos) {
  if (pos >= 100) {
    return;
  }

  if (pos == jj_endpos + 1) {
    jj_lasttokens[jj_endpos++] = kind;
  } else if (jj_endpos != 0) {
    jj_expentry = new int[jj_endpos];

    for (int i = 0; i < jj_endpos; i++) {
      jj_expentry[i] = jj_lasttokens[i];
    }

    for (final int[] oldentry : jj_expentries) {
      if (oldentry.length == jj_expentry.length) {
        boolean isMatched = true;
        for (int i = 0; i < jj_expentry.length; i++) {
          if (oldentry[i] != jj_expentry[i]) {
            isMatched = false;
            break;
          }
        }
        if (isMatched) {
          jj_expentries.add(jj_expentry);
          break;
        }
      }
    }

    if (pos != 0) {
      jj_endpos = pos;
      jj_lasttokens[jj_endpos - 1] = kind;
    }
  }
}

  /** Generate ParseException. */
  static public ParseException generateParseException() {
    jj_expentries.clear();
    boolean[] la1tokens = new boolean[150];
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 188; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
          if ((jj_la1_2[i] & (1<<j)) != 0) {
            la1tokens[64+j] = true;
          }
          if ((jj_la1_3[i] & (1<<j)) != 0) {
            la1tokens[96+j] = true;
          }
          if ((jj_la1_4[i] & (1<<j)) != 0) {
            la1tokens[128+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 150; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.add(jj_expentry);
      }
    }
    jj_endpos = 0;
    jj_rescan_token();
    jj_add_error_token(0, 0);
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = jj_expentries.get(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  static private boolean trace_enabled = false;

  /** Trace enabled. */
  static public final boolean trace_enabled() {
    return trace_enabled;
  }

  /** Enable tracing. */
  static public final void enable_tracing() {}

  /** Disable tracing. */
  static public final void disable_tracing() {}

  static private void jj_rescan_token() {
    jj_rescan = true;
    for (int i = 0; i < 11; i++) {
      try {
        JJCalls p = jj_2_rtns[i];
        do {
          if (p.gen > jj_gen) {
            jj_la = p.arg;
            jj_scanpos = p.first;
            jj_lastpos = p.first;
            switch (i) {
              case 0: jj_3_1(); break;
              case 1: jj_3_2(); break;
              case 2: jj_3_3(); break;
              case 3: jj_3_4(); break;
              case 4: jj_3_5(); break;
              case 5: jj_3_6(); break;
              case 6: jj_3_7(); break;
              case 7: jj_3_8(); break;
              case 8: jj_3_9(); break;
              case 9: jj_3_10(); break;
              case 10: jj_3_11(); break;
            }
          }
          p = p.next;
        } while (p != null);
      } catch(LookaheadSuccess ls) { /* ignore */ }
    }
    jj_rescan = false;
  }

  static private void jj_save(int index, int xla) {
    JJCalls p = jj_2_rtns[index];
    while (p.gen > jj_gen) {
      if (p.next == null) {
        p.next = new JJCalls();
        p = p.next;
        break;
      }
      p = p.next;
    }
    p.gen = jj_gen + xla - jj_la; 
    p.first = token;
    p.arg = xla;
  }

  static final class JJCalls {
	 int gen;
	 Token first;
	 int arg;
	 JJCalls next;
  }

}
