/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import org.eclipse.jgit.lib.BatchingProgressMonitor;

public class TextProgressMonitor
extends BatchingProgressMonitor {
    private final Writer out;
    private boolean write;

    public TextProgressMonitor() {
        this(new PrintWriter(System.err));
    }

    public TextProgressMonitor(Writer out) {
        this.out = out;
        this.write = true;
    }

    protected void onUpdate(String taskName, int workCurr) {
        StringBuilder s2 = new StringBuilder();
        this.format(s2, taskName, workCurr);
        this.send(s2);
    }

    protected void onEndTask(String taskName, int workCurr) {
        StringBuilder s2 = new StringBuilder();
        this.format(s2, taskName, workCurr);
        s2.append("\n");
        this.send(s2);
    }

    private void format(StringBuilder s2, String taskName, int workCurr) {
        s2.append("\r");
        s2.append(taskName);
        s2.append(": ");
        while (s2.length() < 25) {
            s2.append(' ');
        }
        s2.append(workCurr);
    }

    protected void onUpdate(String taskName, int cmp, int totalWork, int pcnt) {
        StringBuilder s2 = new StringBuilder();
        this.format(s2, taskName, cmp, totalWork, pcnt);
        this.send(s2);
    }

    protected void onEndTask(String taskName, int cmp, int totalWork, int pcnt) {
        StringBuilder s2 = new StringBuilder();
        this.format(s2, taskName, cmp, totalWork, pcnt);
        s2.append("\n");
        this.send(s2);
    }

    private void format(StringBuilder s2, String taskName, int cmp, int totalWork, int pcnt) {
        s2.append("\r");
        s2.append(taskName);
        s2.append(": ");
        while (s2.length() < 25) {
            s2.append(' ');
        }
        String endStr = String.valueOf(totalWork);
        String curStr = String.valueOf(cmp);
        while (curStr.length() < endStr.length()) {
            curStr = " " + curStr;
        }
        if (pcnt < 100) {
            s2.append(' ');
        }
        if (pcnt < 10) {
            s2.append(' ');
        }
        s2.append(pcnt);
        s2.append("% (");
        s2.append(curStr);
        s2.append("/");
        s2.append(endStr);
        s2.append(")");
    }

    private void send(StringBuilder s2) {
        if (this.write) {
            try {
                this.out.write(s2.toString());
                this.out.flush();
            }
            catch (IOException err) {
                this.write = false;
            }
        }
    }
}

