/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.io.IOException;
import java.text.MessageFormat;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.errors.EntryExistsException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.errors.ObjectWritingException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.FileTreeEntry;
import org.eclipse.jgit.lib.GitlinkTreeEntry;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.SymlinkTreeEntry;
import org.eclipse.jgit.lib.TreeEntry;
import org.eclipse.jgit.lib.TreeFormatter;
import org.eclipse.jgit.util.RawParseUtils;

@Deprecated
public class Tree
extends TreeEntry {
    private static final TreeEntry[] EMPTY_TREE = new TreeEntry[0];
    private final Repository db;
    private TreeEntry[] contents;

    public static final int compareNames(byte[] a, byte[] b, int lasta, int lastb) {
        return Tree.compareNames(a, b, 0, b.length, lasta, lastb);
    }

    private static final int compareNames(byte[] a, byte[] nameUTF8, int nameStart, int nameEnd, int lasta, int lastb) {
        int aj;
        int k;
        int j = 0;
        for (k = nameStart; j < a.length && k < nameEnd; ++j, ++k) {
            aj = a[j] & 0xFF;
            int bk = nameUTF8[k] & 0xFF;
            if (aj < bk) {
                return -1;
            }
            if (aj <= bk) continue;
            return 1;
        }
        if (j < a.length) {
            aj = a[j] & 0xFF;
            if (aj < lastb) {
                return -1;
            }
            if (aj > lastb) {
                return 1;
            }
            if (j == a.length - 1) {
                return 0;
            }
            return -1;
        }
        if (k < nameEnd) {
            int bk = nameUTF8[k] & 0xFF;
            if (lasta < bk) {
                return -1;
            }
            if (lasta > bk) {
                return 1;
            }
            if (k == nameEnd - 1) {
                return 0;
            }
            return 1;
        }
        if (lasta < lastb) {
            return -1;
        }
        if (lasta > lastb) {
            return 1;
        }
        int namelength = nameEnd - nameStart;
        if (a.length == namelength) {
            return 0;
        }
        if (a.length < namelength) {
            return -1;
        }
        return 1;
    }

    private static final byte[] substring(byte[] s2, int nameStart, int nameEnd) {
        if (nameStart == 0 && nameStart == s2.length) {
            return s2;
        }
        byte[] n = new byte[nameEnd - nameStart];
        System.arraycopy(s2, nameStart, n, 0, n.length);
        return n;
    }

    private static final int binarySearch(TreeEntry[] entries, byte[] nameUTF8, int nameUTF8last, int nameStart, int nameEnd) {
        if (entries.length == 0) {
            return -1;
        }
        int high = entries.length;
        int low = 0;
        do {
            int mid;
            int cmp;
            if ((cmp = Tree.compareNames(entries[mid = low + high >>> 1].getNameUTF8(), nameUTF8, nameStart, nameEnd, TreeEntry.lastChar(entries[mid]), nameUTF8last)) < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp == 0) {
                return mid;
            }
            high = mid;
        } while (low < high);
        return -(low + 1);
    }

    public Tree(Repository repo) {
        super(null, null, null);
        this.db = repo;
        this.contents = EMPTY_TREE;
    }

    public Tree(Repository repo, ObjectId myId, byte[] raw) throws IOException {
        super(null, myId, null);
        this.db = repo;
        this.readTree(raw);
    }

    public Tree(Tree parent, byte[] nameUTF8) {
        super(parent, null, nameUTF8);
        this.db = parent.getRepository();
        this.contents = EMPTY_TREE;
    }

    public Tree(Tree parent, ObjectId id, byte[] nameUTF8) {
        super(parent, id, nameUTF8);
        this.db = parent.getRepository();
    }

    public FileMode getMode() {
        return FileMode.TREE;
    }

    public boolean isRoot() {
        return this.getParent() == null;
    }

    public Repository getRepository() {
        return this.db;
    }

    public boolean isLoaded() {
        return this.contents != null;
    }

    public void unload() {
        if (this.isModified()) {
            throw new IllegalStateException(JGitText.get().cannotUnloadAModifiedTree);
        }
        this.contents = null;
    }

    public FileTreeEntry addFile(String name) throws IOException {
        return this.addFile(Repository.gitInternalSlash(Constants.encode(name)), 0);
    }

    public FileTreeEntry addFile(byte[] s2, int offset) throws IOException {
        int slash;
        for (slash = offset; slash < s2.length && s2[slash] != 47; ++slash) {
        }
        this.ensureLoaded();
        int xlast = slash < s2.length ? 47 : 0;
        int p = Tree.binarySearch(this.contents, s2, xlast, offset, slash);
        if (p >= 0 && slash < s2.length && this.contents[p] instanceof Tree) {
            return ((Tree)this.contents[p]).addFile(s2, slash + 1);
        }
        byte[] newName = Tree.substring(s2, offset, slash);
        if (p >= 0) {
            throw new EntryExistsException(RawParseUtils.decode(newName));
        }
        if (slash < s2.length) {
            Tree t = new Tree(this, newName);
            this.insertEntry(p, t);
            return t.addFile(s2, slash + 1);
        }
        FileTreeEntry f = new FileTreeEntry(this, null, newName, false);
        this.insertEntry(p, f);
        return f;
    }

    public Tree addTree(String name) throws IOException {
        return this.addTree(Repository.gitInternalSlash(Constants.encode(name)), 0);
    }

    public Tree addTree(byte[] s2, int offset) throws IOException {
        int slash;
        for (slash = offset; slash < s2.length && s2[slash] != 47; ++slash) {
        }
        this.ensureLoaded();
        int p = Tree.binarySearch(this.contents, s2, 47, offset, slash);
        if (p >= 0 && slash < s2.length && this.contents[p] instanceof Tree) {
            return ((Tree)this.contents[p]).addTree(s2, slash + 1);
        }
        byte[] newName = Tree.substring(s2, offset, slash);
        if (p >= 0) {
            throw new EntryExistsException(RawParseUtils.decode(newName));
        }
        Tree t = new Tree(this, newName);
        this.insertEntry(p, t);
        return slash == s2.length ? t : t.addTree(s2, slash + 1);
    }

    public void addEntry(TreeEntry e) throws IOException {
        this.ensureLoaded();
        int p = Tree.binarySearch(this.contents, e.getNameUTF8(), TreeEntry.lastChar(e), 0, e.getNameUTF8().length);
        if (p >= 0) {
            throw new EntryExistsException(e.getName());
        }
        e.attachParent(this);
        this.insertEntry(p, e);
    }

    private void insertEntry(int p, TreeEntry e) {
        int k;
        TreeEntry[] c = this.contents;
        TreeEntry[] n = new TreeEntry[c.length + 1];
        p = -(p + 1);
        for (k = c.length - 1; k >= p; --k) {
            n[k + 1] = c[k];
        }
        n[p] = e;
        for (k = p - 1; k >= 0; --k) {
            n[k] = c[k];
        }
        this.contents = n;
        this.setModified();
    }

    void removeEntry(TreeEntry e) {
        TreeEntry[] c = this.contents;
        int p = Tree.binarySearch(c, e.getNameUTF8(), TreeEntry.lastChar(e), 0, e.getNameUTF8().length);
        if (p >= 0) {
            int k;
            TreeEntry[] n = new TreeEntry[c.length - 1];
            for (k = c.length - 1; k > p; --k) {
                n[k - 1] = c[k];
            }
            for (k = p - 1; k >= 0; --k) {
                n[k] = c[k];
            }
            this.contents = n;
            this.setModified();
        }
    }

    public int memberCount() throws IOException {
        this.ensureLoaded();
        return this.contents.length;
    }

    public TreeEntry[] members() throws IOException {
        this.ensureLoaded();
        TreeEntry[] c = this.contents;
        if (c.length != 0) {
            TreeEntry[] r = new TreeEntry[c.length];
            for (int k = c.length - 1; k >= 0; --k) {
                r[k] = c[k];
            }
            return r;
        }
        return c;
    }

    private boolean exists(String s2, byte slast) throws IOException {
        return this.findMember(s2, slast) != null;
    }

    public boolean existsTree(String path) throws IOException {
        return this.exists(path, (byte)47);
    }

    public boolean existsBlob(String path) throws IOException {
        return this.exists(path, (byte)0);
    }

    private TreeEntry findMember(String s2, byte slast) throws IOException {
        return this.findMember(Repository.gitInternalSlash(Constants.encode(s2)), slast, 0);
    }

    private TreeEntry findMember(byte[] s2, byte slast, int offset) throws IOException {
        int slash;
        for (slash = offset; slash < s2.length && s2[slash] != 47; ++slash) {
        }
        this.ensureLoaded();
        int xlast = slash < s2.length ? 47 : (int)slast;
        int p = Tree.binarySearch(this.contents, s2, xlast, offset, slash);
        if (p >= 0) {
            TreeEntry r = this.contents[p];
            if (slash < s2.length - 1) {
                return r instanceof Tree ? ((Tree)r).findMember(s2, slast, slash + 1) : null;
            }
            return r;
        }
        return null;
    }

    public TreeEntry findBlobMember(String s2) throws IOException {
        return this.findMember(s2, (byte)0);
    }

    public TreeEntry findTreeMember(String s2) throws IOException {
        return this.findMember(s2, (byte)47);
    }

    private void ensureLoaded() throws IOException, MissingObjectException {
        if (!this.isLoaded()) {
            ObjectLoader ldr = this.db.open(this.getId(), 2);
            this.readTree(ldr.getCachedBytes());
        }
    }

    private void readTree(byte[] raw) throws IOException {
        int rawSize = raw.length;
        int rawPtr = 0;
        int nextIndex = 0;
        while (rawPtr < rawSize) {
            while (rawPtr < rawSize && raw[rawPtr] != 0) {
                ++rawPtr;
            }
            ++rawPtr;
            rawPtr += 20;
            ++nextIndex;
        }
        TreeEntry[] temp = new TreeEntry[nextIndex];
        rawPtr = 0;
        nextIndex = 0;
        while (rawPtr < rawSize) {
            TreeEntry ent;
            byte c;
            if ((c = raw[rawPtr++]) < 48 || c > 55) {
                throw new CorruptObjectException(this.getId(), JGitText.get().corruptObjectInvalidEntryMode);
            }
            int mode = c - 48;
            while (32 != (c = raw[rawPtr++])) {
                if (c < 48 || c > 55) {
                    throw new CorruptObjectException(this.getId(), JGitText.get().corruptObjectInvalidMode);
                }
                mode <<= 3;
                mode += c - 48;
            }
            int nameLen = 0;
            while (raw[rawPtr + nameLen] != 0) {
                ++nameLen;
            }
            byte[] name = new byte[nameLen];
            System.arraycopy(raw, rawPtr, name, 0, nameLen);
            ObjectId id = ObjectId.fromRaw(raw, rawPtr += nameLen + 1);
            rawPtr += 20;
            if (FileMode.REGULAR_FILE.equals(mode)) {
                ent = new FileTreeEntry(this, id, name, false);
            } else if (FileMode.EXECUTABLE_FILE.equals(mode)) {
                ent = new FileTreeEntry(this, id, name, true);
            } else if (FileMode.TREE.equals(mode)) {
                ent = new Tree(this, id, name);
            } else if (FileMode.SYMLINK.equals(mode)) {
                ent = new SymlinkTreeEntry(this, id, name);
            } else if (FileMode.GITLINK.equals(mode)) {
                ent = new GitlinkTreeEntry(this, id, name);
            } else {
                throw new CorruptObjectException(this.getId(), MessageFormat.format(JGitText.get().corruptObjectInvalidMode2, Integer.toOctalString(mode)));
            }
            temp[nextIndex++] = ent;
        }
        this.contents = temp;
    }

    public byte[] format() throws IOException {
        TreeFormatter fmt = new TreeFormatter();
        for (TreeEntry e : this.members()) {
            ObjectId id = e.getId();
            if (id == null) {
                throw new ObjectWritingException(MessageFormat.format(JGitText.get().objectAtPathDoesNotHaveId, e.getFullName()));
            }
            fmt.append(e.getNameUTF8(), e.getMode(), (AnyObjectId)id);
        }
        return fmt.toByteArray();
    }

    public String toString() {
        StringBuilder r = new StringBuilder();
        r.append(ObjectId.toString(this.getId()));
        r.append(" T ");
        r.append(this.getFullName());
        return r.toString();
    }
}

