/*
 * Decompiled with CFR 0.152.
 */
package bbd.jportal2;

import bbd.jportal2.Field;
import bbd.jportal2.JPortalTemplateOutputOptions;
import bbd.jportal2.Line;
import bbd.jportal2.PlaceHolderPairs;
import bbd.jportal2.Proc;
import java.io.Serializable;
import java.util.Vector;

public class PlaceHolder
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final byte COLON = 0;
    public static final byte QUESTION = 1;
    public static final byte AT = 2;
    public static final byte CURLY = 3;
    public static final byte AT_NAMED = 4;
    public static final byte PERC_STRING = 5;
    public static final byte DOLLAR_NO = 6;
    private Proc proc;
    public Vector<PlaceHolderPairs> pairs;
    private StringBuffer command;
    private StringBuffer upper;
    private int questionsSeen;
    private String varPrefix;
    public int totalDynamicSize;
    private static final String BEGIN = "\uffbb";
    private static final String END = "\uffee";

    public PlaceHolder(Proc proc, JPortalTemplateOutputOptions options, byte useMark, String varPrefix) {
        this.proc = proc;
        this.varPrefix = varPrefix;
        this.totalDynamicSize = 0;
        this.makeCommand(options);
        this.makePairs();
        switch (useMark) {
            case 1: {
                this.makeQuestionMarks();
                break;
            }
            case 2: {
                this.makeAtMarks();
                break;
            }
            case 3: {
                this.makeCurlyMarks();
                break;
            }
            case 4: {
                this.makeAtNamed();
                break;
            }
            case 5: {
                this.makePercString();
                break;
            }
            case 6: {
                this.makeDollarNo();
            }
        }
    }

    public Vector<String> getLines() {
        Vector<String> result = new Vector<String>();
        int anchor = 0;
        int beg = PlaceHolder.indexOf(this.command, BEGIN, anchor);
        if (beg > 0) {
            String start = PlaceHolder.substring(this.command, 0, beg, ' ');
            result.addElement(start);
        }
        int end = beg;
        while (beg != -1 && (end = PlaceHolder.indexOf(this.command, END, anchor)) >= beg) {
            anchor = end + 1;
            String line = PlaceHolder.substring(this.command, beg + 1, end, '\"');
            result.addElement(line);
            beg = PlaceHolder.indexOf(this.command, BEGIN, anchor);
            if (beg - end <= 1) continue;
            line = PlaceHolder.substring(this.command, end + 1, beg, ' ');
            result.addElement(line);
        }
        if (end + 1 < this.command.length()) {
            String tail = PlaceHolder.substring(this.command, end + 1, this.command.length(), ' ');
            result.addElement(tail);
        }
        return result;
    }

    public Vector<PlaceHolderPairs> getPairs() {
        return this.pairs;
    }

    public int getTotalDynamicSize() {
        return this.totalDynamicSize;
    }

    private void makeCommand(JPortalTemplateOutputOptions options) {
        this.command = new StringBuffer();
        for (int i = 0; i < this.proc.lines.size(); ++i) {
            Line l = this.proc.lines.elementAt(i);
            if (l.isVar) {
                this.command.append(this.varPrefix);
                this.command.append(l.getDecoratedLine());
                this.totalDynamicSize += this.proc.getDynamicSize(l.getDecoratedLine(options).toString());
                continue;
            }
            this.command.append(BEGIN);
            this.command.append(this.question(new StringBuffer(l.getDecoratedLine(options).toString())));
            this.command.append(END);
        }
    }

    private void makePairs() {
        this.pairs = new Vector();
        this.upper = new StringBuffer(this.command.toString().toUpperCase());
        int i = 0;
        while (i < this.proc.inputs.size()) {
            Field field = this.proc.inputs.elementAt(i);
            int pos = this.colonIndexOf(field);
            if (pos != -1) {
                int j;
                for (j = 0; j < this.pairs.size(); ++j) {
                    PlaceHolderPairs jPair = this.pairs.elementAt(j);
                    if (jPair.pos > pos) break;
                }
                this.pairs.insertElementAt(new PlaceHolderPairs(field, pos), j);
                continue;
            }
            ++i;
        }
    }

    private void makeQuestionMarks() {
        for (int i = this.pairs.size() - 1; i >= 0; --i) {
            PlaceHolderPairs pair = this.pairs.elementAt(i);
            Field field = pair.field;
            int pos = pair.pos;
            if (pos == -1) continue;
            String parm = "?";
            PlaceHolder.delete(this.command, pos, field.name.length() + 1);
            this.command.insert(pos, parm);
        }
    }

    private void makeAtMarks() {
        for (int i = this.pairs.size() - 1; i >= 0; --i) {
            PlaceHolderPairs pair = this.pairs.elementAt(i);
            Field field = pair.field;
            int pos = pair.pos;
            if (pos == -1) continue;
            String parm = "@P" + i;
            PlaceHolder.delete(this.command, pos, field.name.length() + 1);
            this.command.insert(pos, parm);
        }
    }

    private void makeAtNamed() {
        for (int i = this.pairs.size() - 1; i >= 0; --i) {
            PlaceHolderPairs pair = this.pairs.elementAt(i);
            Field field = pair.field;
            int pos = pair.pos;
            if (pos == -1) continue;
            String parm = "@" + field.name;
            PlaceHolder.delete(this.command, pos, field.name.length() + 1);
            this.command.insert(pos, parm);
        }
    }

    private void makeCurlyMarks() {
        for (int i = this.pairs.size() - 1; i >= 0; --i) {
            PlaceHolderPairs pair = this.pairs.elementAt(i);
            Field field = pair.field;
            int pos = pair.pos;
            if (pos == -1) continue;
            String curly = "{" + i + "}";
            PlaceHolder.delete(this.command, pos, field.name.length() + 1);
            this.command.insert(pos, curly);
        }
    }

    private void makePercString() {
        for (int i = this.pairs.size() - 1; i >= 0; --i) {
            PlaceHolderPairs pair = this.pairs.elementAt(i);
            Field field = pair.field;
            int pos = pair.pos;
            if (pos == -1) continue;
            String parm = "%(" + field.name + ")s";
            PlaceHolder.delete(this.command, pos, field.name.length() + 1);
            this.command.insert(pos, parm);
        }
    }

    private void makeDollarNo() {
        for (int i = this.pairs.size() - 1; i >= 0; --i) {
            PlaceHolderPairs pair = this.pairs.elementAt(i);
            Field field = pair.field;
            int pos = pair.pos;
            if (pos == -1) continue;
            String parm = "$" + (i + 1);
            PlaceHolder.delete(this.command, pos, field.name.length() + 1);
            this.command.insert(pos, parm);
        }
    }

    private static void delete(StringBuffer buffer, int from, int size) {
        int len = buffer.length() - size;
        for (int i = from; i < len; ++i) {
            buffer.setCharAt(i, buffer.charAt(i + size));
        }
        buffer.setLength(len);
    }

    private static String substring(StringBuffer buffer, int from, int to, char ch) {
        int len = to - from + 2;
        char[] work = new char[len];
        work[0] = ch;
        buffer.getChars(from, to, work, 1);
        work[len - 1] = ch;
        return new String(work);
    }

    private static int indexOf(StringBuffer buffer, String key, int offset) {
        for (int i = offset; i < buffer.length(); ++i) {
            int pos = i;
            for (int j = 0; j < key.length(); ++j) {
                if (buffer.charAt(i + j) == key.charAt(j)) continue;
                pos = -1;
                break;
            }
            if (pos == -1) continue;
            return pos;
        }
        return -1;
    }

    private String question(StringBuffer line) {
        int findPos;
        int anchor = 0;
        while ((findPos = PlaceHolder.indexOf(line, "?", anchor)) >= 0) {
            int startQuote = PlaceHolder.indexOf(line, "'", anchor);
            if (startQuote >= 0) {
                int endQuote = PlaceHolder.indexOf(line, "'", startQuote + 1);
                if (findPos > startQuote && findPos < endQuote) {
                    anchor = endQuote + 1;
                    continue;
                }
            }
            PlaceHolder.delete(line, findPos, 1);
            if (findPos < line.length() && line.charAt(findPos) == '?') {
                anchor = findPos + 1;
                continue;
            }
            if (this.questionsSeen < this.proc.inputs.size()) {
                Field field = this.proc.inputs.elementAt(this.questionsSeen++);
                if (field.type == 10 && this.proc.isInsert) {
                    field = this.proc.inputs.elementAt(this.questionsSeen++);
                }
                line.insert(findPos, ":" + field.name);
                anchor = findPos + field.name.length() + 1;
                continue;
            }
            line.insert(findPos, ":<UNKNOWN(" + this.questionsSeen + ")>");
            anchor = findPos + 12;
        }
        return line.toString();
    }

    private int colonIndexOf(Field field) {
        int pos;
        int anchor = 0;
        String holder = ":" + field.name.toUpperCase();
        int len = holder.length();
        while ((pos = PlaceHolder.indexOf(this.upper, holder, anchor)) != -1) {
            char ch = this.upper.charAt(pos + len);
            if (ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '9' || ch == '_') {
                anchor = pos + 1;
                continue;
            }
            for (int i = 0; i < len; ++i) {
                this.upper.setCharAt(pos + i, '?');
            }
            return pos;
        }
        return pos;
    }
}

