/*
 * Decompiled with CFR 0.152.
 */
package bbd.jportal2;

import bbd.jportal2.JPortalTemplateOutputOptions;
import bbd.jportal2.SingleFileCompiler;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.function.BiConsumer;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectCompiler {
    private static final Logger logger = LoggerFactory.getLogger(ProjectCompiler.class);
    private List<String> inputDirs = new ArrayList<String>();
    private List<String> inputFiles = new ArrayList<String>();
    private List<String> builtin = new ArrayList<String>();
    private List<String> compilerFlags = new ArrayList<String>();
    private List<String> builtinSIProcessors = new ArrayList<String>();
    private List<String> templateBasedSIProcessors = new ArrayList<String>();
    private List<String> builtinPostProcessors = new ArrayList<String>();
    private List<String> templateBasedPostProcessors = new ArrayList<String>();
    private List<String> templateLocations = new ArrayList<String>();
    private JPortalTemplateOutputOptions templateOutputOptions = JPortalTemplateOutputOptions.defaultTemplateOptions();
    private Boolean projectCompile = false;

    public ProjectCompiler(Boolean projectCompile) {
        this.projectCompile = projectCompile;
    }

    public void addInputDirs(List<String> listOfInputDirs) {
        this.inputDirs.addAll(listOfInputDirs);
    }

    public void addInputDir(String inputDir) {
        this.inputDirs.add(inputDir);
    }

    public void addInputFiles(List<String> inputFiles) {
        for (String filePath : inputFiles) {
            this.addInputFile(filePath);
        }
    }

    public void addInputFile(String inputFileName) {
        if ("si".compareTo(FilenameUtils.getExtension(inputFileName)) == 0) {
            this.inputFiles.add(inputFileName);
        }
    }

    public int compileAll() throws Exception {
        ArrayList<String> allInputFiles = new ArrayList<String>();
        this.addAllInputDirsToList(allInputFiles);
        this.addAllInputFilesToList(allInputFiles);
        if (this.compilerFlags.size() == 0) {
            logger.info("No compiler getFlags detected.");
        }
        int rc = 0;
        if (this.builtinSIProcessors.size() == 0 && this.templateBasedSIProcessors.size() == 0) {
            logger.error("No generators were specified!");
            logger.error("You need to specify at least one builtin generator (using --generator) or one template-based generator (using --template-generator).");
            rc = 1;
        }
        if (rc != 0) {
            return rc;
        }
        SingleFileCompiler sfCompiler = new SingleFileCompiler();
        for (String filename : allInputFiles) {
            int resultRc = sfCompiler.compile(filename, this.compilerFlags, this.builtinSIProcessors, this.templateBasedSIProcessors, this.builtinPostProcessors, this.templateBasedPostProcessors, this.templateLocations, this.templateOutputOptions, true);
            if (resultRc <= 0) continue;
            rc = resultRc;
        }
        if (rc != 0) {
            return rc;
        }
        for (String filename : allInputFiles) {
            logger.info("Generating for SI File: " + filename);
            int localRc = sfCompiler.compile(filename, this.compilerFlags, this.builtinSIProcessors, this.templateBasedSIProcessors, this.builtinPostProcessors, this.templateBasedPostProcessors, this.templateLocations, this.templateOutputOptions, false);
            if (localRc <= 0) continue;
            rc = 1;
        }
        return rc;
    }

    private void addAllInputFilesToList(List<String> listToAddTo) {
        listToAddTo.addAll(this.inputFiles);
    }

    private void addAllInputDirsToList(List<String> listToAddTo) {
        for (String inputDir : this.inputDirs) {
            ArrayList<String> listOfFiles = new ArrayList<String>();
            this.directoryToList(inputDir, listOfFiles);
            listToAddTo.addAll(listOfFiles);
        }
    }

    private void directoryToList(String inputDir, List<String> outList) {
        File folder = new File(inputDir);
        if (!folder.isDirectory()) {
            logger.warn("{} is not a directory! Ignoring it...", (Object)inputDir);
            return;
        }
        File[] listOfFiles = folder.listFiles();
        if (listOfFiles == null) {
            logger.warn("{} is an empty directory! Ignoring it...", (Object)inputDir);
            return;
        }
        for (File file : listOfFiles) {
            if (file.isDirectory()) {
                this.directoryToList(file.toString(), outList);
                continue;
            }
            if (!file.isFile()) continue;
            Path path = Paths.get(inputDir, file.getName());
            outList.add(path.toString());
        }
    }

    public void addCompilerFlags(List<String> compilerFlags) {
        this.compilerFlags.addAll(compilerFlags);
    }

    public void addBuiltinSIProcessors(List<String> builtinSIProcessors) {
        this.builtinSIProcessors.addAll(builtinSIProcessors);
    }

    public void addBuiltinSIProcessor(String builtInSIProcessor) {
        this.builtinSIProcessors.add(builtInSIProcessor);
    }

    public void addTemplateBasedSIProcessors(List<String> templateBasedSIProcessors) {
        this.templateBasedSIProcessors.addAll(templateBasedSIProcessors);
    }

    public void addTemplateBasedSIProcessor(String templateBasedSIProcessor) {
        this.templateBasedSIProcessors.add(templateBasedSIProcessor);
    }

    public void addBuiltinPostProcessors(List<String> builtinPostProcessors) {
        this.builtinSIProcessors.addAll(builtinPostProcessors);
    }

    public void addBuiltinPostProcessor(String builtInPostProcessor) {
        this.builtinSIProcessors.add(builtInPostProcessor);
    }

    public void addTemplateBasedPostProcessors(List<String> templateBasedPostProcessors) {
        this.templateBasedPostProcessors.addAll(templateBasedPostProcessors);
    }

    public void addTemplateBasedPostProcessor(String templateBasedPostProcessor) {
        this.templateBasedPostProcessors.add(templateBasedPostProcessor);
    }

    public void addTemplateLocations(List<String> templateLocations) {
        this.templateLocations.addAll(templateLocations);
    }

    public void addTemplateLocation(String templateLocation) {
        this.templateLocations.add(templateLocation);
    }

    public void overrideWithPropertiesFile(String propertiesFileName) throws RuntimeException {
        if (propertiesFileName.isEmpty()) {
            return;
        }
        try (FileInputStream input = new FileInputStream(propertiesFileName);){
            Properties prop = new Properties();
            prop.load(input);
            prop.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> this.setTemplateOutputProperty((String)key, (String)value)));
        }
        catch (IOException ex) {
            logger.error("Error processing properties file " + propertiesFileName, ex);
            throw new RuntimeException(ex);
        }
    }

    private void setTemplateOutputProperty(String key, String value) {
        logger.debug("Property specified: " + key + " -> " + value);
        switch (key) {
            case "TemplateOutputOptions.DatabaseNamePrefix": {
                this.templateOutputOptions.DatabaseNamePrefix = value;
                break;
            }
            case "TemplateOutputOptions.DatabaseNameSuffix": {
                this.templateOutputOptions.DatabaseNameSuffix = value;
                break;
            }
            case "TemplateOutputOptions.SchemaNamePrefix": {
                this.templateOutputOptions.SchemaNamePrefix = value;
                break;
            }
            case "TemplateOutputOptions.SchemaNameSuffix": {
                this.templateOutputOptions.SchemaNameSuffix = value;
                break;
            }
            case "TemplateOutputOptions.TableNamePrefix": {
                this.templateOutputOptions.TableNamePrefix = value;
                break;
            }
            case "TemplateOutputOptions.TableNameSuffix": {
                this.templateOutputOptions.TableNameSuffix = value;
                break;
            }
            case "TemplateOutputOptions.FieldNamePrefix": {
                this.templateOutputOptions.FieldNamePrefix = value;
                break;
            }
            case "TemplateOutputOptions.FieldNameSuffix": {
                this.templateOutputOptions.FieldNameSuffix = value;
                break;
            }
            case "TemplateOutputOptions.FieldVariablePrefix": {
                this.templateOutputOptions.FieldVariablePrefix = value;
                break;
            }
            case "TemplateOutputOptions.FieldVariableSuffix": {
                this.templateOutputOptions.FieldVariableSuffix = value;
                break;
            }
            case "TemplateOutputOptions.EngineSugarPrefix": {
                this.templateOutputOptions.EngineSugarPrefix = value;
                break;
            }
            case "TemplateOutputOptions.EngineSugarSuffix": {
                this.templateOutputOptions.EngineSugarSuffix = value;
                break;
            }
            case "TemplateOutputOptions.EngineSugarOutput": {
                this.templateOutputOptions.EngineSugarOutput = value;
                break;
            }
            case "TemplateOutputOptions.EngineSugarSequence": {
                this.templateOutputOptions.EngineSugarSequence = value;
                break;
            }
            case "TemplateOutputOptions.EngineSugarTail": {
                this.templateOutputOptions.EngineSugarSuffix = value;
                break;
            }
            case "TemplateOutputOptions.DynamicVariablePrefix": {
                this.templateOutputOptions.DynamicVariablePrefix = value;
                break;
            }
            case "TemplateOutputOptions.DynamicVariableSuffix": {
                this.templateOutputOptions.DynamicVariableSuffix = value;
                break;
            }
            default: {
                logger.warn("Property: " + key + " not matched!");
            }
        }
    }
}

