/*
 * Decompiled with CFR 0.152.
 */
package bbd.jportal2;

import bbd.jportal2.JPortal2Arguments;
import bbd.jportal2.PathHelpers;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.TextProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplateDownloader {
    private static final Logger logger = LoggerFactory.getLogger(TemplateDownloader.class);

    public int downloadTemplates(JPortal2Arguments arguments) {
        for (String templateGenerator : arguments.getTemplatesToDownload()) {
            if (this.downloadGenerator(templateGenerator, arguments.getDownloadedTemplateLocation())) continue;
            return 1;
        }
        return 0;
    }

    private boolean downloadGenerator(String templateGenerator, String downloadedTemplateLocation) {
        if (!templateGenerator.contains(":") || templateGenerator.split(":").length < 2) {
            logger.error("Error in template-generator parameter. The correct format is --template-generator=<name>:<output_directory>, but --template-generator='{}' was specified instead.", (Object)templateGenerator);
            return false;
        }
        GeneratorDownloadParameters generatorParameters = new GeneratorDownloadParameters(templateGenerator).extractParametersFromOption();
        String generatorName = generatorParameters.getGeneratorName();
        String generatorURLString = generatorParameters.getGeneratorURL();
        String templateDownloadDirectory = PathHelpers.addTrailingSlash(downloadedTemplateLocation);
        File templateDownloadLocationFile = Paths.get(templateDownloadDirectory, new String[0]).toFile();
        URL generatorURL = null;
        try {
            generatorURL = new URL(generatorURLString);
        }
        catch (IOException e) {
            logger.error("Invalid URL: {}", (Object)generatorURLString, (Object)e);
            return false;
        }
        Path generatorDownloadDirectoryPath = Paths.get(templateDownloadLocationFile.getAbsolutePath(), generatorName);
        Path fullGeneratorDownloadPath = Paths.get(generatorDownloadDirectoryPath.toString(), FilenameUtils.getName(generatorURL.getPath()));
        if (Files.exists(generatorDownloadDirectoryPath, new LinkOption[0])) {
            logger.info("Template {} already exists in template-download-location {}. If you want to force a fresh download, delete the directory {}", generatorName, generatorDownloadDirectoryPath.toString(), generatorDownloadDirectoryPath.toAbsolutePath());
            return true;
        }
        if (FilenameUtils.getExtension(fullGeneratorDownloadPath.toString()).equals("zip")) {
            return this.downloadZippedGenerator(generatorName, generatorURL, generatorParameters.downloadSpecifier, generatorDownloadDirectoryPath, fullGeneratorDownloadPath);
        }
        if (FilenameUtils.getExtension(fullGeneratorDownloadPath.toString()).equals("git")) {
            return this.downloadGittedGenerator(generatorName, generatorURL, generatorParameters.downloadSpecifier, generatorDownloadDirectoryPath);
        }
        logger.error("JPortal can only deal with URL's that end in .git or .zip. Something is wrong with {}", (Object)generatorURL);
        return false;
    }

    private boolean downloadZippedGenerator(String generatorName, URL generatorURL, String mustStripBaseDir, Path GeneratorDownloadDirectoryPath, Path fullGeneratorDownloadPath) {
        try {
            boolean stripBaseDir = mustStripBaseDir != null && mustStripBaseDir.toLowerCase().contains("stripbasedir");
            logger.info("Downloading generator {} from {} (stripBaseDir = {})", generatorName, generatorURL.toString(), stripBaseDir);
            this.downloadFromURL(generatorURL, fullGeneratorDownloadPath.toString());
            if (FilenameUtils.getExtension(fullGeneratorDownloadPath.toString()).equals("zip")) {
                logger.info("Unzipping {} to {}", (Object)fullGeneratorDownloadPath.toString(), (Object)GeneratorDownloadDirectoryPath.toString());
                this.unzipFolder(fullGeneratorDownloadPath, GeneratorDownloadDirectoryPath, stripBaseDir);
            } else {
                logger.error("JPortal only supports automatic downloading of templates in .zip format.");
            }
        }
        catch (Exception e) {
            logger.error("Error downloading: {}", (Object)generatorURL.toString(), (Object)e);
            return false;
        }
        return true;
    }

    private boolean downloadGittedGenerator(String generatorName, URL generatorURL, String gitTag, Path generatorDownloadDirectoryPath) {
        try {
            logger.info("Downloading generator {} from {}", (Object)generatorName, (Object)generatorURL.toString());
            if (gitTag.isEmpty()) {
                logger.error("No Git tag was specified. If you want to download a template from a git repo, you need to use the command '--download-template <template-name>:<git-repo>|<git-tag>', for example '--download-template SQLAlchemy:https://github.com/SI-Gen/jportal2-generator-vanguard-sqlalchemy.git|1.2' or '--download-template SQLAlchemy:https://github.com/SI-Gen/jportal2-generator-vanguard-sqlalchemy.git|develop'. We STRONGLY recommend you use a TAG, instead of HEAD, master, main or develop!");
            }
            logger.info("Cloning repo: {}", (Object)generatorURL);
            Git git = Git.cloneRepository().setProgressMonitor(new TextProgressMonitor(new PrintWriter(System.out))).setURI(generatorURL.toString()).setDirectory(generatorDownloadDirectoryPath.toFile()).setBranchesToClone(Collections.singleton("refs/tags/" + gitTag)).call();
            logger.info("Checking out tag/branch: {}", (Object)gitTag);
            git.checkout().setName("refs/tags/" + gitTag).call();
        }
        catch (Exception e) {
            logger.error("Error downloading: {}", (Object)generatorURL.toString(), (Object)e);
            return false;
        }
        return true;
    }

    private void unzipFolder(Path source, Path target, boolean stripBaseDir) throws IOException {
        try (ZipInputStream zis = new ZipInputStream(new FileInputStream(source.toFile()));){
            ZipEntry zipEntry = zis.getNextEntry();
            String baseDir = "";
            if (stripBaseDir) {
                baseDir = zipEntry.getName().split(File.separator)[0] + File.separator;
            }
            while (zipEntry != null) {
                boolean isDirectory = false;
                if (zipEntry.getName().endsWith(File.separator)) {
                    isDirectory = true;
                }
                Path newPath = this.zipSlipProtect(zipEntry, target);
                String tmpNewPath = newPath.toString();
                tmpNewPath = tmpNewPath.replace(baseDir, "");
                newPath = Paths.get(tmpNewPath, new String[0]);
                if (isDirectory) {
                    Files.createDirectories(newPath, new FileAttribute[0]);
                } else {
                    if (newPath.getParent() != null && Files.notExists(newPath.getParent(), new LinkOption[0])) {
                        Files.createDirectories(newPath.getParent(), new FileAttribute[0]);
                    }
                    Files.copy(zis, newPath, StandardCopyOption.REPLACE_EXISTING);
                }
                zipEntry = zis.getNextEntry();
            }
            zis.closeEntry();
        }
    }

    private Path zipSlipProtect(ZipEntry zipEntry, Path targetDir) throws IOException {
        Path targetDirResolved = targetDir.resolve(zipEntry.getName());
        Path normalizePath = targetDirResolved.normalize();
        if (!normalizePath.startsWith(targetDir)) {
            throw new IOException("Bad zip entry: " + zipEntry.getName());
        }
        return normalizePath;
    }

    private void downloadFromURL(URL url, String fileName) throws IOException {
        FileUtils.copyURLToFile(url, new File(fileName));
    }

    private class GeneratorDownloadParameters {
        private final String generator;
        private String generatorName;
        private String downloadSpecifier;
        private String generatorURL;

        GeneratorDownloadParameters(String generator) {
            this.generator = generator;
        }

        String getGeneratorName() {
            return this.generatorName;
        }

        String getGeneratorURL() {
            return this.generatorURL;
        }

        String getDownloadSpecifier() {
            return this.downloadSpecifier;
        }

        GeneratorDownloadParameters extractParametersFromOption() {
            int strchr = this.generator.indexOf(58);
            if (strchr != -1) {
                this.generatorName = this.generator.substring(0, strchr);
                this.generatorURL = this.generator.substring(strchr + 1, this.generator.length());
                int strchr2 = this.generatorURL.lastIndexOf(124);
                if (strchr2 != -1) {
                    this.downloadSpecifier = this.generatorURL.substring(strchr2 + 1, this.generatorURL.length());
                    this.generatorURL = this.generatorURL.substring(0, strchr2);
                }
                return this;
            }
            throw new RuntimeException();
        }
    }
}

