/*
 * Decompiled with CFR 0.152.
 */
package bbd.jportal2.generators;

import bbd.jportal2.BaseGenerator;
import bbd.jportal2.Database;
import bbd.jportal2.Field;
import bbd.jportal2.Grant;
import bbd.jportal2.IBuiltInSIProcessor;
import bbd.jportal2.Key;
import bbd.jportal2.Line;
import bbd.jportal2.Link;
import bbd.jportal2.Proc;
import bbd.jportal2.Table;
import bbd.jportal2.View;
import java.io.IOException;
import java.io.PrintWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Db2DDL
extends BaseGenerator
implements IBuiltInSIProcessor {
    private static final Logger logger = LoggerFactory.getLogger(Db2DDL.class);
    public boolean hasData;

    public Db2DDL() {
        super(Db2DDL.class);
    }

    @Override
    public String description() {
        return "Generate DB2 DDL";
    }

    @Override
    public String documentation() {
        return "Generate DB2 DDL.";
    }

    @Override
    public void generate(Database database, String output) {
        block17: {
            try {
                int i;
                String fileName = database.output.length() > 0 ? database.output : database.name;
                this.hasData = false;
                try (PrintWriter outData = this.openOutputFileForGeneration("sql", output + fileName + ".sql");){
                    for (i = 0; i < database.tables.size(); ++i) {
                        this.generate(database.tables.elementAt(i), outData);
                    }
                    outData.flush();
                }
                if (!this.hasData) break block17;
                outData = this.openOutputFileForGeneration("_data.sql", output + fileName + "_data_.sql");
                try {
                    for (i = 0; i < database.tables.size(); ++i) {
                        this.generateData(database.tables.elementAt(i), outData);
                    }
                    outData.flush();
                }
                finally {
                    if (outData != null) {
                        outData.close();
                    }
                }
            }
            catch (IOException e1) {
                logger.error("Generate DB2 SQL IO Error");
            }
        }
    }

    String bSO(int i) {
        String x = "" + (101 + i);
        return x.substring(1);
    }

    void generate(Table table, PrintWriter outData) {
        int i;
        String tableOwner = "";
        if (table.database.schema.length() > 0) {
            tableOwner = table.database.schema + "";
        } else if (table.database.server.length() > 0) {
            tableOwner = table.database.server + "";
        }
        String tableName = tableOwner + table.name;
        String comma = "( ";
        boolean useBigSequence = false;
        if (table.fields.size() > 0) {
            int i2;
            outData.println("DROP TABLE " + tableName + ";");
            outData.println();
            outData.println("CREATE TABLE " + tableName);
            for (i2 = 0; i2 < table.fields.size(); ++i2) {
                Field field = table.fields.elementAt(i2);
                if (field.type == 24) {
                    useBigSequence = true;
                }
                outData.print(comma + field.name + " " + this.varType(field));
                if (field.defaultValue.length() > 0) {
                    outData.print(" DEFAULT " + field.defaultValue);
                }
                if (field.checkValue.length() > 0) {
                    outData.print(" CHECK (" + field.checkValue + ")");
                } else if (!field.isNull) {
                    outData.print(" NOT NULL");
                }
                if (field.type == 18) {
                    outData.print(" GENERATED BY DEFAULT FOR EACH ROW ON UPDATE AS ROW CHANGE TIMESTAMP");
                }
                outData.println();
                comma = ", ";
            }
            outData.print(")");
            if (table.options.size() > 0) {
                for (i2 = 0; i2 < table.options.size(); ++i2) {
                    String option = table.options.elementAt(i2);
                    if (option.toLowerCase().indexOf("tablespace") == 0) {
                        outData.println();
                        outData.print("  IN " + option.substring(11));
                        continue;
                    }
                    if (option.toLowerCase().indexOf("distribute") == 0) {
                        outData.println();
                        outData.print("  " + option);
                        continue;
                    }
                    if (option.toLowerCase().indexOf("partition") != 0) continue;
                    outData.println();
                    outData.print("  " + option);
                }
            }
            outData.println(";");
            outData.println();
            if (table.database.server.length() > 0) {
                outData.println("DROP ALIAS " + table.name + ";");
                outData.println();
                outData.println("CREATE ALIAS " + table.name + " FOR " + tableName + ";");
                outData.println();
            }
            for (i2 = 0; i2 < table.grants.size(); ++i2) {
                Grant grant = table.grants.elementAt(i2);
                this.generate(grant, outData, tableName);
            }
            if (table.hasSequence) {
                outData.println("DROP SEQUENCE " + tableName + "Seq;");
                outData.println();
                outData.println("CREATE SEQUENCE " + tableName + "Seq");
                if (useBigSequence) {
                    outData.println("  AS BIGINT");
                } else {
                    outData.println("  AS INT");
                }
                outData.println("  START WITH 1");
                outData.println("  INCREMENT BY 1");
                outData.println("  NO MAXVALUE");
                outData.println("  NO CYCLE");
                outData.println("  CACHE 200");
                outData.println("  ORDER;");
                outData.println();
                if (table.grants.size() > 0) {
                    Grant grant = table.grants.elementAt(0);
                    for (int j = 0; j < grant.users.size(); ++j) {
                        String user = grant.users.elementAt(j);
                        outData.println("GRANT SELECT ON " + tableName + "SEQ TO " + user + ";");
                        outData.println();
                    }
                }
            }
            for (i = 0; i < table.keys.size(); ++i) {
                Key key = table.keys.elementAt(i);
                boolean PSH = false;
                String fieldName = key.fields.elementAt(0);
                int no = table.getFieldIndex(fieldName);
                if (no != -1) {
                    Field field = table.fields.elementAt(no);
                    if (field.type == 25 || field.type == 24 || field.type == 10 || field.type == 14) {
                        PSH = true;
                    }
                }
                if ((key.isPrimary || key.isUnique) && !PSH) continue;
                this.generateIndexPSH(table, key, outData, PSH);
            }
        }
        for (i = 0; i < table.views.size(); ++i) {
            View view = table.views.elementAt(i);
            this.generate(view, outData, table.name, tableOwner);
        }
        if (table.keys.size() > 0) {
            for (i = 0; i < table.keys.size(); ++i) {
                Key key = table.keys.elementAt(i);
                if (key.isPrimary) {
                    outData.println("ALTER TABLE " + tableName);
                    this.generatePrimary(table, key, outData);
                    outData.println(";");
                    continue;
                }
                if (!key.isUnique) continue;
                outData.println("ALTER TABLE " + tableName);
                this.generateUnique(table, key, outData);
                outData.println(";");
            }
            outData.println("");
        }
        if (table.links.size() > 0) {
            for (i = 0; i < table.links.size(); ++i) {
                Link link = table.links.elementAt(i);
                if (link.linkName.length() == 0) {
                    link.linkName = table.name + "_FK" + this.bSO(i);
                }
                this.generate(link, outData, tableName, tableOwner, i);
            }
        }
        for (i = 0; i < table.procs.size(); ++i) {
            Proc proc = table.procs.elementAt(i);
            if (!proc.isData) continue;
            this.hasData = true;
        }
    }

    void generateData(Table table, PrintWriter outData) {
        for (int i = 0; i < table.procs.size(); ++i) {
            Proc proc = table.procs.elementAt(i);
            if (!proc.isData) continue;
            this.generate(proc, outData);
        }
    }

    String makeMaxName(String data, int size) {
        if (data.length() <= size) {
            return data;
        }
        String x = "_UOIEAY";
        for (int i = 0; i < x.length(); ++i) {
            char lookup = x.charAt(i);
            int n = data.indexOf(lookup);
            while (n != -1) {
                data = n == 0 ? data.substring(1) : (n == data.length() - 1 ? data.substring(0, n) : data.substring(0, n) + data.substring(n + 1));
                if (data.length() <= size) {
                    return data;
                }
                n = data.indexOf(lookup);
            }
        }
        return data.substring(0, size);
    }

    void generatePrimary(Table table, Key key, PrintWriter outData) {
        int i;
        String comma = "( ";
        String keyname = key.name.toUpperCase();
        if (keyname.indexOf(table.name.toUpperCase()) == -1) {
            keyname = table.name.toUpperCase() + "_" + keyname;
        }
        outData.println("ADD CONSTRAINT " + this.makeMaxName(keyname, 128) + " PRIMARY KEY");
        for (i = 0; i < key.fields.size(); ++i) {
            String name = key.fields.elementAt(i);
            outData.println(comma + name);
            comma = "  , ";
        }
        outData.print(")");
        for (i = 0; i < key.options.size(); ++i) {
            String option = key.options.elementAt(i);
            if (option.toLowerCase().indexOf("tablespace") != 0) continue;
            outData.print(" IN " + option.substring(11));
            break;
        }
    }

    void generateUnique(Table table, Key key, PrintWriter outData) {
        int i;
        String comma = "( ";
        String keyname = key.name.toUpperCase();
        if (keyname.indexOf(table.name.toUpperCase()) == -1) {
            keyname = table.name.toUpperCase() + "_" + keyname;
        }
        outData.println("ADD CONSTRAINT " + this.makeMaxName(keyname, 128) + " UNIQUE");
        for (i = 0; i < key.fields.size(); ++i) {
            String name = key.fields.elementAt(i);
            outData.println(comma + name);
            comma = "  , ";
        }
        outData.print(")");
        for (i = 0; i < key.options.size(); ++i) {
            String option = key.options.elementAt(i);
            if (option.toLowerCase().indexOf("tablespace") != 0) continue;
            outData.print(" IN " + option.substring(11));
            break;
        }
    }

    void generateIndex(Table table, Key key, PrintWriter outData) {
        this.generateIndexPSH(table, key, outData, false);
    }

    void generateIndexPSH(Table table, Key key, PrintWriter outData, boolean withPSH) {
        int i;
        String tableOwner = "";
        if (table.database.schema.length() > 0) {
            tableOwner = table.database.schema + "";
        } else if (table.database.server.length() > 0) {
            tableOwner = table.database.server + "";
        }
        String comma = "( ";
        String keyname = key.name.toUpperCase();
        if (keyname.indexOf(table.name.toUpperCase()) == -1) {
            keyname = this.makeMaxName(table.name.toUpperCase() + "_" + keyname, 128);
        }
        outData.println("DROP INDEX " + tableOwner + keyname + ";");
        outData.println("");
        outData.println("CREATE INDEX " + tableOwner + keyname + " ON " + tableOwner + table.name);
        for (i = 0; i < key.fields.size(); ++i) {
            String name = key.fields.elementAt(i);
            outData.println(comma + name);
            comma = ", ";
        }
        outData.print(")");
        for (i = 0; i < key.options.size(); ++i) {
            String option = key.options.elementAt(i);
            if (option.toLowerCase().indexOf("tablespace") != 0) continue;
            outData.print(" IN " + option.substring(11));
            break;
        }
        if (withPSH) {
            outData.print(" PAGE SPLIT HIGH ");
        }
        outData.println(";");
        outData.println();
    }

    void generate(Link link, PrintWriter outData, String tableName, String owner, int no) {
        String name;
        int i;
        outData.println("ALTER TABLE " + tableName);
        String comma = "( ";
        String linkname = "FK" + no + link.linkName.toUpperCase();
        outData.println("ADD CONSTRAINT " + this.makeMaxName(linkname, 128) + " FOREIGN KEY");
        for (i = 0; i < link.fields.size(); ++i) {
            name = link.fields.elementAt(i);
            outData.println(comma + name);
            comma = "    , ";
        }
        outData.print(") REFERENCES " + owner + link.name);
        if (link.linkFields.size() > 0) {
            comma = "(";
            for (i = 0; i < link.linkFields.size(); ++i) {
                name = link.linkFields.elementAt(i);
                outData.print(comma + name);
                comma = ", ";
            }
            outData.print(")");
        }
        if (link.isDeleteCascade) {
            outData.print(" ON DELETE CASCADE");
        }
        outData.println(";");
        outData.println();
    }

    void generate(Grant grant, PrintWriter outData, String object) {
        for (int i = 0; i < grant.perms.size(); ++i) {
            String perm = grant.perms.elementAt(i);
            for (int j = 0; j < grant.users.size(); ++j) {
                String user = grant.users.elementAt(j);
                outData.println("GRANT " + perm + " ON " + object + " TO " + user + ";");
                outData.println();
            }
        }
    }

    void generate(View view, PrintWriter outData, String tableName, String tableOwner) {
        int i;
        outData.println("DROP VIEW " + tableOwner + tableName + view.name + ";");
        outData.println();
        outData.println("CREATE VIEW " + tableOwner + tableName + view.name);
        if (view.aliases.size() > 0) {
            String comma = "( ";
            for (int i2 = 0; i2 < view.aliases.size(); ++i2) {
                String alias = view.aliases.elementAt(i2);
                outData.println(comma + alias);
                comma = ", ";
            }
            outData.print(") ");
        }
        outData.println("AS");
        outData.println("(");
        for (i = 0; i < view.lines.size(); ++i) {
            String line = view.lines.elementAt(i);
            outData.println(line);
        }
        outData.println(");");
        outData.println();
        for (i = 0; i < view.users.size(); ++i) {
            String user = view.users.elementAt(i);
            outData.println("GRANT SELECT ON " + tableName + view.name + " TO " + user + ";");
        }
        outData.println();
    }

    void generate(Proc proc, PrintWriter outData) {
        for (int i = 0; i < proc.lines.size(); ++i) {
            Line l = proc.lines.elementAt(i);
            outData.println(l.getDecoratedLine());
        }
        outData.println();
    }

    String varType(Field field) {
        switch (field.type) {
            case 3: {
                return "SMALLINT";
            }
            case 15: {
                return "SMALLINT";
            }
            case 11: 
            case 14: {
                return "INT";
            }
            case 12: 
            case 24: {
                return "BIGINT";
            }
            case 4: {
                if (field.length > 32762) {
                    return "CLOB(" + String.valueOf(field.length) + ")";
                }
                return "VARCHAR(" + String.valueOf(field.length) + ")";
            }
            case 21: {
                return "CHAR(" + String.valueOf(field.length) + ")";
            }
            case 5: {
                return "DATE";
            }
            case 6: {
                return "TIMESTAMP";
            }
            case 17: {
                return "TIME";
            }
            case 18: {
                return "TIMESTAMP";
            }
            case 7: 
            case 9: {
                if (field.scale != 0) {
                    return "DECIMAL(" + String.valueOf(field.precision) + ", " + String.valueOf(field.scale) + ")";
                }
                if (field.precision != 0) {
                    return "DECIMAL(" + String.valueOf(field.precision) + ", 0)";
                }
                return "DOUBLE";
            }
            case 1: {
                return "BLOB(" + String.valueOf(field.length) + ")";
            }
            case 19: {
                return "CLOB(" + String.valueOf(field.length) + ")";
            }
            case 13: {
                return "DECIMAL(18,2)";
            }
            case 20: {
                return "VARCHAR(50)";
            }
            case 23: {
                return "XML";
            }
            case 31: {
                return "JSON";
            }
            case 10: {
                return "<not supported>";
            }
        }
        return "unknown";
    }
}

