/*
 * Decompiled with CFR 0.152.
 */
package bbd.jportal2.generators;

import bbd.jportal2.BaseGenerator;
import bbd.jportal2.Database;
import bbd.jportal2.Field;
import bbd.jportal2.Flag;
import bbd.jportal2.Grant;
import bbd.jportal2.IBuiltInSIProcessor;
import bbd.jportal2.Key;
import bbd.jportal2.Line;
import bbd.jportal2.Link;
import bbd.jportal2.Proc;
import bbd.jportal2.Table;
import bbd.jportal2.View;
import java.io.PrintWriter;
import java.util.Vector;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MSSqlDDL
extends BaseGenerator
implements IBuiltInSIProcessor {
    private static final Logger logger = LoggerFactory.getLogger(MSSqlDDL.class);
    private Vector<Flag> flagsVector;
    boolean addTimestamp;
    boolean useInsertTrigger;
    boolean useUpdateTrigger;
    boolean internalStamps;
    boolean generate42;
    boolean auditTrigger;
    private String tableOwner;
    private String tableSchema;

    public MSSqlDDL() {
        super(MSSqlDDL.class);
    }

    @Override
    public String description() {
        return "Generate MSSql DDL";
    }

    @Override
    public String documentation() {
        return "Generate MSSql DDL";
    }

    private void flagDefaults() {
        this.addTimestamp = false;
        this.useInsertTrigger = false;
        this.useUpdateTrigger = false;
        this.internalStamps = false;
        this.auditTrigger = false;
        this.generate42 = false;
    }

    @Override
    public Vector<Flag> getFlags() {
        if (this.flagsVector == null) {
            this.flagDefaults();
            this.flagsVector = new Vector();
            this.flagsVector.addElement(new Flag("add timestamp", this.addTimestamp, "Add Timestamp - legacy getFlags"));
            this.flagsVector.addElement(new Flag("use insert trigger", this.useInsertTrigger, "Use Insert Trigger - legacy getFlags"));
            this.flagsVector.addElement(new Flag("use update trigger", this.useUpdateTrigger, "Use Update Trigger - legacy getFlags"));
            this.flagsVector.addElement(new Flag("internal stamps", this.internalStamps, "Use Internal Stamps - legacy getFlags"));
            this.flagsVector.addElement(new Flag("generate 4.2", this.generate42, "Generate for SqlServer 4.2 - legacy getFlags"));
            this.flagsVector.addElement(new Flag("auditTrigger", this.auditTrigger, "Generate Auditing Table and Triggers"));
        }
        return this.flagsVector;
    }

    void setFlags(Database database) {
        if (this.flagsVector != null) {
            this.addTimestamp = this.toBoolean(this.flagsVector.elementAt((int)0).value);
            this.useInsertTrigger = this.toBoolean(this.flagsVector.elementAt((int)1).value);
            this.useUpdateTrigger = this.toBoolean(this.flagsVector.elementAt((int)2).value);
            this.internalStamps = this.toBoolean(this.flagsVector.elementAt((int)3).value);
            this.generate42 = this.toBoolean(this.flagsVector.elementAt((int)4).value);
            this.auditTrigger = this.toBoolean(this.flagsVector.elementAt((int)5).value);
        } else {
            this.flagDefaults();
        }
        for (int i = 0; i < database.flags.size(); ++i) {
            String flag = database.flags.elementAt(i);
            if (flag.equalsIgnoreCase("add timestamp")) {
                this.addTimestamp = true;
                continue;
            }
            if (flag.equalsIgnoreCase("use triggers")) {
                this.useInsertTrigger = true;
                this.useUpdateTrigger = true;
                continue;
            }
            if (flag.equalsIgnoreCase("use insert trigger")) {
                this.useInsertTrigger = true;
                continue;
            }
            if (flag.equalsIgnoreCase("use update trigger")) {
                this.useUpdateTrigger = true;
                continue;
            }
            if (flag.equalsIgnoreCase("internal stamps")) {
                this.internalStamps = true;
                continue;
            }
            if (flag.equalsIgnoreCase("generate 4.2")) {
                this.generate42 = true;
                continue;
            }
            if (!flag.equalsIgnoreCase("audit triggers")) continue;
            this.auditTrigger = true;
        }
        if (this.addTimestamp) {
            logger.info(" (add timestamp)");
        }
        if (this.useInsertTrigger) {
            logger.info(" (use insert trigger)");
        }
        if (this.useUpdateTrigger) {
            logger.info(" (use update trigger)");
        }
        if (this.internalStamps) {
            logger.info(" (internal stamps)");
        }
        if (this.generate42) {
            logger.info(" (generate 4.2)");
        }
        if (this.auditTrigger) {
            logger.info(" (audit triggers)");
        }
    }

    @Override
    public void generate(Database database, String output) throws Exception {
        this.setFlags(database);
        String fileName = database.output.length() > 0 ? database.output : database.name;
        if (database.schema.length() > 0) {
            this.tableOwner = database.schema + "";
            this.tableSchema = database.schema;
        } else {
            this.tableOwner = "";
            this.tableSchema = "";
        }
        try (PrintWriter outputFile = this.openOutputFileForGeneration("sql", output + fileName + ".sql");){
            int i;
            outputFile.println("USE " + database.name);
            outputFile.println();
            for (i = 0; i < database.tables.size(); ++i) {
                this.generateTable(database.tables.elementAt(i), outputFile);
            }
            for (i = 0; i < database.views.size(); ++i) {
                this.generateView(database.views.elementAt(i), outputFile, "");
            }
            outputFile.flush();
        }
    }

    void generateAuditTable(Table table, PrintWriter outData) {
        String tableName = this.tableOwner + table.name;
        outData.println("IF OBJECT_ID('" + tableName + "Audit','U') IS NOT NULL");
        outData.println("    DROP TABLE " + tableName + "Audit");
        outData.println("GO");
        outData.println();
        outData.println("CREATE TABLE " + tableName + "Audit");
        outData.println("(");
        outData.println("  AuditId INTEGER IDENTITY(1,1) NOT NULL PRIMARY KEY");
        outData.println(", AuditAction INTEGER NOT NULL -- 1 = INSERT, 2 = DELETE, 3 = UPDATE");
        outData.println(", AuditWhen DATETIME NOT NULL");
        for (int i = 0; i < table.fields.size(); ++i) {
            Field field = table.fields.elementAt(i);
            outData.println(", " + this.varType(field, true, false) + " NULL");
        }
        outData.println(")");
        outData.println("GO");
        outData.println();
    }

    void generateAuditTrigger(Table table, PrintWriter outData) {
        Field field;
        int i;
        String tableName = this.tableOwner + table.name;
        outData.println("IF OBJECT_ID('" + tableName + "AuditTrigger','TR') IS NOT NULL");
        outData.println("    DROP TRIGGER " + tableName + "AuditTrigger");
        outData.println("GO");
        outData.println();
        outData.println("CREATE TRIGGER " + tableName + "AuditTrigger ON " + tableName);
        outData.println("FOR INSERT, DELETE, UPDATE AS");
        outData.println("BEGIN");
        outData.println("  DECLARE @INSERT INT, @DELETE INT, @ACTION INT;");
        outData.println("  SELECT @INSERT = COUNT(*) FROM INSERTED;");
        outData.println("  SELECT @DELETE = COUNT(*) FROM DELETED;");
        outData.println("  IF @INSERT > 0 SELECT @ACTION = 1 ELSE SELECT @ACTION = 0;");
        outData.println("  IF @DELETE > 0 SELECT @ACTION = @ACTION + 2;");
        outData.println("  -- 1 = INSERT, 2 = DELETE, 3 = UPDATE");
        outData.println("  IF @ACTION = 2 BEGIN");
        outData.println("    INSERT INTO " + tableName + "Audit");
        outData.println("    SELECT @ACTION");
        outData.println("         , GETDATE()");
        for (i = 0; i < table.fields.size(); ++i) {
            field = table.fields.elementAt(i);
            outData.println("          , " + field.name);
        }
        outData.println("    FROM DELETED;");
        outData.println("  END ELSE");
        outData.println("  BEGIN");
        outData.println("    INSERT INTO " + tableName + "Audit");
        outData.println("    SELECT @ACTION");
        outData.println("         , GETDATE()");
        for (i = 0; i < table.fields.size(); ++i) {
            field = table.fields.elementAt(i);
            outData.println("         , " + field.name);
        }
        outData.println("    FROM INSERTED;");
        outData.println("  END");
        outData.println("END");
        outData.println("GO");
        outData.println();
    }

    void generateTable(Table table, PrintWriter outData) {
        int i;
        Field field;
        Link link;
        Key key;
        Field field2;
        int i2;
        String tableName = this.tableOwner + "." + table.name;
        String comma = "  ";
        outData.println("IF OBJECT_ID('" + tableName + "','U') IS NOT NULL");
        outData.println("    DROP TABLE " + tableName);
        outData.println("GO");
        outData.println();
        outData.println("CREATE TABLE " + tableName);
        outData.println("(");
        for (i2 = 0; i2 < table.fields.size(); ++i2) {
            field2 = table.fields.elementAt(i2);
            outData.print(comma + this.varType(field2, false, table.hasSequenceReturning));
            if (field2.defaultValue.length() > 0) {
                int[] b = new int[]{4, 5, 6, 17, 18, 21, 23};
                outData.print(" CONSTRAINT  DF_" + this.tableOwner + "_" + table.name + "_" + field2.name + " DEFAULT ");
                if (ArrayUtils.contains(b, (int)field2.type)) {
                    outData.print("'" + field2.defaultValue + "'");
                } else {
                    outData.print(field2.defaultValue);
                }
            }
            if (!field2.isNull) {
                outData.println(" NOT NULL");
            } else {
                outData.println(" NULL");
            }
            comma = ", ";
        }
        if (this.internalStamps) {
            outData.println(comma + "UpdateWhen  DATETIME DEFAULT CURRENT_TIMESTAMP NULL");
            outData.println(comma + "UpdateByWho CHAR(8)  DEFAULT USER NULL ");
        }
        if (this.addTimestamp) {
            outData.println(comma + "TIMESTAMP");
        }
        if (!this.generate42) {
            for (i2 = 0; i2 < table.keys.size(); ++i2) {
                key = table.keys.elementAt(i2);
                if (key.isPrimary) {
                    this.generatePrimary(key, this.tableSchema + "_" + table.name, outData);
                    continue;
                }
                if (!key.isUnique) continue;
                this.generateUnique(key, this.tableSchema + "_" + table.name, outData);
            }
            for (i2 = 0; i2 < table.links.size(); ++i2) {
                link = table.links.elementAt(i2);
                this.generateLink(link, this.tableSchema + "_" + table.name, outData);
            }
        }
        outData.println(")");
        outData.println("GO");
        outData.println();
        for (i2 = 0; i2 < table.keys.size(); ++i2) {
            key = table.keys.elementAt(i2);
            if (!this.generate42 && (key.isPrimary || key.isUnique)) continue;
            this.generateKey(key, outData, tableName);
        }
        if (this.generate42) {
            for (i2 = 0; i2 < table.links.size(); ++i2) {
                link = table.links.elementAt(i2);
                this.generateSpLink(link, outData, tableName);
            }
        }
        for (i2 = 0; i2 < table.grants.size(); ++i2) {
            Grant grant = table.grants.elementAt(i2);
            this.generateGrant(grant, outData, table.database.userid + "" + tableName);
        }
        if (this.useInsertTrigger && (table.hasSequence || table.hasUserStamp || table.hasTimeStamp)) {
            outData.println("IF OBJECT_ID('" + tableName + "InsertTrigger','TR') IS NOT NULL");
            outData.println("    DROP TRIGGER " + tableName + "InsertTrigger");
            outData.println("GO");
            outData.println();
            outData.println("CREATE TRIGGER " + tableName + "InsertTrigger ON " + tableName + " FOR INSERT AS");
            for (i2 = 0; i2 < table.fields.size(); ++i2) {
                field2 = table.fields.elementAt(i2);
                if (field2.type != 14) continue;
                outData.println("UPDATE " + tableName + " SET " + field2.name + "=" + field2.name + "+0");
                outData.println("WHERE " + field2.name + "=(SELECT MAX(" + field2.name + ") FROM " + tableName + ")");
            }
            outData.println("UPDATE " + tableName);
            outData.println("SET");
            comma = "  ";
            for (i2 = 0; i2 < table.fields.size(); ++i2) {
                field2 = table.fields.elementAt(i2);
                if (field2.type == 14) {
                    outData.println(comma + field2.name + " = (SELECT MAX(" + field2.name + ") FROM " + tableName + ")+1");
                    comma = ", ";
                    continue;
                }
                if (field2.type == 20) {
                    outData.println(comma + field2.name + " = USER_NAME()");
                    comma = ", ";
                    continue;
                }
                if (field2.type != 18) continue;
                outData.println(comma + field2.name + " = GETDATE()");
                comma = ", ";
            }
            String cond = "WHERE ";
            for (int i3 = 0; i3 < table.fields.size(); ++i3) {
                field = table.fields.elementAt(i3);
                if (!field.isPrimaryKey) continue;
                outData.println(cond + field.name + " = (SELECT " + field.name + " FROM INSERTED)");
                cond = "  AND ";
            }
            outData.println("GO");
            outData.println();
        }
        if ((table.hasUserStamp || table.hasTimeStamp) && this.auditTrigger) {
            outData.println("IF OBJECT_ID('" + tableName + "UpdateTrigger','TR') IS NOT NULL");
            outData.println("    DROP TRIGGER " + tableName + "UpdateTrigger");
            outData.println("GO");
            outData.println();
            outData.println("CREATE TRIGGER " + tableName + "UpdateTrigger ON " + tableName + " FOR UPDATE AS");
            outData.println("UPDATE " + tableName);
            outData.println("SET");
            comma = "  ";
            for (int i4 = 0; i4 < table.fields.size(); ++i4) {
                Field field3 = table.fields.elementAt(i4);
                if (field3.type == 20) {
                    outData.println(comma + field3.name + " = USER_NAME()");
                    comma = ", ";
                    continue;
                }
                if (field3.type != 18) continue;
                outData.println(comma + field3.name + " = GETDATE()");
                comma = ", ";
            }
            outData.println("FROM INSERTED I");
            String cond = "WHERE ";
            for (int i5 = 0; i5 < table.fields.size(); ++i5) {
                field = table.fields.elementAt(i5);
                if (!field.isPrimaryKey) continue;
                outData.println(cond + tableName + "" + field.name + " = I." + field.name + " ");
                cond = "  AND ";
            }
            outData.println("GO");
            outData.println();
        }
        if (this.auditTrigger) {
            this.generateAuditTable(table, outData);
            this.generateAuditTrigger(table, outData);
        }
        for (i = 0; i < table.views.size(); ++i) {
            View view = table.views.elementAt(i);
            this.generateView(view, outData, tableName);
        }
        for (i = 0; i < table.procs.size(); ++i) {
            Proc proc = table.procs.elementAt(i);
            if (!proc.isData) continue;
            this.generateData(proc, outData);
        }
    }

    void generateKey(Key key, PrintWriter outData, String table) {
        String name;
        int i;
        String comma = "  ";
        if (key.isPrimary) {
            outData.println("CREATE UNIQUE CLUSTERED INDEX " + key.name + " ON " + table);
        } else if (key.isUnique) {
            outData.println("CREATE UNIQUE INDEX " + key.name + " ON " + table);
        } else {
            outData.println("CREATE INDEX " + key.name + " ON " + table);
        }
        outData.println("(");
        for (i = 0; i < key.fields.size(); ++i) {
            name = key.fields.elementAt(i);
            outData.println(comma + name);
            comma = ", ";
        }
        outData.println(")");
        for (i = 0; i < key.options.size(); ++i) {
            String option = key.options.elementAt(i);
            outData.println(option);
        }
        outData.println("GO");
        outData.println();
        if (key.isPrimary) {
            outData.println("sp_primarykey " + table);
            for (i = 0; i < key.fields.size(); ++i) {
                name = key.fields.elementAt(i);
                outData.println(", " + name);
            }
            outData.println("GO");
            outData.println();
        }
    }

    void generatePrimary(Key key, String table, PrintWriter outData) {
        String comma = "    ";
        outData.println(", CONSTRAINT PK_" + table + "_" + key.name + " PRIMARY KEY (");
        for (int i = 0; i < key.fields.size(); ++i) {
            String name = key.fields.elementAt(i);
            outData.println(comma + name);
            comma = "  , ";
        }
        outData.println("  )");
    }

    void generateUnique(Key key, String table, PrintWriter outData) {
        String comma = "    ";
        outData.println(", CONSTRAINT UK_" + table + "_" + key.name + " UNIQUE (");
        for (int i = 0; i < key.fields.size(); ++i) {
            String name = key.fields.elementAt(i);
            outData.println(comma + name);
            comma = "  , ";
        }
        outData.println("  )");
    }

    void generateLink(Link link, String table, PrintWriter outData) {
        String name;
        int i;
        String comma = "    ";
        String temp = "";
        for (i = 0; i < link.fields.size(); ++i) {
            name = link.fields.elementAt(i);
            temp = temp + "_" + name;
        }
        outData.println(", CONSTRAINT FK_" + table + "_" + link.useName() + temp + " FOREIGN KEY (");
        for (i = 0; i < link.fields.size(); ++i) {
            name = link.fields.elementAt(i);
            outData.println(comma + name);
            comma = "   ,";
        }
        outData.println("  )");
        if (link.linkFields.size() > 0) {
            outData.println("  REFERENCES " + link.name + "(");
            comma = "";
            for (i = 0; i < link.linkFields.size(); ++i) {
                name = link.linkFields.elementAt(i);
                outData.println(comma + name);
                comma = "   ,";
            }
            outData.println("  )");
        } else {
            outData.println("  REFERENCES " + link.name);
        }
        if (link.isDeleteCascade) {
            outData.println("    ON DELETE CASCADE");
        }
        if (link.isUpdateCascade) {
            outData.println("    ON UPDATE CASCADE");
        }
        for (i = 0; i < link.options.size(); ++i) {
            String option = link.options.elementAt(i);
            outData.println("    " + option);
        }
    }

    void generateSpLink(Link link, PrintWriter outData, String table) {
        outData.println("sp_foreignkey " + table + ", " + link.name);
        for (int i = 0; i < link.fields.size(); ++i) {
            String name = link.fields.elementAt(i);
            outData.println(", " + name);
        }
        outData.println("GO");
        outData.println();
    }

    void generateGrant(Grant grant, PrintWriter outData, String object) {
        for (int i = 0; i < grant.perms.size(); ++i) {
            String perm = grant.perms.elementAt(i);
            for (int j = 0; j < grant.users.size(); ++j) {
                String user = grant.users.elementAt(j);
                outData.println("GRANT " + perm + " ON " + object + " TO " + user);
                outData.println("GO");
                outData.println();
            }
        }
    }

    void generateView(View view, PrintWriter outData, String tableName) {
        int i;
        outData.println("IF OBJECT_ID('" + tableName + view.name + "','V') IS NOT NULL");
        outData.println("    DROP VIEW " + tableName + view.name);
        outData.println("GO");
        outData.println();
        outData.println("CREATE VIEW " + tableName + view.name);
        outData.println("(");
        String comma = "  ";
        for (i = 0; i < view.aliases.size(); ++i) {
            String alias = view.aliases.elementAt(i);
            outData.println(comma + alias);
            comma = ", ";
        }
        outData.println(") AS");
        outData.println("(");
        for (i = 0; i < view.lines.size(); ++i) {
            String line = view.lines.elementAt(i);
            outData.println(line);
        }
        outData.println(")");
        outData.println("GO");
        outData.println();
        for (i = 0; i < view.users.size(); ++i) {
            String user = view.users.elementAt(i);
            outData.println("GRANT SELECT ON " + tableName + view.name + " TO " + user);
        }
        if (view.users.size() > 0) {
            outData.println("GO");
            outData.println();
        }
    }

    void generateData(Proc proc, PrintWriter outData) {
        for (int i = 0; i < proc.lines.size(); ++i) {
            Line l = proc.lines.elementAt(i);
            if (l.getDecoratedLine().startsWith("--start")) {
                outData.println("BEGIN TRANSACTION;");
                continue;
            }
            outData.println(l.getDecoratedLine());
        }
        outData.println();
    }

    String varType(Field field, boolean typeOnly, boolean hasSequenceReturning) {
        switch (field.type) {
            case 2: {
                return field.name + " BIT";
            }
            case 3: {
                return field.name + " TINYINT";
            }
            case 15: {
                return field.name + " SMALLINT";
            }
            case 11: {
                return field.name + " INT";
            }
            case 12: {
                return field.name + " BIGINT";
            }
            case 14: {
                if (hasSequenceReturning) {
                    return field.name + " INTEGER IDENTITY(1,1)";
                }
                return field.name + " INTEGER";
            }
            case 24: {
                if (hasSequenceReturning) {
                    return field.name + " BIGINT IDENTITY(1,1)";
                }
                return field.name + " BIGINT";
            }
            case 10: {
                if (typeOnly) {
                    return field.name + " INTEGER";
                }
                return field.name + " INTEGER IDENTITY(1,1)";
            }
            case 25: {
                if (typeOnly) {
                    return field.name + " BIGINT";
                }
                return field.name + " BIGINT IDENTITY(1,1)";
            }
            case 4: {
                if (field.length > 8000) {
                    return field.name + " VARCHAR(MAX)";
                }
                return field.name + " VARCHAR(" + String.valueOf(field.length) + ")";
            }
            case 21: {
                return field.name + " CHAR(" + String.valueOf(field.length) + ")";
            }
            case 5: {
                return field.name + " DATETIME";
            }
            case 6: {
                return field.name + " DATETIME";
            }
            case 17: {
                return field.name + " DATETIME";
            }
            case 18: {
                return field.name + " DATETIME";
            }
            case 7: 
            case 9: {
                if (field.precision > 15) {
                    return field.name + " DECIMAL(" + field.precision + "," + field.scale + ")";
                }
                return field.name + " FLOAT";
            }
            case 1: {
                return field.name + " IMAGE";
            }
            case 19: {
                return field.name + " TEXT";
            }
            case 23: 
            case 30: {
                return field.name + " XML";
            }
            case 31: 
            case 32: {
                return field.name + " JSON";
            }
            case 13: {
                return field.name + " MONEY";
            }
            case 20: {
                return field.name + " VARCHAR(50)";
            }
            case 22: {
                return field.name + " UNIQUEIDENTIFIER";
            }
        }
        throw new Error(String.format("Undefined SI type for field: \"%s\"", field.name));
    }
}

