/*
 * Decompiled with CFR 0.152.
 */
package checkers.basetype;

import checkers.basetype.BaseTypeVisitor;
import checkers.source.SourceChecker;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javacutils.ErrorReporter;

public abstract class BaseTypeChecker
extends SourceChecker {
    protected BaseTypeVisitor<?> createSourceVisitor() {
        for (Class<?> checkerClass = this.getClass(); checkerClass != BaseTypeChecker.class; checkerClass = checkerClass.getSuperclass()) {
            String classToLoad = checkerClass.getName().replace("Checker", "Visitor").replace("Subchecker", "Visitor");
            BaseTypeVisitor result = (BaseTypeVisitor)BaseTypeChecker.invokeConstructorFor(classToLoad, new Class[]{BaseTypeChecker.class}, new Object[]{this});
            if (result == null) continue;
            return result;
        }
        return new BaseTypeVisitor(this);
    }

    @Override
    public Set<String> getSupportedLintOptions() {
        HashSet<String> lintSet = new HashSet<String>(super.getSupportedLintOptions());
        lintSet.add("cast");
        lintSet.add("cast:redundant");
        lintSet.add("cast:unsafe");
        return Collections.unmodifiableSet(lintSet);
    }

    public static <T> T invokeConstructorFor(String name, Class<?>[] paramTypes, Object[] args) {
        Class<?> cls = null;
        try {
            cls = Class.forName(name);
        }
        catch (Exception e) {
            return null;
        }
        assert (cls != null) : "reflectively loading " + name + " failed";
        try {
            Constructor<?> ctor = cls.getConstructor(paramTypes);
            return (T)ctor.newInstance(args);
        }
        catch (Throwable t) {
            if (t instanceof InvocationTargetException) {
                Throwable err = t.getCause();
                String msg = err instanceof SourceChecker.CheckerError ? err.getMessage() : err.toString();
                ErrorReporter.errorAbort("InvocationTargetException when invoking constructor for class " + name + "; Underlying cause: " + msg, t);
            } else {
                ErrorReporter.errorAbort("Unexpected " + t.getClass().getSimpleName() + " for " + "class " + name + " when invoking the constructor; parameter types: " + Arrays.toString(paramTypes), t);
            }
            return null;
        }
    }
}

