/*
 * Decompiled with CFR 0.152.
 */
package checkers.types;

import checkers.types.AnnotatedTypeMirror;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javacutils.AnnotationUtils;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.type.TypeKind;

public abstract class QualifierHierarchy {
    public boolean isValid() {
        return this.getTypeQualifiers().size() > 0;
    }

    public int getWidth() {
        return this.getTopAnnotations().size();
    }

    public abstract Set<? extends AnnotationMirror> getTopAnnotations();

    public abstract AnnotationMirror getTopAnnotation(AnnotationMirror var1);

    public abstract AnnotationMirror getBottomAnnotation(AnnotationMirror var1);

    public abstract Set<? extends AnnotationMirror> getBottomAnnotations();

    public abstract AnnotationMirror getPolymorphicAnnotation(AnnotationMirror var1);

    public abstract Set<? extends AnnotationMirror> getTypeQualifiers();

    public abstract boolean isSubtype(AnnotationMirror var1, AnnotationMirror var2);

    public abstract boolean isSubtype(Collection<? extends AnnotationMirror> var1, Collection<? extends AnnotationMirror> var2);

    public abstract AnnotationMirror leastUpperBound(AnnotationMirror var1, AnnotationMirror var2);

    public abstract AnnotationMirror greatestLowerBound(AnnotationMirror var1, AnnotationMirror var2);

    public Set<? extends AnnotationMirror> leastUpperBounds(Collection<? extends AnnotationMirror> annos1, Collection<? extends AnnotationMirror> annos2) {
        assert (annos1.size() == annos2.size()) : "QualifierHierarchy.leastUpperBounds: tried to determine LUB with sets of different sizes!\n    Set 1: " + annos1 + " Set 2: " + annos2;
        assert (annos1.size() != 0) : "QualifierHierarchy.leastUpperBounds: tried to determine LUB with empty sets!";
        Set<AnnotationMirror> result = AnnotationUtils.createAnnotationSet();
        for (AnnotationMirror annotationMirror : annos1) {
            for (AnnotationMirror annotationMirror2 : annos2) {
                AnnotationMirror lub = this.leastUpperBound(annotationMirror, annotationMirror2);
                if (lub == null) continue;
                result.add(lub);
            }
        }
        assert (result.size() == annos1.size()) : "QualifierHierarchy.leastUpperBounds: resulting set has incorrect number of annotations!\n    Set 1: " + annos1 + " Set 2: " + annos2 + " LUB: " + result;
        return result;
    }

    public Set<? extends AnnotationMirror> greatestLowerBounds(Collection<? extends AnnotationMirror> annos1, Collection<? extends AnnotationMirror> annos2) {
        assert (annos1.size() == annos2.size()) : "QualifierHierarchy.greatestLowerBounds: tried to determine GLB with sets of different sizes!\n    Set 1: " + annos1 + " Set 2: " + annos2;
        assert (annos1.size() != 0) : "QualifierHierarchy.greatestLowerBounds: tried to determine GLB with empty sets!";
        Set<AnnotationMirror> result = AnnotationUtils.createAnnotationSet();
        for (AnnotationMirror annotationMirror : annos1) {
            for (AnnotationMirror annotationMirror2 : annos2) {
                AnnotationMirror glb = this.greatestLowerBound(annotationMirror, annotationMirror2);
                if (glb == null) continue;
                result.add(glb);
            }
        }
        assert (result.size() == annos1.size()) : "QualifierHierarchy.greatestLowerBounds: resulting set has incorrect number of annotations!\n    Set 1: " + annos1 + " Set 2: " + annos2 + " LUB: " + result;
        return result;
    }

    public abstract boolean isSubtypeTypeVariable(AnnotationMirror var1, AnnotationMirror var2);

    public abstract boolean isSubtypeTypeVariable(Collection<? extends AnnotationMirror> var1, Collection<? extends AnnotationMirror> var2);

    public abstract AnnotationMirror leastUpperBoundTypeVariable(AnnotationMirror var1, AnnotationMirror var2);

    public abstract AnnotationMirror greatestLowerBoundTypeVariable(AnnotationMirror var1, AnnotationMirror var2);

    public Set<? extends AnnotationMirror> leastUpperBoundsTypeVariable(Collection<? extends AnnotationMirror> annos1, Collection<? extends AnnotationMirror> annos2) {
        Set<AnnotationMirror> result = AnnotationUtils.createAnnotationSet();
        for (AnnotationMirror annotationMirror : this.getTopAnnotations()) {
            AnnotationMirror anno1ForTop = null;
            for (AnnotationMirror annotationMirror2 : annos1) {
                if (!this.isSubtypeTypeVariable(annotationMirror2, annotationMirror)) continue;
                anno1ForTop = annotationMirror2;
            }
            AnnotationMirror anno2ForTop = null;
            for (AnnotationMirror anno2 : annos2) {
                if (!this.isSubtypeTypeVariable(anno2, annotationMirror)) continue;
                anno2ForTop = anno2;
            }
            AnnotationMirror annotationMirror3 = this.leastUpperBoundTypeVariable(anno1ForTop, anno2ForTop);
            if (annotationMirror3 == null) continue;
            result.add(annotationMirror3);
        }
        return result;
    }

    public Set<? extends AnnotationMirror> greatestLowerBoundsTypeVariable(Collection<? extends AnnotationMirror> annos1, Collection<? extends AnnotationMirror> annos2) {
        Set<AnnotationMirror> result = AnnotationUtils.createAnnotationSet();
        for (AnnotationMirror annotationMirror : this.getTopAnnotations()) {
            AnnotationMirror anno1ForTop = null;
            for (AnnotationMirror annotationMirror2 : annos1) {
                if (!this.isSubtypeTypeVariable(annotationMirror2, annotationMirror)) continue;
                anno1ForTop = annotationMirror2;
            }
            AnnotationMirror anno2ForTop = null;
            for (AnnotationMirror anno2 : annos2) {
                if (!this.isSubtypeTypeVariable(anno2, annotationMirror)) continue;
                anno2ForTop = anno2;
            }
            AnnotationMirror annotationMirror3 = this.greatestLowerBoundTypeVariable(anno1ForTop, anno2ForTop);
            if (annotationMirror3 == null) continue;
            result.add(annotationMirror3);
        }
        return result;
    }

    public static boolean canHaveEmptyAnnotationSet(AnnotatedTypeMirror type) {
        return type.getKind() == TypeKind.TYPEVAR || type.getKind() == TypeKind.WILDCARD || type.getKind() == TypeKind.UNION || type.getKind() == TypeKind.INTERSECTION;
    }

    public boolean isSubtype(AnnotatedTypeMirror type1, AnnotatedTypeMirror type2, AnnotationMirror anno1, AnnotationMirror anno2) {
        if (QualifierHierarchy.canHaveEmptyAnnotationSet(type1) || QualifierHierarchy.canHaveEmptyAnnotationSet(type2)) {
            return this.isSubtypeTypeVariable(anno1, anno2);
        }
        return this.isSubtype(anno1, anno2);
    }

    public boolean isSubtype(AnnotatedTypeMirror type1, AnnotatedTypeMirror type2, Collection<? extends AnnotationMirror> rhs, Collection<AnnotationMirror> lhs) {
        if (QualifierHierarchy.canHaveEmptyAnnotationSet(type1) || QualifierHierarchy.canHaveEmptyAnnotationSet(type2)) {
            return this.isSubtypeTypeVariable(rhs, lhs);
        }
        return this.isSubtype(rhs, lhs);
    }

    public AnnotationMirror leastUpperBound(AnnotatedTypeMirror type1, AnnotatedTypeMirror type2, AnnotationMirror a1, AnnotationMirror a2) {
        if (QualifierHierarchy.canHaveEmptyAnnotationSet(type1) || QualifierHierarchy.canHaveEmptyAnnotationSet(type2)) {
            return this.leastUpperBoundTypeVariable(a1, a2);
        }
        return this.leastUpperBound(a1, a2);
    }

    public AnnotationMirror greatestLowerBound(AnnotatedTypeMirror type1, AnnotatedTypeMirror type2, AnnotationMirror a1, AnnotationMirror a2) {
        if (QualifierHierarchy.canHaveEmptyAnnotationSet(type1) || QualifierHierarchy.canHaveEmptyAnnotationSet(type2)) {
            return this.greatestLowerBoundTypeVariable(a1, a2);
        }
        return this.greatestLowerBound(a1, a2);
    }

    public Set<? extends AnnotationMirror> leastUpperBounds(AnnotatedTypeMirror type1, AnnotatedTypeMirror type2, Collection<? extends AnnotationMirror> annos1, Collection<AnnotationMirror> annos2) {
        if (QualifierHierarchy.canHaveEmptyAnnotationSet(type1) || QualifierHierarchy.canHaveEmptyAnnotationSet(type2)) {
            return this.leastUpperBoundsTypeVariable(annos1, annos2);
        }
        return this.leastUpperBounds(annos1, annos2);
    }

    public Set<? extends AnnotationMirror> greatestLowerBounds(AnnotatedTypeMirror type1, AnnotatedTypeMirror type2, Collection<? extends AnnotationMirror> annos1, Collection<AnnotationMirror> annos2) {
        if (QualifierHierarchy.canHaveEmptyAnnotationSet(type1) || QualifierHierarchy.canHaveEmptyAnnotationSet(type2)) {
            return this.greatestLowerBoundsTypeVariable(annos1, annos2);
        }
        return this.greatestLowerBounds(annos1, annos2);
    }

    public AnnotationMirror findCorrespondingAnnotation(AnnotationMirror aliased, Collection<? extends AnnotationMirror> a) {
        AnnotationMirror top = this.getTopAnnotation(aliased);
        for (AnnotationMirror annotationMirror : a) {
            if (!this.isSubtype(annotationMirror, top)) continue;
            return annotationMirror;
        }
        return null;
    }

    public AnnotationMirror getAnnotationInHierarchy(Collection<? extends AnnotationMirror> annos, AnnotationMirror top) {
        AnnotationMirror annoInHierarchy = null;
        for (AnnotationMirror annotationMirror : annos) {
            if (!this.isSubtype(annotationMirror, top)) continue;
            annoInHierarchy = annotationMirror;
        }
        return annoInHierarchy;
    }

    public <T> boolean updateMappingToMutableSet(Map<T, Set<AnnotationMirror>> map, T key, AnnotationMirror newQual) {
        if (!map.containsKey(key)) {
            Set<AnnotationMirror> set = AnnotationUtils.createAnnotationSet();
            set.add(newQual);
            map.put(key, set);
        } else {
            Set<AnnotationMirror> prevs = map.get(key);
            for (AnnotationMirror p : prevs) {
                if (!AnnotationUtils.areSame(this.getTopAnnotation(p), this.getTopAnnotation(newQual))) continue;
                return false;
            }
            prevs.add(newQual);
            map.put(key, prevs);
        }
        return true;
    }
}

