/*
 * Decompiled with CFR 0.152.
 */
package dataflow.analysis;

import dataflow.analysis.AbstractValue;
import dataflow.analysis.Store;
import dataflow.analysis.TransferResult;
import java.util.Map;
import javax.lang.model.type.TypeMirror;

public class ConditionalTransferResult<A extends AbstractValue<A>, S extends Store<S>>
extends TransferResult<A, S> {
    protected S thenStore;
    protected S elseStore;

    public ConditionalTransferResult(A value, S thenStore, S elseStore) {
        super(value);
        this.thenStore = thenStore;
        this.elseStore = elseStore;
    }

    public ConditionalTransferResult(A value, S thenStore, S elseStore, Map<TypeMirror, S> exceptionalStores) {
        super(value);
        this.exceptionalStores = exceptionalStores;
        this.thenStore = thenStore;
        this.elseStore = elseStore;
    }

    @Override
    public S getRegularStore() {
        return this.thenStore.leastUpperBound(this.elseStore);
    }

    @Override
    public S getThenStore() {
        return this.thenStore;
    }

    @Override
    public S getElseStore() {
        return this.elseStore;
    }

    @Override
    public boolean containsTwoStores() {
        return true;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("RegularTransferResult(");
        result.append(System.getProperty("line.separator"));
        result.append("resultValue = " + this.resultValue);
        result.append(System.getProperty("line.separator"));
        result.append("thenStore = " + this.thenStore);
        result.append("elseStore = " + this.elseStore);
        result.append(System.getProperty("line.separator"));
        result.append(")");
        return result.toString();
    }
}

