/*
 * Decompiled with CFR 0.152.
 */
package org.stringtemplate.v4.compiler;

import java.util.ArrayList;
import org.stringtemplate.v4.compiler.Bytecode;
import org.stringtemplate.v4.compiler.CompiledST;
import org.stringtemplate.v4.misc.Interval;
import org.stringtemplate.v4.misc.Misc;

public class BytecodeDisassembler {
    CompiledST code;
    static final /* synthetic */ int[] $SwitchMap$org$stringtemplate$v4$compiler$Bytecode$OperandType;

    public BytecodeDisassembler(CompiledST code) {
        this.code = code;
    }

    public String instrs() {
        StringBuilder buf = new StringBuilder();
        int ip = 0;
        while (ip < this.code.codeSize) {
            if (ip > 0) {
                buf.append(", ");
            }
            byte opcode = this.code.instrs[ip];
            Bytecode.Instruction I2 = Bytecode.instructions[opcode];
            buf.append(I2.name);
            ++ip;
            for (int opnd = 0; opnd < I2.nopnds; ++opnd) {
                buf.append(' ');
                buf.append(BytecodeDisassembler.getShort(this.code.instrs, ip));
                ip += 2;
            }
        }
        return buf.toString();
    }

    public String disassemble() {
        StringBuilder buf = new StringBuilder();
        int i = 0;
        while (i < this.code.codeSize) {
            i = this.disassembleInstruction(buf, i);
            buf.append('\n');
        }
        return buf.toString();
    }

    public int disassembleInstruction(StringBuilder buf, int ip) {
        int i;
        byte opcode = this.code.instrs[ip];
        if (ip >= this.code.codeSize) {
            throw new IllegalArgumentException("ip out of range: " + ip);
        }
        Bytecode.Instruction I2 = Bytecode.instructions[opcode];
        if (I2 == null) {
            throw new IllegalArgumentException("no such instruction " + opcode + " at address " + ip);
        }
        String instrName = I2.name;
        buf.append(String.format("%04d:\t%-14s", new Integer(ip), instrName));
        ++ip;
        if (I2.nopnds == 0) {
            buf.append("  ");
            return ip;
        }
        ArrayList<String> operands = new ArrayList<String>();
        block4: for (i = 0; i < I2.nopnds; ++i) {
            int opnd = BytecodeDisassembler.getShort(this.code.instrs, ip);
            ip += 2;
            switch ($SwitchMap$org$stringtemplate$v4$compiler$Bytecode$OperandType[I2.type[i].ordinal()]) {
                case 1: {
                    operands.add(this.showConstPoolOperand(opnd));
                    continue block4;
                }
                case 2: 
                case 3: {
                    operands.add(String.valueOf(opnd));
                    continue block4;
                }
                default: {
                    operands.add(String.valueOf(opnd));
                }
            }
        }
        for (i = 0; i < operands.size(); ++i) {
            String s2 = (String)operands.get(i);
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(s2);
        }
        return ip;
    }

    private String showConstPoolOperand(int poolIndex) {
        StringBuffer buf = new StringBuffer();
        buf.append("#");
        buf.append(poolIndex);
        String s2 = "<bad string index>";
        if (poolIndex < this.code.strings.length) {
            if (this.code.strings[poolIndex] == null) {
                s2 = "null";
            } else {
                s2 = this.code.strings[poolIndex].toString();
                if (this.code.strings[poolIndex] instanceof String) {
                    s2 = Misc.replaceEscapes(s2);
                    s2 = '\"' + s2 + '\"';
                }
            }
        }
        buf.append(":");
        buf.append(s2);
        return buf.toString();
    }

    public static int getShort(byte[] memory, int index) {
        int b1 = memory[index] & 0xFF;
        int b2 = memory[index + 1] & 0xFF;
        int word = b1 << 8 | b2;
        return word;
    }

    public String strings() {
        StringBuffer buf = new StringBuffer();
        int addr = 0;
        if (this.code.strings != null) {
            String[] arr$ = this.code.strings;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                String o = arr$[i$];
                if (o instanceof String) {
                    String s2 = o;
                    s2 = Misc.replaceEscapes(s2);
                    buf.append(String.format("%04d: \"%s\"\n", new Integer(addr), s2));
                } else {
                    buf.append(String.format("%04d: %s\n", new Integer(addr), o));
                }
                ++addr;
            }
        }
        return buf.toString();
    }

    public String sourceMap() {
        StringBuffer buf = new StringBuffer();
        int addr = 0;
        Interval[] arr$ = this.code.sourceMap;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Interval I2 = arr$[i$];
            if (I2 != null) {
                String chunk = this.code.template.substring(I2.a, I2.b + 1);
                buf.append(String.format("%04d: %s\t\"%s\"\n", new Integer(addr), I2, chunk));
            }
            ++addr;
        }
        return buf.toString();
    }

    static {
        $SwitchMap$org$stringtemplate$v4$compiler$Bytecode$OperandType = new int[Bytecode.OperandType.values().length];
        try {
            BytecodeDisassembler.$SwitchMap$org$stringtemplate$v4$compiler$Bytecode$OperandType[Bytecode.OperandType.STRING.ordinal()] = 1;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            BytecodeDisassembler.$SwitchMap$org$stringtemplate$v4$compiler$Bytecode$OperandType[Bytecode.OperandType.ADDR.ordinal()] = 2;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            BytecodeDisassembler.$SwitchMap$org$stringtemplate$v4$compiler$Bytecode$OperandType[Bytecode.OperandType.INT.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {
            // empty catch block
        }
    }
}

