/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.dircache;

import java.io.IOException;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheEntry;

abstract class BaseDirCacheEditor {
    protected DirCache cache;
    protected DirCacheEntry[] entries;
    protected int entryCnt;

    protected BaseDirCacheEditor(DirCache dc, int ecnt) {
        this.cache = dc;
        this.entries = new DirCacheEntry[ecnt];
    }

    public DirCache getDirCache() {
        return this.cache;
    }

    protected void fastAdd(DirCacheEntry newEntry) {
        if (this.entries.length == this.entryCnt) {
            DirCacheEntry[] n = new DirCacheEntry[(this.entryCnt + 16) * 3 / 2];
            System.arraycopy(this.entries, 0, n, 0, this.entryCnt);
            this.entries = n;
        }
        this.entries[this.entryCnt++] = newEntry;
    }

    protected void fastKeep(int pos, int cnt) {
        if (this.entryCnt + cnt > this.entries.length) {
            int m1 = (this.entryCnt + 16) * 3 / 2;
            int m22 = this.entryCnt + cnt;
            DirCacheEntry[] n = new DirCacheEntry[Math.max(m1, m22)];
            System.arraycopy(this.entries, 0, n, 0, this.entryCnt);
            this.entries = n;
        }
        this.cache.toArray(pos, this.entries, this.entryCnt, cnt);
        this.entryCnt += cnt;
    }

    public abstract void finish();

    protected void replace() {
        if (this.entryCnt < this.entries.length / 2) {
            DirCacheEntry[] n = new DirCacheEntry[this.entryCnt];
            System.arraycopy(this.entries, 0, n, 0, this.entryCnt);
            this.entries = n;
        }
        this.cache.replace(this.entries, this.entryCnt);
    }

    public boolean commit() throws IOException {
        this.finish();
        this.cache.write();
        return this.cache.commit();
    }
}

