/*
 * Decompiled with CFR 0.152.
 */
package bbd.jportal2;

import bbd.jportal2.GeneratedFiles;
import bbd.jportal2.JPortalTemplateOutputOptions;
import bbd.jportal2.Sequence;
import bbd.jportal2.Table;
import bbd.jportal2.View;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Database
implements Serializable {
    private static final Logger logger = LoggerFactory.getLogger(Database.class);
    private static final long serialVersionUID = 1L;
    public String name = "";
    public String output = "";
    public String server = "";
    public String schema = "";
    public String userid = "";
    public String password = "";
    public String packageName = "";
    public Vector<Table> tables = new Vector();
    public Vector<String> flags = new Vector();
    public Vector<Sequence> sequences = new Vector();
    public Vector<View> views = new Vector();
    public Vector<String> imports = new Vector();
    public JPortalTemplateOutputOptions templateOutputOptions;
    public ArrayList<GeneratedFiles> generatedOutputFiles = new ArrayList();

    public String getName() {
        return this.name;
    }

    public String getOutput() {
        return this.output;
    }

    public String getServer() {
        return this.server;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getUserid() {
        return this.userid;
    }

    public String getPassword() {
        return this.password;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public Vector<Table> getTables() {
        return this.tables;
    }

    public Vector<String> getFlags() {
        return this.flags;
    }

    public Vector<Sequence> getSequences() {
        return this.sequences;
    }

    public Vector<View> getViews() {
        return this.views;
    }

    public Vector<String> getImports() {
        return this.imports;
    }

    public boolean hasTable(String s2) {
        for (int i = 0; i < this.tables.size(); ++i) {
            Table table = this.tables.elementAt(i);
            if (!table.name.equalsIgnoreCase(s2)) continue;
            return true;
        }
        return false;
    }

    public String outName() {
        if (this.output.length() > 0) {
            return this.output;
        }
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Database readRepository(String name) throws Exception {
        logger.info("Inputting " + name + ".repository");
        try (ObjectInputStream in = new ObjectInputStream(new FileInputStream(name + ".repository"));){
            Database database;
            Database database2 = database = (Database)in.readObject();
            return database2;
        }
    }

    private void addinTable(Vector<Table> tables, Table addin) {
        for (int i = 0; i < tables.size(); ++i) {
            Table table = tables.elementAt(i);
            if (!table.name.equalsIgnoreCase(addin.name)) continue;
            logger.info("Import table name :" + addin.name + " to merge with existing.");
            table = table.add(addin);
            tables.setElementAt(table, i);
            return;
        }
        tables.addElement(addin);
    }

    private void addinView(Vector<View> views, View addin) {
        for (int i = 0; i < views.size(); ++i) {
            View view = views.elementAt(i);
            if (!view.name.equalsIgnoreCase(addin.name)) continue;
            logger.warn("Import view name :" + addin.name + " already exists");
            return;
        }
        views.addElement(addin);
    }

    private static void addinSequence(Vector<Sequence> sequences, Sequence addin) {
        for (int i = 0; i < sequences.size(); ++i) {
            Sequence sequence = sequences.elementAt(i);
            if (!sequence.name.equalsIgnoreCase(addin.name)) continue;
            logger.warn("Import sequence name :" + addin.name + " already exists");
            return;
        }
        sequences.addElement(addin);
    }

    private String set(String a, String b, String what) {
        if (a.length() == 0) {
            a = b;
        } else if (!a.equalsIgnoreCase(b)) {
            logger.warn("Import " + what + " name :" + a + " not the same as :" + b);
        }
        return a;
    }

    public void add(Database database) {
        int i;
        this.name = this.set(this.name, database.name, "name");
        this.output = this.set(this.output, database.output, "output");
        this.server = this.set(this.server, database.server, "server");
        this.userid = this.set(this.userid, database.userid, "userid");
        this.password = this.set(this.password, database.password, "password");
        this.packageName = this.set(this.packageName, database.packageName, "packageName");
        for (i = 0; i < database.tables.size(); ++i) {
            Table table = database.tables.elementAt(i);
            this.addinTable(this.tables, table);
        }
        for (i = 0; i < database.views.size(); ++i) {
            View view = database.views.elementAt(i);
            this.addinView(this.views, view);
        }
        for (i = 0; i < database.sequences.size(); ++i) {
            Sequence sequence = database.sequences.elementAt(i);
            Database.addinSequence(this.sequences, sequence);
        }
        for (i = 0; i < database.imports.size(); ++i) {
            String addinName = "";
            try {
                addinName = database.imports.elementAt(i);
                logger.warn("Addin name " + addinName);
                boolean addIt = true;
                for (int j = 0; j < this.imports.size(); ++j) {
                    String already = this.imports.elementAt(j);
                    if (!already.equalsIgnoreCase(addinName)) continue;
                    addIt = false;
                    logger.warn("Already imported: " + addinName);
                    break;
                }
                if (!addIt) continue;
                this.imports.addElement(addinName);
                Database next = Database.readRepository(addinName);
                this.add(next);
                continue;
            }
            catch (Exception ex) {
                logger.error("Import name :" + addinName + " failed.", ex);
            }
        }
    }

    public Database doImports() {
        if (this.imports.size() > 0) {
            Database database = new Database();
            database.add(this);
            return database;
        }
        return this;
    }

    public String packageMerge(String output) {
        String ow;
        int oi;
        Vector<String> ov = new Vector<String>();
        Vector<String> pv = new Vector<String>();
        if (this.packageName.length() == 0) {
            return output;
        }
        int length = output.length();
        int sep = output.lastIndexOf(47);
        char sepChar = '\\';
        if (sep != -1) {
            sepChar = '/';
        } else {
            sep = output.lastIndexOf(92);
        }
        if (sep < length - 1) {
            output = output + sepChar;
        }
        String work = this.packageName + '.';
        int p = work.indexOf(46);
        while (p >= 0) {
            if (p > 0) {
                pv.addElement(work.substring(0, p));
            }
            work = work.substring(p + 1);
            p = work.indexOf(46);
        }
        work = output;
        p = work.indexOf(sepChar);
        while (p >= 0) {
            if (p > 0) {
                ov.addElement(work.substring(0, p));
            }
            work = work.substring(p + 1);
            p = work.indexOf(sepChar);
        }
        String pw = (String)pv.elementAt(0);
        for (oi = ov.size() - 1; oi >= 0 && (ow = (String)ov.elementAt(oi)).compareTo(pw) != 0; --oi) {
        }
        if (oi == -1) {
            return output;
        }
        int pi = 0;
        while (oi < ov.size()) {
            pw = (String)pv.elementAt(pi);
            ow = (String)ov.elementAt(oi);
            if (ow.compareTo(pw) != 0) break;
            ++pi;
            ++oi;
        }
        if (oi < ov.size()) {
            return output;
        }
        while (pi < pv.size()) {
            pw = (String)pv.elementAt(pi);
            output = output + pw + sepChar;
            ++pi;
        }
        return output;
    }

    public ArrayList<GeneratedFiles> getGeneratedOutputFiles() {
        return this.generatedOutputFiles;
    }

    public void addGeneratedOutputFiles(GeneratedFiles generatedOutputFiles) {
        this.generatedOutputFiles.add(generatedOutputFiles);
    }
}

