/*
 * Decompiled with CFR 0.152.
 */
package bbd.jportal2;

import bbd.jportal2.Const;
import bbd.jportal2.Database;
import bbd.jportal2.Enum;
import bbd.jportal2.Field;
import bbd.jportal2.Grant;
import bbd.jportal2.ISQLProcToken;
import bbd.jportal2.JPortalConstants;
import bbd.jportal2.JPortalTemplateOutputOptions;
import bbd.jportal2.JPortalTokenManager;
import bbd.jportal2.Key;
import bbd.jportal2.Line;
import bbd.jportal2.Link;
import bbd.jportal2.Misc;
import bbd.jportal2.Parameter;
import bbd.jportal2.ParseException;
import bbd.jportal2.Proc;
import bbd.jportal2.SQLProcDynamicSQLVariableToken;
import bbd.jportal2.SQLProcStringToken;
import bbd.jportal2.SimpleCharStream;
import bbd.jportal2.Table;
import bbd.jportal2.Token;
import bbd.jportal2.Value;
import bbd.jportal2.View;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JPortal
implements JPortalConstants {
    private static final Logger logger = LoggerFactory.getLogger(JPortal.class);
    protected static Database database;
    protected static Table table;
    protected static Enum entry;
    protected static Field field;
    protected static Const constant;
    protected static Value value;
    protected static Grant grant;
    protected static Key key;
    protected static Link link;
    protected static View view;
    protected static Proc proc;
    protected static Parameter parameter;
    protected static String perm;
    protected static String user;
    protected static String line;
    protected static String inDir;
    private static boolean parser_initialised;
    private static boolean fieldsNullByDefault;
    private static boolean isLiteral;
    private static String literal;
    private static boolean jj_initialized_once;
    public static JPortalTokenManager token_source;
    static SimpleCharStream jj_input_stream;
    public static Token token;
    public static Token jj_nt;
    private static int jj_ntk;
    private static Token jj_scanpos;
    private static Token jj_lastpos;
    private static int jj_la;
    private static int jj_gen;
    private static final int[] jj_la1;
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private static int[] jj_la1_2;
    private static int[] jj_la1_3;
    private static int[] jj_la1_4;
    private static final JJCalls[] jj_2_rtns;
    private static boolean jj_rescan;
    private static int jj_gc;
    private static final LookaheadSuccess jj_ls;
    private static List<int[]> jj_expentries;
    private static int[] jj_expentry;
    private static int jj_kind;
    private static int[] jj_lasttokens;
    private static int jj_endpos;
    private static boolean trace_enabled;

    public static void main(String[] args) {
        try {
            for (int i = 0; i < args.length; ++i) {
                System.out.println(args[i] + ": Parsing ...");
                JPortal.setFieldsNullState(false);
                JPortal.run(args[i]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Database run(String inFile) {
        return JPortal.run(inFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Database run(String inFile, String inNub, JPortalTemplateOutputOptions options) {
        Database database;
        FileReader reader = new FileReader(inFile);
        try {
            database = JPortal.run(inFile, inNub, reader, options);
        }
        catch (Throwable throwable) {
            try {
                reader.close();
                throw throwable;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        reader.close();
        return database;
    }

    private static void setupNub(String inNub) {
        inDir = inNub;
    }

    public static void clearDatabase() {
        database = null;
    }

    public static Database run(String inFile, Reader reader, JPortalTemplateOutputOptions options) {
        return JPortal.run(inFile, "", reader, options);
    }

    public static Database run(String inFile, String inNub, Reader reader, JPortalTemplateOutputOptions options) {
        JPortal.setupNub(inNub);
        try {
            if (!parser_initialised) {
                new JPortal(reader);
                parser_initialised = true;
            } else {
                JPortal.ReInit(reader);
            }
            table = null;
            entry = null;
            field = null;
            constant = null;
            value = null;
            grant = null;
            key = null;
            link = null;
            view = null;
            proc = null;
            parameter = null;
            perm = null;
            user = null;
            line = null;
            isLiteral = false;
            literal = "";
            if (database == null) {
                database = new Database();
            }
            JPortal.database.templateOutputOptions = options;
            JPortal.jInput();
            return database;
        }
        catch (ParseException e) {
            logger.error("ParseException", e);
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static void setFieldsNullState(boolean state) {
        fieldsNullByDefault = state;
    }

    public static Database loadBinFile(String inFile) {
        return database;
    }

    static String fixString(String s2) {
        return s2.substring(1, s2.length() - 1);
    }

    static String parseConsts(String s2) {
        StringBuffer buffer = new StringBuffer();
        int cB = s2.indexOf("%");
        while (cB != -1) {
            block9: {
                String lookup;
                int cE;
                block10: {
                    block8: {
                        if (cB > 0) {
                            buffer.append(s2.substring(0, cB));
                            s2 = s2.substring(cB + 1);
                        }
                        if ((cE = s2.indexOf("%")) == -1) {
                            buffer.append('%');
                            break;
                        }
                        if (cE != 0) break block8;
                        buffer.append('%');
                        s2 = s2.substring(1);
                        break block9;
                    }
                    lookup = s2.substring(0, cE);
                    int cP = lookup.indexOf(".");
                    if (cP <= 0) break block10;
                    String fieldName = lookup.substring(0, cP);
                    String enumName = lookup.substring(cP + 1);
                    Field field = table.getField(fieldName);
                    if (field == null) break block10;
                    boolean done = false;
                    for (int i = 0; i < field.enums.size(); ++i) {
                        Enum entry = field.enums.elementAt(i);
                        if (!entry.name.equalsIgnoreCase(enumName)) continue;
                        String evalue = "" + entry.value;
                        if (field.type == 21 && field.length == 1) {
                            evalue = "'" + (char)entry.value + "'";
                        }
                        buffer.append(evalue);
                        s2 = s2.substring(cE + 1);
                        done = true;
                        break;
                    }
                    if (done) break block9;
                }
                buffer.append('%');
                buffer.append(lookup);
                buffer.append('%');
                s2 = s2.substring(cE + 1);
            }
            cB = s2.indexOf("%");
        }
        buffer.append(s2);
        return buffer.toString();
    }

    static String parseDynamics(String s2) {
        s2 = JPortal.parseConsts(s2);
        int dB = s2.indexOf("&");
        while (dB != -1) {
            int dE;
            Line line;
            if (dB > 0) {
                line = new Line(JPortal.database.templateOutputOptions, new SQLProcStringToken(s2.substring(0, dB)), new SQLProcStringToken(" "));
                JPortal.proc.lines.addElement(line);
                s2 = s2.substring(dB);
            }
            boolean strung = false;
            int addB = 0;
            boolean addE = false;
            char c = '\u0000';
            for (dE = 1; dE < s2.length(); ++dE) {
                c = s2.charAt(dE);
                if (dE == 1 && c == '\'') {
                    strung = true;
                    addB = 1;
                    continue;
                }
                String valid = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789_()";
                if (valid.indexOf(c) == -1) break;
            }
            if (strung && c == '\'') {
                addE = true;
                ++dE;
            }
            String dVar = s2.substring(1 + addB, dE - addB);
            s2 = s2.substring(dE);
            int sB = dVar.indexOf("(");
            int sE = dVar.indexOf(")");
            Integer size = new Integer(256);
            if (sB > 0) {
                if (sE > sB) {
                    String dSize = dVar.substring(sB + 1, sE);
                    size = new Integer(dSize);
                }
                dVar = dVar.substring(0, sB);
            } else if (sE > 0) {
                s2 = dVar.substring(sE) + s2;
                dVar = dVar.substring(0, sE);
            }
            line = new Line(JPortal.database.templateOutputOptions, (ISQLProcToken)new SQLProcDynamicSQLVariableToken(dVar), true);
            JPortal.proc.lines.addElement(line);
            if (!proc.hasDynamic(dVar)) {
                if (JPortal.proc.extendsStd) {
                    JPortal.proc.useStd = false;
                }
                JPortal.proc.dynamics.addElement(dVar);
                JPortal.proc.dynamicSizes.addElement(size);
                JPortal.proc.dynamicStrung.addElement(new Boolean(strung));
            }
            dB = s2.indexOf("&");
        }
        return s2;
    }

    static void loadTableModule(String s2, Vector<String> useProcs) {
        try {
            String importFile = inDir + s2 + ".nub";
            String workDir = inDir;
            int sep = workDir.indexOf(59);
            boolean found = false;
            while (sep > 0) {
                importFile = workDir.substring(0, sep) + s2 + ".nub";
                if (new File(importFile).exists()) {
                    found = true;
                    break;
                }
                if (sep >= workDir.length()) break;
                workDir = workDir.substring(sep + 1);
                sep = workDir.indexOf(59);
            }
            if (!found) {
                found = new File(importFile).exists();
            }
            if (found) {
                logger.info("Inputting " + importFile);
                DataInputStream ids = new DataInputStream(new FileInputStream(importFile));
                table = new Table();
                table.reader(ids, useProcs);
                ids.close();
                JPortal.table.database = database;
            } else {
                logger.warn("Import of " + s2 + ".nub failed");
            }
        }
        catch (Exception e) {
            logger.warn("Table nub " + s2 + ".nub failed to read (" + e.getMessage() + ")");
            e.printStackTrace();
        }
    }

    static String replaceAllLiteral(String haystack) {
        String s2 = "\\[]'\" ";
        for (int i = 0; i < s2.length(); ++i) {
            String c = "" + s2.charAt(i);
            haystack = JPortal.replaceAll(haystack, c, "");
        }
        return haystack;
    }

    static String replaceAll(String haystack, String needle, String replacement) {
        int i = haystack.lastIndexOf(needle);
        if (i != -1) {
            StringBuffer buffer = new StringBuffer(haystack);
            buffer.replace(i, i + needle.length(), replacement);
            while ((i = haystack.lastIndexOf(needle, i - 1)) != -1) {
                buffer.replace(i, i + needle.length(), replacement);
            }
            haystack = buffer.toString();
        }
        return haystack;
    }

    static void saveTableModule() {
        try {
            String outDir = inDir;
            int sep = inDir.indexOf(59);
            if (sep > 0) {
                outDir = inDir.substring(0, sep);
            }
            if (outDir.length() > 0) {
                logger.info("Outputting " + outDir + JPortal.table.name + ".nub");
                DataOutputStream ods = new DataOutputStream(new FileOutputStream(outDir + JPortal.table.name + ".nub"));
                JPortal.table.database = null;
                table.writer(ods);
                ods.close();
                JPortal.table.database = database;
            }
        }
        catch (Exception e) {
            logger.error("Table nub " + inDir + JPortal.table.name + ".nub failed to write", e);
        }
    }

    public static final void jInput() throws ParseException {
        block29: {
            String s2;
            JPortal.jj_consume_token(27);
            JPortal.database.name = s2 = JPortal.jIdent();
            JPortal.database.userid = "";
            JPortal.database.password = "";
            block22: while (true) {
                switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                    case 41: {
                        break;
                    }
                    default: {
                        JPortal.jj_la1[0] = jj_gen;
                        break block22;
                    }
                }
                JPortal.jj_consume_token(41);
                block23: while (true) {
                    s2 = JPortal.jString();
                    JPortal.database.flags.addElement(s2);
                    switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                        case 131: {
                            continue block23;
                        }
                    }
                    break;
                }
                JPortal.jj_la1[1] = jj_gen;
            }
            switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                case 65: {
                    JPortal.jj_consume_token(65);
                    JPortal.database.packageName = s2 = JPortal.jPackageIdent();
                    break;
                }
                default: {
                    JPortal.jj_la1[2] = jj_gen;
                }
            }
            block24: while (true) {
                switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                    case 46: 
                    case 64: {
                        break;
                    }
                    default: {
                        JPortal.jj_la1[3] = jj_gen;
                        break block29;
                    }
                }
                switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                    case 64: {
                        JPortal.jj_consume_token(64);
                        JPortal.database.output = s2 = JPortal.jIdentOrString();
                        continue block24;
                    }
                    case 46: {
                        JPortal.jj_consume_token(46);
                        s2 = JPortal.jIdentOrString();
                        JPortal.database.imports.addElement(s2);
                        continue block24;
                    }
                }
                break;
            }
            JPortal.jj_la1[4] = jj_gen;
            JPortal.jj_consume_token(-1);
            throw new ParseException();
        }
        JPortal.jConnect();
        block25: while (true) {
            JPortal.jTables();
            if (database.hasTable(JPortal.table.name)) {
                logger.warn(JPortal.table.name + " is already present");
            } else {
                JPortal.database.tables.addElement(table);
            }
            switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                case 46: 
                case 87: {
                    continue block25;
                }
            }
            break;
        }
        JPortal.jj_la1[5] = jj_gen;
        block26: while (true) {
            switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                case 101: {
                    break;
                }
                default: {
                    JPortal.jj_la1[6] = jj_gen;
                    break block26;
                }
            }
            JPortal.jView();
            JPortal.database.views.addElement(view);
        }
        JPortal.jj_consume_token(0);
    }

    public static final void jConnect() throws ParseException {
        String s2;
        JPortal.jj_consume_token(80);
        JPortal.database.server = s2 = JPortal.jIdentOrString();
        switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
            case 71: {
                JPortal.jj_consume_token(71);
                JPortal.database.schema = s2 = JPortal.jIdentOrString();
                break;
            }
            default: {
                JPortal.jj_la1[7] = jj_gen;
            }
        }
        switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
            case 98: {
                JPortal.jj_consume_token(98);
                JPortal.database.userid = s2 = JPortal.jIdent();
                JPortal.jj_consume_token(66);
                JPortal.database.password = s2 = JPortal.jIdent();
                break;
            }
            default: {
                JPortal.jj_la1[8] = jj_gen;
            }
        }
    }

    public static final String jPackageIdent() throws ParseException {
        String s2 = JPortal.jIdent();
        block3: while (true) {
            switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                case 149: {
                    break;
                }
                default: {
                    JPortal.jj_la1[9] = jj_gen;
                    break block3;
                }
            }
            JPortal.jj_consume_token(149);
            String n = JPortal.jIdent();
            s2 = s2 + "." + n;
        }
        return s2;
    }

    public static final String jIdentOrString() throws ParseException {
        switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
            case 134: 
            case 135: {
                String s2 = JPortal.jIdent();
                return s2;
            }
            case 131: {
                Token t = JPortal.jj_consume_token(131);
                String s3 = t.image;
                return JPortal.fixString(s3);
            }
        }
        JPortal.jj_la1[10] = jj_gen;
        JPortal.jj_consume_token(-1);
        throw new ParseException();
    }

    public static final String jIdent() throws ParseException {
        switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
            case 134: {
                Token t = JPortal.jj_consume_token(134);
                isLiteral = false;
                literal = "";
                return t.image;
            }
            case 135: {
                Token t = JPortal.jj_consume_token(135);
                String s2 = t.image;
                isLiteral = true;
                literal = s2.substring(2, s2.length() - 1);
                return JPortal.replaceAllLiteral(s2.substring(2, s2.length() - 1));
            }
        }
        JPortal.jj_la1[11] = jj_gen;
        JPortal.jj_consume_token(-1);
        throw new ParseException();
    }

    public static final void jTables() throws ParseException {
        boolean save = false;
        switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
            case 87: {
                JPortal.jTable();
                while (JPortal.jj_2_1(2)) {
                    JPortal.jExtras();
                }
                save = true;
                break;
            }
            case 46: {
                JPortal.jTableImport();
                save = false;
                break;
            }
            default: {
                JPortal.jj_la1[12] = jj_gen;
                JPortal.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        block11: while (true) {
            switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                case 68: 
                case 85: 
                case 115: 
                case 145: 
                case 148: {
                    break;
                }
                default: {
                    JPortal.jj_la1[13] = jj_gen;
                    break block11;
                }
            }
            JPortal.jProc();
        }
        block12: while (true) {
            switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                case 105: {
                    break;
                }
                default: {
                    JPortal.jj_la1[14] = jj_gen;
                    break block12;
                }
            }
            JPortal.jj_consume_token(105);
            parameter = new Parameter();
            JPortal.table.parameters.addElement(parameter);
            JPortal.jParm();
        }
        if (save) {
            JPortal.saveTableModule();
        }
    }

    public static final void jTableImport() throws ParseException {
        Vector<String> v = new Vector<String>();
        JPortal.jj_consume_token(46);
        String s2 = JPortal.jIdentOrString();
        switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
            case 124: {
                JPortal.jj_consume_token(124);
                block9: while (true) {
                    String p = JPortal.jIdent();
                    v.addElement(p);
                    switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                        case 134: 
                        case 135: {
                            continue block9;
                        }
                    }
                    break;
                }
                JPortal.jj_la1[15] = jj_gen;
                JPortal.jj_consume_token(127);
                break;
            }
            default: {
                JPortal.jj_la1[16] = jj_gen;
            }
        }
        JPortal.loadTableModule(s2, v);
        JPortal.table.database = database;
        switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
            case 125: {
                JPortal.table.alias = s2 = JPortal.jAlias();
                break;
            }
            default: {
                JPortal.jj_la1[17] = jj_gen;
            }
        }
    }

    public static final void jTable() throws ParseException {
        Token t = JPortal.jj_consume_token(87);
        String s2 = JPortal.jIdent();
        table = new Table();
        JPortal.table.database = database;
        JPortal.table.name = s2;
        JPortal.table.isLiteral = isLiteral;
        JPortal.table.literalName = literal;
        JPortal.table.start = t.beginLine;
        switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
            case 125: {
                JPortal.table.alias = s2 = JPortal.jAlias();
                break;
            }
            default: {
                JPortal.jj_la1[18] = jj_gen;
            }
        }
        switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
            case 23: {
                JPortal.jj_consume_token(23);
                t = JPortal.jj_consume_token(131);
                s2 = t.image;
                JPortal.table.check = JPortal.fixString(s2);
                break;
            }
            default: {
                JPortal.jj_la1[19] = jj_gen;
            }
        }
        block18: while (true) {
            switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                case 118: {
                    break;
                }
                default: {
                    JPortal.jj_la1[20] = jj_gen;
                    break block18;
                }
            }
            s2 = JPortal.jComment();
            JPortal.table.comments.addElement(s2);
        }
        block19: while (true) {
            switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                case 62: {
                    break;
                }
                default: {
                    JPortal.jj_la1[21] = jj_gen;
                    break block19;
                }
            }
            JPortal.jj_consume_token(62);
            block20: while (true) {
                s2 = JPortal.jString();
                JPortal.table.options.addElement(s2);
                switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                    case 131: {
                        continue block20;
                    }
                }
                break;
            }
            JPortal.jj_la1[22] = jj_gen;
        }
        block21: while (true) {
            switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                case 134: 
                case 135: {
                    break;
                }
                default: {
                    JPortal.jj_la1[23] = jj_gen;
                    break block21;
                }
            }
            JPortal.jField();
            if (table.hasField(JPortal.field.name)) {
                logger.warn(JPortal.field.name + " is already present");
                continue;
            }
            JPortal.table.fields.addElement(field);
        }
    }

    public static final void jPackageField() throws ParseException {
        String s2;
        block20: {
            s2 = JPortal.jPackageIdent();
            field = new Field();
            JPortal.field.name = s2;
            JPortal.field.isLiteral = isLiteral;
            JPortal.field.literalName = literal;
            JPortal.field.isNull = fieldsNullByDefault;
            boolean state = true;
            switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                case 125: {
                    JPortal.field.alias = s2 = JPortal.jAlias();
                    break;
                }
                default: {
                    JPortal.jj_la1[24] = jj_gen;
                }
            }
            JPortal.jDatatype();
            block18: while (true) {
                switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                    case 20: 
                    case 23: 
                    case 31: 
                    case 60: 
                    case 61: {
                        break;
                    }
                    default: {
                        JPortal.jj_la1[25] = jj_gen;
                        break block20;
                    }
                }
                switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                    case 31: {
                        JPortal.jj_consume_token(31);
                        Token t = JPortal.jj_consume_token(131);
                        s2 = t.image;
                        JPortal.field.defaultValue = JPortal.fixString(s2);
                        continue block18;
                    }
                    case 60: 
                    case 61: {
                        switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                            case 60: {
                                JPortal.jj_consume_token(60);
                                state = false;
                                break;
                            }
                            default: {
                                JPortal.jj_la1[26] = jj_gen;
                            }
                        }
                        JPortal.jj_consume_token(61);
                        JPortal.field.isNull = state;
                        continue block18;
                    }
                    case 20: {
                        JPortal.jj_consume_token(20);
                        JPortal.field.isCalc = state;
                        continue block18;
                    }
                    case 23: {
                        JPortal.jj_consume_token(23);
                        Token t = JPortal.jj_consume_token(131);
                        s2 = t.image;
                        JPortal.field.checkValue = JPortal.fixString(s2);
                        continue block18;
                    }
                }
                break;
            }
            JPortal.jj_la1[27] = jj_gen;
            JPortal.jj_consume_token(-1);
            throw new ParseException();
        }
        block19: while (true) {
            switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                case 118: {
                    break;
                }
                default: {
                    JPortal.jj_la1[28] = jj_gen;
                    break block19;
                }
            }
            s2 = JPortal.jComment();
            JPortal.field.comments.addElement(s2);
        }
    }

    public static final void jField() throws ParseException {
        String s2;
        block20: {
            s2 = JPortal.jIdent();
            field = new Field();
            JPortal.field.name = s2;
            JPortal.field.isLiteral = isLiteral;
            JPortal.field.literalName = literal;
            JPortal.field.isNull = fieldsNullByDefault;
            boolean state = true;
            switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                case 125: {
                    JPortal.field.alias = s2 = JPortal.jAlias();
                    break;
                }
                default: {
                    JPortal.jj_la1[29] = jj_gen;
                }
            }
            JPortal.jDatatype();
            block18: while (true) {
                switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                    case 20: 
                    case 23: 
                    case 31: 
                    case 60: 
                    case 61: {
                        break;
                    }
                    default: {
                        JPortal.jj_la1[30] = jj_gen;
                        break block20;
                    }
                }
                switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                    case 31: {
                        JPortal.jj_consume_token(31);
                        Token t = JPortal.jj_consume_token(131);
                        s2 = t.image;
                        JPortal.field.defaultValue = JPortal.fixString(s2);
                        continue block18;
                    }
                    case 60: 
                    case 61: {
                        switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                            case 60: {
                                JPortal.jj_consume_token(60);
                                state = false;
                                break;
                            }
                            default: {
                                JPortal.jj_la1[31] = jj_gen;
                            }
                        }
                        JPortal.jj_consume_token(61);
                        JPortal.field.isNull = state;
                        continue block18;
                    }
                    case 20: {
                        JPortal.jj_consume_token(20);
                        JPortal.field.isCalc = state;
                        continue block18;
                    }
                    case 23: {
                        JPortal.jj_consume_token(23);
                        Token t = JPortal.jj_consume_token(131);
                        s2 = t.image;
                        JPortal.field.checkValue = JPortal.fixString(s2);
                        continue block18;
                    }
                }
                break;
            }
            JPortal.jj_la1[32] = jj_gen;
            JPortal.jj_consume_token(-1);
            throw new ParseException();
        }
        block19: while (true) {
            switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                case 118: {
                    break;
                }
                default: {
                    JPortal.jj_la1[33] = jj_gen;
                    break block19;
                }
            }
            s2 = JPortal.jComment();
            JPortal.field.comments.addElement(s2);
        }
    }

    public static final String jAlias() throws ParseException {
        JPortal.jj_consume_token(125);
        String alias = JPortal.jIdent();
        JPortal.jj_consume_token(128);
        return alias;
    }

    public static final void jDatatype() throws ParseException {
        block0 : switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
            case 15: {
                JPortal.jj_consume_token(15);
                JPortal.field.type = 1;
                JPortal.field.length = 0;
                switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                    case 124: 
                    case 125: 
                    case 130: {
                        JPortal.jCharsize();
                        break block0;
                    }
                }
                JPortal.jj_la1[34] = jj_gen;
                break;
            }
            case 16: {
                JPortal.jj_consume_token(16);
                JPortal.field.type = (byte)2;
                JPortal.field.length = 1;
                break;
            }
            case 19: {
                JPortal.jj_consume_token(19);
                JPortal.field.type = (byte)3;
                JPortal.field.length = 1;
                switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                    case 123: 
                    case 125: {
                        switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                            case 125: {
                                JPortal.jEnumValue();
                                break block0;
                            }
                            case 123: {
                                JPortal.jCharList();
                                break block0;
                            }
                        }
                        JPortal.jj_la1[35] = jj_gen;
                        JPortal.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                JPortal.jj_la1[36] = jj_gen;
                break;
            }
            case 22: {
                JPortal.jj_consume_token(22);
                JPortal.field.type = (byte)4;
                JPortal.field.length = 1;
                switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                    case 124: 
                    case 125: 
                    case 130: {
                        JPortal.jCharsize();
                        break;
                    }
                    default: {
                        JPortal.jj_la1[37] = jj_gen;
                    }
                }
                switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                    case 123: {
                        JPortal.jCharList();
                        break block0;
                    }
                }
                JPortal.jj_la1[38] = jj_gen;
                break;
            }
            case 8: {
                JPortal.jj_consume_token(8);
                JPortal.field.type = (byte)21;
                JPortal.field.length = 1;
                switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                    case 124: 
                    case 125: 
                    case 130: {
                        JPortal.jEnumChar();
                        break block0;
                    }
                }
                JPortal.jj_la1[39] = jj_gen;
                break;
            }
            case 103: {
                JPortal.jj_consume_token(103);
                JPortal.field.type = (byte)27;
                JPortal.field.length = 1;
                switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                    case 124: 
                    case 125: 
                    case 130: {
                        JPortal.jCharsize();
                        break;
                    }
                    default: {
                        JPortal.jj_la1[40] = jj_gen;
                    }
                }
                switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                    case 123: {
                        JPortal.jCharList();
                        break block0;
                    }
                }
                JPortal.jj_la1[41] = jj_gen;
                break;
            }
            case 102: {
                JPortal.jj_consume_token(102);
                JPortal.field.type = (byte)28;
                JPortal.field.length = 1;
                switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                    case 124: 
                    case 125: 
                    case 130: {
                        JPortal.jEnumChar();
                        break block0;
                    }
                }
                JPortal.jj_la1[42] = jj_gen;
                break;
            }
            case 100: {
                JPortal.jj_consume_token(100);
                JPortal.field.type = (byte)29;
                JPortal.field.length = 1;
                switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                    case 124: 
                    case 125: 
                    case 130: {
                        JPortal.jCharsize();
                        break;
                    }
                    default: {
                        JPortal.jj_la1[43] = jj_gen;
                    }
                }
                switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                    case 123: {
                        JPortal.jCharList();
                        break block0;
                    }
                }
                JPortal.jj_la1[44] = jj_gen;
                break;
            }
            case 82: {
                JPortal.jj_consume_token(82);
                JPortal.field.type = (byte)15;
                JPortal.field.length = 2;
                switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                    case 123: 
                    case 125: {
                        switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                            case 125: {
                                JPortal.jEnumValue();
                                break block0;
                            }
                            case 123: {
                                JPortal.jCharList();
                                break block0;
                            }
                        }
                        JPortal.jj_la1[45] = jj_gen;
                        JPortal.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                JPortal.jj_la1[46] = jj_gen;
                break;
            }
            case 51: {
                JPortal.jj_consume_token(51);
                JPortal.field.type = (byte)11;
                JPortal.field.length = 4;
                switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                    case 123: 
                    case 125: {
                        switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                            case 125: {
                                JPortal.jEnumValue();
                                break block0;
                            }
                            case 123: {
                                JPortal.jCharList();
                                break block0;
                            }
                        }
                        JPortal.jj_la1[47] = jj_gen;
                        JPortal.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                JPortal.jj_la1[48] = jj_gen;
                break;
            }
            case 55: {
                JPortal.jj_consume_token(55);
                JPortal.field.type = (byte)12;
                JPortal.field.length = 8;
                break;
            }
            case 92: {
                JPortal.jj_consume_token(92);
                JPortal.field.type = (byte)22;
                JPortal.field.length = 16;
                break;
            }
            case 28: {
                JPortal.jj_consume_token(28);
                JPortal.field.type = (byte)5;
                JPortal.field.length = 8;
                break;
            }
            case 29: {
                JPortal.jj_consume_token(29);
                JPortal.field.type = (byte)6;
                JPortal.field.length = 14;
                break;
            }
            case 88: {
                JPortal.jj_consume_token(88);
                JPortal.field.type = (byte)17;
                JPortal.field.length = 6;
                break;
            }
            case 89: {
                JPortal.jj_consume_token(89);
                JPortal.field.type = (byte)18;
                JPortal.table.hasTimeStamp = true;
                JPortal.field.length = 14;
                break;
            }
            case 10: {
                JPortal.jj_consume_token(10);
                JPortal.field.type = (byte)26;
                JPortal.table.hasAutoTimeStamp = true;
                JPortal.field.length = 14;
                break;
            }
            case 90: {
                JPortal.jj_consume_token(90);
                JPortal.field.type = (byte)19;
                JPortal.field.length = 0;
                switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                    case 124: 
                    case 125: 
                    case 130: {
                        JPortal.jCharsize();
                        break block0;
                    }
                }
                JPortal.jj_la1[49] = jj_gen;
                break;
            }
            case 104: {
                JPortal.jj_consume_token(104);
                JPortal.field.type = (byte)23;
                JPortal.field.length = 4096;
                switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                    case 124: 
                    case 125: 
                    case 130: {
                        JPortal.jCharsize();
                        break block0;
                    }
                }
                JPortal.jj_la1[50] = jj_gen;
                break;
            }
            case 14: {
                JPortal.jj_consume_token(14);
                JPortal.field.type = (byte)30;
                JPortal.field.length = 0x400000;
                switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                    case 124: 
                    case 125: 
                    case 130: {
                        JPortal.jCharsize();
                        break block0;
                    }
                }
                JPortal.jj_la1[51] = jj_gen;
                break;
            }
            case 52: {
                JPortal.jj_consume_token(52);
                JPortal.field.type = (byte)31;
                JPortal.field.length = 4096;
                switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                    case 124: 
                    case 125: 
                    case 130: {
                        JPortal.jCharsize();
                        break block0;
                    }
                }
                JPortal.jj_la1[52] = jj_gen;
                break;
            }
            case 12: {
                JPortal.jj_consume_token(12);
                JPortal.field.type = (byte)32;
                JPortal.field.length = 0x400000;
                switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                    case 124: 
                    case 125: 
                    case 130: {
                        JPortal.jCharsize();
                        break block0;
                    }
                }
                JPortal.jj_la1[53] = jj_gen;
                break;
            }
            case 99: {
                JPortal.jj_consume_token(99);
                JPortal.field.type = (byte)20;
                JPortal.table.hasUserStamp = true;
                JPortal.field.length = 50;
                break;
            }
            case 79: {
                JPortal.jj_consume_token(79);
                JPortal.field.type = (byte)14;
                JPortal.field.isSequence = true;
                JPortal.table.hasSequence = true;
                JPortal.field.length = 4;
                break;
            }
            case 13: {
                JPortal.jj_consume_token(13);
                JPortal.field.type = (byte)24;
                JPortal.field.isSequence = true;
                JPortal.table.hasSequence = true;
                JPortal.field.length = 8;
                break;
            }
            case 45: {
                JPortal.jj_consume_token(45);
                JPortal.field.type = (byte)10;
                JPortal.field.isSequence = true;
                JPortal.table.hasSequence = true;
                JPortal.field.length = 4;
                break;
            }
            case 11: {
                JPortal.jj_consume_token(11);
                JPortal.field.type = (byte)25;
                JPortal.field.isSequence = true;
                JPortal.table.hasSequence = true;
                JPortal.field.length = 8;
                break;
            }
            case 37: 
            case 42: {
                switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                    case 37: {
                        JPortal.jj_consume_token(37);
                        break;
                    }
                    case 42: {
                        JPortal.jj_consume_token(42);
                        break;
                    }
                    default: {
                        JPortal.jj_la1[54] = jj_gen;
                        JPortal.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                JPortal.field.type = (byte)7;
                JPortal.field.length = 8;
                switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                    case 124: 
                    case 125: {
                        JPortal.jFloatsize();
                        break block0;
                    }
                }
                JPortal.jj_la1[55] = jj_gen;
                break;
            }
            case 57: {
                JPortal.jj_consume_token(57);
                JPortal.field.type = (byte)13;
                JPortal.field.length = 8;
                break;
            }
            case 122: {
                JPortal.jLookup();
                break;
            }
            default: {
                JPortal.jj_la1[56] = jj_gen;
                JPortal.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public static final void jLookup() throws ParseException {
        String name = JPortal.field.name;
        JPortal.jj_consume_token(122);
        switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
            case 125: {
                JPortal.jj_consume_token(125);
                name = JPortal.jIdent();
                JPortal.jj_consume_token(128);
                break;
            }
            default: {
                JPortal.jj_la1[57] = jj_gen;
            }
        }
        Field other = proc.getInput(name);
        if (other == null) {
            other = proc.getOutput(name);
        }
        if (other == null) {
            other = table.getField(name);
        }
        if (other == null) {
            logger.warn(JPortal.field.name + " is not present for type usage. Resorting to int.");
            JPortal.field.type = (byte)11;
            JPortal.field.length = 4;
        } else {
            JPortal.field.type = other.type;
            JPortal.field.length = other.length;
            JPortal.field.precision = other.precision;
            JPortal.field.scale = other.scale;
            JPortal.field.enums = other.enums;
            if (other.enums != null && !other.enums.isEmpty()) {
                JPortal.field.enumType = other.useUpperName();
            }
        }
    }

    public static final void jEnumValue() throws ParseException {
        String s2;
        JPortal.jj_consume_token(125);
        switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
            case 54: {
                JPortal.jj_consume_token(54);
                JPortal.field.enumLink = s2 = JPortal.jIdent();
                break;
            }
            default: {
                JPortal.jj_la1[58] = jj_gen;
            }
        }
        block9: while (true) {
            s2 = JPortal.jIdent();
            JPortal.jj_consume_token(122);
            int n = JPortal.jNumber();
            switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                case 121: {
                    JPortal.jj_consume_token(121);
                    break;
                }
                default: {
                    JPortal.jj_la1[59] = jj_gen;
                }
            }
            entry = new Enum();
            JPortal.entry.name = s2;
            JPortal.entry.value = n;
            JPortal.field.enums.addElement(entry);
            switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                case 134: 
                case 135: {
                    continue block9;
                }
            }
            break;
        }
        JPortal.jj_la1[60] = jj_gen;
        JPortal.jj_consume_token(128);
    }

    public static final void jFloatsize() throws ParseException {
        switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
            case 124: {
                int n;
                JPortal.jj_consume_token(124);
                JPortal.field.precision = n = JPortal.jNumber();
                JPortal.jj_consume_token(121);
                JPortal.field.scale = n = JPortal.jNumber();
                JPortal.jj_consume_token(127);
                break;
            }
            case 125: {
                int n;
                JPortal.jj_consume_token(125);
                JPortal.field.precision = n = JPortal.jNumber();
                JPortal.jj_consume_token(121);
                JPortal.field.scale = n = JPortal.jNumber();
                JPortal.jj_consume_token(128);
                break;
            }
            default: {
                JPortal.jj_la1[61] = jj_gen;
                JPortal.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public static final void jEnumChar() throws ParseException {
        switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
            case 124: {
                int n;
                JPortal.jj_consume_token(124);
                JPortal.field.length = n = JPortal.jNumber();
                JPortal.jj_consume_token(127);
                break;
            }
            case 125: {
                JPortal.jj_consume_token(125);
                switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                    case 130: {
                        int n;
                        JPortal.field.length = n = JPortal.jNumber();
                        break;
                    }
                    case 54: 
                    case 134: 
                    case 135: {
                        String s2;
                        switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                            case 54: {
                                JPortal.jj_consume_token(54);
                                JPortal.field.enumLink = s2 = JPortal.jIdent();
                                break;
                            }
                            default: {
                                JPortal.jj_la1[62] = jj_gen;
                            }
                        }
                        block18: while (true) {
                            s2 = JPortal.jIdent();
                            JPortal.jj_consume_token(122);
                            int n = JPortal.jAsciiChar();
                            switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                                case 121: {
                                    JPortal.jj_consume_token(121);
                                    break;
                                }
                                default: {
                                    JPortal.jj_la1[63] = jj_gen;
                                }
                            }
                            entry = new Enum();
                            JPortal.entry.name = s2;
                            JPortal.entry.value = n;
                            JPortal.field.enums.addElement(entry);
                            switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                                case 134: 
                                case 135: {
                                    continue block18;
                                }
                            }
                            break;
                        }
                        JPortal.jj_la1[64] = jj_gen;
                        break;
                    }
                    default: {
                        JPortal.jj_la1[65] = jj_gen;
                        JPortal.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                JPortal.jj_consume_token(128);
                break;
            }
            case 130: {
                int n;
                JPortal.field.length = n = JPortal.jNumber();
                break;
            }
            default: {
                JPortal.jj_la1[66] = jj_gen;
                JPortal.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public static final void jCharsize() throws ParseException {
        switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
            case 124: {
                int n;
                JPortal.jj_consume_token(124);
                JPortal.field.length = n = JPortal.jNumber();
                JPortal.jj_consume_token(127);
                break;
            }
            case 125: {
                int n;
                JPortal.jj_consume_token(125);
                JPortal.field.length = n = JPortal.jNumber();
                JPortal.jj_consume_token(128);
                break;
            }
            case 130: {
                int n;
                JPortal.field.length = n = JPortal.jNumber();
                break;
            }
            default: {
                JPortal.jj_la1[67] = jj_gen;
                JPortal.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public static final void jCharList() throws ParseException {
        JPortal.jj_consume_token(123);
        block6: while (true) {
            String s2 = JPortal.jIdent();
            switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                case 121: {
                    JPortal.jj_consume_token(121);
                    break;
                }
                default: {
                    JPortal.jj_la1[68] = jj_gen;
                }
            }
            JPortal.field.valueList.addElement(s2);
            switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                case 134: 
                case 135: {
                    continue block6;
                }
            }
            break;
        }
        JPortal.jj_la1[69] = jj_gen;
        JPortal.jj_consume_token(126);
    }

    public static final int jNumber() throws ParseException {
        Token t = JPortal.jj_consume_token(130);
        String s2 = t.image;
        Integer i = new Integer(s2);
        return i;
    }

    public static final void jParm() throws ParseException {
        block59: {
            String s2;
            switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                case 131: {
                    JPortal.parameter.title = s2 = JPortal.jString();
                    break;
                }
                default: {
                    JPortal.jj_la1[70] = jj_gen;
                }
            }
            block45: while (true) {
                switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                    case 106: 
                    case 107: 
                    case 108: 
                    case 109: 
                    case 110: 
                    case 111: 
                    case 112: 
                    case 113: {
                        break;
                    }
                    default: {
                        JPortal.jj_la1[71] = jj_gen;
                        break block59;
                    }
                }
                switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                    case 106: {
                        JPortal.jj_consume_token(106);
                        block46: while (true) {
                            if (table.hasField(s2 = JPortal.jIdent())) {
                                JPortal.parameter.shows.addElement(table.getField(s2));
                            } else {
                                logger.warn(s2 + " is not present in table for show.");
                            }
                            switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                                case 134: 
                                case 135: {
                                    continue block46;
                                }
                            }
                            break;
                        }
                        JPortal.jj_la1[72] = jj_gen;
                        continue block45;
                    }
                    case 107: {
                        JPortal.jj_consume_token(107);
                        JPortal.parameter.isViewOnly = true;
                        continue block45;
                    }
                    case 113: {
                        JPortal.jj_consume_token(113);
                        block47: while (true) {
                            if (table.hasField(s2 = JPortal.jIdent())) {
                                JPortal.parameter.supplied.addElement(table.getField(s2));
                            } else {
                                logger.warn(s2 + " is not present in table for supplied.");
                            }
                            switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                                case 134: 
                                case 135: {
                                    continue block47;
                                }
                            }
                            break;
                        }
                        JPortal.jj_la1[73] = jj_gen;
                        continue block45;
                    }
                    case 108: {
                        JPortal.jj_consume_token(108);
                        switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                            case 134: 
                            case 135: {
                                s2 = JPortal.jIdent();
                                break;
                            }
                            case 73: {
                                JPortal.jj_consume_token(73);
                                s2 = "SelectAll";
                                break;
                            }
                            default: {
                                JPortal.jj_la1[74] = jj_gen;
                                JPortal.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        Proc p = table.getProc(s2);
                        if (p != null) {
                            JPortal.parameter.cache = p;
                        } else {
                            logger.warn(s2 + " is not present in table as a cache reader.");
                        }
                        while (true) {
                            switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                                case 134: 
                                case 135: {
                                    break;
                                }
                                default: {
                                    JPortal.jj_la1[75] = jj_gen;
                                    continue block45;
                                }
                            }
                            s2 = JPortal.jIdent();
                            JPortal.parameter.cacheExtras.addElement(s2);
                        }
                    }
                    case 109: {
                        JPortal.jj_consume_token(109);
                        switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                            case 134: 
                            case 135: {
                                s2 = JPortal.jIdent();
                                break;
                            }
                            case 73: {
                                JPortal.jj_consume_token(73);
                                s2 = "SelectAll";
                                break;
                            }
                            default: {
                                JPortal.jj_la1[76] = jj_gen;
                                JPortal.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        Proc p = table.getProc(s2);
                        if (p != null) {
                            JPortal.parameter.reader = p;
                            continue block45;
                        }
                        logger.warn(s2 + " is not present in table as a reader.");
                        continue block45;
                    }
                    case 110: {
                        JPortal.jj_consume_token(110);
                        switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                            case 134: 
                            case 135: {
                                s2 = JPortal.jIdent();
                                break;
                            }
                            case 50: {
                                JPortal.jj_consume_token(50);
                                s2 = "Insert";
                                break;
                            }
                            default: {
                                JPortal.jj_la1[77] = jj_gen;
                                JPortal.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        Proc p = table.getProc(s2);
                        if (p != null) {
                            JPortal.parameter.insert = p;
                            continue block45;
                        }
                        logger.warn(s2 + " is not present in table as an inserter.");
                        continue block45;
                    }
                    case 112: {
                        JPortal.jj_consume_token(112);
                        switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                            case 134: 
                            case 135: {
                                s2 = JPortal.jIdent();
                                break;
                            }
                            case 94: {
                                JPortal.jj_consume_token(94);
                                s2 = "Update";
                                break;
                            }
                            default: {
                                JPortal.jj_la1[78] = jj_gen;
                                JPortal.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        Proc p = table.getProc(s2);
                        if (p != null) {
                            JPortal.parameter.update = p;
                            continue block45;
                        }
                        logger.warn(s2 + " is not present in table as an updater.");
                        continue block45;
                    }
                    case 111: {
                        JPortal.jj_consume_token(111);
                        switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                            case 134: 
                            case 135: {
                                s2 = JPortal.jIdent();
                                break;
                            }
                            case 35: {
                                JPortal.jj_consume_token(35);
                                s2 = "DeleteOne";
                                break;
                            }
                            default: {
                                JPortal.jj_la1[79] = jj_gen;
                                JPortal.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        Proc p = table.getProc(s2);
                        if (p != null) {
                            JPortal.parameter.delete = p;
                            continue block45;
                        }
                        logger.warn(s2 + " is not present in table as a deleter.");
                        continue block45;
                    }
                }
                break;
            }
            JPortal.jj_la1[80] = jj_gen;
            JPortal.jj_consume_token(-1);
            throw new ParseException();
        }
    }

    public static final void jExtras() throws ParseException {
        switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
            case 44: {
                JPortal.jGrant();
                JPortal.table.grants.addElement(grant);
                break;
            }
            case 53: {
                JPortal.jKey();
                JPortal.table.keys.addElement(key);
                break;
            }
            case 54: {
                JPortal.jLink();
                JPortal.table.links.addElement(link);
                break;
            }
            case 101: {
                JPortal.jView();
                JPortal.table.views.addElement(view);
                break;
            }
            case 25: {
                JPortal.jConst();
                JPortal.table.consts.addElement(constant);
                break;
            }
            default: {
                JPortal.jj_la1[81] = jj_gen;
                JPortal.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public static final void jConst() throws ParseException {
        JPortal.jj_consume_token(25);
        String s2 = JPortal.jIdent();
        constant = new Const();
        JPortal.constant.name = s2;
        block6: while (true) {
            s2 = JPortal.jIdent();
            JPortal.jj_consume_token(122);
            String v = JPortal.jString();
            switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                case 121: {
                    JPortal.jj_consume_token(121);
                    break;
                }
                default: {
                    JPortal.jj_la1[82] = jj_gen;
                }
            }
            value = new Value();
            JPortal.value.key = s2;
            JPortal.value.value = v;
            JPortal.constant.values.addElement(value);
            switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                case 134: 
                case 135: {
                    continue block6;
                }
            }
            break;
        }
        JPortal.jj_la1[83] = jj_gen;
    }

    public static final void jGrant() throws ParseException {
        JPortal.jj_consume_token(44);
        grant = new Grant();
        block6: while (true) {
            JPortal.jPermission();
            if (grant.hasPerm(perm)) {
                logger.warn("perm " + perm + " already present in grant");
            } else {
                JPortal.grant.perms.addElement(perm);
            }
            switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                case 7: 
                case 32: 
                case 39: 
                case 50: 
                case 72: 
                case 94: {
                    continue block6;
                }
            }
            break;
        }
        JPortal.jj_la1[84] = jj_gen;
        JPortal.jj_consume_token(91);
        block7: while (true) {
            JPortal.jUser();
            if (grant.hasUser(user)) {
                logger.warn("user " + user + " already present in grant");
            } else {
                JPortal.grant.users.addElement(user);
            }
            switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                case 134: 
                case 135: {
                    continue block7;
                }
            }
            break;
        }
        JPortal.jj_la1[85] = jj_gen;
    }

    public static final void jPermission() throws ParseException {
        switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
            case 7: {
                JPortal.jj_consume_token(7);
                JPortal.table.hasExecute = true;
                JPortal.table.hasSelect = true;
                JPortal.table.hasDelete = true;
                JPortal.table.hasInsert = true;
                JPortal.table.hasUpdate = true;
                perm = "all";
                break;
            }
            case 32: {
                JPortal.jj_consume_token(32);
                JPortal.table.hasDelete = true;
                perm = "delete";
                break;
            }
            case 50: {
                JPortal.jj_consume_token(50);
                JPortal.table.hasInsert = true;
                perm = "insert";
                break;
            }
            case 72: {
                JPortal.jj_consume_token(72);
                JPortal.table.hasSelect = true;
                perm = "select";
                break;
            }
            case 94: {
                JPortal.jj_consume_token(94);
                JPortal.table.hasUpdate = true;
                perm = "update";
                break;
            }
            case 39: {
                JPortal.jj_consume_token(39);
                JPortal.table.hasExecute = true;
                break;
            }
            default: {
                JPortal.jj_la1[86] = jj_gen;
                JPortal.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public static final void jUser() throws ParseException {
        user = JPortal.jIdent();
    }

    public static final void jKey() throws ParseException {
        JPortal.jj_consume_token(53);
        String s2 = JPortal.jIdent();
        key = new Key();
        JPortal.key.name = s2;
        block12: while (true) {
            switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                case 62: {
                    break;
                }
                default: {
                    JPortal.jj_la1[87] = jj_gen;
                    break block12;
                }
            }
            JPortal.jj_consume_token(62);
            block13: while (true) {
                s2 = JPortal.jString();
                JPortal.key.options.addElement(s2);
                switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                    case 131: {
                        continue block13;
                    }
                }
                break;
            }
            JPortal.jj_la1[88] = jj_gen;
        }
        block14: while (true) {
            switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                case 67: 
                case 93: {
                    break;
                }
                default: {
                    JPortal.jj_la1[89] = jj_gen;
                    break block14;
                }
            }
            JPortal.jModifier();
        }
        block15: while (true) {
            JPortal.jColumn();
            switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                case 134: 
                case 135: {
                    continue block15;
                }
            }
            break;
        }
        JPortal.jj_la1[90] = jj_gen;
    }

    public static final void jModifier() throws ParseException {
        switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
            case 93: {
                JPortal.jj_consume_token(93);
                JPortal.key.isUnique = true;
                break;
            }
            case 67: {
                JPortal.jj_consume_token(67);
                JPortal.key.isPrimary = true;
                JPortal.table.hasPrimaryKey = true;
                break;
            }
            default: {
                JPortal.jj_la1[91] = jj_gen;
                JPortal.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public static final void jColumn() throws ParseException {
        String s2 = JPortal.jIdent();
        if (!table.hasField(s2)) {
            logger.warn(JPortal.key.name + " field " + s2 + " not present in table");
        } else if (key.hasField(s2)) {
            logger.warn(JPortal.key.name + " field " + s2 + " already present in key");
        } else {
            if (JPortal.key.isPrimary) {
                table.setPrimary(s2);
            }
            JPortal.key.fields.addElement(s2);
        }
    }

    public static final void jLink() throws ParseException {
        Proc dproc = new Proc();
        JPortal.jj_consume_token(54);
        String s2 = JPortal.jPackageIdent();
        link = new Link();
        JPortal.link.name = s2;
        switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
            case 125: {
                JPortal.jj_consume_token(125);
                block27: while (true) {
                    s2 = JPortal.jIdent();
                    JPortal.link.linkFields.addElement(s2);
                    switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                        case 134: 
                        case 135: {
                            continue block27;
                        }
                    }
                    break;
                }
                JPortal.jj_la1[92] = jj_gen;
                JPortal.jj_consume_token(128);
                break;
            }
            default: {
                JPortal.jj_la1[93] = jj_gen;
            }
        }
        switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
            case 32: {
                JPortal.jj_consume_token(32);
                switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                    case 21: {
                        JPortal.jj_consume_token(21);
                        break;
                    }
                    default: {
                        JPortal.jj_la1[94] = jj_gen;
                    }
                }
                JPortal.link.isDeleteCascade = true;
                break;
            }
            default: {
                JPortal.jj_la1[95] = jj_gen;
            }
        }
        switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
            case 94: {
                JPortal.jj_consume_token(94);
                switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                    case 21: {
                        JPortal.jj_consume_token(21);
                        break;
                    }
                    default: {
                        JPortal.jj_la1[96] = jj_gen;
                    }
                }
                JPortal.link.isUpdateCascade = true;
                break;
            }
            default: {
                JPortal.jj_la1[97] = jj_gen;
            }
        }
        block28: while (true) {
            switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                case 62: {
                    break;
                }
                default: {
                    JPortal.jj_la1[98] = jj_gen;
                    break block28;
                }
            }
            JPortal.jj_consume_token(62);
            block29: while (true) {
                s2 = JPortal.jString();
                JPortal.link.options.addElement(s2);
                switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                    case 131: {
                        continue block29;
                    }
                }
                break;
            }
            JPortal.jj_la1[99] = jj_gen;
        }
        block30: while (true) {
            JPortal.jLinkColumn();
            switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                case 134: 
                case 135: {
                    continue block30;
                }
            }
            break;
        }
        JPortal.jj_la1[100] = jj_gen;
    }

    public static final void jLinkColumn() throws ParseException {
        String s2 = JPortal.jIdent();
        if (!table.hasField(s2)) {
            logger.warn(JPortal.link.name + " field " + s2 + " not present in table");
        } else if (link.hasField(s2)) {
            logger.warn(JPortal.link.name + " field " + s2 + " already present in link");
        } else {
            JPortal.link.fields.addElement(s2);
        }
    }

    public static final void jView() throws ParseException {
        Token t = JPortal.jj_consume_token(101);
        String s2 = JPortal.jIdent();
        view = new View();
        JPortal.view.name = s2;
        JPortal.view.start = t.beginLine;
        switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
            case 91: {
                JPortal.jj_consume_token(91);
                block15: while (true) {
                    JPortal.jUser();
                    if (view.hasUser(user)) {
                        logger.warn(JPortal.view.name + " user " + user + " already present in view");
                    } else {
                        JPortal.view.users.addElement(user);
                    }
                    switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                        case 134: 
                        case 135: {
                            continue block15;
                        }
                    }
                    break;
                }
                JPortal.jj_la1[101] = jj_gen;
                break;
            }
            default: {
                JPortal.jj_la1[102] = jj_gen;
            }
        }
        switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
            case 64: {
                JPortal.jj_consume_token(64);
                block16: while (true) {
                    JPortal.jViewAlias();
                    switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                        case 134: 
                        case 135: {
                            continue block16;
                        }
                    }
                    break;
                }
                JPortal.jj_la1[103] = jj_gen;
                break;
            }
            default: {
                JPortal.jj_la1[104] = jj_gen;
            }
        }
        switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
            case 114: {
                JPortal.jOldViewCode();
                break;
            }
            default: {
                JPortal.jj_la1[105] = jj_gen;
                JPortal.jNewViewCode();
            }
        }
    }

    public static final void jNewViewCode() throws ParseException {
        block3: while (true) {
            switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                case 142: {
                    break;
                }
                default: {
                    JPortal.jj_la1[106] = jj_gen;
                    break block3;
                }
            }
            Token t = JPortal.jj_consume_token(142);
            line = t.image.trim();
            JPortal.view.lines.addElement(line);
        }
    }

    public static final void jOldViewCode() throws ParseException {
        JPortal.jj_consume_token(114);
        block3: while (true) {
            switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                case 131: {
                    break;
                }
                default: {
                    JPortal.jj_la1[107] = jj_gen;
                    break block3;
                }
            }
            JPortal.jLine();
            JPortal.view.lines.addElement(line);
        }
        JPortal.jj_consume_token(116);
    }

    public static final void jViewAlias() throws ParseException {
        String s2 = JPortal.jIdent();
        if (view.hasAlias(s2)) {
            logger.warn(JPortal.key.name + " alias " + s2 + " already present in view");
        } else {
            JPortal.view.aliases.addElement(s2);
        }
    }

    public static final void jLine() throws ParseException {
        Token t = JPortal.jj_consume_token(131);
        String s2 = t.image;
        line = JPortal.fixString(s2);
    }

    public static final String jString() throws ParseException {
        Token t = JPortal.jj_consume_token(131);
        String s2 = t.image;
        return JPortal.fixString(s2);
    }

    public static final int jAsciiChar() throws ParseException {
        String s2 = JPortal.jString();
        return s2.charAt(0);
    }

    public static final void jProc() throws ParseException {
        switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
            case 68: 
            case 85: {
                switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                    case 68: {
                        Token t = JPortal.jj_consume_token(68);
                        proc = new Proc();
                        JPortal.proc.table = table;
                        JPortal.proc.start = t.beginLine;
                        JPortal.proc.isProc = true;
                        break;
                    }
                    case 85: {
                        Token t = JPortal.jj_consume_token(85);
                        proc = new Proc();
                        JPortal.proc.table = table;
                        JPortal.proc.start = t.beginLine;
                        JPortal.proc.isSProc = true;
                        break;
                    }
                    default: {
                        JPortal.jj_la1[108] = jj_gen;
                        JPortal.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                block8 : switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                    case 17: 
                    case 18: 
                    case 24: 
                    case 33: 
                    case 34: 
                    case 35: 
                    case 40: 
                    case 50: 
                    case 56: 
                    case 73: 
                    case 74: 
                    case 77: 
                    case 78: 
                    case 94: 
                    case 95: 
                    case 96: 
                    case 97: {
                        JPortal.jStdProc();
                        break;
                    }
                    case 134: 
                    case 135: {
                        if (JPortal.jj_2_2(3)) {
                            JPortal.jNewProc();
                            break;
                        }
                        switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                            case 134: 
                            case 135: {
                                JPortal.jUserProc();
                                break block8;
                            }
                        }
                        JPortal.jj_la1[109] = jj_gen;
                        JPortal.jj_consume_token(-1);
                        throw new ParseException();
                    }
                    default: {
                        JPortal.jj_la1[110] = jj_gen;
                        JPortal.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                if (table.hasProc(proc)) {
                    logger.warn("proc " + JPortal.proc.name + " already present in table");
                    break;
                }
                JPortal.table.procs.addElement(proc);
                proc.checkPlaceHolders();
                break;
            }
            case 115: 
            case 145: 
            case 148: {
                switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                    case 115: {
                        JPortal.jOldData();
                        break;
                    }
                    case 145: {
                        JPortal.jNewData();
                        break;
                    }
                    case 148: {
                        JPortal.jIdlCode();
                        break;
                    }
                    default: {
                        JPortal.jj_la1[111] = jj_gen;
                        JPortal.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                JPortal.table.procs.addElement(proc);
                break;
            }
            default: {
                JPortal.jj_la1[112] = jj_gen;
                JPortal.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public static final void jStdProc() throws ParseException {
        String s2;
        boolean forUpdate = false;
        boolean forReadOnly = false;
        boolean inOrder = false;
        boolean descending = false;
        boolean isStdProc = false;
        switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
            case 50: {
                JPortal.jj_consume_token(50);
                switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                    case 70: {
                        JPortal.jj_consume_token(70);
                        JPortal.proc.hasReturning = true;
                        break;
                    }
                    default: {
                        JPortal.jj_la1[113] = jj_gen;
                    }
                }
                JPortal.table.hasSequenceReturning = JPortal.table.hasSequence;
                JPortal.proc.name = "Insert";
                JPortal.proc.isBuiltIn = true;
                table.buildInsert(proc);
                JPortal.table.hasStdProcs = true;
                if (!JPortal.table.hasIdentity) break;
                JPortal.table.procs.addElement(proc);
                proc = new Proc();
                JPortal.proc.table = table;
                JPortal.proc.name = "Identity";
                table.buildIdentity(proc);
                break;
            }
            case 94: {
                JPortal.jj_consume_token(94);
                if (!JPortal.table.hasPrimaryKey) {
                    logger.warn("proc Update requires a primary key");
                    break;
                }
                JPortal.proc.name = "Update";
                JPortal.proc.isBuiltIn = true;
                JPortal.proc.isUpdate = true;
                table.buildUpdate(proc);
                JPortal.table.hasStdProcs = true;
                break;
            }
            case 95: {
                JPortal.jj_consume_token(95);
                block152: while (true) {
                    JPortal.jProcColumn();
                    switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                        case 134: 
                        case 135: {
                            continue block152;
                        }
                    }
                    break;
                }
                JPortal.jj_la1[114] = jj_gen;
                JPortal.proc.isUpdate = true;
                table.buildUpdateFor(proc);
                JPortal.table.hasStdProcs = true;
                break;
            }
            case 96: {
                JPortal.jj_consume_token(96);
                block153: while (true) {
                    JPortal.jProcUpdateByColumn();
                    switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                        case 134: 
                        case 135: {
                            continue block153;
                        }
                    }
                    break;
                }
                JPortal.jj_la1[115] = jj_gen;
                switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                    case 81: {
                        JPortal.jj_consume_token(81);
                        block154: while (true) {
                            JPortal.jProcColumn();
                            switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                                case 134: 
                                case 135: {
                                    continue block154;
                                }
                            }
                            break;
                        }
                        JPortal.jj_la1[116] = jj_gen;
                        break;
                    }
                    default: {
                        JPortal.jj_la1[117] = jj_gen;
                    }
                }
                switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                    case 9: {
                        JPortal.jj_consume_token(9);
                        JPortal.proc.name = s2 = JPortal.jIdent();
                        JPortal.proc.isBuiltIn = true;
                        break;
                    }
                    default: {
                        JPortal.jj_la1[118] = jj_gen;
                    }
                }
                if (JPortal.proc.name == null || JPortal.proc.name.trim().isEmpty()) {
                    JPortal.proc.name = "UpdateBy";
                    for (String fname : JPortal.proc.fields) {
                        JPortal.proc.name = JPortal.proc.name + fname;
                    }
                }
                JPortal.proc.isUpdate = true;
                table.buildUpdateBy(proc);
                JPortal.table.hasStdProcs = true;
                break;
            }
            case 17: {
                JPortal.jj_consume_token(17);
                switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                    case 125: {
                        JPortal.jRowCount();
                        break;
                    }
                    default: {
                        JPortal.jj_la1[119] = jj_gen;
                    }
                }
                JPortal.table.hasSequenceReturning = JPortal.table.hasSequence;
                JPortal.proc.name = "BulkInsert";
                JPortal.proc.isBuiltIn = true;
                table.buildBulkInsert(proc);
                JPortal.table.hasStdProcs = true;
                if (!JPortal.table.hasIdentity) break;
                JPortal.table.procs.addElement(proc);
                proc = new Proc();
                JPortal.proc.table = table;
                JPortal.proc.name = "Identity";
                table.buildIdentity(proc);
                break;
            }
            case 97: {
                JPortal.jj_consume_token(97);
                JPortal.proc.name = "MaxTmStamp";
                table.buildMaxTmStamp(proc);
                JPortal.table.hasStdProcs = true;
                break;
            }
            case 18: {
                JPortal.jj_consume_token(18);
                switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                    case 125: {
                        JPortal.jRowCount();
                        break;
                    }
                    default: {
                        JPortal.jj_la1[120] = jj_gen;
                    }
                }
                if (!JPortal.table.hasPrimaryKey) {
                    logger.warn("proc Update requires a primary key");
                    break;
                }
                JPortal.proc.name = "BulkUpdate";
                JPortal.proc.isBuiltIn = true;
                JPortal.proc.isUpdate = true;
                table.buildBulkUpdate(proc);
                JPortal.table.hasStdProcs = true;
                break;
            }
            case 35: {
                JPortal.jj_consume_token(35);
                switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                    case 125: {
                        JPortal.jj_consume_token(125);
                        JPortal.jj_consume_token(86);
                        JPortal.jj_consume_token(128);
                        JPortal.proc.isStd = true;
                        break;
                    }
                    default: {
                        JPortal.jj_la1[121] = jj_gen;
                    }
                }
                JPortal.table.hasStdProcs = true;
                if (!JPortal.table.hasPrimaryKey) {
                    logger.warn("proc DeleteOne requires a primary key");
                    break;
                }
                JPortal.proc.name = "DeleteOne";
                JPortal.proc.isBuiltIn = true;
                table.buildDeleteOne(proc);
                JPortal.table.hasStdProcs = true;
                break;
            }
            case 34: {
                JPortal.jj_consume_token(34);
                JPortal.proc.name = "DeleteAll";
                JPortal.proc.isBuiltIn = true;
                table.buildDeleteAll(proc);
                JPortal.table.hasStdProcs = true;
                break;
            }
            case 33: {
                JPortal.jj_consume_token(33);
                block156: while (true) {
                    JPortal.jProcColumn();
                    switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                        case 134: 
                        case 135: {
                            continue block156;
                        }
                    }
                    break;
                }
                JPortal.jj_la1[122] = jj_gen;
                JPortal.proc.name = "DeleteBy";
                for (String fname : JPortal.proc.fields) {
                    JPortal.proc.name = JPortal.proc.name + fname;
                }
                JPortal.proc.isBuiltIn = true;
                table.buildDeleteBy(proc);
                JPortal.table.hasStdProcs = true;
                break;
            }
            case 78: {
                JPortal.jj_consume_token(78);
                block49 : switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                    case 43: 
                    case 69: 
                    case 94: {
                        switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                            case 43: {
                                JPortal.jj_consume_token(43);
                                break;
                            }
                            default: {
                                JPortal.jj_la1[123] = jj_gen;
                            }
                        }
                        switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                            case 94: {
                                JPortal.jj_consume_token(94);
                                forUpdate = true;
                                break block49;
                            }
                            case 69: {
                                JPortal.jj_consume_token(69);
                                forReadOnly = true;
                                break block49;
                            }
                        }
                        JPortal.jj_la1[124] = jj_gen;
                        JPortal.jj_consume_token(-1);
                        throw new ParseException();
                    }
                    default: {
                        JPortal.jj_la1[125] = jj_gen;
                    }
                }
                if (!JPortal.table.hasPrimaryKey) {
                    logger.warn("proc SelectOne requires a primary key");
                    break;
                }
                JPortal.proc.name = "SelectOne";
                JPortal.proc.isBuiltIn = true;
                if (forUpdate) {
                    JPortal.proc.name = JPortal.proc.name + "Upd";
                } else if (forReadOnly) {
                    JPortal.proc.name = JPortal.proc.name + "ReadOnly";
                }
                table.buildSelectOne(proc, forUpdate, forReadOnly);
                JPortal.table.hasStdProcs = true;
                break;
            }
            case 77: {
                JPortal.jj_consume_token(77);
                block158: while (true) {
                    JPortal.jProcColumn();
                    switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                        case 134: 
                        case 135: {
                            continue block158;
                        }
                    }
                    break;
                }
                JPortal.jj_la1[126] = jj_gen;
                switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                    case 47: 
                    case 63: {
                        switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                            case 47: {
                                JPortal.jj_consume_token(47);
                                break;
                            }
                            default: {
                                JPortal.jj_la1[127] = jj_gen;
                            }
                        }
                        JPortal.jj_consume_token(63);
                        inOrder = true;
                        break;
                    }
                    default: {
                        JPortal.jj_la1[128] = jj_gen;
                    }
                }
                block68 : switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                    case 43: 
                    case 69: 
                    case 94: {
                        switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                            case 43: {
                                JPortal.jj_consume_token(43);
                                break;
                            }
                            default: {
                                JPortal.jj_la1[129] = jj_gen;
                            }
                        }
                        switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                            case 94: {
                                JPortal.jj_consume_token(94);
                                forUpdate = true;
                                break block68;
                            }
                            case 69: {
                                JPortal.jj_consume_token(69);
                                forReadOnly = true;
                                break block68;
                            }
                        }
                        JPortal.jj_la1[130] = jj_gen;
                        JPortal.jj_consume_token(-1);
                        throw new ParseException();
                    }
                    default: {
                        JPortal.jj_la1[131] = jj_gen;
                    }
                }
                switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                    case 9: {
                        JPortal.jj_consume_token(9);
                        JPortal.proc.name = s2 = JPortal.jIdent();
                        break;
                    }
                    default: {
                        JPortal.jj_la1[132] = jj_gen;
                    }
                }
                if (JPortal.proc.name == null || JPortal.proc.name.trim().isEmpty()) {
                    JPortal.proc.name = "SelectOneBy";
                    for (String fname : JPortal.proc.fields) {
                        JPortal.proc.name = JPortal.proc.name + fname;
                    }
                }
                JPortal.proc.isBuiltIn = true;
                JPortal.proc.isSingle = true;
                table.buildSelectBy(proc, forUpdate, forReadOnly, inOrder, descending);
                JPortal.table.hasStdProcs = true;
                break;
            }
            case 74: {
                JPortal.jj_consume_token(74);
                block160: while (true) {
                    JPortal.jProcColumn();
                    switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                        case 134: 
                        case 135: {
                            continue block160;
                        }
                    }
                    break;
                }
                JPortal.jj_la1[133] = jj_gen;
                block84 : switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                    case 47: 
                    case 63: {
                        switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                            case 47: {
                                JPortal.jj_consume_token(47);
                                break;
                            }
                            default: {
                                JPortal.jj_la1[134] = jj_gen;
                            }
                        }
                        JPortal.jj_consume_token(63);
                        inOrder = true;
                        block161: while (true) {
                            switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                                case 134: 
                                case 135: {
                                    break;
                                }
                                default: {
                                    JPortal.jj_la1[135] = jj_gen;
                                    break block161;
                                }
                            }
                            JPortal.jOrderColumn();
                        }
                        switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                            case 36: {
                                JPortal.jj_consume_token(36);
                                descending = true;
                                break block84;
                            }
                        }
                        JPortal.jj_la1[136] = jj_gen;
                        break;
                    }
                    default: {
                        JPortal.jj_la1[137] = jj_gen;
                    }
                }
                block96 : switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                    case 43: 
                    case 69: 
                    case 94: {
                        switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                            case 43: {
                                JPortal.jj_consume_token(43);
                                break;
                            }
                            default: {
                                JPortal.jj_la1[138] = jj_gen;
                            }
                        }
                        switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                            case 94: {
                                JPortal.jj_consume_token(94);
                                forUpdate = true;
                                break block96;
                            }
                            case 69: {
                                JPortal.jj_consume_token(69);
                                forReadOnly = true;
                                break block96;
                            }
                        }
                        JPortal.jj_la1[139] = jj_gen;
                        JPortal.jj_consume_token(-1);
                        throw new ParseException();
                    }
                    default: {
                        JPortal.jj_la1[140] = jj_gen;
                    }
                }
                switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                    case 9: {
                        JPortal.jj_consume_token(9);
                        JPortal.proc.name = s2 = JPortal.jIdent();
                        JPortal.proc.isBuiltIn = true;
                        break;
                    }
                    default: {
                        JPortal.jj_la1[141] = jj_gen;
                    }
                }
                block109 : switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                    case 70: {
                        JPortal.jj_consume_token(70);
                        block162: while (true) {
                            JPortal.jProcReturningColumn();
                            switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                                case 134: 
                                case 135: {
                                    continue block162;
                                }
                            }
                            break;
                        }
                        JPortal.jj_la1[142] = jj_gen;
                        break;
                    }
                    default: {
                        JPortal.jj_la1[146] = jj_gen;
                        switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                            case 64: {
                                JPortal.jj_consume_token(64);
                                switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                                    case 125: {
                                        JPortal.jOutputType();
                                        break;
                                    }
                                    default: {
                                        JPortal.jj_la1[143] = jj_gen;
                                    }
                                }
                                while (true) {
                                    switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                                        case 134: 
                                        case 135: {
                                            break;
                                        }
                                        default: {
                                            JPortal.jj_la1[144] = jj_gen;
                                            break block109;
                                        }
                                    }
                                    JPortal.jField();
                                    if (JPortal.proc.isSProc) {
                                        if (proc.hasInput(JPortal.field.name)) {
                                            field = proc.getInput(JPortal.field.name);
                                        } else {
                                            JPortal.proc.inputs.addElement(field);
                                        }
                                        JPortal.field.isOut = true;
                                        continue;
                                    }
                                    if (proc.hasOutput(JPortal.field.name)) {
                                        if (JPortal.proc.extendsStd) continue;
                                        logger.warn(JPortal.proc.name + " field " + JPortal.field.name + " already present as output");
                                        continue;
                                    }
                                    if (JPortal.proc.extendsStd) {
                                        JPortal.proc.useStd = false;
                                        isStdProc = false;
                                    }
                                    if (!JPortal.field.isNull) {
                                        JPortal.field.isNull = table.hasFieldAsNull(JPortal.field.name);
                                    }
                                    JPortal.proc.outputs.addElement(field);
                                }
                            }
                        }
                        JPortal.jj_la1[145] = jj_gen;
                    }
                }
                if (JPortal.proc.name == null || JPortal.proc.name.trim().isEmpty()) {
                    JPortal.proc.name = "SelectBy";
                    for (String fname : JPortal.proc.fields) {
                        JPortal.proc.name = JPortal.proc.name + fname;
                    }
                }
                table.buildSelectBy(proc, forUpdate, forReadOnly, inOrder, descending);
                JPortal.table.hasStdProcs = true;
                break;
            }
            case 73: {
                JPortal.jj_consume_token(73);
                block124 : switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                    case 47: 
                    case 63: {
                        switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                            case 47: {
                                JPortal.jj_consume_token(47);
                                break;
                            }
                            default: {
                                JPortal.jj_la1[147] = jj_gen;
                            }
                        }
                        JPortal.jj_consume_token(63);
                        inOrder = true;
                        block165: while (true) {
                            switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                                case 134: 
                                case 135: {
                                    break;
                                }
                                default: {
                                    JPortal.jj_la1[148] = jj_gen;
                                    break block165;
                                }
                            }
                            JPortal.jOrderColumn();
                        }
                        switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                            case 36: {
                                JPortal.jj_consume_token(36);
                                descending = true;
                                break block124;
                            }
                        }
                        JPortal.jj_la1[149] = jj_gen;
                        break;
                    }
                    default: {
                        JPortal.jj_la1[150] = jj_gen;
                    }
                }
                block136 : switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                    case 43: 
                    case 69: 
                    case 94: {
                        switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                            case 43: {
                                JPortal.jj_consume_token(43);
                                break;
                            }
                            default: {
                                JPortal.jj_la1[151] = jj_gen;
                            }
                        }
                        switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                            case 94: {
                                JPortal.jj_consume_token(94);
                                forUpdate = true;
                                break block136;
                            }
                            case 69: {
                                JPortal.jj_consume_token(69);
                                forReadOnly = true;
                                break block136;
                            }
                        }
                        JPortal.jj_la1[152] = jj_gen;
                        JPortal.jj_consume_token(-1);
                        throw new ParseException();
                    }
                    default: {
                        JPortal.jj_la1[153] = jj_gen;
                    }
                }
                if (JPortal.table.hasBigXML) {
                    logger.warn("proc SelectAll is invalid with BigXML field");
                    break;
                }
                if (JPortal.table.hasBigJSON) {
                    logger.warn("proc SelectAll is invalid with BigJSON field");
                    break;
                }
                JPortal.proc.name = "SelectAll";
                JPortal.proc.isBuiltIn = true;
                if (inOrder) {
                    JPortal.proc.name = JPortal.proc.name + "Sorted";
                }
                if (forUpdate) {
                    JPortal.proc.name = JPortal.proc.name + "Upd";
                } else if (forReadOnly) {
                    JPortal.proc.name = JPortal.proc.name + "ReadOnly";
                }
                table.buildSelectAll(proc, forUpdate, forReadOnly, inOrder, descending);
                JPortal.table.hasStdProcs = true;
                break;
            }
            case 24: {
                JPortal.jj_consume_token(24);
                JPortal.proc.name = "Count";
                JPortal.proc.isBuiltIn = true;
                table.buildCount(proc);
                break;
            }
            case 40: {
                JPortal.jj_consume_token(40);
                if (!JPortal.table.hasPrimaryKey) {
                    logger.warn("proc Exists requires a primary key");
                    break;
                }
                JPortal.proc.name = "Exists";
                JPortal.proc.isBuiltIn = true;
                table.buildExists(proc);
                break;
            }
            case 56: {
                JPortal.jj_consume_token(56);
                if (!JPortal.table.hasPrimaryKey) {
                    logger.warn("proc Merge requires a primary key");
                    break;
                }
                if (JPortal.table.hasSequence) {
                    logger.warn("proc Merge cannot be used on a table with a sequence");
                    break;
                }
                JPortal.proc.name = "Merge";
                JPortal.proc.isBuiltIn = true;
                table.buildMerge(proc);
                break;
            }
            default: {
                JPortal.jj_la1[154] = jj_gen;
                JPortal.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        block166: while (true) {
            switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                case 62: {
                    break;
                }
                default: {
                    JPortal.jj_la1[155] = jj_gen;
                    break block166;
                }
            }
            JPortal.jj_consume_token(62);
            block167: while (true) {
                s2 = JPortal.jString();
                JPortal.proc.options.addElement(s2);
                switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                    case 131: {
                        continue block167;
                    }
                }
                break;
            }
            JPortal.jj_la1[156] = jj_gen;
        }
    }

    public static final void jNewProc() throws ParseException {
        String s2;
        boolean isStdProc = false;
        boolean forUpdate = false;
        boolean forReadOnly = false;
        boolean inOrder = false;
        boolean descending = false;
        JPortal.proc.name = s2 = JPortal.jIdent();
        JPortal.jj_consume_token(72);
        switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
            case 125: {
                JPortal.jj_consume_token(125);
                JPortal.jj_consume_token(86);
                JPortal.jj_consume_token(128);
                JPortal.proc.isStd = true;
                break;
            }
            default: {
                JPortal.jj_la1[157] = jj_gen;
            }
        }
        switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
            case 49: {
                JPortal.jj_consume_token(49);
                switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                    case 125: {
                        JPortal.jInputType();
                        break;
                    }
                    default: {
                        JPortal.jj_la1[158] = jj_gen;
                    }
                }
                JPortal.proc.extendsStd = true;
                JPortal.proc.useStd = true;
                isStdProc = true;
                block24: while (true) {
                    JPortal.jField();
                    if (proc.hasInput(JPortal.field.name)) {
                        logger.warn(JPortal.proc.name + " field " + JPortal.field.name + " already present as input");
                    } else {
                        if (JPortal.proc.extendsStd && !proc.hasOutput(JPortal.field.name)) {
                            JPortal.proc.useStd = false;
                            isStdProc = false;
                        }
                        if (!JPortal.field.isNull) {
                            JPortal.field.isNull = table.hasFieldAsNull(JPortal.field.name);
                        }
                        JPortal.field.isIn = true;
                        JPortal.proc.inputs.addElement(field);
                    }
                    switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                        case 134: 
                        case 135: {
                            continue block24;
                        }
                    }
                    break;
                }
                JPortal.jj_la1[159] = jj_gen;
                break;
            }
            default: {
                JPortal.jj_la1[160] = jj_gen;
            }
        }
        block12 : switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
            case 64: {
                JPortal.jj_consume_token(64);
                switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                    case 125: {
                        JPortal.jOutputType();
                        break;
                    }
                    default: {
                        JPortal.jj_la1[161] = jj_gen;
                    }
                }
                while (true) {
                    switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                        case 134: 
                        case 135: {
                            break;
                        }
                        default: {
                            JPortal.jj_la1[162] = jj_gen;
                            break block12;
                        }
                    }
                    JPortal.jPackageField();
                    if (JPortal.proc.isSProc) {
                        if (proc.hasInput(JPortal.field.name)) {
                            field = proc.getInput(JPortal.field.name);
                        } else {
                            JPortal.proc.inputs.addElement(field);
                        }
                        JPortal.field.isOut = true;
                        continue;
                    }
                    if (proc.hasOutput(JPortal.field.name)) {
                        if (JPortal.proc.extendsStd) continue;
                        logger.warn(JPortal.proc.name + " field " + JPortal.field.name + " already present as output");
                        continue;
                    }
                    if (JPortal.proc.extendsStd) {
                        JPortal.proc.useStd = false;
                        isStdProc = false;
                    }
                    if (!JPortal.field.isNull) {
                        JPortal.field.isNull = table.hasFieldAsNull(JPortal.field.name);
                    }
                    JPortal.proc.outputs.addElement(field);
                }
            }
            default: {
                JPortal.jj_la1[163] = jj_gen;
            }
        }
        switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
            case 84: 
            case 114: {
                JPortal.jOldCode();
                break;
            }
            default: {
                JPortal.jj_la1[164] = jj_gen;
                JPortal.jNewCode();
            }
        }
        JPortal.proc.useStd = true;
        isStdProc = true;
    }

    public static final void jProcColumn() throws ParseException {
        String s2 = JPortal.jIdent();
        if (!table.hasField(s2)) {
            logger.warn(JPortal.proc.name + " field " + s2 + " not present in table");
        } else if (proc.hasFields(s2)) {
            logger.warn(JPortal.proc.name + " field " + s2 + " already present");
        } else if (proc.hasUpdateFields(s2)) {
            logger.warn(JPortal.proc.name + " field " + s2 + " cannot be set as well, already present as input");
        } else {
            JPortal.proc.fields.addElement(s2);
        }
    }

    public static final void jProcReturningColumn() throws ParseException {
        String s2 = JPortal.jIdent();
        if (!table.hasField(s2)) {
            logger.warn(JPortal.proc.name + " field " + s2 + " not present in table");
        } else if (proc.hasOutput(s2)) {
            logger.warn(JPortal.proc.name + " output " + s2 + " already present");
        } else {
            JPortal.proc.outputs.addElement(table.getField(s2));
        }
    }

    public static final void jOrderColumn() throws ParseException {
        String s2 = JPortal.jIdent();
        if (!table.hasField(s2)) {
            logger.warn(JPortal.proc.name + " field " + s2 + " not present in table");
        } else if (proc.hasOrders(s2)) {
            logger.warn(JPortal.proc.name + " field " + s2 + " already present");
        } else {
            JPortal.proc.orderFields.addElement(table.getField(s2));
        }
    }

    public static final void jProcUpdateByColumn() throws ParseException {
        String s2 = JPortal.jIdent();
        if (!table.hasField(s2)) {
            logger.warn(JPortal.proc.name + " field " + s2 + " not present in table");
        } else if (proc.hasUpdateFields(s2)) {
            logger.warn(JPortal.proc.name + " field " + s2 + " already present");
        } else {
            JPortal.proc.updateFields.addElement(s2);
        }
    }

    public static final String jComment() throws ParseException {
        Token t = JPortal.jj_consume_token(118);
        String s2 = t.image;
        while (s2.indexOf(42) == 0) {
            s2 = s2.substring(1);
        }
        int n = s2.indexOf(13);
        if (n == -1 && (n = s2.indexOf(10)) == -1) {
            n = s2.length() - 1;
        }
        return s2.substring(0, n);
    }

    public static final void jRowCount() throws ParseException {
        JPortal.jj_consume_token(125);
        int n = JPortal.jNumber();
        JPortal.jj_consume_token(128);
        JPortal.proc.noRows = n;
    }

    public static final void jUserProc() throws ParseException {
        String s2;
        boolean isStdProc = false;
        JPortal.proc.name = s2 = JPortal.jIdent();
        JPortal.proc.isBuiltIn = false;
        Line l1 = new Line(JPortal.database.templateOutputOptions, Misc.generateProcNameComment(proc));
        JPortal.proc.lines.addElement(l1);
        switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
            case 125: {
                JPortal.jj_consume_token(125);
                JPortal.jj_consume_token(86);
                JPortal.jj_consume_token(128);
                JPortal.proc.extendsStd = true;
                JPortal.proc.useStd = true;
                isStdProc = true;
                for (int i = 0; i < JPortal.table.fields.size(); ++i) {
                    JPortal.proc.outputs.addElement(JPortal.table.fields.elementAt(i));
                }
                break;
            }
            default: {
                JPortal.jj_la1[165] = jj_gen;
            }
        }
        block43: while (true) {
            switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                case 118: {
                    break;
                }
                default: {
                    JPortal.jj_la1[166] = jj_gen;
                    break block43;
                }
            }
            s2 = JPortal.jComment();
            JPortal.proc.comments.addElement(s2);
        }
        block44: while (true) {
            switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                case 62: {
                    break;
                }
                default: {
                    JPortal.jj_la1[167] = jj_gen;
                    break block44;
                }
            }
            JPortal.jj_consume_token(62);
            block45: while (true) {
                s2 = JPortal.jString();
                JPortal.proc.options.addElement(s2);
                switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                    case 131: {
                        continue block45;
                    }
                }
                break;
            }
            JPortal.jj_la1[168] = jj_gen;
        }
        block12 : switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
            case 49: {
                JPortal.jj_consume_token(49);
                switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                    case 125: {
                        JPortal.jInputType();
                        break;
                    }
                    default: {
                        JPortal.jj_la1[169] = jj_gen;
                    }
                }
                while (true) {
                    switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                        case 134: 
                        case 135: {
                            break;
                        }
                        default: {
                            JPortal.jj_la1[170] = jj_gen;
                            break block12;
                        }
                    }
                    JPortal.jField();
                    if (proc.hasInput(JPortal.field.name)) {
                        logger.warn(JPortal.proc.name + " field " + JPortal.field.name + " already present as input");
                        continue;
                    }
                    if (JPortal.proc.extendsStd && !proc.hasOutput(JPortal.field.name)) {
                        JPortal.proc.useStd = false;
                        isStdProc = false;
                    }
                    if (!JPortal.field.isNull) {
                        JPortal.field.isNull = table.hasFieldAsNull(JPortal.field.name);
                    }
                    JPortal.field.isIn = true;
                    JPortal.proc.inputs.addElement(field);
                }
            }
            default: {
                JPortal.jj_la1[171] = jj_gen;
            }
        }
        block21 : switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
            case 48: {
                JPortal.jj_consume_token(48);
                switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                    case 125: {
                        JPortal.jOutputType();
                        break;
                    }
                    default: {
                        JPortal.jj_la1[172] = jj_gen;
                    }
                }
                while (true) {
                    switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                        case 134: 
                        case 135: {
                            break;
                        }
                        default: {
                            JPortal.jj_la1[173] = jj_gen;
                            break block21;
                        }
                    }
                    JPortal.jField();
                    if (proc.hasInput(JPortal.field.name)) {
                        logger.warn(JPortal.proc.name + " field " + JPortal.field.name + " already present as input");
                        continue;
                    }
                    if (proc.hasOutput(JPortal.field.name)) {
                        if (JPortal.proc.extendsStd) continue;
                        logger.warn(JPortal.proc.name + " field " + JPortal.field.name + " already present as output");
                        continue;
                    }
                    if (JPortal.proc.extendsStd) {
                        JPortal.proc.useStd = false;
                        isStdProc = false;
                        JPortal.proc.isProc = true;
                    }
                    if (!JPortal.field.isNull) {
                        JPortal.field.isNull = table.hasFieldAsNull(JPortal.field.name);
                    }
                    JPortal.field.isIn = true;
                    JPortal.field.isOut = true;
                    JPortal.proc.inputs.addElement(field);
                    if (JPortal.proc.isSProc) continue;
                    JPortal.proc.outputs.addElement(field);
                }
            }
            default: {
                JPortal.jj_la1[174] = jj_gen;
            }
        }
        block30 : switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
            case 64: {
                JPortal.jj_consume_token(64);
                switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                    case 125: {
                        JPortal.jOutputType();
                        break;
                    }
                    default: {
                        JPortal.jj_la1[175] = jj_gen;
                    }
                }
                while (true) {
                    switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                        case 134: 
                        case 135: {
                            break;
                        }
                        default: {
                            JPortal.jj_la1[176] = jj_gen;
                            break block30;
                        }
                    }
                    JPortal.jField();
                    if (JPortal.proc.isSProc) {
                        if (proc.hasInput(JPortal.field.name)) {
                            field = proc.getInput(JPortal.field.name);
                        } else {
                            JPortal.proc.inputs.addElement(field);
                        }
                        JPortal.field.isOut = true;
                        continue;
                    }
                    if (proc.hasOutput(JPortal.field.name)) {
                        if (JPortal.proc.extendsStd) continue;
                        logger.warn(JPortal.proc.name + " field " + JPortal.field.name + " already present as output");
                        continue;
                    }
                    if (JPortal.proc.extendsStd) {
                        JPortal.proc.useStd = false;
                        isStdProc = false;
                    }
                    if (!JPortal.field.isNull) {
                        JPortal.field.isNull = table.hasFieldAsNull(JPortal.field.name);
                    }
                    JPortal.proc.outputs.addElement(field);
                }
            }
            default: {
                JPortal.jj_la1[177] = jj_gen;
            }
        }
        if (isStdProc) {
            JPortal.table.hasStdProcs = true;
        }
        switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
            case 84: 
            case 114: {
                JPortal.jOldCode();
                break;
            }
            default: {
                JPortal.jj_la1[178] = jj_gen;
                JPortal.jNewCode();
            }
        }
    }

    public static final void jOldCode() throws ParseException {
        block12: {
            switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                case 84: {
                    JPortal.jj_consume_token(84);
                    JPortal.proc.isSql = true;
                    break;
                }
                default: {
                    JPortal.jj_la1[179] = jj_gen;
                }
            }
            JPortal.jj_consume_token(114);
            block10: while (true) {
                switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                    case 131: 
                    case 134: 
                    case 135: {
                        break;
                    }
                    default: {
                        JPortal.jj_la1[180] = jj_gen;
                        break block12;
                    }
                }
                switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                    case 131: {
                        JPortal.jLine();
                        Line l1 = new Line(JPortal.database.templateOutputOptions, new SQLProcStringToken(line));
                        JPortal.proc.lines.addElement(l1);
                        continue block10;
                    }
                    case 134: 
                    case 135: {
                        String s2 = JPortal.jIdent();
                        Integer size = JPortal.jOptSize();
                        Line l2 = new Line(JPortal.database.templateOutputOptions, (ISQLProcToken)new SQLProcStringToken(s2), true);
                        JPortal.proc.lines.addElement(l2);
                        if (proc.hasDynamic(s2)) continue block10;
                        if (JPortal.proc.extendsStd) {
                            JPortal.proc.useStd = false;
                        }
                        JPortal.proc.dynamics.addElement(s2);
                        JPortal.proc.dynamicSizes.addElement(size);
                        continue block10;
                    }
                }
                break;
            }
            JPortal.jj_la1[181] = jj_gen;
            JPortal.jj_consume_token(-1);
            throw new ParseException();
        }
        JPortal.jj_consume_token(116);
    }

    public static final void jNewCode() throws ParseException {
        block3: while (true) {
            switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                case 142: {
                    break;
                }
                default: {
                    JPortal.jj_la1[182] = jj_gen;
                    break block3;
                }
            }
            Token t = JPortal.jj_consume_token(142);
            String s2 = JPortal.parseDynamics(t.image.trim() + " ");
            if (s2.length() <= 0) continue;
            Line line = new Line(JPortal.database.templateOutputOptions, new SQLProcStringToken(s2));
            JPortal.proc.lines.addElement(line);
        }
    }

    public static final Integer jOptSize() throws ParseException {
        int n = 256;
        switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
            case 125: {
                JPortal.jj_consume_token(125);
                n = JPortal.jNumber();
                JPortal.jj_consume_token(128);
                break;
            }
            default: {
                JPortal.jj_la1[183] = jj_gen;
            }
        }
        return new Integer(n);
    }

    public static final void jInputType() throws ParseException {
        if (JPortal.jj_2_3(2)) {
            JPortal.jj_consume_token(125);
            JPortal.jj_consume_token(58);
            JPortal.jj_consume_token(128);
            JPortal.proc.isMultipleInput = true;
        } else if (JPortal.jj_2_4(2)) {
            JPortal.jj_consume_token(125);
            int n = JPortal.jNumber();
            JPortal.jj_consume_token(128);
            JPortal.proc.noRows = n;
            JPortal.proc.isMultipleInput = true;
        } else if (JPortal.jj_2_5(2)) {
            JPortal.jj_consume_token(125);
            JPortal.jj_consume_token(86);
            for (int i = 0; i < JPortal.table.fields.size(); ++i) {
                JPortal.proc.inputs.addElement(JPortal.table.fields.elementAt(i));
            }
            JPortal.jj_consume_token(128);
        } else {
            JPortal.jj_consume_token(-1);
            throw new ParseException();
        }
    }

    public static final void jOutputType() throws ParseException {
        if (JPortal.jj_2_6(2)) {
            JPortal.jj_consume_token(125);
            JPortal.jj_consume_token(83);
            JPortal.proc.isSingle = true;
            switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                case 86: {
                    JPortal.jj_consume_token(86);
                    for (int i = 0; i < JPortal.table.fields.size(); ++i) {
                        JPortal.proc.outputs.addElement(JPortal.table.fields.elementAt(i));
                    }
                    break;
                }
                default: {
                    JPortal.jj_la1[184] = jj_gen;
                }
            }
            JPortal.jj_consume_token(128);
        } else if (JPortal.jj_2_7(2)) {
            JPortal.jj_consume_token(125);
            JPortal.jj_consume_token(83);
            JPortal.proc.isSingle = true;
            switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                case 94: {
                    JPortal.jj_consume_token(94);
                    JPortal.proc.hasUpdates = true;
                    break;
                }
                default: {
                    JPortal.jj_la1[185] = jj_gen;
                }
            }
            JPortal.jj_consume_token(128);
        } else if (JPortal.jj_2_8(2)) {
            JPortal.jj_consume_token(125);
            int n = JPortal.jNumber();
            JPortal.jj_consume_token(128);
            JPortal.proc.noRows = n;
        } else if (JPortal.jj_2_9(2)) {
            JPortal.jj_consume_token(125);
            JPortal.jj_consume_token(86);
            for (int i = 0; i < JPortal.table.fields.size(); ++i) {
                JPortal.proc.outputs.addElement(JPortal.table.fields.elementAt(i));
            }
            switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                case 83: {
                    JPortal.jj_consume_token(83);
                    JPortal.proc.isSingle = true;
                    break;
                }
                default: {
                    JPortal.jj_la1[186] = jj_gen;
                }
            }
            JPortal.jj_consume_token(128);
        } else {
            JPortal.jj_consume_token(-1);
            throw new ParseException();
        }
    }

    public static final void jOldData() throws ParseException {
        JPortal.jj_consume_token(115);
        proc = new Proc();
        JPortal.proc.isData = true;
        block3: while (true) {
            switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                case 131: {
                    break;
                }
                default: {
                    JPortal.jj_la1[187] = jj_gen;
                    break block3;
                }
            }
            JPortal.jLine();
            Line l1 = new Line(JPortal.database.templateOutputOptions, new SQLProcStringToken(line));
            JPortal.proc.lines.addElement(l1);
        }
        JPortal.jj_consume_token(117);
    }

    public static final void jNewData() throws ParseException {
        Token t = JPortal.jj_consume_token(145);
        proc = new Proc();
        JPortal.proc.isData = true;
        Line l1 = new Line(JPortal.database.templateOutputOptions, new SQLProcStringToken(t.image.trim()));
        JPortal.proc.lines.addElement(l1);
        while (JPortal.jj_2_10(2)) {
            t = JPortal.jj_consume_token(145);
            Line l2 = new Line(JPortal.database.templateOutputOptions, new SQLProcStringToken(t.image.trim()));
            JPortal.proc.lines.addElement(l2);
        }
    }

    public static final void jIdlCode() throws ParseException {
        Token t = JPortal.jj_consume_token(148);
        proc = new Proc();
        JPortal.proc.isIdlCode = true;
        Line l1 = new Line(JPortal.database.templateOutputOptions, new SQLProcStringToken(t.image.trim()));
        JPortal.proc.lines.addElement(l1);
        while (JPortal.jj_2_11(2)) {
            t = JPortal.jj_consume_token(148);
            Line l2 = new Line(JPortal.database.templateOutputOptions, new SQLProcStringToken(t.image.trim()));
            JPortal.proc.lines.addElement(l2);
        }
    }

    private static boolean jj_2_1(int xla) {
        jj_la = xla;
        jj_scanpos = token;
        jj_lastpos = token;
        try {
            boolean bl = !JPortal.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            JPortal.jj_save(0, xla);
        }
    }

    private static boolean jj_2_2(int xla) {
        jj_la = xla;
        jj_scanpos = token;
        jj_lastpos = token;
        try {
            boolean bl = !JPortal.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            JPortal.jj_save(1, xla);
        }
    }

    private static boolean jj_2_3(int xla) {
        jj_la = xla;
        jj_scanpos = token;
        jj_lastpos = token;
        try {
            boolean bl = !JPortal.jj_3_3();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            JPortal.jj_save(2, xla);
        }
    }

    private static boolean jj_2_4(int xla) {
        jj_la = xla;
        jj_scanpos = token;
        jj_lastpos = token;
        try {
            boolean bl = !JPortal.jj_3_4();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            JPortal.jj_save(3, xla);
        }
    }

    private static boolean jj_2_5(int xla) {
        jj_la = xla;
        jj_scanpos = token;
        jj_lastpos = token;
        try {
            boolean bl = !JPortal.jj_3_5();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            JPortal.jj_save(4, xla);
        }
    }

    private static boolean jj_2_6(int xla) {
        jj_la = xla;
        jj_scanpos = token;
        jj_lastpos = token;
        try {
            boolean bl = !JPortal.jj_3_6();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            JPortal.jj_save(5, xla);
        }
    }

    private static boolean jj_2_7(int xla) {
        jj_la = xla;
        jj_scanpos = token;
        jj_lastpos = token;
        try {
            boolean bl = !JPortal.jj_3_7();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            JPortal.jj_save(6, xla);
        }
    }

    private static boolean jj_2_8(int xla) {
        jj_la = xla;
        jj_scanpos = token;
        jj_lastpos = token;
        try {
            boolean bl = !JPortal.jj_3_8();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            JPortal.jj_save(7, xla);
        }
    }

    private static boolean jj_2_9(int xla) {
        jj_la = xla;
        jj_scanpos = token;
        jj_lastpos = token;
        try {
            boolean bl = !JPortal.jj_3_9();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            JPortal.jj_save(8, xla);
        }
    }

    private static boolean jj_2_10(int xla) {
        jj_la = xla;
        jj_scanpos = token;
        jj_lastpos = token;
        try {
            boolean bl = !JPortal.jj_3_10();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            JPortal.jj_save(9, xla);
        }
    }

    private static boolean jj_2_11(int xla) {
        jj_la = xla;
        jj_scanpos = token;
        jj_lastpos = token;
        try {
            boolean bl = !JPortal.jj_3_11();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            JPortal.jj_save(10, xla);
        }
    }

    private static boolean jj_3R_71() {
        return JPortal.jj_3R_82();
    }

    private static boolean jj_3R_76() {
        return JPortal.jj_scan_token(49);
    }

    private static boolean jj_3R_93() {
        Token xsp = jj_scanpos;
        if (JPortal.jj_3R_94()) {
            jj_scanpos = xsp;
            if (JPortal.jj_3R_95()) {
                jj_scanpos = xsp;
                if (JPortal.jj_3R_96()) {
                    jj_scanpos = xsp;
                    if (JPortal.jj_3R_97()) {
                        jj_scanpos = xsp;
                        if (JPortal.jj_3R_98()) {
                            jj_scanpos = xsp;
                            if (JPortal.jj_3R_99()) {
                                return true;
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private static boolean jj_3R_94() {
        return JPortal.jj_scan_token(7);
    }

    private static boolean jj_3R_72() {
        return JPortal.jj_3R_83();
    }

    private static boolean jj_3R_88() {
        Token xsp;
        do {
            xsp = jj_scanpos;
        } while (!JPortal.jj_3R_92());
        jj_scanpos = xsp;
        return false;
    }

    private static boolean jj_3_10() {
        return JPortal.jj_scan_token(145);
    }

    private static boolean jj_3R_73() {
        return JPortal.jj_3R_84();
    }

    private static boolean jj_3R_92() {
        return JPortal.jj_scan_token(142);
    }

    private static boolean jj_3_7() {
        if (JPortal.jj_scan_token(125)) {
            return true;
        }
        return JPortal.jj_scan_token(83);
    }

    private static boolean jj_3R_79() {
        return JPortal.jj_3R_88();
    }

    private static boolean jj_3R_95() {
        return JPortal.jj_scan_token(32);
    }

    private static boolean jj_3R_96() {
        return JPortal.jj_scan_token(50);
    }

    private static boolean jj_3R_84() {
        if (JPortal.jj_scan_token(25)) {
            return true;
        }
        return JPortal.jj_3R_74();
    }

    private static boolean jj_3_8() {
        if (JPortal.jj_scan_token(125)) {
            return true;
        }
        return JPortal.jj_3R_68();
    }

    private static boolean jj_3R_68() {
        return JPortal.jj_scan_token(130);
    }

    private static boolean jj_3R_97() {
        return JPortal.jj_scan_token(72);
    }

    private static boolean jj_3_9() {
        if (JPortal.jj_scan_token(125)) {
            return true;
        }
        return JPortal.jj_scan_token(86);
    }

    private static boolean jj_3_11() {
        return JPortal.jj_scan_token(148);
    }

    private static boolean jj_3R_98() {
        return JPortal.jj_scan_token(94);
    }

    private static boolean jj_3R_74() {
        Token xsp = jj_scanpos;
        if (JPortal.jj_3R_85()) {
            jj_scanpos = xsp;
            if (JPortal.jj_3R_86()) {
                return true;
            }
        }
        return false;
    }

    private static boolean jj_3R_77() {
        return JPortal.jj_scan_token(64);
    }

    private static boolean jj_3R_85() {
        return JPortal.jj_scan_token(134);
    }

    private static boolean jj_3R_99() {
        return JPortal.jj_scan_token(39);
    }

    private static boolean jj_3R_87() {
        Token xsp = jj_scanpos;
        if (JPortal.jj_3R_91()) {
            jj_scanpos = xsp;
        }
        return JPortal.jj_scan_token(114);
    }

    private static boolean jj_3R_86() {
        return JPortal.jj_scan_token(135);
    }

    private static boolean jj_3R_83() {
        if (JPortal.jj_scan_token(101)) {
            return true;
        }
        return JPortal.jj_3R_74();
    }

    private static boolean jj_3R_91() {
        return JPortal.jj_scan_token(84);
    }

    private static boolean jj_3R_80() {
        Token xsp;
        if (JPortal.jj_scan_token(44)) {
            return true;
        }
        if (JPortal.jj_3R_89()) {
            return true;
        }
        do {
            xsp = jj_scanpos;
        } while (!JPortal.jj_3R_89());
        jj_scanpos = xsp;
        return false;
    }

    private static boolean jj_3_3() {
        if (JPortal.jj_scan_token(125)) {
            return true;
        }
        return JPortal.jj_scan_token(58);
    }

    private static boolean jj_3_4() {
        if (JPortal.jj_scan_token(125)) {
            return true;
        }
        return JPortal.jj_3R_68();
    }

    private static boolean jj_3R_82() {
        if (JPortal.jj_scan_token(54)) {
            return true;
        }
        return JPortal.jj_3R_90();
    }

    private static boolean jj_3R_89() {
        return JPortal.jj_3R_93();
    }

    private static boolean jj_3_2() {
        return JPortal.jj_3R_67();
    }

    private static boolean jj_3R_67() {
        if (JPortal.jj_3R_74()) {
            return true;
        }
        if (JPortal.jj_scan_token(72)) {
            return true;
        }
        Token xsp = jj_scanpos;
        if (JPortal.jj_3R_75()) {
            jj_scanpos = xsp;
        }
        xsp = jj_scanpos;
        if (JPortal.jj_3R_76()) {
            jj_scanpos = xsp;
        }
        xsp = jj_scanpos;
        if (JPortal.jj_3R_77()) {
            jj_scanpos = xsp;
        }
        xsp = jj_scanpos;
        if (JPortal.jj_3R_78()) {
            jj_scanpos = xsp;
            if (JPortal.jj_3R_79()) {
                return true;
            }
        }
        return false;
    }

    private static boolean jj_3R_81() {
        if (JPortal.jj_scan_token(53)) {
            return true;
        }
        return JPortal.jj_3R_74();
    }

    private static boolean jj_3_5() {
        if (JPortal.jj_scan_token(125)) {
            return true;
        }
        return JPortal.jj_scan_token(86);
    }

    private static boolean jj_3_1() {
        return JPortal.jj_3R_66();
    }

    private static boolean jj_3R_66() {
        Token xsp = jj_scanpos;
        if (JPortal.jj_3R_69()) {
            jj_scanpos = xsp;
            if (JPortal.jj_3R_70()) {
                jj_scanpos = xsp;
                if (JPortal.jj_3R_71()) {
                    jj_scanpos = xsp;
                    if (JPortal.jj_3R_72()) {
                        jj_scanpos = xsp;
                        if (JPortal.jj_3R_73()) {
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    private static boolean jj_3R_69() {
        return JPortal.jj_3R_80();
    }

    private static boolean jj_3R_90() {
        return JPortal.jj_3R_74();
    }

    private static boolean jj_3R_75() {
        return JPortal.jj_scan_token(125);
    }

    private static boolean jj_3R_70() {
        return JPortal.jj_3R_81();
    }

    private static boolean jj_3R_78() {
        return JPortal.jj_3R_87();
    }

    private static boolean jj_3_6() {
        if (JPortal.jj_scan_token(125)) {
            return true;
        }
        return JPortal.jj_scan_token(83);
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x800000, 0, 0, 0, 0, 0, -2138046464, 0, -2138046464, 0, 0, -2138046464, 0, -2138046464, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 810155264, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x2000000, 0, 0, 128, 0, 128, 0, 0, 0, 0, 0, 0, 0, 0x200000, 0, 0x200000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x1060000, 0, 0, 0, 0, 0, 0, 0, 512, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 512, 0, 0, 0, 0, 0, 0, 0, 0, 512, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x1060000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[]{512, 0, 0, 16384, 16384, 16384, 0, 0, 0, 0, 0, 0, 16384, 0, 0, 0, 0, 0, 0, 0, 0, 0x40000000, 0, 0, 0, 0x30000000, 0x10000000, 0x30000000, 0, 0, 0x30000000, 0x10000000, 0x30000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1056, 0, 43525152, 0, 0x400000, 0, 0, 0, 0x400000, 0, 0, 0x400000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 262144, 0, 8, 0, 0x601000, 0, 0, 262273, 0, 262273, 0x40000000, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0x40000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 17039630, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2048, 0, 2048, 0, 32768, -2147450880, 2048, 0, 2048, 0, 0, 32768, 0, 16, -2147450880, 2048, 0, 2048, 0, 0, 0, 0, 0, 0, 32768, 0, 16, -2147450880, 2048, 0, 2048, 17039630, 0x40000000, 0, 0, 0, 0, 131072, 0, 0, 0, 0, 0, 0, 0x40000000, 0, 0, 0, 131072, 0, 0, 65536, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    }

    private static void jj_la1_init_2() {
        jj_la1_2 = new int[]{0, 0, 2, 1, 1, 0x800000, 0, 128, 0, 0, 0, 0, 0x800000, 0x200010, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 386170880, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 512, 0, 512, 0, 0x40000000, 0, 0, 0, 0, 0, 0x40000100, 0, 0x40000100, 0, 0, 0x20000008, 0, 0x20000008, 0, 0, 0, 0, 0, 0x40000000, 0, 0, 0, 0, 0x8000000, 0, 1, 0, 0, 0, 0x200010, 0, -1073715712, 0, 0x200010, 64, 0, 0, 0, 131072, 0, 0, 0, 0, 0, 0, 0x40000020, 0x40000020, 0, 0, 0, 0, 0x40000020, 0x40000020, 0, 0, 0, 0, 0, 0, 0, 0x40000020, 0x40000020, 0, 0, 0, 0, 1, 64, 0, 0, 0, 0, 0, 0x40000020, 0x40000020, -1073715712, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0x100000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0x100000, 0x100000, 0, 0, 0, 0, 0x400000, 0x40000000, 524288, 0};
    }

    private static void jj_la1_init_3() {
        jj_la1_3 = new int[]{0, 0, 0, 0, 0, 0, 32, 0, 4, 0, 0, 0, 0, 524288, 512, 0, 0x10000000, 0x20000000, 0x20000000, 0, 0x400000, 0, 0, 0, 0x20000000, 0, 0, 0, 0x400000, 0x20000000, 0, 0, 0, 0x400000, 0x30000000, 0x28000000, 0x28000000, 0x30000000, 0x8000000, 0x30000000, 0x30000000, 0x8000000, 0x30000000, 0x30000000, 0x8000000, 0x28000000, 0x28000000, 0x28000000, 0x28000000, 0x30000000, 0x30000000, 0x30000000, 0x30000000, 0x30000000, 0, 0x30000000, 67109336, 0x20000000, 0, 0x2000000, 0, 0x30000000, 0, 0x2000000, 0, 0, 0x30000000, 0x30000000, 0x2000000, 0, 0, 261120, 0, 0, 0, 0, 0, 0, 0, 0, 261120, 32, 0x2000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x20000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 262144, 0, 0, 0, 0, 3, 524288, 524288, 0, 0, 0, 0, 0, 0, 0x20000000, 0x20000000, 0x20000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x20000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0x20000000, 0x20000000, 0, 0, 0x20000000, 0, 0, 262144, 0x20000000, 0x400000, 0, 0, 0x20000000, 0, 0, 0x20000000, 0, 0, 0x20000000, 0, 0, 262144, 0, 0, 0, 0, 0x20000000, 0, 0, 0, 0};
    }

    private static void jj_la1_init_4() {
        jj_la1_4 = new int[]{0, 8, 0, 0, 0, 0, 0, 0, 0, 0x200000, 200, 192, 0, 0x120000, 0, 192, 0, 0, 0, 0, 0, 0, 8, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 4, 0, 4, 4, 0, 4, 4, 0, 0, 0, 0, 0, 4, 4, 4, 4, 4, 0, 0, 0, 0, 0, 0, 192, 0, 0, 0, 192, 196, 4, 4, 0, 192, 8, 0, 192, 192, 192, 192, 192, 192, 192, 192, 0, 0, 0, 192, 0, 192, 0, 0, 8, 0, 192, 0, 192, 0, 0, 0, 0, 0, 0, 8, 192, 192, 0, 192, 0, 0, 16384, 8, 0, 192, 192, 0x120000, 0x120000, 0, 192, 192, 192, 0, 0, 0, 0, 0, 192, 0, 0, 0, 192, 0, 0, 0, 0, 0, 0, 192, 0, 192, 0, 0, 0, 0, 0, 0, 192, 0, 192, 0, 0, 0, 192, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 192, 0, 0, 192, 0, 0, 0, 0, 0, 8, 0, 192, 0, 0, 192, 0, 0, 192, 0, 0, 0, 200, 200, 16384, 0, 0, 0, 0, 8};
    }

    public JPortal(InputStream stream) {
        this(stream, null);
    }

    public JPortal(InputStream stream, String encoding) {
        int i;
        if (jj_initialized_once) {
            System.out.println("ERROR: Second call to constructor of static parser.  ");
            System.out.println("\t   You must either use ReInit() or set the JavaCC option STATIC to false");
            System.out.println("\t   during parser generation.");
            throw new IllegalStateException();
        }
        jj_initialized_once = true;
        try {
            jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
        token_source = new JPortalTokenManager(jj_input_stream);
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (i = 0; i < 188; ++i) {
            JPortal.jj_la1[i] = -1;
        }
        for (i = 0; i < jj_2_rtns.length; ++i) {
            JPortal.jj_2_rtns[i] = new JJCalls();
        }
    }

    public static void ReInit(InputStream stream) {
        JPortal.ReInit(stream, null);
    }

    public static void ReInit(InputStream stream, String encoding) {
        int i;
        try {
            jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
        JPortalTokenManager.ReInit(jj_input_stream);
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (i = 0; i < 188; ++i) {
            JPortal.jj_la1[i] = -1;
        }
        for (i = 0; i < jj_2_rtns.length; ++i) {
            JPortal.jj_2_rtns[i] = new JJCalls();
        }
    }

    public JPortal(Reader stream) {
        int i;
        if (jj_initialized_once) {
            System.out.println("ERROR: Second call to constructor of static parser. ");
            System.out.println("\t   You must either use ReInit() or set the JavaCC option STATIC to false");
            System.out.println("\t   during parser generation.");
            throw new IllegalStateException();
        }
        jj_initialized_once = true;
        jj_input_stream = new SimpleCharStream(stream, 1, 1);
        token_source = new JPortalTokenManager(jj_input_stream);
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (i = 0; i < 188; ++i) {
            JPortal.jj_la1[i] = -1;
        }
        for (i = 0; i < jj_2_rtns.length; ++i) {
            JPortal.jj_2_rtns[i] = new JJCalls();
        }
    }

    public static void ReInit(Reader stream) {
        int i;
        if (jj_input_stream == null) {
            jj_input_stream = new SimpleCharStream(stream, 1, 1);
        } else {
            jj_input_stream.ReInit(stream, 1, 1);
        }
        if (token_source == null) {
            token_source = new JPortalTokenManager(jj_input_stream);
        }
        JPortalTokenManager.ReInit(jj_input_stream);
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (i = 0; i < 188; ++i) {
            JPortal.jj_la1[i] = -1;
        }
        for (i = 0; i < jj_2_rtns.length; ++i) {
            JPortal.jj_2_rtns[i] = new JJCalls();
        }
    }

    public JPortal(JPortalTokenManager tm) {
        int i;
        if (jj_initialized_once) {
            System.out.println("ERROR: Second call to constructor of static parser. ");
            System.out.println("\t   You must either use ReInit() or set the JavaCC option STATIC to false");
            System.out.println("\t   during parser generation.");
            throw new IllegalStateException();
        }
        jj_initialized_once = true;
        token_source = tm;
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (i = 0; i < 188; ++i) {
            JPortal.jj_la1[i] = -1;
        }
        for (i = 0; i < jj_2_rtns.length; ++i) {
            JPortal.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(JPortalTokenManager tm) {
        int i;
        token_source = tm;
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (i = 0; i < 188; ++i) {
            JPortal.jj_la1[i] = -1;
        }
        for (i = 0; i < jj_2_rtns.length; ++i) {
            JPortal.jj_2_rtns[i] = new JJCalls();
        }
    }

    private static Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = token;
        token = JPortal.token.next != null ? JPortal.token.next : (JPortal.token.next = token_source.getNextToken());
        jj_ntk = -1;
        if (JPortal.token.kind == kind) {
            ++jj_gen;
            if (++jj_gc > 100) {
                jj_gc = 0;
                for (int i = 0; i < jj_2_rtns.length; ++i) {
                    JJCalls c = jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return token;
        }
        token = oldToken;
        jj_kind = kind;
        throw JPortal.generateParseException();
    }

    private static boolean jj_scan_token(int kind) {
        if (jj_scanpos == jj_lastpos) {
            --jj_la;
            if (JPortal.jj_scanpos.next == null) {
                jj_scanpos = JPortal.jj_scanpos.next = token_source.getNextToken();
                jj_lastpos = JPortal.jj_scanpos.next;
            } else {
                jj_lastpos = jj_scanpos = JPortal.jj_scanpos.next;
            }
        } else {
            jj_scanpos = JPortal.jj_scanpos.next;
        }
        if (jj_rescan) {
            int i = 0;
            Token tok = token;
            while (tok != null && tok != jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                JPortal.jj_add_error_token(kind, i);
            }
        }
        if (JPortal.jj_scanpos.kind != kind) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            throw jj_ls;
        }
        return false;
    }

    public static final Token getNextToken() {
        token = JPortal.token.next != null ? JPortal.token.next : (JPortal.token.next = token_source.getNextToken());
        jj_ntk = -1;
        ++jj_gen;
        return token;
    }

    public static final Token getToken(int index) {
        Token t = token;
        for (int i = 0; i < index; ++i) {
            if (t.next == null) {
                t.next = token_source.getNextToken();
            }
            t = t.next;
        }
        return t;
    }

    private static int jj_ntk_f() {
        jj_nt = JPortal.token.next;
        if (jj_nt == null) {
            JPortal.token.next = token_source.getNextToken();
            jj_ntk = JPortal.token.next.kind;
            return jj_ntk;
        }
        jj_ntk = JPortal.jj_nt.kind;
        return jj_ntk;
    }

    private static void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == jj_endpos + 1) {
            JPortal.jj_lasttokens[JPortal.jj_endpos++] = kind;
        } else if (jj_endpos != 0) {
            jj_expentry = new int[jj_endpos];
            for (int i = 0; i < jj_endpos; ++i) {
                JPortal.jj_expentry[i] = jj_lasttokens[i];
            }
            for (int[] oldentry : jj_expentries) {
                if (oldentry.length != jj_expentry.length) continue;
                boolean isMatched = true;
                for (int i = 0; i < jj_expentry.length; ++i) {
                    if (oldentry[i] == jj_expentry[i]) continue;
                    isMatched = false;
                    break;
                }
                if (!isMatched) continue;
                jj_expentries.add(jj_expentry);
                break;
            }
            if (pos != 0) {
                jj_endpos = pos;
                JPortal.jj_lasttokens[JPortal.jj_endpos - 1] = kind;
            }
        }
    }

    public static ParseException generateParseException() {
        int i;
        jj_expentries.clear();
        boolean[] la1tokens = new boolean[150];
        if (jj_kind >= 0) {
            la1tokens[JPortal.jj_kind] = true;
            jj_kind = -1;
        }
        for (i = 0; i < 188; ++i) {
            if (jj_la1[i] != jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) != 0) {
                    la1tokens[32 + j] = true;
                }
                if ((jj_la1_2[i] & 1 << j) != 0) {
                    la1tokens[64 + j] = true;
                }
                if ((jj_la1_3[i] & 1 << j) != 0) {
                    la1tokens[96 + j] = true;
                }
                if ((jj_la1_4[i] & 1 << j) == 0) continue;
                la1tokens[128 + j] = true;
            }
        }
        for (i = 0; i < 150; ++i) {
            if (!la1tokens[i]) continue;
            jj_expentry = new int[1];
            JPortal.jj_expentry[0] = i;
            jj_expentries.add(jj_expentry);
        }
        jj_endpos = 0;
        JPortal.jj_rescan_token();
        JPortal.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[jj_expentries.size()][];
        for (int i2 = 0; i2 < jj_expentries.size(); ++i2) {
            exptokseq[i2] = jj_expentries.get(i2);
        }
        return new ParseException(token, exptokseq, tokenImage);
    }

    public static final boolean trace_enabled() {
        return trace_enabled;
    }

    public static final void enable_tracing() {
    }

    public static final void disable_tracing() {
    }

    private static void jj_rescan_token() {
        jj_rescan = true;
        for (int i = 0; i < 11; ++i) {
            try {
                JJCalls p = jj_2_rtns[i];
                do {
                    if (p.gen <= jj_gen) continue;
                    jj_la = p.arg;
                    jj_scanpos = p.first;
                    jj_lastpos = p.first;
                    switch (i) {
                        case 0: {
                            JPortal.jj_3_1();
                            break;
                        }
                        case 1: {
                            JPortal.jj_3_2();
                            break;
                        }
                        case 2: {
                            JPortal.jj_3_3();
                            break;
                        }
                        case 3: {
                            JPortal.jj_3_4();
                            break;
                        }
                        case 4: {
                            JPortal.jj_3_5();
                            break;
                        }
                        case 5: {
                            JPortal.jj_3_6();
                            break;
                        }
                        case 6: {
                            JPortal.jj_3_7();
                            break;
                        }
                        case 7: {
                            JPortal.jj_3_8();
                            break;
                        }
                        case 8: {
                            JPortal.jj_3_9();
                            break;
                        }
                        case 9: {
                            JPortal.jj_3_10();
                            break;
                        }
                        case 10: {
                            JPortal.jj_3_11();
                        }
                    }
                } while ((p = p.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        jj_rescan = false;
    }

    private static void jj_save(int index, int xla) {
        JJCalls p = jj_2_rtns[index];
        while (p.gen > jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = jj_gen + xla - jj_la;
        p.first = token;
        p.arg = xla;
    }

    static {
        parser_initialised = false;
        fieldsNullByDefault = false;
        isLiteral = false;
        literal = "";
        jj_initialized_once = false;
        jj_la1 = new int[188];
        JPortal.jj_la1_init_0();
        JPortal.jj_la1_init_1();
        JPortal.jj_la1_init_2();
        JPortal.jj_la1_init_3();
        JPortal.jj_la1_init_4();
        jj_2_rtns = new JJCalls[11];
        jj_rescan = false;
        jj_gc = 0;
        jj_ls = new LookaheadSuccess();
        jj_expentries = new ArrayList<int[]>();
        jj_kind = -1;
        jj_lasttokens = new int[100];
        trace_enabled = false;
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends IllegalStateException {
        private LookaheadSuccess() {
        }
    }
}

