/*
 * Decompiled with CFR 0.152.
 */
package bbd.jportal2.generators;

import bbd.jportal2.BaseGenerator;
import bbd.jportal2.Database;
import bbd.jportal2.Enum;
import bbd.jportal2.Field;
import bbd.jportal2.Flag;
import bbd.jportal2.IBuiltInSIProcessor;
import bbd.jportal2.JPortalTemplateOutputOptions;
import bbd.jportal2.PlaceHolder;
import bbd.jportal2.PlaceHolderPairs;
import bbd.jportal2.Proc;
import bbd.jportal2.Table;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSNetCode
extends BaseGenerator
implements IBuiltInSIProcessor {
    JPortalTemplateOutputOptions CSNetCodeOutputOptions = JPortalTemplateOutputOptions.defaultBuiltInOptions();
    private static final Logger logger = LoggerFactory.getLogger(CSNetCode.class);
    protected Vector<Flag> flagsVector;
    boolean mSSqlStoredProcs;
    boolean hasStoredProcs;
    boolean useGenerics;
    boolean usePartials;
    boolean useSeparate;
    boolean noDatatables;
    boolean useYields;
    boolean useCSharp2;
    boolean useCSharp1;
    boolean useNotify;
    boolean useFunc;
    String version = "4.0.";
    String runTimeVersion = "4.0.30319";
    OutputStream procFile;
    PrintWriter procData;
    PlaceHolder placeHolder;

    public CSNetCode() {
        super(CSNetCode.class);
    }

    @Override
    public String description() {
        return "Generate C# Code for ADO.NET via IDbConnection";
    }

    @Override
    public String documentation() {
        return "Generate C# Code for ADO.NET via IDbConnection\r\nDATABASE name FLAGS flag\r\n- \"mssql storedprocs\" generate stored procedures for MSSql\r\n- \"use generics\" generate lists as generics\r\n- \"use partials\" generate classes as partials\r\n- \"use yields\" generate code for yields\r\n- \"no datatables\" do not generate code for datatables\r\n- \"use C# 2.0\" generate classes with above uses\r\n- \"use C# 1.0\" generate classes compatable with C# 1.0\r\n- \"use separate\" generate classes in separate files\r\n- \"use notify\" generate classes with INotifyPropertyChanged implemented";
    }

    private void flagDefaults() {
        this.hasStoredProcs = false;
        this.mSSqlStoredProcs = false;
        this.useGenerics = false;
        this.usePartials = false;
        this.useYields = false;
        this.useSeparate = false;
        this.noDatatables = false;
        this.useCSharp1 = false;
        this.useCSharp2 = false;
        this.useNotify = false;
        this.useFunc = false;
    }

    @Override
    public Vector<Flag> getFlags() {
        if (this.flagsVector == null) {
            this.flagsVector = new Vector();
            this.flagDefaults();
            this.flagsVector.addElement(new Flag("mssql storedprocs", new Boolean(this.mSSqlStoredProcs), "Generate MSSql Stored Procedures"));
            this.flagsVector.addElement(new Flag("use generics", new Boolean(this.useGenerics), "Generate C# 2.0 Generics"));
            this.flagsVector.addElement(new Flag("use partials", new Boolean(this.usePartials), "Generate C# 2.0 Partials"));
            this.flagsVector.addElement(new Flag("use yields", new Boolean(this.useYields), "Generate C# 2.0 Yields"));
            this.flagsVector.addElement(new Flag("use separate", new Boolean(this.useSeparate), "Generate Separate Files"));
            this.flagsVector.addElement(new Flag("no datatables", new Boolean(this.noDatatables), "Do not Generate Datatables"));
            this.flagsVector.addElement(new Flag("use C#2.0", new Boolean(this.useCSharp2), "Generate for C#2.0"));
            this.flagsVector.addElement(new Flag("use C#1.0", new Boolean(this.useCSharp1), "Generate for C#1.0"));
            this.flagsVector.addElement(new Flag("use notify", new Boolean(this.useNotify), "Generate for INotifyPropertyChanged"));
            this.flagsVector.addElement(new Flag("use func", new Boolean(this.useFunc), "Generate Functions"));
        }
        return this.flagsVector;
    }

    void setFlags(Database database) {
        if (this.flagsVector != null) {
            this.mSSqlStoredProcs = this.toBoolean(this.flagsVector.elementAt((int)0).value);
            this.useGenerics = this.toBoolean(this.flagsVector.elementAt((int)1).value);
            this.usePartials = this.toBoolean(this.flagsVector.elementAt((int)2).value);
            this.useYields = this.toBoolean(this.flagsVector.elementAt((int)3).value);
            this.useSeparate = this.toBoolean(this.flagsVector.elementAt((int)4).value);
            this.noDatatables = this.toBoolean(this.flagsVector.elementAt((int)5).value);
            this.useCSharp2 = this.toBoolean(this.flagsVector.elementAt((int)6).value);
            this.useCSharp1 = this.toBoolean(this.flagsVector.elementAt((int)7).value);
            this.useNotify = this.toBoolean(this.flagsVector.elementAt((int)8).value);
            this.useFunc = this.toBoolean(this.flagsVector.elementAt((int)9).value);
        } else {
            this.flagDefaults();
        }
        for (int i = 0; i < database.flags.size(); ++i) {
            String flag = database.flags.elementAt(i);
            if (flag.equalsIgnoreCase("mssql storedprocs")) {
                this.mSSqlStoredProcs = true;
                continue;
            }
            if (flag.equalsIgnoreCase("use generics")) {
                this.useGenerics = true;
                continue;
            }
            if (flag.equalsIgnoreCase("use partials")) {
                this.usePartials = true;
                continue;
            }
            if (flag.equalsIgnoreCase("use yields")) {
                this.useYields = true;
                continue;
            }
            if (flag.equalsIgnoreCase("use separate")) {
                this.useSeparate = true;
                continue;
            }
            if (flag.equalsIgnoreCase("no datatables")) {
                this.noDatatables = true;
                continue;
            }
            if (flag.equalsIgnoreCase("use C#2.0")) {
                this.useCSharp2 = true;
                this.useYields = true;
                this.usePartials = true;
                this.useGenerics = true;
                continue;
            }
            if (flag.equalsIgnoreCase("use C#1.0")) {
                this.useCSharp2 = false;
                this.useYields = false;
                this.usePartials = false;
                this.useGenerics = false;
                this.useCSharp1 = true;
                this.runTimeVersion = "1.1";
                continue;
            }
            if (flag.equalsIgnoreCase("use notify")) {
                this.useNotify = true;
                continue;
            }
            if (!flag.equalsIgnoreCase("use func")) continue;
            this.useFunc = true;
        }
        if (this.mSSqlStoredProcs) {
            logger.info(" (mssql storedprocs)");
        }
        if (this.useGenerics) {
            logger.info(" (use generics)");
        }
        if (this.usePartials) {
            logger.info(" (use partials)");
        }
        if (this.useYields) {
            logger.info(" (use yields)");
        }
        if (this.useSeparate) {
            logger.info(" (use separate)");
        }
        if (this.noDatatables) {
            logger.info(" (no datatables)");
        }
        if (this.useNotify) {
            logger.info(" (use notify)");
        }
        if (this.useFunc) {
            logger.info(" (use func)");
        }
    }

    @Override
    public void generate(Database database, String output) throws Exception {
        this.setFlags(database);
        for (int i = 0; i < database.tables.size(); ++i) {
            Table table = database.tables.elementAt(i);
            this.generate(table, output);
        }
    }

    void generate(Table table, String output) throws Exception {
        String added = "";
        if (this.useSeparate) {
            added = "Structs";
        }
        PrintWriter outFile = this.openOutputFileForGeneration("cs", this.openOutputStream(table, output, added));
        this.hasStoredProcs = false;
        if (!this.mSSqlStoredProcs && this.isStoredProcs(table)) {
            this.hasStoredProcs = true;
        }
        if (this.mSSqlStoredProcs || this.hasStoredProcs) {
            try (PrintWriter procData = this.openOutputFileForGeneration("sproc.sql", output + table.name + ".sproc.sql");){
                procData.println("USE " + table.database.name);
                procData.println();
            }
        }
        this.openWriterPuttingTop(table, outFile);
        this.generateStructs(table, outFile);
        if (!this.noDatatables) {
            if (this.useSeparate) {
                outFile.println("}");
                outFile.flush();
                outFile.close();
                outFile = this.openOutputFileForGeneration("Tables.cs", this.openOutputStream(table, output, "Tables"));
                this.openWriterPuttingTop(table, outFile);
            }
            this.generateDataTables(table, outFile);
        }
        if (this.useSeparate) {
            outFile.println("}");
            outFile.flush();
            outFile.close();
            outFile = this.openOutputFileForGeneration("cs", this.openOutputStream(table, output, ""));
            this.openWriterPuttingTop(table, outFile);
        }
        this.generateCode(table, outFile);
        outFile.println("}");
        outFile.flush();
        if (this.mSSqlStoredProcs || this.hasStoredProcs) {
            this.procData.flush();
        }
    }

    private void openWriterPuttingTop(Table table, PrintWriter outData) {
        String packageName = table.database.packageName;
        if (packageName.length() == 0) {
            packageName = "bbd.jportal2";
        }
        outData.println("//------------------------------------------------------------------------------");
        outData.println("// <auto-generated>");
        outData.println("//     This code was generated by a tool.");
        outData.println("//     Runtime Version: " + this.runTimeVersion);
        outData.println("//");
        outData.println("//     Changes to this file may cause incorrect behavior and will be lost if");
        outData.println("//     the code is regenerated.");
        outData.println("// </auto-generated>");
        outData.println("//------------------------------------------------------------------------------");
        outData.println("");
        outData.println("// ");
        outData.println("// This source code was auto-generated by jportal2.jar, Version=" + this.version);
        outData.println("// ");
        outData.println("using System;");
        if (this.useGenerics) {
            outData.println("using System.Collections.Generic;");
        } else {
            outData.println("using System.Collections;");
            outData.println("using System.Collections.Specialized;");
        }
        if (this.useNotify) {
            outData.println("using System.ComponentModel;");
            outData.println("using System.Runtime.CompilerServices;");
        }
        outData.println("using System.Data;");
        outData.println("using bbd.jportal2;");
        outData.println("");
        outData.println("namespace " + packageName);
        outData.println("{");
    }

    private String openOutputStream(Table table, String output, String added) {
        return output + table.name + added + ".cs";
    }

    private void generateSelector(Field field, PrintWriter outData) {
        outData.println(this.indent(2) + "public class Nfpp" + field.useUpperName() + " // NO _______ PARAMETER PROPERTIES ");
        outData.println(this.indent(2) + "{");
        outData.println(this.indent(3) + "DataTable parent;");
        outData.println(this.indent(3) + "public " + this.fieldCastNo(field) + " this[int row]");
        outData.println(this.indent(3) + "{");
        outData.println(this.indent(4) + "get");
        outData.println(this.indent(4) + "{");
        if (field.isNull) {
            outData.println(this.indent(5) + "if (parent.Rows[row][c" + field.useUpperName() + "] == DBNull.Value)");
            outData.println(this.indent(5) + "{");
            if (this.useCSharp1) {
                outData.println(this.indent(6) + "return " + this.validNull(field) + ";");
            } else {
                outData.println(this.indent(6) + "return default(" + this.fieldCastNo(field) + ");");
            }
            outData.println(this.indent(5) + "}");
            outData.println(this.indent(5) + "else");
            outData.println(this.indent(5) + "{");
            outData.println(this.indent(6) + "return (" + this.fieldCastNo(field) + ")parent.Rows[row][c" + field.useUpperName() + "];");
            outData.println(this.indent(5) + "}");
        } else {
            outData.println(this.indent(5) + "return (" + this.fieldCastNo(field) + ")parent.Rows[row][c" + field.useUpperName() + "];");
        }
        outData.println(this.indent(4) + "}");
        outData.println(this.indent(4) + "set");
        outData.println(this.indent(4) + "{");
        outData.println(this.indent(5) + "parent.Rows[row][c" + field.useUpperName() + "] = value;");
        outData.println(this.indent(4) + "}");
        outData.println(this.indent(3) + "}");
        if (field.isNull) {
            outData.println(this.indent(3) + "public bool IsNull(int row){ return parent.Rows[row].IsNull(c" + field.useUpperName() + "); }");
            outData.println(this.indent(3) + "public void SetNull(int row){ parent.Rows[row][c" + field.useUpperName() + "] = DBNull.Value; }");
        }
        outData.println(this.indent(3) + "public Nfpp" + field.useUpperName() + "(DataTable parent) { this.parent = parent; }");
        outData.println(this.indent(2) + "}");
        outData.println(this.indent(2) + "private Nfpp" + field.useUpperName() + " m" + field.useUpperName() + ";");
        outData.println(this.indent(2) + "public Nfpp" + field.useUpperName() + " " + field.useUpperName());
        outData.println(this.indent(2) + "{");
        outData.println(this.indent(3) + "get { return m" + field.useUpperName() + "; }");
        outData.println(this.indent(3) + "set { m" + field.useUpperName() + " = value; }");
        outData.println(this.indent(2) + "}");
    }

    public boolean isStoredProcs(Table table) {
        boolean hasStoredProcs = false;
        for (int i = 0; i < table.procs.size(); ++i) {
            Proc proc = table.procs.elementAt(i);
            if (proc.isSProc) {
                return true;
            }
            if (proc.outputs.size() != 0 && !proc.isSingle) continue;
        }
        return hasStoredProcs;
    }

    public void generateDataTables(Table table, PrintWriter outData) {
        boolean hasDataTables = false;
        for (int i = 0; i < table.procs.size(); ++i) {
            Field field;
            int j;
            Field field2;
            int j2;
            Proc proc = table.procs.elementAt(i);
            if (proc.outputs.size() == 0 || proc.isSingle) continue;
            hasDataTables = true;
            outData.println(this.indent(1) + "[Serializable()]");
            outData.println(this.indent(1) + "public " + (this.usePartials ? "partial " : "") + "class " + table.useName() + proc.upperFirst() + "DataTable : DataTable");
            outData.println(this.indent(1) + "{");
            int noInDataSet = 0;
            for (j2 = 0; j2 < proc.inputs.size(); ++j2) {
                field2 = proc.inputs.elementAt(j2);
                outData.println(this.indent(2) + "public const int c" + field2.useUpperName() + " = " + noInDataSet + ";");
                ++noInDataSet;
            }
            for (j2 = 0; j2 < proc.outputs.size(); ++j2) {
                field2 = proc.outputs.elementAt(j2);
                if (proc.hasInput(field2.name)) continue;
                outData.println(this.indent(2) + "public const int c" + field2.useUpperName() + " = " + noInDataSet + ";");
                ++noInDataSet;
            }
            outData.println(this.indent(2) + "public static string ToString(int ordinal)");
            outData.println(this.indent(2) + "{");
            outData.println(this.indent(3) + "switch (ordinal)");
            outData.println(this.indent(3) + "{");
            for (j2 = 0; j2 < proc.inputs.size(); ++j2) {
                field2 = proc.inputs.elementAt(j2);
                outData.println(this.indent(4) + "case c" + field2.useUpperName() + ": return \"" + field2.useUpperName() + "\";");
            }
            for (j2 = 0; j2 < proc.outputs.size(); ++j2) {
                field2 = proc.outputs.elementAt(j2);
                if (proc.hasInput(field2.name)) continue;
                outData.println(this.indent(4) + "case c" + field2.useUpperName() + ": return \"" + field2.useUpperName() + "\";");
            }
            outData.println(this.indent(3) + "}");
            outData.println(this.indent(3) + "return \"<??\"+ordinal+\"??>\";");
            outData.println(this.indent(2) + "}");
            for (j2 = 0; j2 < proc.inputs.size(); ++j2) {
                field2 = proc.inputs.elementAt(j2);
                this.generateSelector(field2, outData);
            }
            for (j2 = 0; j2 < proc.outputs.size(); ++j2) {
                field2 = proc.outputs.elementAt(j2);
                if (proc.hasInput(field2.name)) continue;
                this.generateSelector(field2, outData);
            }
            String mainName = table.useName();
            if (!proc.isStd) {
                mainName = mainName + proc.upperFirst();
            }
            outData.println(this.indent(2) + "public class RowBag");
            outData.println(this.indent(2) + "{");
            outData.println(this.indent(3) + "public " + mainName + "Rec mRec;");
            outData.println(this.indent(3) + "public object tag = null;");
            outData.println(this.indent(3) + "public RowBag(" + mainName + "Rec aRec)");
            outData.println(this.indent(3) + "{");
            outData.println(this.indent(4) + "mRec = aRec;");
            outData.println(this.indent(3) + "}");
            outData.println(this.indent(2) + "}");
            if (this.useGenerics) {
                outData.println(this.indent(2) + "public Dictionary<DataRow, RowBag> dictionary;");
            } else {
                outData.println(this.indent(2) + "public HybridDictionary dictionary;");
            }
            if (this.useGenerics) {
                outData.println(this.indent(2) + "public " + table.useName() + proc.upperFirst() + "DataTable(List<" + mainName + "Rec> aList)");
            } else {
                outData.println(this.indent(2) + "public " + table.useName() + proc.upperFirst() + "DataTable(ArrayList aList)");
            }
            outData.println(this.indent(3) + ": base(\"" + table.useName() + proc.upperFirst() + "\")");
            outData.println(this.indent(2) + "{");
            for (j = 0; j < proc.inputs.size(); ++j) {
                field = proc.inputs.elementAt(j);
                outData.println(this.indent(3) + "Columns.Add(new DataColumn(\"" + field.useUpperName() + "\", typeof(" + this.dataTableType(field) + ")));");
            }
            for (j = 0; j < proc.outputs.size(); ++j) {
                field = proc.outputs.elementAt(j);
                if (proc.hasInput(field.name)) continue;
                outData.println(this.indent(3) + "Columns.Add(new DataColumn(\"" + field.useUpperName() + "\", typeof(" + this.dataTableType(field) + ")));");
            }
            for (j = 0; j < proc.inputs.size(); ++j) {
                field = proc.inputs.elementAt(j);
                outData.println(this.indent(3) + "m" + field.useUpperName() + " = new Nfpp" + field.useUpperName() + "(this);");
            }
            for (j = 0; j < proc.outputs.size(); ++j) {
                field = proc.outputs.elementAt(j);
                if (proc.hasInput(field.name)) continue;
                outData.println(this.indent(3) + "m" + field.useUpperName() + " = new Nfpp" + field.useUpperName() + "(this);");
            }
            if (this.useGenerics) {
                outData.println(this.indent(3) + "dictionary = new Dictionary<DataRow, RowBag>();");
            } else {
                outData.println(this.indent(3) + "dictionary = new HybridDictionary();");
            }
            outData.println(this.indent(3) + "foreach (" + mainName + "Rec wRec in aList)");
            outData.println(this.indent(3) + "{");
            outData.println(this.indent(4) + "DataRow wRow = NewRow();");
            outData.println(this.indent(4) + "dictionary.Add(wRow, new RowBag(wRec));");
            for (j = 0; j < proc.inputs.size(); ++j) {
                field = proc.inputs.elementAt(j);
                if (field.isNull) {
                    outData.println(this.indent(4) + "if (wRec." + field.useUpperName() + "IsNull == true)");
                    outData.println(this.indent(4) + "{");
                    outData.println(this.indent(5) + "wRow[c" + field.useUpperName() + "] = DBNull.Value;");
                    outData.println(this.indent(4) + "}");
                    outData.println(this.indent(4) + "else");
                    outData.println(this.indent(4) + "{");
                    outData.println(this.indent(5) + "wRow[c" + field.useUpperName() + "] = wRec." + field.useUpperName() + ";");
                    outData.println(this.indent(4) + "}");
                    continue;
                }
                outData.println(this.indent(4) + "wRow[c" + field.useUpperName() + "] = wRec." + field.useUpperName() + ";");
            }
            for (j = 0; j < proc.outputs.size(); ++j) {
                field = proc.outputs.elementAt(j);
                if (proc.hasInput(field.name)) continue;
                if (field.isNull) {
                    outData.println(this.indent(4) + "if (wRec." + field.useUpperName() + "IsNull == true)");
                    outData.println(this.indent(4) + "{");
                    outData.println(this.indent(5) + "wRow[c" + field.useUpperName() + "] = DBNull.Value;");
                    outData.println(this.indent(4) + "}");
                    outData.println(this.indent(4) + "else");
                    outData.println(this.indent(4) + "{");
                    outData.println(this.indent(5) + "wRow[c" + field.useUpperName() + "] = wRec." + field.useUpperName() + ";");
                    outData.println(this.indent(4) + "}");
                    continue;
                }
                outData.println(this.indent(4) + "wRow[c" + field.useUpperName() + "] = wRec." + field.useUpperName() + ";");
            }
            outData.println(this.indent(4) + "Rows.Add(wRow);");
            outData.println(this.indent(3) + "}");
            outData.println(this.indent(2) + "}");
            outData.println(this.indent(2) + "public RowBag GetRowBag(int row)");
            outData.println(this.indent(2) + "{");
            outData.println(this.indent(3) + "DataRow wRow = Rows[row];");
            if (this.useGenerics) {
                outData.println(this.indent(3) + "return dictionary[wRow];");
            } else {
                outData.println(this.indent(3) + "return (RowBag)dictionary[wRow];");
            }
            outData.println(this.indent(2) + "}");
            outData.println(this.indent(2) + "public " + mainName + "Rec this[int row]");
            outData.println(this.indent(2) + "{");
            outData.println(this.indent(3) + "get");
            outData.println(this.indent(3) + "{");
            outData.println(this.indent(4) + "DataRow wRow = Rows[row];");
            outData.println(this.indent(4) + mainName + "Rec wRec = new " + mainName + "Rec();");
            for (j = 0; j < proc.inputs.size(); ++j) {
                field = proc.inputs.elementAt(j);
                if (field.isNull) {
                    outData.println(this.indent(4) + "if (wRow.IsNull(c" + field.useUpperName() + "))");
                    outData.println(this.indent(4) + "{");
                    outData.println(this.indent(5) + "wRec." + field.useUpperName() + "IsNull = true;");
                    outData.println(this.indent(4) + "}");
                    outData.println(this.indent(4) + "else");
                    outData.println(this.indent(4) + "{");
                    outData.println(this.indent(5) + "wRec." + field.useUpperName() + " = " + this.fieldCast(field) + "wRow[c" + field.useUpperName() + "];");
                    outData.println(this.indent(4) + "}");
                    continue;
                }
                outData.println(this.indent(5) + "wRec." + field.useUpperName() + " = " + this.fieldCast(field) + "wRow[c" + field.useUpperName() + "];");
            }
            for (j = 0; j < proc.outputs.size(); ++j) {
                field = proc.outputs.elementAt(j);
                if (proc.hasInput(field.name)) continue;
                if (field.isNull) {
                    outData.println(this.indent(4) + "if (wRow.IsNull(c" + field.useUpperName() + "))");
                    outData.println(this.indent(4) + "{");
                    outData.println(this.indent(5) + "wRec." + field.useUpperName() + "IsNull = true;");
                    outData.println(this.indent(4) + "}");
                    outData.println(this.indent(4) + "else");
                    outData.println(this.indent(4) + "{");
                    outData.println(this.indent(5) + "wRec." + field.useUpperName() + " = " + this.fieldCast(field) + "wRow[c" + field.useUpperName() + "];");
                    outData.println(this.indent(4) + "}");
                    continue;
                }
                outData.println(this.indent(4) + "wRec." + field.useUpperName() + " = " + this.fieldCast(field) + "wRow[c" + field.useUpperName() + "];");
            }
            outData.println(this.indent(4) + "return wRec;");
            outData.println(this.indent(3) + "}");
            outData.println(this.indent(3) + "set");
            outData.println(this.indent(3) + "{");
            outData.println(this.indent(4) + "DataRow wRow = Rows[row];");
            for (j = 0; j < proc.inputs.size(); ++j) {
                field = proc.inputs.elementAt(j);
                if (field.isNull) {
                    outData.println(this.indent(4) + "if (value." + field.useUpperName() + "IsNull == true)");
                    outData.println(this.indent(4) + "{");
                    outData.println(this.indent(5) + "wRow[c" + field.useUpperName() + "] = DBNull.Value;");
                    outData.println(this.indent(4) + "}");
                    outData.println(this.indent(4) + "else");
                    outData.println(this.indent(4) + "{");
                    outData.println(this.indent(5) + "wRow[c" + field.useUpperName() + "] = value." + field.useUpperName() + ";");
                    outData.println(this.indent(4) + "}");
                    continue;
                }
                outData.println(this.indent(4) + "wRow[c" + field.useUpperName() + "] = value." + field.useUpperName() + ";");
            }
            for (j = 0; j < proc.outputs.size(); ++j) {
                field = proc.outputs.elementAt(j);
                if (proc.hasInput(field.name)) continue;
                if (field.isNull) {
                    outData.println(this.indent(4) + "if (value." + field.useUpperName() + "IsNull == true)");
                    outData.println(this.indent(4) + "{");
                    outData.println(this.indent(5) + "wRow[c" + field.useUpperName() + "] = DBNull.Value;");
                    outData.println(this.indent(4) + "}");
                    outData.println(this.indent(4) + "else");
                    outData.println(this.indent(4) + "{");
                    outData.println(this.indent(5) + "wRow[c" + field.useUpperName() + "] = value." + field.useUpperName() + ";");
                    outData.println(this.indent(4) + "}");
                    continue;
                }
                outData.println(this.indent(4) + "wRow[c" + field.useUpperName() + "] = value." + field.useUpperName() + ";");
            }
            outData.println(this.indent(3) + "}");
            outData.println(this.indent(2) + "}");
            outData.println(this.indent(1) + "}");
        }
        if (hasDataTables && this.usePartials && this.useSeparate) {
            int i;
            String mainName = table.useName();
            outData.println(this.indent(1) + "public partial class " + mainName);
            outData.println(this.indent(1) + "{");
            for (i = 0; i < table.procs.size(); ++i) {
                Proc proc = table.procs.elementAt(i);
                if (proc.isData || !proc.isStd || this.noDatatables || proc.outputs.size() <= 0 || proc.isSingle) continue;
                this.generateFetchProcDataTables(proc, mainName, outData);
            }
            outData.println(this.indent(1) + "}");
            for (i = 0; i < table.procs.size(); ++i) {
                Proc proc = table.procs.elementAt(i);
                if (proc.isData || proc.isStd || proc.outputs.size() <= 0 || proc.isSingle) continue;
                mainName = table.useName() + proc.upperFirst();
                outData.println(this.indent(1) + "public partial class " + mainName);
                outData.println(this.indent(1) + "{");
                if (!this.noDatatables) {
                    this.generateFetchProcDataTables(proc, mainName, outData);
                }
                outData.println(this.indent(1) + "}");
            }
        }
    }

    public void generateStructPairs(Proc proc, Vector<Field> fields, Vector<?> dynamics, String mainName, PrintWriter outData, String tableName, boolean hasReturning) {
        outData.println(this.indent(1) + "[Serializable()]");
        String inherit = "";
        inherit = proc != null && proc.extendsStd ? " : " + tableName + "Rec" + (this.useNotify ? ", INotifyPropertyChanged" : "") : (this.useNotify ? " : INotifyPropertyChanged" : "");
        outData.println(this.indent(1) + "public " + (this.usePartials ? "partial " : "") + "class " + mainName + "Rec" + inherit);
        outData.println(this.indent(1) + "{");
        if (this.useNotify && fields.size() > 0) {
            outData.println(this.indent(2) + "#region INotifyPropertyChanged Members ");
            outData.println("");
            outData.println(this.indent(2) + "public event PropertyChangedEventHandler PropertyChanged;");
            outData.println("");
            outData.println(this.indent(2) + "public void NotifyPropertyChanged([CallerMemberName] string propertyName = null)");
            outData.println(this.indent(2) + "{");
            outData.println(this.indent(3) + "if (this.PropertyChanged != null)");
            outData.println(this.indent(3) + "{");
            outData.println(this.indent(4) + "this.PropertyChanged(this, new PropertyChangedEventArgs(propertyName));");
            outData.println(this.indent(3) + "}");
            outData.println(this.indent(2) + "}");
            outData.println("");
            outData.println(this.indent(2) + "#endregion");
            outData.println("");
        }
        for (int i = 0; i < fields.size(); ++i) {
            Field field = fields.elementAt(i);
            String temp = "[Column(MaxLength=" + field.length;
            if (field.precision > 0) {
                temp = "[Column(MaxLength=" + field.precision + field.scale + 1;
            }
            if (field.isNull) {
                temp = temp + ", CanBeNull=true";
            }
            if (field.isPrimaryKey) {
                temp = temp + ", IsPrimaryKey=true";
            }
            if (field.isSequence) {
                temp = temp + ", isSequence=true";
            }
            if (field.precision > 0) {
                temp = temp + ", Precision=" + field.precision + ", Scale=" + field.scale;
            }
            outData.println(this.fieldDef(field, temp));
            if (!field.isNull) continue;
            if (this.getDataType(field, new StringBuffer(), new StringBuffer()) == "string") {
                outData.println(this.indent(2) + "private bool " + field.useLowerName() + "IsNull;");
                outData.println(this.indent(2) + "public bool " + field.useUpperName() + "IsNull");
                outData.println(this.indent(2) + "{");
                outData.println(this.indent(3) + "get { return this." + field.useLowerName() + " == null ? true : " + field.useLowerName() + "IsNull; }");
                outData.println(this.indent(3) + "set { this." + field.useLowerName() + "IsNull = value; }");
                outData.println(this.indent(2) + "}");
                continue;
            }
            outData.println(this.indent(2) + "private bool " + field.useLowerName() + "IsNull;");
            outData.println(this.indent(2) + "public bool " + field.useUpperName() + "IsNull");
            outData.println(this.indent(2) + "{ ");
            outData.println(this.indent(3) + "get { return this." + field.useLowerName() + "IsNull; }");
            outData.println(this.indent(3) + "set { this." + field.useLowerName() + "IsNull = value; }");
            outData.println(this.indent(2) + "}");
        }
        outData.println(this.indent(1) + "}");
    }

    public void generateEnumOrdinals(Table table, PrintWriter outData) {
        for (int i = 0; i < table.fields.size(); ++i) {
            String evalue;
            Enum en;
            int j;
            Field field = table.fields.elementAt(i);
            if (field.enums.size() <= 0) continue;
            outData.println(this.indent(1) + "public class " + table.useName() + field.useUpperName() + "Ord");
            outData.println(this.indent(1) + "{");
            String datatype = "int";
            if (field.type == 21 && field.length == 1) {
                datatype = "string";
            }
            for (j = 0; j < field.enums.size(); ++j) {
                en = field.enums.elementAt(j);
                evalue = "" + en.value;
                if (field.type == 21 && field.length == 1) {
                    evalue = "\"" + (char)en.value + "\"";
                }
                outData.println(this.indent(2) + "public const " + datatype + " " + en.name + " = " + evalue + ";");
            }
            outData.println(this.indent(2) + "public static string ToString(" + datatype + " ordinal)");
            outData.println(this.indent(2) + "{");
            outData.println(this.indent(3) + "switch (ordinal)");
            outData.println(this.indent(3) + "{");
            for (j = 0; j < field.enums.size(); ++j) {
                en = field.enums.elementAt(j);
                evalue = "" + en.value;
                if (field.type == 21 && field.length == 1) {
                    evalue = "\"" + (char)en.value + "\"";
                }
                outData.println(this.indent(4) + "case " + evalue + ": return \"" + en.name + "\";");
            }
            outData.println(this.indent(3) + "}");
            outData.println(this.indent(3) + "return \"unknown ordinal: \"+ordinal;");
            outData.println(this.indent(2) + "}");
            outData.println(this.indent(1) + "}");
        }
    }

    public void generateStructs(Table table, PrintWriter outData) {
        if (table.fields.size() > 0) {
            Proc proc;
            int i;
            if (table.comments.size() > 0) {
                outData.println(this.indent(1) + "/// <summary>");
                for (int i2 = 0; i2 < table.comments.size(); ++i2) {
                    String s2 = table.comments.elementAt(i2);
                    outData.println(this.indent(1) + "/// " + s2);
                }
                outData.println(this.indent(1) + "/// </summary>");
            }
            boolean hasReturning = false;
            for (i = 0; i < table.procs.size(); ++i) {
                proc = table.procs.elementAt(i);
                if (!proc.hasReturning || !proc.isStd) continue;
                hasReturning = true;
                break;
            }
            this.generateStructPairs(null, table.fields, null, table.useName(), outData, null, hasReturning);
            this.generateEnumOrdinals(table, outData);
            for (i = 0; i < table.procs.size(); ++i) {
                int j;
                proc = table.procs.elementAt(i);
                if (proc.isData || proc.isStd || proc.hasNoData()) continue;
                if (proc.comments.size() > 0) {
                    outData.println(this.indent(1) + "/// <summary>");
                    for (int j2 = 0; j2 < proc.comments.size(); ++j2) {
                        String s3 = proc.comments.elementAt(j2);
                        outData.println(this.indent(1) + "/// " + s3);
                    }
                    outData.println(this.indent(1) + "/// </summary>");
                }
                Vector<Field> fields = new Vector<Field>();
                if (!proc.extendsStd) {
                    for (int j3 = 0; j3 < proc.outputs.size(); ++j3) {
                        fields.addElement(proc.outputs.elementAt(j3));
                    }
                }
                for (j = 0; j < proc.inputs.size(); ++j) {
                    Field field = proc.inputs.elementAt(j);
                    if (proc.hasOutput(field.name) && !field.isExtStd) continue;
                    fields.addElement(field);
                }
                for (j = 0; j < proc.dynamics.size(); ++j) {
                    String s4 = proc.dynamics.elementAt(j);
                    Integer n = proc.dynamicSizes.elementAt(j);
                    Field field = new Field();
                    field.name = s4;
                    field.type = (byte)8;
                    field.length = n;
                    fields.addElement(field);
                }
                this.generateStructPairs(proc, fields, proc.dynamics, table.useName() + proc.upperFirst(), outData, table.useName(), false);
            }
        }
    }

    public void generateCode(Table table, PrintWriter outData) {
        Proc proc;
        int i;
        boolean firsttime = true;
        boolean isLoaded = true;
        for (i = 0; i < table.procs.size(); ++i) {
            proc = table.procs.elementAt(i);
            if (proc.isData || !proc.isStd) continue;
            this.generateStdCode(table, proc, outData, firsttime, isLoaded);
            if (proc.outputs.size() > 0 && !proc.isSingle) {
                isLoaded = false;
            }
            firsttime = false;
        }
        if (!firsttime) {
            outData.println(this.indent(1) + "}");
        }
        for (i = 0; i < table.procs.size(); ++i) {
            proc = table.procs.elementAt(i);
            if (proc.isData || proc.isStd) continue;
            this.generateCode(table, proc, outData);
        }
    }

    void generateStoredProc(Proc proc, String storedProcName, Vector<?> lines) {
        int i;
        this.procData.println("IF OBJECT_ID('dbo." + storedProcName + "','P') IS NOT NULL");
        this.procData.println(this.indent(1) + "DROP PROCEDURE dbo." + storedProcName);
        this.procData.println("GO");
        this.procData.println("");
        this.procData.println("CREATE PROCEDURE dbo." + storedProcName);
        String comma = "(";
        for (i = 0; i < this.placeHolder.pairs.size(); ++i) {
            PlaceHolderPairs pair = this.placeHolder.pairs.elementAt(i);
            Field field = pair.field;
            this.procData.println(comma + " @P" + i + " " + this.varType(field) + " -- " + field.name);
            comma = ",";
        }
        if (this.placeHolder.pairs.size() > 0) {
            this.procData.println(")");
        }
        this.procData.println("AS");
        for (i = 0; i < lines.size(); ++i) {
            String line = (String)lines.elementAt(i);
            this.procData.println(line.substring(1, line.length() - 1));
        }
        if (proc.isInsert && proc.hasReturning && proc.table.hasIdentity) {
            this.procData.println("; SELECT CAST(SCOPE_IDENTITY() AS INT)");
        }
        this.procData.println("GO");
        this.procData.println("");
    }

    void generateStoredProcCommand(Proc proc, PrintWriter outData) {
        this.placeHolder = new PlaceHolder(proc, this.CSNetCodeOutputOptions, 2, "");
        String storedProcName = proc.table.useName() + proc.upperFirst();
        Vector<String> lines = this.placeHolder.getLines();
        this.generateStoredProc(proc, storedProcName, lines);
        outData.println(this.indent(2) + "public string Command" + proc.upperFirst() + "()");
        outData.println(this.indent(2) + "{");
        for (int i = 0; i < lines.size(); ++i) {
            String line = lines.elementAt(i);
            outData.println(this.indent(3) + "// " + line.substring(1, line.length() - 1));
        }
        outData.println(this.indent(3) + "return \"" + storedProcName + "\";");
        outData.println(this.indent(2) + "}");
    }

    void generateCommand(Proc proc, PrintWriter outData) {
        if (proc.hasReturning) {
            this.placeHolder = new PlaceHolder(proc, this.CSNetCodeOutputOptions, 3, "");
            outData.println(this.indent(2) + "public string Command" + proc.upperFirst() + "(JConnect aConnect, string aTable, string aField)");
        } else {
            this.placeHolder = new PlaceHolder(proc, this.CSNetCodeOutputOptions, 3, "Rec.");
            outData.println(this.indent(2) + "public string Command" + proc.upperFirst() + "()");
        }
        Vector<String> lines = this.placeHolder.getLines();
        outData.println(this.indent(2) + "{");
        if (proc.hasReturning) {
            outData.println(this.indent(3) + "Returning _ret = new Returning(aConnect.TypeOfVendor, aTable, aField);");
        }
        outData.println(this.indent(3) + "return ");
        String plus = this.indent(4);
        for (int i = 0; i < lines.size(); ++i) {
            String line = lines.elementAt(i);
            outData.println(plus + line);
            plus = this.indent(4) + "+ ";
        }
        outData.println(this.indent(4) + ";");
        outData.println(this.indent(2) + "}");
    }

    void generateNonQueryProc(Proc proc, String mainName, PrintWriter outData) {
        int i;
        Field identity = null;
        for (i = 0; i < proc.table.fields.size(); ++i) {
            Field field = proc.table.fields.elementAt(i);
            if (!field.isPrimaryKey) continue;
            identity = field;
            break;
        }
        if (proc.hasReturning) {
            outData.println(this.indent(2) + "public bool " + proc.upperFirst() + "(JConnect aConnect)");
        } else {
            outData.println(this.indent(2) + "public void " + proc.upperFirst() + "(JConnect aConnect)");
        }
        outData.println(this.indent(2) + "{");
        outData.println(this.indent(3) + "using (JCursor wCursor = new JCursor(aConnect))");
        outData.println(this.indent(3) + "{");
        if (this.doMSSqlStoredProcs(proc)) {
            outData.println(this.indent(4) + "wCursor.Procedure(Command" + proc.upperFirst() + "());");
        } else {
            if (this.placeHolder.pairs.size() > 0) {
                outData.println(this.indent(4) + "// format command to change {n} to ?, @Pn or :Pn placeholders depending on Vendor");
            }
            outData.println(this.indent(4) + "wCursor.Format(Command" + proc.upperFirst() + "(" + this.returning(proc) + "), " + this.placeHolder.pairs.size() + ");");
        }
        for (i = 0; i < this.placeHolder.pairs.size(); ++i) {
            PlaceHolderPairs pair = this.placeHolder.pairs.elementAt(i);
            Field field = pair.field;
            String member = "";
            if (field.type == 1) {
                member = ".getBlob()";
            }
            String tail = "";
            if (field.isNull) {
                tail = ", mRec." + field.useUpperName() + "IsNull";
            }
            if (proc.isInsert && field.isSequence) {
                outData.println(this.indent(4) + "var " + field.useLowerName() + " = mRec." + field.useUpperName() + ";");
                outData.println(this.indent(4) + "wCursor.Parameter(" + i + ", wCursor.GetSequence(\"" + proc.table.name + "\",\"" + field.name + "\", ref " + field.useLowerName() + "));");
                outData.println(this.indent(4) + "mRec." + field.useUpperName() + " = " + field.useLowerName() + ";");
                continue;
            }
            if (field.type == 18) {
                outData.println(this.indent(4) + "var " + field.useLowerName() + i + " = mRec." + field.useUpperName() + ";");
                outData.println(this.indent(4) + "wCursor.Parameter(" + i + ", wCursor.GetTimeStamp(ref " + field.useLowerName() + i + "));");
                outData.println(this.indent(4) + "mRec." + field.useUpperName() + " = " + field.useLowerName() + i + ";");
                continue;
            }
            if (field.type == 20) {
                outData.println(this.indent(4) + "var " + field.useLowerName() + i + " = mRec." + field.useUpperName() + ";");
                outData.println(this.indent(4) + "wCursor.Parameter(" + i + ", wCursor.GetUserStamp(ref " + field.useLowerName() + i + "));");
                outData.println(this.indent(4) + "mRec." + field.useUpperName() + " = " + field.useLowerName() + i + ";");
                continue;
            }
            outData.println(this.indent(4) + "wCursor.Parameter(" + i + ", mRec." + field.useUpperName() + member + tail + ");");
        }
        if (proc.hasReturning) {
            outData.println(this.indent(4) + "wCursor.Run();");
            outData.println(this.indent(4) + "bool wResult = (wCursor.HasReader() && wCursor.Read());");
            outData.println(this.indent(4) + "if (wResult == true)");
            outData.println(this.indent(4) + "{");
            if (identity.isNull && this.getDataType(identity, new StringBuffer(), new StringBuffer()) == "string") {
                outData.println(this.indent(5) + "var " + identity.useLowerName() + "IsNull = mRec." + identity.useUpperName() + "IsNull;");
                outData.println(this.indent(5) + "mRec." + identity.useUpperName() + " = " + this.castOf(identity) + "wCursor.GetString(0, out " + identity.useLowerName() + "IsNull);");
                outData.println(this.indent(5) + "mRec." + identity.useUpperName() + "IsNull = " + identity.useLowerName() + "IsNull;");
            } else if (identity.isNull) {
                outData.println(this.indent(5) + "var " + identity.useLowerName() + "IsNull = mRec." + identity.useUpperName() + "IsNull;");
                outData.println(this.indent(5) + "mRec." + identity.useUpperName() + " = " + this.castOf(identity) + "wCursor." + this.cursorGet(identity, 0) + ";");
                outData.println(this.indent(5) + "mRec." + identity.useUpperName() + "IsNull = " + identity.useLowerName() + "IsNull;");
            } else {
                outData.println(this.indent(5) + "mRec." + identity.useUpperName() + " = " + this.castOf(identity) + "wCursor." + this.cursorGet(identity, 0) + ";");
            }
            outData.println(this.indent(4) + "}");
            outData.println(this.indent(4) + "if (wCursor.HasReader())");
            outData.println(this.indent(4) + "{");
            outData.println(this.indent(5) + "wCursor.Close();");
            outData.println(this.indent(4) + "}");
            outData.println(this.indent(4) + "return wResult;");
            outData.println(this.indent(3) + "}");
            outData.println(this.indent(2) + "}");
        } else {
            outData.println(this.indent(4) + "wCursor.Exec();");
            outData.println(this.indent(3) + "}");
            outData.println(this.indent(2) + "}");
        }
    }

    void generateFunc(Proc proc, String mainName, PrintWriter outData) {
        Field field;
        Integer n;
        String s2;
        int j;
        String line;
        String result;
        StringBuffer temp2;
        StringBuffer maker;
        Field field2;
        int i;
        String input = "";
        String postfix = "";
        boolean isLoaded = false;
        int ind = 0;
        String placeHolder = "";
        if (proc.outputs.size() > 0 && !proc.isSingle && !proc.isInsert) {
            isLoaded = true;
        }
        for (i = 0; i < proc.inputs.size(); ++i) {
            field2 = proc.inputs.elementAt(i);
            if (!field2.isPrimaryKey && !proc.updateFields.contains(field2.name)) continue;
            maker = new StringBuffer();
            temp2 = new StringBuffer();
            result = this.returnNullableDataType(field2, maker, temp2);
            line = ", ";
            input = input + line + result + " " + field2.useLowerName();
        }
        for (i = 0; i < proc.inputs.size(); ++i) {
            field2 = proc.inputs.elementAt(i);
            if (field2.isExtStdOut || field2.type == 18 || field2.type == 20 || field2.isPrimaryKey || proc.updateFields.contains(field2.name)) continue;
            maker = new StringBuffer();
            temp2 = new StringBuffer();
            result = this.returnNullableDataType(field2, maker, temp2);
            line = ", ";
            input = input + line + result + " " + field2.useLowerName();
        }
        for (j = 0; j < proc.dynamics.size(); ++j) {
            s2 = proc.dynamics.elementAt(j);
            n = proc.dynamicSizes.elementAt(j);
            field = new Field();
            field.name = s2;
            field.type = (byte)8;
            field.length = n;
            line = ", ";
            input = input + line + "string " + field.useLowerName();
        }
        if ((input = input + ")").equals(")")) {
            postfix = "Struct";
        }
        if (proc.isSingle) {
            outData.println(this.indent(2) + "public " + mainName + "Rec " + proc.upperFirst() + postfix + "(JConnect aConnect" + input);
        } else if (!isLoaded) {
            if (proc.isMultipleInput) {
                outData.println(this.indent(2) + "public void " + proc.upperFirst() + postfix + "(JConnect aConnect, List<" + mainName + "Rec> aList)");
            } else {
                outData.println(this.indent(2) + "public void " + proc.upperFirst() + postfix + "(JConnect aConnect" + input);
            }
        } else if (proc.hasReturning) {
            outData.println(this.indent(2) + "public bool " + proc.upperFirst() + postfix + "(JConnect aConnect" + input);
        } else {
            outData.println(this.indent(2) + "public List<" + mainName + "Rec> " + proc.upperFirst() + postfix + "(JConnect aConnect" + input);
        }
        outData.println(this.indent(2) + "{");
        if (proc.isMultipleInput) {
            outData.println(this.indent(3) + "foreach (var item in aList)");
            outData.println(this.indent(3) + "{");
            placeHolder = "item.";
            ind = 1;
        }
        for (i = 0; i < proc.inputs.size(); ++i) {
            field2 = proc.inputs.elementAt(i);
            if (field2.isExtStdOut || field2.type == 18 || field2.type == 20) continue;
            placeHolder = field2.useLowerName();
            if (proc.isMultipleInput) {
                placeHolder = "item." + field2.useUpperName();
            }
            if (field2.isNull && this.getNullableType(field2)) {
                outData.println(this.indent(3 + ind) + "if (" + placeHolder + ".HasValue)");
                outData.println(this.indent(3 + ind) + "{");
                outData.println(this.indent(4 + ind) + "mRec." + field2.useUpperName() + " = " + placeHolder + ".Value;");
                outData.println(this.indent(3 + ind) + "}");
                outData.println(this.indent(3 + ind) + "mRec." + field2.useUpperName() + "IsNull = !" + placeHolder + ".HasValue;");
                continue;
            }
            outData.println(this.indent(3 + ind) + "mRec." + field2.useUpperName() + " = " + placeHolder + ";");
        }
        for (j = 0; j < proc.dynamics.size(); ++j) {
            s2 = proc.dynamics.elementAt(j);
            n = proc.dynamicSizes.elementAt(j);
            field = new Field();
            field.name = s2;
            field.type = (byte)8;
            field.length = n;
            line = ", ";
            if (proc.isMultipleInput) {
                outData.println(this.indent(3 + ind) + "mRec." + field.useUpperName() + " = item." + field.useUpperName() + ";");
                continue;
            }
            outData.println(this.indent(3 + ind) + "mRec." + field.useUpperName() + " = " + field.useLowerName() + ";");
        }
        if (proc.isSingle) {
            outData.println(this.indent(3) + "if (" + proc.upperFirst() + "(aConnect))");
            outData.println(this.indent(3) + "{");
            outData.println(this.indent(4) + "return mRec;");
            outData.println(this.indent(3) + "}");
            outData.println(this.indent(3) + "else");
            outData.println(this.indent(3) + "{");
            outData.println(this.indent(4) + "return null;");
            outData.println(this.indent(3) + "}");
            outData.println(this.indent(2) + "}");
        } else if (!isLoaded) {
            outData.println(this.indent(3 + ind) + proc.upperFirst() + "(aConnect);");
            if (proc.isMultipleInput) {
                outData.println(this.indent(3) + "}");
            }
            outData.println(this.indent(2) + "}");
        } else if (proc.hasReturning) {
            outData.println(this.indent(3) + "return " + proc.upperFirst() + "(aConnect);");
            outData.println(this.indent(2) + "}");
        } else {
            outData.println(this.indent(3) + proc.upperFirst() + "Load(aConnect);");
            outData.println(this.indent(3) + "return Loaded;");
            outData.println(this.indent(2) + "}");
        }
    }

    void generateReturningProc(Proc proc, String mainName, PrintWriter outData) {
        int i;
        Field identity = null;
        for (i = 0; i < proc.table.fields.size(); ++i) {
            Field field = proc.table.fields.elementAt(i);
            if (!field.isSequence) continue;
            identity = field;
            break;
        }
        if (identity == null) {
            this.generateNonQueryProc(proc, mainName, outData);
            return;
        }
        outData.println(this.indent(2) + "public bool " + proc.upperFirst() + "(JConnect aConnect)");
        outData.println(this.indent(2) + "{");
        outData.println(this.indent(3) + "using (JCursor wCursor = new JCursor(aConnect))");
        outData.println(this.indent(3) + "{");
        if (this.doMSSqlStoredProcs(proc)) {
            outData.println(this.indent(4) + "wCursor.Procedure(Command" + proc.upperFirst() + "());");
        } else {
            if (this.placeHolder.pairs.size() > 0) {
                outData.println(this.indent(4) + "// format command to change {n} to ?, @Pn or :Pn placeholders depending on Vendor");
            }
            outData.println(this.indent(4) + "wCursor.Format(Command" + proc.upperFirst() + "(" + this.returning(proc) + "), " + this.placeHolder.pairs.size() + ");");
        }
        for (i = 0; i < this.placeHolder.pairs.size(); ++i) {
            PlaceHolderPairs pair = this.placeHolder.pairs.elementAt(i);
            Field field = pair.field;
            String member = "";
            if (field.type == 1) {
                member = ".getBlob()";
            }
            String tail = "";
            if (field.isNull) {
                tail = ", mRec." + field.useUpperName() + "IsNull";
            }
            if (field.type == 18) {
                outData.println(this.indent(4) + "var " + field.useLowerName() + i + " = mRec." + field.useUpperName() + ";");
                outData.println(this.indent(4) + "wCursor.Parameter(" + i + ", wCursor.GetTimeStamp(ref " + field.useLowerName() + i + "));");
                outData.println(this.indent(4) + "mRec." + field.useUpperName() + " = " + field.useLowerName() + i + ";");
                continue;
            }
            if (field.type == 20) {
                outData.println(this.indent(4) + "var " + field.useLowerName() + i + " = mRec." + field.useUpperName() + ";");
                outData.println(this.indent(4) + "wCursor.Parameter(" + i + ", wCursor.GetUserStamp(ref " + field.useLowerName() + i + "));");
                outData.println(this.indent(4) + "mRec." + field.useUpperName() + " = " + field.useLowerName() + i + ";");
                continue;
            }
            outData.println(this.indent(4) + "wCursor.Parameter(" + i + ", mRec." + field.useUpperName() + member + tail + ");");
        }
        outData.println(this.indent(4) + "wCursor.Run();");
        outData.println(this.indent(4) + "bool wResult = (wCursor.HasReader() && wCursor.Read());");
        outData.println(this.indent(4) + "if (wResult == true)");
        outData.println(this.indent(4) + "{");
        if (identity.isNull && this.getDataType(identity, new StringBuffer(), new StringBuffer()) == "string") {
            outData.println(this.indent(5) + "var " + identity.useLowerName() + "IsNull = mRec." + identity.useUpperName() + "IsNull;");
            outData.println(this.indent(5) + "mRec." + identity.useUpperName() + " = " + this.castOf(identity) + "wCursor.GetString(0, out " + identity.useLowerName() + "IsNull);");
            outData.println(this.indent(5) + "mRec." + identity.useUpperName() + "IsNull = " + identity.useLowerName() + "IsNull;");
        } else if (identity.isNull) {
            outData.println(this.indent(4) + "var " + identity.useLowerName() + "IsNull = mRec." + identity.useUpperName() + "IsNull;");
            outData.println(this.indent(4) + "mRec." + identity.useUpperName() + " = " + this.castOf(identity) + "wCursor." + this.cursorGet(identity, 0) + ";");
            outData.println(this.indent(4) + "mRec." + identity.useUpperName() + "IsNull = " + identity.useLowerName() + "IsNull;");
        } else {
            outData.println(this.indent(5) + "mRec." + identity.useUpperName() + " = " + this.castOf(identity) + "wCursor." + this.cursorGet(identity, 0) + ";");
        }
        outData.println(this.indent(4) + "}");
        outData.println(this.indent(4) + "if (wCursor.HasReader())");
        outData.println(this.indent(4) + "{");
        outData.println(this.indent(5) + "wCursor.Close();");
        outData.println(this.indent(4) + "}");
        outData.println(this.indent(4) + "return wResult;");
        outData.println(this.indent(3) + "}");
        outData.println(this.indent(2) + "}");
    }

    void generateReadOneProc(Proc proc, String mainName, PrintWriter outData) {
        int i;
        outData.println(this.indent(2) + "public bool " + proc.upperFirst() + "(JConnect aConnect)");
        outData.println(this.indent(2) + "{");
        outData.println(this.indent(3) + "using (JCursor wCursor = new JCursor(aConnect))");
        outData.println(this.indent(3) + "{");
        if (this.doMSSqlStoredProcs(proc)) {
            outData.println(this.indent(4) + "wCursor.Procedure(Command" + proc.upperFirst() + "());");
        } else {
            if (this.placeHolder.pairs.size() > 0) {
                outData.println(this.indent(4) + "// format command to change {n} to ?, @Pn or :Pn placeholders depending on Vendor");
            }
            outData.println(this.indent(4) + "wCursor.Format(Command" + proc.upperFirst() + "(" + this.returning(proc) + "), " + this.placeHolder.pairs.size() + ");");
        }
        for (i = 0; i < this.placeHolder.pairs.size(); ++i) {
            PlaceHolderPairs pair = this.placeHolder.pairs.elementAt(i);
            Field field = pair.field;
            String member = "";
            if (field.type == 1) {
                member = ".getBlob()";
            }
            String tail = "";
            if (field.isNull) {
                tail = ", mRec." + field.useUpperName() + "IsNull";
            }
            if (field.type == 18) {
                outData.println(this.indent(4) + "var " + field.useLowerName() + i + " = mRec." + field.useUpperName() + ";");
                outData.println(this.indent(4) + "wCursor.Parameter(" + i + ", wCursor.GetTimeStamp(ref " + field.useLowerName() + i + "));");
                outData.println(this.indent(4) + "mRec." + field.useUpperName() + " = " + field.useLowerName() + i + ";");
                continue;
            }
            if (field.type == 20) {
                outData.println(this.indent(4) + "var " + field.useLowerName() + i + " = mRec." + field.useUpperName() + ";");
                outData.println(this.indent(4) + "wCursor.Parameter(" + i + ", wCursor.GetUserStamp(ref " + field.useLowerName() + i + "));");
                outData.println(this.indent(4) + "mRec." + field.useUpperName() + " = " + field.useLowerName() + i + ";");
                continue;
            }
            outData.println(this.indent(4) + "wCursor.Parameter(" + i + ", mRec." + field.useUpperName() + member + tail + ");");
        }
        outData.println(this.indent(4) + "wCursor.Run();");
        outData.println(this.indent(4) + "bool wResult = (wCursor.HasReader() && wCursor.Read());");
        outData.println(this.indent(4) + "if (wResult == true)");
        outData.println(this.indent(4) + "{");
        for (i = 0; i < proc.outputs.size(); ++i) {
            Field field = proc.outputs.elementAt(i);
            String member = "";
            if (field.type == 1) {
                member = ".Buffer";
            }
            if (field.isNull && this.getDataType(field, new StringBuffer(), new StringBuffer()) == "string") {
                outData.println(this.indent(5) + "var " + field.useLowerName() + "IsNull = mRec." + field.useUpperName() + "IsNull;");
                outData.println(this.indent(5) + "mRec." + field.useUpperName() + member + " = " + this.castOf(field) + "wCursor.GetString(" + i + ", out " + field.useLowerName() + "IsNull);");
                outData.println(this.indent(5) + "mRec." + field.useUpperName() + "IsNull = " + field.useLowerName() + "IsNull;");
                continue;
            }
            if (field.isNull) {
                outData.println(this.indent(5) + "var " + field.useLowerName() + "IsNull = mRec." + field.useUpperName() + "IsNull;");
                outData.println(this.indent(5) + "mRec." + field.useUpperName() + member + " = " + this.castOf(field) + "wCursor." + this.cursorGet(field, i) + ";");
                outData.println(this.indent(5) + "mRec." + field.useUpperName() + "IsNull = " + field.useLowerName() + "IsNull;");
                continue;
            }
            outData.println(this.indent(5) + "mRec." + field.useUpperName() + member + " = " + this.castOf(field) + "wCursor." + this.cursorGet(field, i) + ";");
        }
        outData.println(this.indent(4) + "}");
        outData.println(this.indent(4) + "if (wCursor.HasReader())");
        outData.println(this.indent(4) + "{");
        outData.println(this.indent(5) + "wCursor.Close();");
        outData.println(this.indent(4) + "}");
        outData.println(this.indent(4) + "return wResult;");
        outData.println(this.indent(3) + "}");
        outData.println(this.indent(2) + "}");
    }

    String returning(Proc proc) {
        if (!proc.hasReturning) {
            return "";
        }
        String tableName = proc.table.useName();
        String fieldName = "";
        for (int i = 0; i < proc.table.fields.size(); ++i) {
            Field field = proc.table.fields.elementAt(i);
            if (!field.isSequence) continue;
            fieldName = field.useName();
            break;
        }
        return "aConnect, \"" + tableName + "\", \"" + fieldName + "\"";
    }

    void generateFetchProc(Proc proc, String mainName, PrintWriter outData, boolean isLoaded) {
        int i;
        Field field;
        int i2;
        outData.println(this.indent(2) + "private void " + proc.upperFirst() + "(JConnect aConnect)");
        outData.println(this.indent(2) + "{");
        if (this.doMSSqlStoredProcs(proc)) {
            outData.println(this.indent(3) + "mCursor.Procedure(Command" + proc.upperFirst() + "());");
        } else {
            if (this.placeHolder.pairs.size() > 0) {
                outData.println(this.indent(3) + "// format command to change {n} to ?, @Pn or :Pn placeholders depending on Vendor");
            }
            outData.println(this.indent(3) + "mCursor.Format(Command" + proc.upperFirst() + "(" + this.returning(proc) + "), " + this.placeHolder.pairs.size() + ");");
        }
        for (i2 = 0; i2 < this.placeHolder.pairs.size(); ++i2) {
            PlaceHolderPairs pair = this.placeHolder.pairs.elementAt(i2);
            field = pair.field;
            String member = "";
            if (field.type == 1) {
                member = ".getBlob()";
            }
            String tail = "";
            if (field.isNull) {
                tail = ", mRec." + field.useUpperName() + "IsNull";
            }
            outData.println(this.indent(3) + "mCursor.Parameter(" + i2 + ", mRec." + field.useUpperName() + member + tail + ");");
        }
        outData.println(this.indent(3) + "mCursor.Run();");
        outData.println(this.indent(2) + "}");
        outData.println(this.indent(2) + "private bool " + proc.upperFirst() + "Fetch()");
        outData.println(this.indent(2) + "{");
        outData.println(this.indent(3) + "bool wResult = (mCursor.HasReader() && mCursor.Read());");
        outData.println(this.indent(3) + "if (wResult == true)");
        outData.println(this.indent(3) + "{");
        for (i2 = 0; i2 < proc.outputs.size(); ++i2) {
            Field field2 = proc.outputs.elementAt(i2);
            String member = "";
            if (field2.type == 1) {
                member = ".Buffer";
            }
            if (field2.isNull && this.getDataType(field2, new StringBuffer(), new StringBuffer()) == "string") {
                outData.println(this.indent(4) + "var " + field2.useLowerName() + "IsNull = mRec." + field2.useUpperName() + "IsNull;");
                outData.println(this.indent(4) + "mRec." + field2.useUpperName() + member + " = " + this.castOf(field2) + "mCursor.GetString(" + i2 + ", out " + field2.useLowerName() + "IsNull);");
                outData.println(this.indent(4) + "mRec." + field2.useUpperName() + "IsNull = " + field2.useLowerName() + "IsNull;");
                continue;
            }
            if (field2.isNull) {
                outData.println(this.indent(4) + "var " + field2.useLowerName() + "IsNull = mRec." + field2.useUpperName() + "IsNull;");
                outData.println(this.indent(4) + "mRec." + field2.useUpperName() + member + " = " + this.castOf(field2) + "mCursor." + this.cursorGet(field2, i2) + ";");
                outData.println(this.indent(4) + "mRec." + field2.useUpperName() + "IsNull = " + field2.useLowerName() + "IsNull;");
                continue;
            }
            outData.println(this.indent(4) + "mRec." + field2.useUpperName() + member + " = " + this.castOf(field2) + "mCursor." + this.cursorGet(field2, i2) + ";");
        }
        outData.println(this.indent(3) + "}");
        outData.println(this.indent(3) + "else if (mCursor.HasReader())");
        outData.println(this.indent(3) + "{");
        outData.println(this.indent(4) + "mCursor.Close();");
        outData.println(this.indent(3) + "}");
        outData.println(this.indent(3) + "return wResult;");
        outData.println(this.indent(2) + "}");
        outData.println(this.indent(2) + "public void " + proc.upperFirst() + "Load(JConnect aConnect)");
        outData.println(this.indent(2) + "{");
        outData.println(this.indent(3) + "using (mCursor = new JCursor(aConnect))");
        outData.println(this.indent(3) + "{");
        outData.println(this.indent(4) + proc.upperFirst() + "(aConnect);");
        outData.println(this.indent(4) + "while (" + proc.upperFirst() + "Fetch())");
        outData.println(this.indent(4) + "{");
        outData.println(this.indent(5) + "mList.Add(mRec);");
        outData.println(this.indent(5) + "mRec = new " + mainName + "Rec();");
        outData.println(this.indent(4) + "}");
        outData.println(this.indent(3) + "}");
        outData.println(this.indent(2) + "}");
        outData.println(this.indent(2) + "public bool " + proc.upperFirst() + "First(JConnect aConnect)");
        outData.println(this.indent(2) + "{");
        outData.println(this.indent(3) + "using (mCursor = new JCursor(aConnect))");
        outData.println(this.indent(3) + "{");
        outData.println(this.indent(4) + proc.upperFirst() + "(aConnect);");
        outData.println(this.indent(4) + "if (" + proc.upperFirst() + "Fetch())");
        outData.println(this.indent(4) + "{");
        outData.println(this.indent(5) + "mCursor.Close();");
        outData.println(this.indent(5) + "return true;");
        outData.println(this.indent(4) + "}");
        outData.println(this.indent(4) + "return false;");
        outData.println(this.indent(3) + "}");
        outData.println(this.indent(2) + "}");
        if (isLoaded) {
            if (this.useGenerics) {
                outData.println(this.indent(2) + "public List<" + mainName + "Rec> Loaded { get { return mList; } }");
            } else {
                outData.println(this.indent(2) + "public ArrayList Loaded { get { return mList; } }");
            }
        }
        outData.println(this.indent(2) + "public class " + proc.upperFirst() + "Ord");
        outData.println(this.indent(2) + "{");
        int noInDataSet = 0;
        for (i = 0; i < proc.inputs.size(); ++i) {
            field = proc.inputs.elementAt(i);
            outData.println(this.indent(3) + "public const int " + field.useUpperName() + " = " + noInDataSet + ";");
            ++noInDataSet;
        }
        for (i = 0; i < proc.outputs.size(); ++i) {
            field = proc.outputs.elementAt(i);
            if (proc.hasInput(field.name)) continue;
            outData.println(this.indent(3) + "public const int " + field.useUpperName() + " = " + noInDataSet + ";");
            ++noInDataSet;
        }
        outData.println(this.indent(3) + "public static string ToString(int ordinal)");
        outData.println(this.indent(3) + "{");
        outData.println(this.indent(4) + "switch (ordinal)");
        outData.println(this.indent(4) + "{");
        noInDataSet = 0;
        for (i = 0; i < proc.inputs.size(); ++i) {
            field = proc.inputs.elementAt(i);
            outData.println(this.indent(5) + "case " + noInDataSet + ": return \"" + field.useUpperName() + "\";");
            ++noInDataSet;
        }
        for (i = 0; i < proc.outputs.size(); ++i) {
            field = proc.outputs.elementAt(i);
            if (proc.hasInput(field.name)) continue;
            outData.println(this.indent(5) + "case " + noInDataSet + ": return \"" + field.useUpperName() + "\";");
            ++noInDataSet;
        }
        outData.println(this.indent(4) + "}");
        outData.println(this.indent(4) + "return \"<??\"+ordinal+\"??>\";");
        outData.println(this.indent(3) + "}");
        outData.println(this.indent(2) + "}");
        if (!(this.noDatatables || this.useSeparate || this.usePartials)) {
            this.generateFetchProcDataTables(proc, mainName, outData);
        }
    }

    void generateFetchProcDataTables(Proc proc, String mainName, PrintWriter outData) {
        outData.println(this.indent(2) + "public " + proc.table.useName() + proc.upperFirst() + "DataTable " + proc.upperFirst() + "DataTable()");
        outData.println(this.indent(2) + "{");
        outData.println(this.indent(3) + proc.table.useName() + proc.upperFirst() + "DataTable wResult = new " + proc.table.useName() + proc.upperFirst() + "DataTable(mList);");
        outData.println(this.indent(3) + "return wResult;");
        outData.println(this.indent(2) + "}");
        outData.println(this.indent(2) + "public " + proc.table.useName() + proc.upperFirst() + "DataTable " + proc.upperFirst() + "DataTable(Connect aConnect)");
        outData.println(this.indent(2) + "{");
        outData.println(this.indent(3) + "" + proc.upperFirst() + "Load(aConnect);");
        outData.println(this.indent(3) + "return " + proc.upperFirst() + "DataTable();");
        outData.println(this.indent(2) + "}");
    }

    void generateProcFunctions(Proc proc, String name, PrintWriter outData, boolean isLoaded) {
        if (proc.outputs.size() > 0 && !proc.isSingle) {
            this.generateFetchProc(proc, name, outData, isLoaded);
        } else if (proc.outputs.size() > 0) {
            this.generateReadOneProc(proc, name, outData);
        } else if (proc.isInsert && proc.hasReturning) {
            this.generateReturningProc(proc, name, outData);
        } else {
            this.generateNonQueryProc(proc, name, outData);
        }
        if (this.useFunc) {
            this.generateFunc(proc, name, outData);
        }
    }

    void generateCClassTop(Proc proc, String mainName, PrintWriter outData, boolean doCursor) {
        outData.println(this.indent(1) + "[Serializable()]");
        outData.println(this.indent(1) + "public " + (this.usePartials ? "partial " : "") + "class " + mainName);
        outData.println(this.indent(1) + "{");
        if (doCursor || !proc.hasNoData()) {
            outData.println(this.indent(2) + "private " + mainName + "Rec mRec;");
            outData.println(this.indent(2) + "public " + mainName + "Rec Rec { get { return mRec; } set { mRec = value; } }");
            if (doCursor || proc.outputs.size() > 0 && !proc.isSingle) {
                if (this.useGenerics) {
                    outData.println(this.indent(2) + "private List<" + mainName + "Rec> mList;");
                } else {
                    outData.println(this.indent(2) + "private ArrayList mList;");
                }
                outData.println(this.indent(2) + "public int Count { get { return mList.Count; } }");
                outData.println(this.indent(2) + "public JCursor mCursor;");
                outData.println(this.indent(2) + "public " + mainName + "Rec this[int i]");
                outData.println(this.indent(2) + "{");
                outData.println(this.indent(3) + "get");
                outData.println(this.indent(3) + "{");
                outData.println(this.indent(4) + "if (i >= 0 && i < mList.Count)");
                outData.println(this.indent(4) + "{");
                if (this.useGenerics) {
                    outData.println(this.indent(5) + "return mList[i];");
                } else {
                    outData.println(this.indent(5) + "return (" + mainName + "Rec)mList[i];");
                }
                outData.println(this.indent(4) + "}");
                outData.println(this.indent(4) + "throw new JPortalException(\"" + mainName + " index out of range\");");
                outData.println(this.indent(3) + "}");
                outData.println(this.indent(3) + "set");
                outData.println(this.indent(3) + "{");
                outData.println(this.indent(4) + "if (i < mList.Count)");
                outData.println(this.indent(4) + "{");
                outData.println(this.indent(5) + "mList.RemoveAt(i);");
                outData.println(this.indent(4) + "}");
                outData.println(this.indent(4) + "mList.Insert(i, value);");
                outData.println(this.indent(3) + "}");
                outData.println(this.indent(2) + "}");
                if (this.useYields) {
                    if (this.useGenerics) {
                        outData.println(this.indent(2) + "public IEnumerable<" + mainName + "Rec> Yielded()");
                    } else {
                        outData.println(this.indent(2) + "public IEnumerable Yielded()");
                    }
                    outData.println(this.indent(2) + "{");
                    outData.println(this.indent(3) + "for (int i=0; i<Count; i++)");
                    outData.println(this.indent(4) + "yield return this[i];");
                    outData.println(this.indent(2) + "}");
                }
            }
            outData.println(this.indent(2) + "public void Clear()");
            outData.println(this.indent(2) + "{");
            if (doCursor || proc.outputs.size() > 0 && !proc.isSingle) {
                if (this.useGenerics) {
                    outData.println(this.indent(3) + "mList = new List<" + mainName + "Rec>();");
                } else {
                    outData.println(this.indent(3) + "mList = new ArrayList();");
                }
            }
            outData.println(this.indent(3) + "mRec = new " + mainName + "Rec();");
            outData.println(this.indent(2) + "}");
            outData.println(this.indent(2) + "public " + mainName + "()");
            outData.println(this.indent(2) + "{");
            outData.println(this.indent(3) + "Clear();");
            outData.println(this.indent(2) + "}");
        }
    }

    boolean doMSSqlStoredProcs(Proc proc) {
        return this.mSSqlStoredProcs && proc.dynamics.size() == 0 || proc.isSProc && proc.dynamics.size() == 0;
    }

    void generateCode(Table table, Proc proc, PrintWriter outData) {
        if (proc.comments.size() > 0) {
            outData.println(this.indent(1) + "/// <summary>");
            for (int i = 0; i < proc.comments.size(); ++i) {
                String comment = proc.comments.elementAt(i);
                outData.println(this.indent(1) + "/// " + comment);
            }
            outData.println(this.indent(1) + "/// </summary>");
        }
        this.generateCClassTop(proc, table.useName() + proc.upperFirst(), outData, false);
        if (this.doMSSqlStoredProcs(proc)) {
            this.generateStoredProcCommand(proc, outData);
        } else {
            this.generateCommand(proc, outData);
        }
        this.generateProcFunctions(proc, table.useName() + proc.upperFirst(), outData, true);
        outData.println(this.indent(1) + "}");
    }

    void generateStdCode(Table table, Proc proc, PrintWriter outData, boolean firsttime, boolean isLoaded) {
        if (firsttime) {
            this.generateCClassTop(proc, table.useName(), outData, table.hasCursorStdProc());
        }
        if (proc.comments.size() > 0) {
            outData.println(this.indent(2) + "/// <summary>");
            for (int i = 0; i < proc.comments.size(); ++i) {
                String comment = proc.comments.elementAt(i);
                outData.println(this.indent(2) + "/// " + comment);
            }
            outData.println(this.indent(2) + "/// </summary>");
        }
        if (this.doMSSqlStoredProcs(proc)) {
            this.generateStoredProcCommand(proc, outData);
        } else {
            this.generateCommand(proc, outData);
        }
        this.generateProcFunctions(proc, table.useName(), outData, isLoaded);
    }

    String castOf(Field field) {
        switch (field.type) {
            case 3: {
                return "(byte)";
            }
            case 15: {
                return "(short)";
            }
        }
        return "";
    }

    String validNull(Field field) {
        switch (field.type) {
            case 5: 
            case 6: 
            case 17: 
            case 18: {
                return "DateTime.MinValue";
            }
            case 2: {
                return "false";
            }
            case 3: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 24: 
            case 25: {
                return "0";
            }
            case 22: {
                return "Guid.Empty";
            }
        }
        return "null";
    }

    String cursorGet(Field field, int occurence) {
        String tail = ")";
        if (field.isNull) {
            tail = ", out " + field.useLowerName() + "IsNull)";
        }
        switch (field.type) {
            case 21: {
                return "GetString(" + occurence + tail;
            }
            case 1: {
                return "GetBlob(" + occurence + ", " + field.length + tail;
            }
            case 2: {
                return "GetBoolean(" + occurence + tail;
            }
            case 3: {
                return "GetByte(" + occurence + tail;
            }
            case 4: {
                return "GetString(" + occurence + tail;
            }
            case 5: {
                return "GetDateTime(" + occurence + tail;
            }
            case 6: {
                return "GetDateTime(" + occurence + tail;
            }
            case 8: {
                return "GetString(" + occurence + tail;
            }
            case 7: 
            case 9: {
                if (field.precision > 15) {
                    return "GetDecimal(" + occurence + tail;
                }
                return "GetDouble(" + occurence + tail;
            }
            case 10: {
                return "GetInt(" + occurence + tail;
            }
            case 11: {
                return "GetInt(" + occurence + tail;
            }
            case 12: {
                return "GetLong(" + occurence + tail;
            }
            case 24: {
                return "GetLong(" + occurence + tail;
            }
            case 25: {
                return "GetLong(" + occurence + tail;
            }
            case 13: {
                return "GetDecimal(" + occurence + tail;
            }
            case 14: {
                return "GetInt(" + occurence + tail;
            }
            case 15: {
                return "GetShort(" + occurence + tail;
            }
            case 17: {
                return "GetDateTime(" + occurence + tail;
            }
            case 18: {
                return "GetDateTime(" + occurence + tail;
            }
            case 19: {
                return "GetString(" + occurence + tail;
            }
            case 23: 
            case 30: {
                return "GetString(" + occurence + tail;
            }
            case 31: 
            case 32: {
                return "GetString(" + occurence + tail;
            }
            case 22: {
                return "GetGuid(" + occurence + tail;
            }
            case 20: {
                return "GetString(" + occurence + tail;
            }
        }
        return "Get(" + occurence + tail;
    }

    String dataTableType(Field field) {
        switch (field.type) {
            case 21: {
                return "String";
            }
            case 1: {
                return "Byte[]";
            }
            case 2: {
                return "Boolean";
            }
            case 3: {
                return "Byte";
            }
            case 4: {
                return "String";
            }
            case 5: {
                return "DateTime";
            }
            case 6: {
                return "DateTime";
            }
            case 8: {
                return "String";
            }
            case 7: 
            case 9: {
                if (field.precision > 15) {
                    return "String";
                }
                return "Double";
            }
            case 10: {
                return "Int32";
            }
            case 25: {
                return "Int64";
            }
            case 11: {
                return "Int32";
            }
            case 12: {
                return "Int64";
            }
            case 13: {
                return "String";
            }
            case 14: {
                return "Int32";
            }
            case 24: {
                return "Int64";
            }
            case 15: {
                return "Int16";
            }
            case 17: {
                return "DateTime";
            }
            case 18: {
                return "DateTime";
            }
            case 19: {
                return "String";
            }
            case 23: 
            case 30: {
                return "String";
            }
            case 31: 
            case 32: {
                return "String";
            }
            case 22: {
                return "Guid";
            }
            case 20: {
                return "String";
            }
        }
        return "dataTableType";
    }

    String fieldDef(Field field, String temp) {
        StringBuffer maker = new StringBuffer();
        StringBuffer temp2 = new StringBuffer(temp);
        String result = this.getDataType(field, maker, temp2);
        String set = this.indent(3) + "set { this." + field.useLowerName() + " = value; } \r\n";
        if (this.useNotify) {
            set = this.indent(3) + "set\r\n" + this.indent(4) + "{\r\n" + this.indent(5) + "this." + field.useLowerName() + " = value; \r\n" + this.indent(5) + "NotifyPropertyChanged();\r\n" + this.indent(4) + "}\r\n";
        }
        if (field.isNull && result == "string") {
            set = this.indent(3) + "set\r\n" + this.indent(3) + "{\r\n" + this.indent(4) + "this." + field.useLowerName() + " = value; \r\n" + this.indent(4) + "this." + field.useUpperName() + "IsNull = value == null ? true : false;\r\n" + (this.useNotify ? this.indent(4) + "NotifyPropertyChanged();\r\n" : "") + this.indent(3) + "}\r\n";
        }
        String ret = this.indent(2) + "private " + result + " " + field.useLowerName() + maker.toString() + ";\r\n" + this.indent(2) + temp2.toString() + ")]\r\n" + this.indent(2) + "public " + result + " " + field.useUpperName() + "\r\n" + this.indent(2) + "{ \r\n" + this.indent(3) + "get { return this." + field.useLowerName() + ";}\r\n" + set + this.indent(2) + "}";
        return ret;
    }

    String getDataType(Field field, StringBuffer maker, StringBuffer temp) {
        String result;
        switch (field.type) {
            case 4: 
            case 20: 
            case 21: {
                result = "string";
                break;
            }
            case 13: {
                result = "decimal";
                break;
            }
            case 1: {
                result = "JPBlob";
                maker.append(" = new JPBlob()");
                break;
            }
            case 19: {
                result = "string";
                break;
            }
            case 23: 
            case 30: {
                result = "string";
                break;
            }
            case 31: 
            case 32: {
                result = "string";
                break;
            }
            case 22: {
                result = "Guid";
                break;
            }
            case 5: 
            case 6: 
            case 17: 
            case 18: {
                result = "DateTime";
                temp.append(", IsVersion=true");
                break;
            }
            case 2: {
                result = "bool";
                break;
            }
            case 3: {
                result = "byte";
                break;
            }
            case 16: {
                result = "short";
                break;
            }
            case 7: 
            case 9: {
                if (field.precision > 15) {
                    result = "decimal";
                    break;
                }
                result = "double";
                break;
            }
            case 10: 
            case 11: 
            case 14: {
                result = "int";
                break;
            }
            case 12: 
            case 24: 
            case 25: {
                result = "long";
                break;
            }
            case 15: {
                result = "short";
                break;
            }
            case 8: {
                result = "string";
                break;
            }
            default: {
                result = "whoknows";
            }
        }
        return result;
    }

    String returnNullableDataType(Field field, StringBuffer maker, StringBuffer temp) {
        String datatype = this.getDataType(field, maker, temp);
        if (this.getNullableType(field) && field.isNull) {
            datatype = datatype + "?";
        }
        return datatype;
    }

    boolean getNullableType(Field field) {
        boolean nullableType;
        switch (field.type) {
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 24: 
            case 25: {
                nullableType = true;
                break;
            }
            default: {
                nullableType = false;
            }
        }
        return nullableType;
    }

    String fieldCastNo(Field field) {
        String result;
        switch (field.type) {
            case 4: 
            case 8: 
            case 20: 
            case 21: {
                result = "string";
                break;
            }
            case 13: {
                result = "decimal";
                break;
            }
            case 1: {
                result = "JPBlob";
                break;
            }
            case 19: {
                result = "string";
                break;
            }
            case 23: 
            case 30: {
                result = "string";
                break;
            }
            case 31: 
            case 32: {
                result = "string";
                break;
            }
            case 22: {
                result = "Guid";
                break;
            }
            case 5: 
            case 6: 
            case 17: 
            case 18: {
                result = "DateTime";
                break;
            }
            case 2: {
                result = "bool";
                break;
            }
            case 3: {
                result = "byte";
                break;
            }
            case 16: {
                result = "short";
                break;
            }
            case 7: 
            case 9: {
                if (field.precision > 15) {
                    result = "decimal";
                    break;
                }
                result = "double";
                break;
            }
            case 10: 
            case 11: 
            case 14: {
                result = "int";
                break;
            }
            case 12: 
            case 24: 
            case 25: {
                result = "long";
                break;
            }
            case 15: {
                result = "short";
                break;
            }
            default: {
                result = "whoknows";
            }
        }
        return result;
    }

    String fieldCast(Field field) {
        return "(" + this.fieldCastNo(field) + ")";
    }

    String varType(Field field) {
        switch (field.type) {
            case 2: {
                return "bit";
            }
            case 3: {
                return "tinyint";
            }
            case 15: {
                return "smallint";
            }
            case 10: 
            case 11: 
            case 14: {
                return "integer";
            }
            case 12: 
            case 24: 
            case 25: {
                return "longint";
            }
            case 4: {
                if (field.length > 8000) {
                    return field.name + " varchar(MAX)";
                }
                return field.name + " varchar(" + String.valueOf(field.length) + ")";
            }
            case 21: {
                return "char(" + String.valueOf(field.length) + ")";
            }
            case 5: {
                return "datetime";
            }
            case 6: {
                return "datetime";
            }
            case 17: {
                return "datetime";
            }
            case 18: {
                return "datetime";
            }
            case 7: 
            case 9: {
                if (field.precision > 15) {
                    return "decimal";
                }
                return "float";
            }
            case 1: {
                return "image";
            }
            case 19: {
                return "text";
            }
            case 23: 
            case 30: {
                return "xml";
            }
            case 31: 
            case 32: {
                return "json";
            }
            case 22: {
                return "uniqueidentifier";
            }
            case 13: {
                return "money";
            }
            case 20: {
                return "varchar(50)";
            }
        }
        return "unknown";
    }

    String indent(int lvl) {
        if (lvl == 0) {
            return "";
        }
        String ind = "";
        for (int i = 0; i < lvl; ++i) {
            ind = ind + "    ";
        }
        return ind;
    }
}

