/*
 * Decompiled with CFR 0.152.
 */
package dataflow.constantpropagation;

import dataflow.analysis.AbstractValue;

public class Constant
implements AbstractValue<Constant> {
    protected Type type;
    protected Integer value;

    public Constant(Type type) {
        assert (!type.equals((Object)Type.CONSTANT));
        this.type = type;
    }

    public Constant(Integer value) {
        this.type = Type.CONSTANT;
        this.value = value;
    }

    public boolean isTop() {
        return this.type.equals((Object)Type.TOP);
    }

    public boolean isBottom() {
        return this.type.equals((Object)Type.BOTTOM);
    }

    public boolean isConstant() {
        return this.type.equals((Object)Type.CONSTANT);
    }

    public Integer getValue() {
        assert (this.isConstant());
        return this.value;
    }

    public Constant copy() {
        if (this.isConstant()) {
            return new Constant(this.value);
        }
        return new Constant(this.type);
    }

    @Override
    public Constant leastUpperBound(Constant other) {
        if (other.isBottom()) {
            return this.copy();
        }
        if (this.isBottom()) {
            return other.copy();
        }
        if (other.isTop() || this.isTop()) {
            return new Constant(Type.TOP);
        }
        if (other.getValue().equals(this.getValue())) {
            return this.copy();
        }
        return new Constant(Type.TOP);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Constant)) {
            return false;
        }
        Constant other = (Constant)obj;
        return this.type == other.type && this.value == other.value;
    }

    public int hashCode() {
        return this.type.hashCode() + (this.value != null ? this.value.hashCode() : 0);
    }

    public String toString() {
        switch (this.type) {
            case TOP: {
                return "T";
            }
            case BOTTOM: {
                return "-";
            }
            case CONSTANT: {
                return this.value.toString();
            }
        }
        assert (false);
        return "???";
    }

    public static enum Type {
        CONSTANT,
        TOP,
        BOTTOM;

    }
}

