/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.revwalk;

import java.text.MessageFormat;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.revwalk.RevWalk;

public class RevFlag {
    public static final RevFlag UNINTERESTING = new StaticRevFlag("UNINTERESTING", 4);
    public static final RevFlag SEEN = new StaticRevFlag("SEEN", 2);
    final RevWalk walker;
    final String name;
    final int mask;

    RevFlag(RevWalk w, String n, int m3) {
        this.walker = w;
        this.name = n;
        this.mask = m3;
    }

    public RevWalk getRevWalk() {
        return this.walker;
    }

    public String toString() {
        return this.name;
    }

    static class StaticRevFlag
    extends RevFlag {
        StaticRevFlag(String n, int m3) {
            super(null, n, m3);
        }

        public RevWalk getRevWalk() {
            throw new UnsupportedOperationException(MessageFormat.format(JGitText.get().isAStaticFlagAndHasNorevWalkInstance, this.toString()));
        }
    }
}

