/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.BaseReceivePack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReceiveCommand {
    private final ObjectId oldId;
    private final ObjectId newId;
    private final String name;
    private Type type;
    private Ref ref;
    private Result status = Result.NOT_ATTEMPTED;
    private String message;
    private boolean typeIsCorrect;

    public static List<ReceiveCommand> filter(List<ReceiveCommand> commands, Result want) {
        ArrayList<ReceiveCommand> r = new ArrayList<ReceiveCommand>(commands.size());
        for (ReceiveCommand cmd : commands) {
            if (cmd.getResult() != want) continue;
            r.add(cmd);
        }
        return r;
    }

    public ReceiveCommand(ObjectId oldId, ObjectId newId, String name) {
        this.oldId = oldId;
        this.newId = newId;
        this.name = name;
        this.type = Type.UPDATE;
        if (ObjectId.zeroId().equals(oldId)) {
            this.type = Type.CREATE;
        }
        if (ObjectId.zeroId().equals(newId)) {
            this.type = Type.DELETE;
        }
    }

    public ReceiveCommand(ObjectId oldId, ObjectId newId, String name, Type type) {
        this.oldId = oldId;
        this.newId = newId;
        this.name = name;
        this.type = type;
    }

    public ObjectId getOldId() {
        return this.oldId;
    }

    public ObjectId getNewId() {
        return this.newId;
    }

    public String getRefName() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    public Ref getRef() {
        return this.ref;
    }

    public Result getResult() {
        return this.status;
    }

    public String getMessage() {
        return this.message;
    }

    public void setResult(Result s2) {
        this.setResult(s2, null);
    }

    public void setResult(Result s2, String m3) {
        this.status = s2;
        this.message = m3;
    }

    public void updateType(RevWalk walk) throws IOException {
        if (this.typeIsCorrect) {
            return;
        }
        if (this.type == Type.UPDATE && !AnyObjectId.equals(this.oldId, this.newId)) {
            RevObject o = walk.parseAny(this.oldId);
            RevObject n = walk.parseAny(this.newId);
            if (!(o instanceof RevCommit && n instanceof RevCommit && walk.isMergedInto((RevCommit)o, (RevCommit)n))) {
                this.setType(Type.UPDATE_NONFASTFORWARD);
            }
        }
        this.typeIsCorrect = true;
    }

    public void execute(BaseReceivePack rp) {
        try {
            RefUpdate ru = rp.getRepository().updateRef(this.getRefName());
            ru.setRefLogIdent(rp.getRefLogIdent());
            switch (this.getType()) {
                case DELETE: {
                    if (!ObjectId.zeroId().equals(this.getOldId())) {
                        ru.setExpectedOldObjectId(this.getOldId());
                    }
                    ru.setForceUpdate(true);
                    this.setResult(ru.delete(rp.getRevWalk()));
                    break;
                }
                case CREATE: 
                case UPDATE: 
                case UPDATE_NONFASTFORWARD: {
                    ru.setForceUpdate(rp.isAllowNonFastForwards());
                    ru.setExpectedOldObjectId(this.getOldId());
                    ru.setNewObjectId(this.getNewId());
                    ru.setRefLogMessage("push", true);
                    this.setResult(ru.update(rp.getRevWalk()));
                }
            }
        }
        catch (IOException err) {
            this.reject(err);
        }
    }

    void setRef(Ref r) {
        this.ref = r;
    }

    void setType(Type t) {
        this.type = t;
    }

    void setTypeFastForwardUpdate() {
        this.type = Type.UPDATE;
        this.typeIsCorrect = true;
    }

    public void setResult(RefUpdate.Result r) {
        switch (r) {
            case NOT_ATTEMPTED: {
                this.setResult(Result.NOT_ATTEMPTED);
                break;
            }
            case LOCK_FAILURE: 
            case IO_FAILURE: {
                this.setResult(Result.LOCK_FAILURE);
                break;
            }
            case NO_CHANGE: 
            case NEW: 
            case FORCED: 
            case FAST_FORWARD: {
                this.setResult(Result.OK);
                break;
            }
            case REJECTED: {
                this.setResult(Result.REJECTED_NONFASTFORWARD);
                break;
            }
            case REJECTED_CURRENT_BRANCH: {
                this.setResult(Result.REJECTED_CURRENT_BRANCH);
                break;
            }
            default: {
                this.setResult(Result.REJECTED_OTHER_REASON, r.name());
            }
        }
    }

    void reject(IOException err) {
        this.setResult(Result.REJECTED_OTHER_REASON, MessageFormat.format(JGitText.get().lockError, err.getMessage()));
    }

    public String toString() {
        return this.getType().name() + ": " + this.getOldId().name() + " " + this.getNewId().name() + " " + this.getRefName();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Result {
        NOT_ATTEMPTED,
        REJECTED_NOCREATE,
        REJECTED_NODELETE,
        REJECTED_NONFASTFORWARD,
        REJECTED_CURRENT_BRANCH,
        REJECTED_MISSING_OBJECT,
        REJECTED_OTHER_REASON,
        LOCK_FAILURE,
        OK;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        CREATE,
        UPDATE,
        UPDATE_NONFASTFORWARD,
        DELETE;

    }
}

