/*
 * Decompiled with CFR 0.152.
 */
package bbd.jportal2;

import bbd.jportal2.Const;
import bbd.jportal2.Database;
import bbd.jportal2.Enum;
import bbd.jportal2.Field;
import bbd.jportal2.Grant;
import bbd.jportal2.JPortalConstants;
import bbd.jportal2.JPortalTokenManager;
import bbd.jportal2.Key;
import bbd.jportal2.Line;
import bbd.jportal2.Link;
import bbd.jportal2.Misc;
import bbd.jportal2.Parameter;
import bbd.jportal2.ParseException;
import bbd.jportal2.Proc;
import bbd.jportal2.SimpleCharStream;
import bbd.jportal2.Table;
import bbd.jportal2.Token;
import bbd.jportal2.Value;
import bbd.jportal2.View;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JPortal
implements JPortalConstants {
    private static final Logger logger = LoggerFactory.getLogger(JPortal.class);
    protected static Database database;
    protected static Table table;
    protected static Enum entry;
    protected static Field field;
    protected static Const constant;
    protected static Value value;
    protected static Grant grant;
    protected static Key key;
    protected static Link link;
    protected static View view;
    protected static Proc proc;
    protected static Parameter parameter;
    protected static String perm;
    protected static String user;
    protected static String line;
    protected static String inDir;
    private static boolean parser_initialised;
    private static boolean fieldsNullByDefault;
    private static boolean isLiteral;
    private static String literal;
    private static boolean jj_initialized_once;
    public static JPortalTokenManager token_source;
    static SimpleCharStream jj_input_stream;
    public static Token token;
    public static Token jj_nt;
    private static int jj_ntk;
    private static Token jj_scanpos;
    private static Token jj_lastpos;
    private static int jj_la;
    private static int jj_gen;
    private static final int[] jj_la1;
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private static int[] jj_la1_2;
    private static int[] jj_la1_3;
    private static int[] jj_la1_4;
    private static final JJCalls[] jj_2_rtns;
    private static boolean jj_rescan;
    private static int jj_gc;
    private static final LookaheadSuccess jj_ls;
    private static List<int[]> jj_expentries;
    private static int[] jj_expentry;
    private static int jj_kind;
    private static int[] jj_lasttokens;
    private static int jj_endpos;
    private static boolean trace_enabled;

    public static void main(String[] args) {
        try {
            for (int i = 0; i < args.length; ++i) {
                System.out.println(args[i] + ": Parsing ...");
                JPortal.setFieldsNullState(false);
                JPortal.run(args[i]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Database run(String inFile) {
        return JPortal.run(inFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Database run(String inFile, String inNub) {
        Database database;
        FileReader reader = new FileReader(inFile);
        try {
            database = JPortal.run(inFile, inNub, reader);
        }
        catch (Throwable throwable) {
            try {
                reader.close();
                throw throwable;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        reader.close();
        return database;
    }

    private static void setupNub(String inNub) {
        inDir = inNub;
    }

    public static Database run(String inFile, Reader reader) {
        return JPortal.run(inFile, "", reader);
    }

    public static Database run(String inFile, String inNub, Reader reader) {
        JPortal.setupNub(inNub);
        try {
            if (!parser_initialised) {
                new JPortal(reader);
                parser_initialised = true;
            } else {
                JPortal.ReInit(reader);
            }
            database = null;
            table = null;
            entry = null;
            field = null;
            constant = null;
            value = null;
            grant = null;
            key = null;
            link = null;
            view = null;
            proc = null;
            parameter = null;
            perm = null;
            user = null;
            line = null;
            isLiteral = false;
            literal = "";
            JPortal.jInput();
            return database;
        }
        catch (ParseException e) {
            logger.error("ParseException", e);
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static void setFieldsNullState(boolean state) {
        fieldsNullByDefault = state;
    }

    public static Database loadBinFile(String inFile) {
        return database;
    }

    static String fixString(String s) {
        return s.substring(1, s.length() - 1);
    }

    static String parseConsts(String s) {
        StringBuffer buffer = new StringBuffer();
        int cB = s.indexOf("%");
        while (cB != -1) {
            block9: {
                String lookup;
                int cE;
                block10: {
                    block8: {
                        if (cB > 0) {
                            buffer.append(s.substring(0, cB));
                            s = s.substring(cB + 1);
                        }
                        if ((cE = s.indexOf("%")) == -1) {
                            buffer.append('%');
                            break;
                        }
                        if (cE != 0) break block8;
                        buffer.append('%');
                        s = s.substring(1);
                        break block9;
                    }
                    lookup = s.substring(0, cE);
                    int cP = lookup.indexOf(".");
                    if (cP <= 0) break block10;
                    String fieldName = lookup.substring(0, cP);
                    String enumName = lookup.substring(cP + 1);
                    Field field = table.getField(fieldName);
                    if (field == null) break block10;
                    boolean done = false;
                    for (int i = 0; i < field.enums.size(); ++i) {
                        Enum entry = field.enums.elementAt(i);
                        if (!entry.name.equalsIgnoreCase(enumName)) continue;
                        String evalue = "" + entry.value;
                        if (field.type == 21 && field.length == 1) {
                            evalue = "'" + (char)entry.value + "'";
                        }
                        buffer.append(evalue);
                        s = s.substring(cE + 1);
                        done = true;
                        break;
                    }
                    if (done) break block9;
                }
                buffer.append('%');
                buffer.append(lookup);
                buffer.append('%');
                s = s.substring(cE + 1);
            }
            cB = s.indexOf("%");
        }
        buffer.append(s);
        return buffer.toString();
    }

    static String parseDynamics(String s) {
        s = JPortal.parseConsts(s);
        int dB = s.indexOf("&");
        while (dB != -1) {
            int dE;
            Line line;
            if (dB > 0) {
                line = new Line(s.substring(0, dB) + " ");
                JPortal.proc.lines.addElement(line);
                s = s.substring(dB);
            }
            boolean strung = false;
            int addB = 0;
            boolean addE = false;
            char c = '\u0000';
            for (dE = 1; dE < s.length(); ++dE) {
                c = s.charAt(dE);
                if (dE == 1 && c == '\'') {
                    strung = true;
                    addB = 1;
                    continue;
                }
                String valid = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789_()";
                if (valid.indexOf(c) == -1) break;
            }
            if (strung && c == '\'') {
                addE = true;
                ++dE;
            }
            String dVar = s.substring(1 + addB, dE - addB);
            s = s.substring(dE);
            int sB = dVar.indexOf("(");
            int sE = dVar.indexOf(")");
            Integer size = new Integer(256);
            if (sB > 0) {
                if (sE > sB) {
                    String dSize = dVar.substring(sB + 1, sE);
                    size = new Integer(dSize);
                }
                dVar = dVar.substring(0, sB);
            } else if (sE > 0) {
                s = dVar.substring(sE) + s;
                dVar = dVar.substring(0, sE);
            }
            line = new Line(dVar, true);
            JPortal.proc.lines.addElement(line);
            if (!proc.hasDynamic(dVar)) {
                if (JPortal.proc.extendsStd) {
                    JPortal.proc.useStd = false;
                }
                JPortal.proc.dynamics.addElement(dVar);
                JPortal.proc.dynamicSizes.addElement(size);
                JPortal.proc.dynamicStrung.addElement(new Boolean(strung));
            }
            dB = s.indexOf("&");
        }
        return s;
    }

    static void loadTableModule(String s, Vector<String> useProcs) {
        try {
            String importFile = inDir + s + ".nub";
            String workDir = inDir;
            int sep = workDir.indexOf(59);
            boolean found = false;
            while (sep > 0) {
                importFile = workDir.substring(0, sep) + s + ".nub";
                if (new File(importFile).exists()) {
                    found = true;
                    break;
                }
                if (sep >= workDir.length()) break;
                workDir = workDir.substring(sep + 1);
                sep = workDir.indexOf(59);
            }
            if (!found) {
                found = new File(importFile).exists();
            }
            if (found) {
                logger.info("Inputting " + importFile);
                DataInputStream ids = new DataInputStream(new FileInputStream(importFile));
                table = new Table();
                table.reader(ids, useProcs);
                ids.close();
                JPortal.table.database = database;
            } else {
                logger.warn("Import of " + s + ".nub failed");
            }
        }
        catch (Exception e) {
            logger.warn("Table nub " + s + ".nub failed to read (" + e.getMessage() + ")");
            e.printStackTrace();
        }
    }

    static String replaceAllLiteral(String haystack) {
        String s = "\\[]'\" ";
        for (int i = 0; i < s.length(); ++i) {
            String c = "" + s.charAt(i);
            haystack = JPortal.replaceAll(haystack, c, "");
        }
        return haystack;
    }

    static String replaceAll(String haystack, String needle, String replacement) {
        int i = haystack.lastIndexOf(needle);
        if (i != -1) {
            StringBuffer buffer = new StringBuffer(haystack);
            buffer.replace(i, i + needle.length(), replacement);
            while ((i = haystack.lastIndexOf(needle, i - 1)) != -1) {
                buffer.replace(i, i + needle.length(), replacement);
            }
            haystack = buffer.toString();
        }
        return haystack;
    }

    static void saveTableModule() {
        try {
            String outDir = inDir;
            int sep = inDir.indexOf(59);
            if (sep > 0) {
                outDir = inDir.substring(0, sep);
            }
            if (outDir.length() > 0) {
                logger.info("Outputting " + outDir + JPortal.table.name + ".nub");
                DataOutputStream ods = new DataOutputStream(new FileOutputStream(outDir + JPortal.table.name + ".nub"));
                JPortal.table.database = null;
                table.writer(ods);
                ods.close();
                JPortal.table.database = database;
            }
        }
        catch (Exception e) {
            logger.error("Table nub " + inDir + JPortal.table.name + ".nub failed to write", e);
        }
    }

    public static final void jInput() throws ParseException {
        block29: {
            JPortal.jj_consume_token(26);
            String s = JPortal.jIdent();
            database = new Database();
            JPortal.database.name = s;
            JPortal.database.userid = "";
            JPortal.database.password = "";
            block22: while (true) {
                switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                    case 40: {
                        break;
                    }
                    default: {
                        JPortal.jj_la1[0] = jj_gen;
                        break block22;
                    }
                }
                JPortal.jj_consume_token(40);
                block23: while (true) {
                    s = JPortal.jString();
                    JPortal.database.flags.addElement(s);
                    switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                        case 128: {
                            continue block23;
                        }
                    }
                    break;
                }
                JPortal.jj_la1[1] = jj_gen;
            }
            switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                case 63: {
                    JPortal.jj_consume_token(63);
                    JPortal.database.packageName = s = JPortal.jPackageIdent();
                    break;
                }
                default: {
                    JPortal.jj_la1[2] = jj_gen;
                }
            }
            block24: while (true) {
                switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                    case 45: 
                    case 62: {
                        break;
                    }
                    default: {
                        JPortal.jj_la1[3] = jj_gen;
                        break block29;
                    }
                }
                switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                    case 62: {
                        JPortal.jj_consume_token(62);
                        JPortal.database.output = s = JPortal.jIdentOrString();
                        continue block24;
                    }
                    case 45: {
                        JPortal.jj_consume_token(45);
                        s = JPortal.jIdentOrString();
                        JPortal.database.imports.addElement(s);
                        continue block24;
                    }
                }
                break;
            }
            JPortal.jj_la1[4] = jj_gen;
            JPortal.jj_consume_token(-1);
            throw new ParseException();
        }
        JPortal.jConnect();
        block25: while (true) {
            JPortal.jTables();
            if (database.hasTable(JPortal.table.name)) {
                logger.warn(JPortal.table.name + " is already present");
            } else {
                JPortal.database.tables.addElement(table);
            }
            switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                case 45: 
                case 84: {
                    continue block25;
                }
            }
            break;
        }
        JPortal.jj_la1[5] = jj_gen;
        block26: while (true) {
            switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                case 98: {
                    break;
                }
                default: {
                    JPortal.jj_la1[6] = jj_gen;
                    break block26;
                }
            }
            JPortal.jView();
            JPortal.database.views.addElement(view);
        }
        JPortal.jj_consume_token(0);
    }

    public static final void jConnect() throws ParseException {
        String s;
        JPortal.jj_consume_token(78);
        JPortal.database.server = s = JPortal.jIdentOrString();
        switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
            case 69: {
                JPortal.jj_consume_token(69);
                JPortal.database.schema = s = JPortal.jIdentOrString();
                break;
            }
            default: {
                JPortal.jj_la1[7] = jj_gen;
            }
        }
        switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
            case 95: {
                JPortal.jj_consume_token(95);
                JPortal.database.userid = s = JPortal.jIdent();
                JPortal.jj_consume_token(64);
                JPortal.database.password = s = JPortal.jIdent();
                break;
            }
            default: {
                JPortal.jj_la1[8] = jj_gen;
            }
        }
    }

    public static final String jPackageIdent() throws ParseException {
        String s = JPortal.jIdent();
        block3: while (true) {
            switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                case 146: {
                    break;
                }
                default: {
                    JPortal.jj_la1[9] = jj_gen;
                    break block3;
                }
            }
            JPortal.jj_consume_token(146);
            String n = JPortal.jIdent();
            s = s + "." + n;
        }
        if ("" != null) {
            return s;
        }
        throw new IllegalStateException("Missing return statement in function");
    }

    public static final String jIdentOrString() throws ParseException {
        switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
            case 131: 
            case 132: {
                String s = JPortal.jIdent();
                if ("" == null) break;
                return s;
            }
            case 128: {
                Token t = JPortal.jj_consume_token(128);
                String s = t.image;
                if ("" == null) break;
                return JPortal.fixString(s);
            }
            default: {
                JPortal.jj_la1[10] = jj_gen;
                JPortal.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        throw new IllegalStateException("Missing return statement in function");
    }

    public static final String jIdent() throws ParseException {
        switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
            case 131: {
                Token t = JPortal.jj_consume_token(131);
                isLiteral = false;
                literal = "";
                if ("" == null) break;
                return t.image;
            }
            case 132: {
                Token t = JPortal.jj_consume_token(132);
                String s = t.image;
                isLiteral = true;
                literal = s.substring(2, s.length() - 1);
                if ("" == null) break;
                return JPortal.replaceAllLiteral(s.substring(2, s.length() - 1));
            }
            default: {
                JPortal.jj_la1[11] = jj_gen;
                JPortal.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        throw new IllegalStateException("Missing return statement in function");
    }

    public static final void jTables() throws ParseException {
        boolean save = false;
        switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
            case 84: {
                JPortal.jTable();
                while (JPortal.jj_2_1(2)) {
                    JPortal.jExtras();
                }
                save = true;
                break;
            }
            case 45: {
                JPortal.jTableImport();
                save = false;
                break;
            }
            default: {
                JPortal.jj_la1[12] = jj_gen;
                JPortal.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        block11: while (true) {
            switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                case 66: 
                case 82: 
                case 112: 
                case 142: 
                case 145: {
                    break;
                }
                default: {
                    JPortal.jj_la1[13] = jj_gen;
                    break block11;
                }
            }
            JPortal.jProc();
        }
        block12: while (true) {
            switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                case 102: {
                    break;
                }
                default: {
                    JPortal.jj_la1[14] = jj_gen;
                    break block12;
                }
            }
            JPortal.jj_consume_token(102);
            parameter = new Parameter();
            JPortal.table.parameters.addElement(parameter);
            JPortal.jParm();
        }
        if (save) {
            JPortal.saveTableModule();
        }
    }

    public static final void jTableImport() throws ParseException {
        Vector<String> v = new Vector<String>();
        JPortal.jj_consume_token(45);
        String s = JPortal.jIdentOrString();
        switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
            case 121: {
                JPortal.jj_consume_token(121);
                block9: while (true) {
                    String p = JPortal.jIdent();
                    v.addElement(p);
                    switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                        case 131: 
                        case 132: {
                            continue block9;
                        }
                    }
                    break;
                }
                JPortal.jj_la1[15] = jj_gen;
                JPortal.jj_consume_token(124);
                break;
            }
            default: {
                JPortal.jj_la1[16] = jj_gen;
            }
        }
        JPortal.loadTableModule(s, v);
        JPortal.table.database = database;
        switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
            case 122: {
                JPortal.table.alias = s = JPortal.jAlias();
                break;
            }
            default: {
                JPortal.jj_la1[17] = jj_gen;
            }
        }
    }

    public static final void jTable() throws ParseException {
        Token t = JPortal.jj_consume_token(84);
        String s = JPortal.jIdent();
        table = new Table();
        JPortal.table.database = database;
        JPortal.table.name = s;
        JPortal.table.isLiteral = isLiteral;
        JPortal.table.literalName = literal;
        JPortal.table.start = t.beginLine;
        switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
            case 122: {
                JPortal.table.alias = s = JPortal.jAlias();
                break;
            }
            default: {
                JPortal.jj_la1[18] = jj_gen;
            }
        }
        switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
            case 22: {
                JPortal.jj_consume_token(22);
                t = JPortal.jj_consume_token(128);
                s = t.image;
                JPortal.table.check = JPortal.fixString(s);
                break;
            }
            default: {
                JPortal.jj_la1[19] = jj_gen;
            }
        }
        block18: while (true) {
            switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                case 115: {
                    break;
                }
                default: {
                    JPortal.jj_la1[20] = jj_gen;
                    break block18;
                }
            }
            s = JPortal.jComment();
            JPortal.table.comments.addElement(s);
        }
        block19: while (true) {
            switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                case 60: {
                    break;
                }
                default: {
                    JPortal.jj_la1[21] = jj_gen;
                    break block19;
                }
            }
            JPortal.jj_consume_token(60);
            block20: while (true) {
                s = JPortal.jString();
                JPortal.table.options.addElement(s);
                switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                    case 128: {
                        continue block20;
                    }
                }
                break;
            }
            JPortal.jj_la1[22] = jj_gen;
        }
        block21: while (true) {
            switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                case 131: 
                case 132: {
                    break;
                }
                default: {
                    JPortal.jj_la1[23] = jj_gen;
                    break block21;
                }
            }
            JPortal.jField();
            if (table.hasField(JPortal.field.name)) {
                logger.warn(JPortal.field.name + " is already present");
                continue;
            }
            JPortal.table.fields.addElement(field);
        }
    }

    public static final void jPackageField() throws ParseException {
        String s;
        block20: {
            s = JPortal.jPackageIdent();
            field = new Field();
            JPortal.field.name = s;
            JPortal.field.isLiteral = isLiteral;
            JPortal.field.literalName = literal;
            JPortal.field.isNull = fieldsNullByDefault;
            boolean state = true;
            switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                case 122: {
                    JPortal.field.alias = s = JPortal.jAlias();
                    break;
                }
                default: {
                    JPortal.jj_la1[24] = jj_gen;
                }
            }
            JPortal.jDatatype();
            block18: while (true) {
                switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                    case 19: 
                    case 22: 
                    case 30: 
                    case 58: 
                    case 59: {
                        break;
                    }
                    default: {
                        JPortal.jj_la1[25] = jj_gen;
                        break block20;
                    }
                }
                switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                    case 30: {
                        JPortal.jj_consume_token(30);
                        Token t = JPortal.jj_consume_token(128);
                        s = t.image;
                        JPortal.field.defaultValue = JPortal.fixString(s);
                        continue block18;
                    }
                    case 58: 
                    case 59: {
                        switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                            case 58: {
                                JPortal.jj_consume_token(58);
                                state = false;
                                break;
                            }
                            default: {
                                JPortal.jj_la1[26] = jj_gen;
                            }
                        }
                        JPortal.jj_consume_token(59);
                        JPortal.field.isNull = state;
                        continue block18;
                    }
                    case 19: {
                        JPortal.jj_consume_token(19);
                        JPortal.field.isCalc = state;
                        continue block18;
                    }
                    case 22: {
                        JPortal.jj_consume_token(22);
                        Token t = JPortal.jj_consume_token(128);
                        s = t.image;
                        JPortal.field.checkValue = JPortal.fixString(s);
                        continue block18;
                    }
                }
                break;
            }
            JPortal.jj_la1[27] = jj_gen;
            JPortal.jj_consume_token(-1);
            throw new ParseException();
        }
        block19: while (true) {
            switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                case 115: {
                    break;
                }
                default: {
                    JPortal.jj_la1[28] = jj_gen;
                    break block19;
                }
            }
            s = JPortal.jComment();
            JPortal.field.comments.addElement(s);
        }
    }

    public static final void jField() throws ParseException {
        String s;
        block20: {
            s = JPortal.jIdent();
            field = new Field();
            JPortal.field.name = s;
            JPortal.field.isLiteral = isLiteral;
            JPortal.field.literalName = literal;
            JPortal.field.isNull = fieldsNullByDefault;
            boolean state = true;
            switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                case 122: {
                    JPortal.field.alias = s = JPortal.jAlias();
                    break;
                }
                default: {
                    JPortal.jj_la1[29] = jj_gen;
                }
            }
            JPortal.jDatatype();
            block18: while (true) {
                switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                    case 19: 
                    case 22: 
                    case 30: 
                    case 58: 
                    case 59: {
                        break;
                    }
                    default: {
                        JPortal.jj_la1[30] = jj_gen;
                        break block20;
                    }
                }
                switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                    case 30: {
                        JPortal.jj_consume_token(30);
                        Token t = JPortal.jj_consume_token(128);
                        s = t.image;
                        JPortal.field.defaultValue = JPortal.fixString(s);
                        continue block18;
                    }
                    case 58: 
                    case 59: {
                        switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                            case 58: {
                                JPortal.jj_consume_token(58);
                                state = false;
                                break;
                            }
                            default: {
                                JPortal.jj_la1[31] = jj_gen;
                            }
                        }
                        JPortal.jj_consume_token(59);
                        JPortal.field.isNull = state;
                        continue block18;
                    }
                    case 19: {
                        JPortal.jj_consume_token(19);
                        JPortal.field.isCalc = state;
                        continue block18;
                    }
                    case 22: {
                        JPortal.jj_consume_token(22);
                        Token t = JPortal.jj_consume_token(128);
                        s = t.image;
                        JPortal.field.checkValue = JPortal.fixString(s);
                        continue block18;
                    }
                }
                break;
            }
            JPortal.jj_la1[32] = jj_gen;
            JPortal.jj_consume_token(-1);
            throw new ParseException();
        }
        block19: while (true) {
            switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                case 115: {
                    break;
                }
                default: {
                    JPortal.jj_la1[33] = jj_gen;
                    break block19;
                }
            }
            s = JPortal.jComment();
            JPortal.field.comments.addElement(s);
        }
    }

    public static final String jAlias() throws ParseException {
        JPortal.jj_consume_token(122);
        String alias = JPortal.jIdent();
        JPortal.jj_consume_token(125);
        if ("" != null) {
            return alias;
        }
        throw new IllegalStateException("Missing return statement in function");
    }

    public static final void jDatatype() throws ParseException {
        block0 : switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
            case 14: {
                JPortal.jj_consume_token(14);
                JPortal.field.type = 1;
                JPortal.field.length = 0;
                switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                    case 121: 
                    case 122: 
                    case 127: {
                        JPortal.jCharsize();
                        break block0;
                    }
                }
                JPortal.jj_la1[34] = jj_gen;
                break;
            }
            case 15: {
                JPortal.jj_consume_token(15);
                JPortal.field.type = (byte)2;
                JPortal.field.length = 1;
                break;
            }
            case 18: {
                JPortal.jj_consume_token(18);
                JPortal.field.type = (byte)3;
                JPortal.field.length = 1;
                switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                    case 120: 
                    case 122: {
                        switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                            case 122: {
                                JPortal.jEnumValue();
                                break block0;
                            }
                            case 120: {
                                JPortal.jCharList();
                                break block0;
                            }
                        }
                        JPortal.jj_la1[35] = jj_gen;
                        JPortal.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                JPortal.jj_la1[36] = jj_gen;
                break;
            }
            case 21: {
                JPortal.jj_consume_token(21);
                JPortal.field.type = (byte)4;
                JPortal.field.length = 1;
                switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                    case 121: 
                    case 122: 
                    case 127: {
                        JPortal.jCharsize();
                        break;
                    }
                    default: {
                        JPortal.jj_la1[37] = jj_gen;
                    }
                }
                switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                    case 120: {
                        JPortal.jCharList();
                        break block0;
                    }
                }
                JPortal.jj_la1[38] = jj_gen;
                break;
            }
            case 8: {
                JPortal.jj_consume_token(8);
                JPortal.field.type = (byte)21;
                JPortal.field.length = 1;
                switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                    case 121: 
                    case 122: 
                    case 127: {
                        JPortal.jEnumChar();
                        break block0;
                    }
                }
                JPortal.jj_la1[39] = jj_gen;
                break;
            }
            case 100: {
                JPortal.jj_consume_token(100);
                JPortal.field.type = (byte)27;
                JPortal.field.length = 1;
                switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                    case 121: 
                    case 122: 
                    case 127: {
                        JPortal.jCharsize();
                        break;
                    }
                    default: {
                        JPortal.jj_la1[40] = jj_gen;
                    }
                }
                switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                    case 120: {
                        JPortal.jCharList();
                        break block0;
                    }
                }
                JPortal.jj_la1[41] = jj_gen;
                break;
            }
            case 99: {
                JPortal.jj_consume_token(99);
                JPortal.field.type = (byte)28;
                JPortal.field.length = 1;
                switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                    case 121: 
                    case 122: 
                    case 127: {
                        JPortal.jEnumChar();
                        break block0;
                    }
                }
                JPortal.jj_la1[42] = jj_gen;
                break;
            }
            case 97: {
                JPortal.jj_consume_token(97);
                JPortal.field.type = (byte)29;
                JPortal.field.length = 1;
                switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                    case 121: 
                    case 122: 
                    case 127: {
                        JPortal.jCharsize();
                        break;
                    }
                    default: {
                        JPortal.jj_la1[43] = jj_gen;
                    }
                }
                switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                    case 120: {
                        JPortal.jCharList();
                        break block0;
                    }
                }
                JPortal.jj_la1[44] = jj_gen;
                break;
            }
            case 79: {
                JPortal.jj_consume_token(79);
                JPortal.field.type = (byte)15;
                JPortal.field.length = 2;
                switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                    case 120: 
                    case 122: {
                        switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                            case 122: {
                                JPortal.jEnumValue();
                                break block0;
                            }
                            case 120: {
                                JPortal.jCharList();
                                break block0;
                            }
                        }
                        JPortal.jj_la1[45] = jj_gen;
                        JPortal.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                JPortal.jj_la1[46] = jj_gen;
                break;
            }
            case 50: {
                JPortal.jj_consume_token(50);
                JPortal.field.type = (byte)11;
                JPortal.field.length = 4;
                switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                    case 120: 
                    case 122: {
                        switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                            case 122: {
                                JPortal.jEnumValue();
                                break block0;
                            }
                            case 120: {
                                JPortal.jCharList();
                                break block0;
                            }
                        }
                        JPortal.jj_la1[47] = jj_gen;
                        JPortal.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                JPortal.jj_la1[48] = jj_gen;
                break;
            }
            case 53: {
                JPortal.jj_consume_token(53);
                JPortal.field.type = (byte)12;
                JPortal.field.length = 8;
                break;
            }
            case 89: {
                JPortal.jj_consume_token(89);
                JPortal.field.type = (byte)22;
                JPortal.field.length = 16;
                break;
            }
            case 27: {
                JPortal.jj_consume_token(27);
                JPortal.field.type = (byte)5;
                JPortal.field.length = 8;
                break;
            }
            case 28: {
                JPortal.jj_consume_token(28);
                JPortal.field.type = (byte)6;
                JPortal.field.length = 14;
                break;
            }
            case 85: {
                JPortal.jj_consume_token(85);
                JPortal.field.type = (byte)17;
                JPortal.field.length = 6;
                break;
            }
            case 86: {
                JPortal.jj_consume_token(86);
                JPortal.field.type = (byte)18;
                JPortal.table.hasTimeStamp = true;
                JPortal.field.length = 14;
                break;
            }
            case 10: {
                JPortal.jj_consume_token(10);
                JPortal.field.type = (byte)26;
                JPortal.table.hasAutoTimeStamp = true;
                JPortal.field.length = 14;
                break;
            }
            case 87: {
                JPortal.jj_consume_token(87);
                JPortal.field.type = (byte)19;
                JPortal.field.length = 0;
                switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                    case 121: 
                    case 122: 
                    case 127: {
                        JPortal.jCharsize();
                        break block0;
                    }
                }
                JPortal.jj_la1[49] = jj_gen;
                break;
            }
            case 101: {
                JPortal.jj_consume_token(101);
                JPortal.field.type = (byte)23;
                JPortal.field.length = 4096;
                switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                    case 121: 
                    case 122: 
                    case 127: {
                        JPortal.jCharsize();
                        break block0;
                    }
                }
                JPortal.jj_la1[50] = jj_gen;
                break;
            }
            case 13: {
                JPortal.jj_consume_token(13);
                JPortal.field.type = (byte)30;
                JPortal.field.length = 0x400000;
                switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                    case 121: 
                    case 122: 
                    case 127: {
                        JPortal.jCharsize();
                        break block0;
                    }
                }
                JPortal.jj_la1[51] = jj_gen;
                break;
            }
            case 96: {
                JPortal.jj_consume_token(96);
                JPortal.field.type = (byte)20;
                JPortal.table.hasUserStamp = true;
                JPortal.field.length = 50;
                break;
            }
            case 77: {
                JPortal.jj_consume_token(77);
                JPortal.field.type = (byte)14;
                JPortal.field.isSequence = true;
                JPortal.table.hasSequence = true;
                JPortal.field.length = 4;
                break;
            }
            case 12: {
                JPortal.jj_consume_token(12);
                JPortal.field.type = (byte)24;
                JPortal.field.isSequence = true;
                JPortal.table.hasSequence = true;
                JPortal.field.length = 8;
                break;
            }
            case 44: {
                JPortal.jj_consume_token(44);
                JPortal.field.type = (byte)10;
                JPortal.field.isSequence = true;
                JPortal.table.hasSequence = true;
                JPortal.field.length = 4;
                break;
            }
            case 11: {
                JPortal.jj_consume_token(11);
                JPortal.field.type = (byte)25;
                JPortal.field.isSequence = true;
                JPortal.table.hasSequence = true;
                JPortal.field.length = 8;
                break;
            }
            case 36: 
            case 41: {
                switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                    case 36: {
                        JPortal.jj_consume_token(36);
                        break;
                    }
                    case 41: {
                        JPortal.jj_consume_token(41);
                        break;
                    }
                    default: {
                        JPortal.jj_la1[52] = jj_gen;
                        JPortal.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                JPortal.field.type = (byte)7;
                JPortal.field.length = 8;
                switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                    case 121: 
                    case 122: {
                        JPortal.jFloatsize();
                        break block0;
                    }
                }
                JPortal.jj_la1[53] = jj_gen;
                break;
            }
            case 55: {
                JPortal.jj_consume_token(55);
                JPortal.field.type = (byte)13;
                JPortal.field.length = 8;
                break;
            }
            case 119: {
                JPortal.jLookup();
                break;
            }
            default: {
                JPortal.jj_la1[54] = jj_gen;
                JPortal.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public static final void jLookup() throws ParseException {
        String name = JPortal.field.name;
        JPortal.jj_consume_token(119);
        switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
            case 122: {
                JPortal.jj_consume_token(122);
                name = JPortal.jIdent();
                JPortal.jj_consume_token(125);
                break;
            }
            default: {
                JPortal.jj_la1[55] = jj_gen;
            }
        }
        Field other = proc.getInput(name);
        if (other == null) {
            other = proc.getOutput(name);
        }
        if (other == null) {
            other = table.getField(name);
        }
        if (other == null) {
            logger.warn(JPortal.field.name + " is not present for type usage. Resorting to int.");
            JPortal.field.type = (byte)11;
            JPortal.field.length = 4;
        } else {
            JPortal.field.type = other.type;
            JPortal.field.length = other.length;
            JPortal.field.precision = other.precision;
            JPortal.field.scale = other.scale;
            JPortal.field.enums = other.enums;
            if (other.enums != null && !other.enums.isEmpty()) {
                JPortal.field.enumType = other.useUpperName();
            }
        }
    }

    public static final void jEnumValue() throws ParseException {
        String s;
        JPortal.jj_consume_token(122);
        switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
            case 52: {
                JPortal.jj_consume_token(52);
                JPortal.field.enumLink = s = JPortal.jIdent();
                break;
            }
            default: {
                JPortal.jj_la1[56] = jj_gen;
            }
        }
        block9: while (true) {
            s = JPortal.jIdent();
            JPortal.jj_consume_token(119);
            int n = JPortal.jNumber();
            switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                case 118: {
                    JPortal.jj_consume_token(118);
                    break;
                }
                default: {
                    JPortal.jj_la1[57] = jj_gen;
                }
            }
            entry = new Enum();
            JPortal.entry.name = s;
            JPortal.entry.value = n;
            JPortal.field.enums.addElement(entry);
            switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                case 131: 
                case 132: {
                    continue block9;
                }
            }
            break;
        }
        JPortal.jj_la1[58] = jj_gen;
        JPortal.jj_consume_token(125);
    }

    public static final void jFloatsize() throws ParseException {
        switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
            case 121: {
                int n;
                JPortal.jj_consume_token(121);
                JPortal.field.precision = n = JPortal.jNumber();
                JPortal.jj_consume_token(118);
                JPortal.field.scale = n = JPortal.jNumber();
                JPortal.jj_consume_token(124);
                break;
            }
            case 122: {
                int n;
                JPortal.jj_consume_token(122);
                JPortal.field.precision = n = JPortal.jNumber();
                JPortal.jj_consume_token(118);
                JPortal.field.scale = n = JPortal.jNumber();
                JPortal.jj_consume_token(125);
                break;
            }
            default: {
                JPortal.jj_la1[59] = jj_gen;
                JPortal.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public static final void jEnumChar() throws ParseException {
        switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
            case 121: {
                int n;
                JPortal.jj_consume_token(121);
                JPortal.field.length = n = JPortal.jNumber();
                JPortal.jj_consume_token(124);
                break;
            }
            case 122: {
                JPortal.jj_consume_token(122);
                switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                    case 127: {
                        int n;
                        JPortal.field.length = n = JPortal.jNumber();
                        break;
                    }
                    case 52: 
                    case 131: 
                    case 132: {
                        String s;
                        switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                            case 52: {
                                JPortal.jj_consume_token(52);
                                JPortal.field.enumLink = s = JPortal.jIdent();
                                break;
                            }
                            default: {
                                JPortal.jj_la1[60] = jj_gen;
                            }
                        }
                        block18: while (true) {
                            s = JPortal.jIdent();
                            JPortal.jj_consume_token(119);
                            int n = JPortal.jAsciiChar();
                            switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                                case 118: {
                                    JPortal.jj_consume_token(118);
                                    break;
                                }
                                default: {
                                    JPortal.jj_la1[61] = jj_gen;
                                }
                            }
                            entry = new Enum();
                            JPortal.entry.name = s;
                            JPortal.entry.value = n;
                            JPortal.field.enums.addElement(entry);
                            switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                                case 131: 
                                case 132: {
                                    continue block18;
                                }
                            }
                            break;
                        }
                        JPortal.jj_la1[62] = jj_gen;
                        break;
                    }
                    default: {
                        JPortal.jj_la1[63] = jj_gen;
                        JPortal.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                JPortal.jj_consume_token(125);
                break;
            }
            case 127: {
                int n;
                JPortal.field.length = n = JPortal.jNumber();
                break;
            }
            default: {
                JPortal.jj_la1[64] = jj_gen;
                JPortal.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public static final void jCharsize() throws ParseException {
        switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
            case 121: {
                int n;
                JPortal.jj_consume_token(121);
                JPortal.field.length = n = JPortal.jNumber();
                JPortal.jj_consume_token(124);
                break;
            }
            case 122: {
                int n;
                JPortal.jj_consume_token(122);
                JPortal.field.length = n = JPortal.jNumber();
                JPortal.jj_consume_token(125);
                break;
            }
            case 127: {
                int n;
                JPortal.field.length = n = JPortal.jNumber();
                break;
            }
            default: {
                JPortal.jj_la1[65] = jj_gen;
                JPortal.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public static final void jCharList() throws ParseException {
        JPortal.jj_consume_token(120);
        block6: while (true) {
            String s = JPortal.jIdent();
            switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                case 118: {
                    JPortal.jj_consume_token(118);
                    break;
                }
                default: {
                    JPortal.jj_la1[66] = jj_gen;
                }
            }
            JPortal.field.valueList.addElement(s);
            switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                case 131: 
                case 132: {
                    continue block6;
                }
            }
            break;
        }
        JPortal.jj_la1[67] = jj_gen;
        JPortal.jj_consume_token(123);
    }

    public static final int jNumber() throws ParseException {
        Token t = JPortal.jj_consume_token(127);
        String s = t.image;
        Integer i = new Integer(s);
        if ("" != null) {
            return i;
        }
        throw new IllegalStateException("Missing return statement in function");
    }

    public static final void jParm() throws ParseException {
        block59: {
            String s;
            switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                case 128: {
                    JPortal.parameter.title = s = JPortal.jString();
                    break;
                }
                default: {
                    JPortal.jj_la1[68] = jj_gen;
                }
            }
            block45: while (true) {
                switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                    case 103: 
                    case 104: 
                    case 105: 
                    case 106: 
                    case 107: 
                    case 108: 
                    case 109: 
                    case 110: {
                        break;
                    }
                    default: {
                        JPortal.jj_la1[69] = jj_gen;
                        break block59;
                    }
                }
                switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                    case 103: {
                        JPortal.jj_consume_token(103);
                        block46: while (true) {
                            if (table.hasField(s = JPortal.jIdent())) {
                                JPortal.parameter.shows.addElement(table.getField(s));
                            } else {
                                logger.warn(s + " is not present in table for show.");
                            }
                            switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                                case 131: 
                                case 132: {
                                    continue block46;
                                }
                            }
                            break;
                        }
                        JPortal.jj_la1[70] = jj_gen;
                        continue block45;
                    }
                    case 104: {
                        JPortal.jj_consume_token(104);
                        JPortal.parameter.isViewOnly = true;
                        continue block45;
                    }
                    case 110: {
                        JPortal.jj_consume_token(110);
                        block47: while (true) {
                            if (table.hasField(s = JPortal.jIdent())) {
                                JPortal.parameter.supplied.addElement(table.getField(s));
                            } else {
                                logger.warn(s + " is not present in table for supplied.");
                            }
                            switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                                case 131: 
                                case 132: {
                                    continue block47;
                                }
                            }
                            break;
                        }
                        JPortal.jj_la1[71] = jj_gen;
                        continue block45;
                    }
                    case 105: {
                        JPortal.jj_consume_token(105);
                        switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                            case 131: 
                            case 132: {
                                s = JPortal.jIdent();
                                break;
                            }
                            case 71: {
                                JPortal.jj_consume_token(71);
                                s = "SelectAll";
                                break;
                            }
                            default: {
                                JPortal.jj_la1[72] = jj_gen;
                                JPortal.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        Proc p = table.getProc(s);
                        if (p != null) {
                            JPortal.parameter.cache = p;
                        } else {
                            logger.warn(s + " is not present in table as a cache reader.");
                        }
                        while (true) {
                            switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                                case 131: 
                                case 132: {
                                    break;
                                }
                                default: {
                                    JPortal.jj_la1[73] = jj_gen;
                                    continue block45;
                                }
                            }
                            s = JPortal.jIdent();
                            JPortal.parameter.cacheExtras.addElement(s);
                        }
                    }
                    case 106: {
                        JPortal.jj_consume_token(106);
                        switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                            case 131: 
                            case 132: {
                                s = JPortal.jIdent();
                                break;
                            }
                            case 71: {
                                JPortal.jj_consume_token(71);
                                s = "SelectAll";
                                break;
                            }
                            default: {
                                JPortal.jj_la1[74] = jj_gen;
                                JPortal.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        Proc p = table.getProc(s);
                        if (p != null) {
                            JPortal.parameter.reader = p;
                            continue block45;
                        }
                        logger.warn(s + " is not present in table as a reader.");
                        continue block45;
                    }
                    case 107: {
                        JPortal.jj_consume_token(107);
                        switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                            case 131: 
                            case 132: {
                                s = JPortal.jIdent();
                                break;
                            }
                            case 49: {
                                JPortal.jj_consume_token(49);
                                s = "Insert";
                                break;
                            }
                            default: {
                                JPortal.jj_la1[75] = jj_gen;
                                JPortal.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        Proc p = table.getProc(s);
                        if (p != null) {
                            JPortal.parameter.insert = p;
                            continue block45;
                        }
                        logger.warn(s + " is not present in table as an inserter.");
                        continue block45;
                    }
                    case 109: {
                        JPortal.jj_consume_token(109);
                        switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                            case 131: 
                            case 132: {
                                s = JPortal.jIdent();
                                break;
                            }
                            case 91: {
                                JPortal.jj_consume_token(91);
                                s = "Update";
                                break;
                            }
                            default: {
                                JPortal.jj_la1[76] = jj_gen;
                                JPortal.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        Proc p = table.getProc(s);
                        if (p != null) {
                            JPortal.parameter.update = p;
                            continue block45;
                        }
                        logger.warn(s + " is not present in table as an updater.");
                        continue block45;
                    }
                    case 108: {
                        JPortal.jj_consume_token(108);
                        switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                            case 131: 
                            case 132: {
                                s = JPortal.jIdent();
                                break;
                            }
                            case 34: {
                                JPortal.jj_consume_token(34);
                                s = "DeleteOne";
                                break;
                            }
                            default: {
                                JPortal.jj_la1[77] = jj_gen;
                                JPortal.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        Proc p = table.getProc(s);
                        if (p != null) {
                            JPortal.parameter.delete = p;
                            continue block45;
                        }
                        logger.warn(s + " is not present in table as a deleter.");
                        continue block45;
                    }
                }
                break;
            }
            JPortal.jj_la1[78] = jj_gen;
            JPortal.jj_consume_token(-1);
            throw new ParseException();
        }
    }

    public static final void jExtras() throws ParseException {
        switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
            case 43: {
                JPortal.jGrant();
                JPortal.table.grants.addElement(grant);
                break;
            }
            case 51: {
                JPortal.jKey();
                JPortal.table.keys.addElement(key);
                break;
            }
            case 52: {
                JPortal.jLink();
                JPortal.table.links.addElement(link);
                break;
            }
            case 98: {
                JPortal.jView();
                JPortal.table.views.addElement(view);
                break;
            }
            case 24: {
                JPortal.jConst();
                JPortal.table.consts.addElement(constant);
                break;
            }
            default: {
                JPortal.jj_la1[79] = jj_gen;
                JPortal.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public static final void jConst() throws ParseException {
        JPortal.jj_consume_token(24);
        String s = JPortal.jIdent();
        constant = new Const();
        JPortal.constant.name = s;
        block6: while (true) {
            s = JPortal.jIdent();
            JPortal.jj_consume_token(119);
            String v = JPortal.jString();
            switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                case 118: {
                    JPortal.jj_consume_token(118);
                    break;
                }
                default: {
                    JPortal.jj_la1[80] = jj_gen;
                }
            }
            value = new Value();
            JPortal.value.key = s;
            JPortal.value.value = v;
            JPortal.constant.values.addElement(value);
            switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                case 131: 
                case 132: {
                    continue block6;
                }
            }
            break;
        }
        JPortal.jj_la1[81] = jj_gen;
    }

    public static final void jGrant() throws ParseException {
        JPortal.jj_consume_token(43);
        grant = new Grant();
        block6: while (true) {
            JPortal.jPermission();
            if (grant.hasPerm(perm)) {
                logger.warn("perm " + perm + " already present in grant");
            } else {
                JPortal.grant.perms.addElement(perm);
            }
            switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                case 7: 
                case 31: 
                case 38: 
                case 49: 
                case 70: 
                case 91: {
                    continue block6;
                }
            }
            break;
        }
        JPortal.jj_la1[82] = jj_gen;
        JPortal.jj_consume_token(88);
        block7: while (true) {
            JPortal.jUser();
            if (grant.hasUser(user)) {
                logger.warn("user " + user + " already present in grant");
            } else {
                JPortal.grant.users.addElement(user);
            }
            switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                case 131: 
                case 132: {
                    continue block7;
                }
            }
            break;
        }
        JPortal.jj_la1[83] = jj_gen;
    }

    public static final void jPermission() throws ParseException {
        switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
            case 7: {
                JPortal.jj_consume_token(7);
                JPortal.table.hasExecute = true;
                JPortal.table.hasSelect = true;
                JPortal.table.hasDelete = true;
                JPortal.table.hasInsert = true;
                JPortal.table.hasUpdate = true;
                perm = "all";
                break;
            }
            case 31: {
                JPortal.jj_consume_token(31);
                JPortal.table.hasDelete = true;
                perm = "delete";
                break;
            }
            case 49: {
                JPortal.jj_consume_token(49);
                JPortal.table.hasInsert = true;
                perm = "insert";
                break;
            }
            case 70: {
                JPortal.jj_consume_token(70);
                JPortal.table.hasSelect = true;
                perm = "select";
                break;
            }
            case 91: {
                JPortal.jj_consume_token(91);
                JPortal.table.hasUpdate = true;
                perm = "update";
                break;
            }
            case 38: {
                JPortal.jj_consume_token(38);
                JPortal.table.hasExecute = true;
                break;
            }
            default: {
                JPortal.jj_la1[84] = jj_gen;
                JPortal.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public static final void jUser() throws ParseException {
        user = JPortal.jIdent();
    }

    public static final void jKey() throws ParseException {
        JPortal.jj_consume_token(51);
        String s = JPortal.jIdent();
        key = new Key();
        JPortal.key.name = s;
        block12: while (true) {
            switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                case 60: {
                    break;
                }
                default: {
                    JPortal.jj_la1[85] = jj_gen;
                    break block12;
                }
            }
            JPortal.jj_consume_token(60);
            block13: while (true) {
                s = JPortal.jString();
                JPortal.key.options.addElement(s);
                switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                    case 128: {
                        continue block13;
                    }
                }
                break;
            }
            JPortal.jj_la1[86] = jj_gen;
        }
        block14: while (true) {
            switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                case 65: 
                case 90: {
                    break;
                }
                default: {
                    JPortal.jj_la1[87] = jj_gen;
                    break block14;
                }
            }
            JPortal.jModifier();
        }
        block15: while (true) {
            JPortal.jColumn();
            switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                case 131: 
                case 132: {
                    continue block15;
                }
            }
            break;
        }
        JPortal.jj_la1[88] = jj_gen;
    }

    public static final void jModifier() throws ParseException {
        switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
            case 90: {
                JPortal.jj_consume_token(90);
                JPortal.key.isUnique = true;
                break;
            }
            case 65: {
                JPortal.jj_consume_token(65);
                JPortal.key.isPrimary = true;
                JPortal.table.hasPrimaryKey = true;
                break;
            }
            default: {
                JPortal.jj_la1[89] = jj_gen;
                JPortal.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public static final void jColumn() throws ParseException {
        String s = JPortal.jIdent();
        if (!table.hasField(s)) {
            logger.warn(JPortal.key.name + " field " + s + " not present in table");
        } else if (key.hasField(s)) {
            logger.warn(JPortal.key.name + " field " + s + " already present in key");
        } else {
            if (JPortal.key.isPrimary) {
                table.setPrimary(s);
            }
            JPortal.key.fields.addElement(s);
        }
    }

    public static final void jLink() throws ParseException {
        Proc dproc = new Proc();
        JPortal.jj_consume_token(52);
        String s = JPortal.jPackageIdent();
        link = new Link();
        JPortal.link.name = s;
        switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
            case 122: {
                JPortal.jj_consume_token(122);
                block27: while (true) {
                    s = JPortal.jIdent();
                    JPortal.link.linkFields.addElement(s);
                    switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                        case 131: 
                        case 132: {
                            continue block27;
                        }
                    }
                    break;
                }
                JPortal.jj_la1[90] = jj_gen;
                JPortal.jj_consume_token(125);
                break;
            }
            default: {
                JPortal.jj_la1[91] = jj_gen;
            }
        }
        switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
            case 31: {
                JPortal.jj_consume_token(31);
                switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                    case 20: {
                        JPortal.jj_consume_token(20);
                        break;
                    }
                    default: {
                        JPortal.jj_la1[92] = jj_gen;
                    }
                }
                JPortal.link.isDeleteCascade = true;
                break;
            }
            default: {
                JPortal.jj_la1[93] = jj_gen;
            }
        }
        switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
            case 91: {
                JPortal.jj_consume_token(91);
                switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                    case 20: {
                        JPortal.jj_consume_token(20);
                        break;
                    }
                    default: {
                        JPortal.jj_la1[94] = jj_gen;
                    }
                }
                JPortal.link.isUpdateCascade = true;
                break;
            }
            default: {
                JPortal.jj_la1[95] = jj_gen;
            }
        }
        block28: while (true) {
            switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                case 60: {
                    break;
                }
                default: {
                    JPortal.jj_la1[96] = jj_gen;
                    break block28;
                }
            }
            JPortal.jj_consume_token(60);
            block29: while (true) {
                s = JPortal.jString();
                JPortal.link.options.addElement(s);
                switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                    case 128: {
                        continue block29;
                    }
                }
                break;
            }
            JPortal.jj_la1[97] = jj_gen;
        }
        block30: while (true) {
            JPortal.jLinkColumn();
            switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                case 131: 
                case 132: {
                    continue block30;
                }
            }
            break;
        }
        JPortal.jj_la1[98] = jj_gen;
    }

    public static final void jLinkColumn() throws ParseException {
        String s = JPortal.jIdent();
        if (!table.hasField(s)) {
            logger.warn(JPortal.link.name + " field " + s + " not present in table");
        } else if (link.hasField(s)) {
            logger.warn(JPortal.link.name + " field " + s + " already present in link");
        } else {
            JPortal.link.fields.addElement(s);
        }
    }

    public static final void jView() throws ParseException {
        Token t = JPortal.jj_consume_token(98);
        String s = JPortal.jIdent();
        view = new View();
        JPortal.view.name = s;
        JPortal.view.start = t.beginLine;
        switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
            case 88: {
                JPortal.jj_consume_token(88);
                block15: while (true) {
                    JPortal.jUser();
                    if (view.hasUser(user)) {
                        logger.warn(JPortal.view.name + " user " + user + " already present in view");
                    } else {
                        JPortal.view.users.addElement(user);
                    }
                    switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                        case 131: 
                        case 132: {
                            continue block15;
                        }
                    }
                    break;
                }
                JPortal.jj_la1[99] = jj_gen;
                break;
            }
            default: {
                JPortal.jj_la1[100] = jj_gen;
            }
        }
        switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
            case 62: {
                JPortal.jj_consume_token(62);
                block16: while (true) {
                    JPortal.jViewAlias();
                    switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                        case 131: 
                        case 132: {
                            continue block16;
                        }
                    }
                    break;
                }
                JPortal.jj_la1[101] = jj_gen;
                break;
            }
            default: {
                JPortal.jj_la1[102] = jj_gen;
            }
        }
        switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
            case 111: {
                JPortal.jOldViewCode();
                break;
            }
            default: {
                JPortal.jj_la1[103] = jj_gen;
                JPortal.jNewViewCode();
            }
        }
    }

    public static final void jNewViewCode() throws ParseException {
        block3: while (true) {
            switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                case 139: {
                    break;
                }
                default: {
                    JPortal.jj_la1[104] = jj_gen;
                    break block3;
                }
            }
            Token t = JPortal.jj_consume_token(139);
            line = t.image.trim();
            JPortal.view.lines.addElement(line);
        }
    }

    public static final void jOldViewCode() throws ParseException {
        JPortal.jj_consume_token(111);
        block3: while (true) {
            switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                case 128: {
                    break;
                }
                default: {
                    JPortal.jj_la1[105] = jj_gen;
                    break block3;
                }
            }
            JPortal.jLine();
            JPortal.view.lines.addElement(line);
        }
        JPortal.jj_consume_token(113);
    }

    public static final void jViewAlias() throws ParseException {
        String s = JPortal.jIdent();
        if (view.hasAlias(s)) {
            logger.warn(JPortal.key.name + " alias " + s + " already present in view");
        } else {
            JPortal.view.aliases.addElement(s);
        }
    }

    public static final void jLine() throws ParseException {
        Token t = JPortal.jj_consume_token(128);
        String s = t.image;
        line = JPortal.fixString(s);
    }

    public static final String jString() throws ParseException {
        Token t = JPortal.jj_consume_token(128);
        String s = t.image;
        if ("" != null) {
            return JPortal.fixString(s);
        }
        throw new IllegalStateException("Missing return statement in function");
    }

    public static final int jAsciiChar() throws ParseException {
        String s = JPortal.jString();
        if ("" != null) {
            return s.charAt(0);
        }
        throw new IllegalStateException("Missing return statement in function");
    }

    public static final void jProc() throws ParseException {
        switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
            case 66: 
            case 82: {
                switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                    case 66: {
                        Token t = JPortal.jj_consume_token(66);
                        proc = new Proc();
                        JPortal.proc.table = table;
                        JPortal.proc.start = t.beginLine;
                        JPortal.proc.isProc = true;
                        break;
                    }
                    case 82: {
                        Token t = JPortal.jj_consume_token(82);
                        proc = new Proc();
                        JPortal.proc.table = table;
                        JPortal.proc.start = t.beginLine;
                        JPortal.proc.isSProc = true;
                        break;
                    }
                    default: {
                        JPortal.jj_la1[106] = jj_gen;
                        JPortal.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                block8 : switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                    case 16: 
                    case 17: 
                    case 23: 
                    case 33: 
                    case 34: 
                    case 39: 
                    case 49: 
                    case 54: 
                    case 71: 
                    case 72: 
                    case 75: 
                    case 76: 
                    case 91: 
                    case 94: {
                        JPortal.jStdProc();
                        break;
                    }
                    case 131: 
                    case 132: {
                        if (JPortal.jj_2_2(3)) {
                            JPortal.jNewProc();
                            break;
                        }
                        switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                            case 131: 
                            case 132: {
                                JPortal.jUserProc();
                                break block8;
                            }
                        }
                        JPortal.jj_la1[107] = jj_gen;
                        JPortal.jj_consume_token(-1);
                        throw new ParseException();
                    }
                    default: {
                        JPortal.jj_la1[108] = jj_gen;
                        JPortal.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                if (table.hasProc(proc)) {
                    logger.warn("proc " + JPortal.proc.name + " already present in table");
                    break;
                }
                JPortal.table.procs.addElement(proc);
                proc.checkPlaceHolders();
                break;
            }
            case 112: 
            case 142: 
            case 145: {
                switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                    case 112: {
                        JPortal.jOldData();
                        break;
                    }
                    case 142: {
                        JPortal.jNewData();
                        break;
                    }
                    case 145: {
                        JPortal.jIdlCode();
                        break;
                    }
                    default: {
                        JPortal.jj_la1[109] = jj_gen;
                        JPortal.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                JPortal.table.procs.addElement(proc);
                break;
            }
            default: {
                JPortal.jj_la1[110] = jj_gen;
                JPortal.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public static final void jStdProc() throws ParseException {
        String s;
        boolean forUpdate = false;
        boolean forReadOnly = false;
        boolean inOrder = false;
        boolean descending = false;
        boolean isStdProc = false;
        switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
            case 49: {
                JPortal.jj_consume_token(49);
                switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                    case 68: {
                        JPortal.jj_consume_token(68);
                        JPortal.proc.hasReturning = true;
                        break;
                    }
                    default: {
                        JPortal.jj_la1[111] = jj_gen;
                    }
                }
                JPortal.table.hasSequenceReturning = JPortal.table.hasSequence;
                JPortal.proc.name = "Insert";
                table.buildInsert(proc);
                JPortal.table.hasStdProcs = true;
                if (!JPortal.table.hasIdentity) break;
                JPortal.table.procs.addElement(proc);
                proc = new Proc();
                JPortal.proc.table = table;
                JPortal.proc.name = "Identity";
                table.buildIdentity(proc);
                break;
            }
            case 91: {
                JPortal.jj_consume_token(91);
                if (!JPortal.table.hasPrimaryKey) {
                    logger.warn("proc Update requires a primary key");
                    break;
                }
                JPortal.proc.name = "Update";
                JPortal.proc.isUpdate = true;
                table.buildUpdate(proc);
                JPortal.table.hasStdProcs = true;
                break;
            }
            case 16: {
                JPortal.jj_consume_token(16);
                switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                    case 122: {
                        JPortal.jRowCount();
                        break;
                    }
                    default: {
                        JPortal.jj_la1[112] = jj_gen;
                    }
                }
                JPortal.proc.name = "BulkInsert";
                table.buildBulkInsert(proc);
                JPortal.table.hasStdProcs = true;
                break;
            }
            case 94: {
                JPortal.jj_consume_token(94);
                JPortal.proc.name = "MaxTmStamp";
                table.buildMaxTmStamp(proc);
                JPortal.table.hasStdProcs = true;
                break;
            }
            case 17: {
                JPortal.jj_consume_token(17);
                switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                    case 122: {
                        JPortal.jRowCount();
                        break;
                    }
                    default: {
                        JPortal.jj_la1[113] = jj_gen;
                    }
                }
                if (!JPortal.table.hasPrimaryKey) {
                    logger.warn("proc Update requires a primary key");
                    break;
                }
                JPortal.proc.name = "BulkUpdate";
                JPortal.proc.isUpdate = true;
                table.buildBulkUpdate(proc);
                JPortal.table.hasStdProcs = true;
                break;
            }
            case 34: {
                JPortal.jj_consume_token(34);
                switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                    case 122: {
                        JPortal.jj_consume_token(122);
                        JPortal.jj_consume_token(83);
                        JPortal.jj_consume_token(125);
                        JPortal.proc.isStd = true;
                        break;
                    }
                    default: {
                        JPortal.jj_la1[114] = jj_gen;
                    }
                }
                JPortal.table.hasStdProcs = true;
                if (!JPortal.table.hasPrimaryKey) {
                    logger.warn("proc DeleteOne requires a primary key");
                    break;
                }
                JPortal.proc.name = "DeleteOne";
                table.buildDeleteOne(proc);
                JPortal.table.hasStdProcs = true;
                break;
            }
            case 33: {
                JPortal.jj_consume_token(33);
                JPortal.proc.name = "DeleteAll";
                table.buildDeleteAll(proc);
                JPortal.table.hasStdProcs = true;
                break;
            }
            case 76: {
                JPortal.jj_consume_token(76);
                block28 : switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                    case 42: 
                    case 67: 
                    case 91: {
                        switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                            case 42: {
                                JPortal.jj_consume_token(42);
                                break;
                            }
                            default: {
                                JPortal.jj_la1[115] = jj_gen;
                            }
                        }
                        switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                            case 91: {
                                JPortal.jj_consume_token(91);
                                forUpdate = true;
                                break block28;
                            }
                            case 67: {
                                JPortal.jj_consume_token(67);
                                forReadOnly = true;
                                break block28;
                            }
                        }
                        JPortal.jj_la1[116] = jj_gen;
                        JPortal.jj_consume_token(-1);
                        throw new ParseException();
                    }
                    default: {
                        JPortal.jj_la1[117] = jj_gen;
                    }
                }
                if (!JPortal.table.hasPrimaryKey) {
                    logger.warn("proc SelectOne requires a primary key");
                    break;
                }
                JPortal.proc.name = "SelectOne";
                if (forUpdate) {
                    JPortal.proc.name = JPortal.proc.name + "Upd";
                } else if (forReadOnly) {
                    JPortal.proc.name = JPortal.proc.name + "ReadOnly";
                }
                table.buildSelectOne(proc, forUpdate, forReadOnly);
                JPortal.table.hasStdProcs = true;
                break;
            }
            case 75: {
                JPortal.jj_consume_token(75);
                block119: while (true) {
                    JPortal.jProcColumn();
                    switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                        case 131: 
                        case 132: {
                            continue block119;
                        }
                    }
                    break;
                }
                JPortal.jj_la1[118] = jj_gen;
                switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                    case 46: 
                    case 61: {
                        switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                            case 46: {
                                JPortal.jj_consume_token(46);
                                break;
                            }
                            default: {
                                JPortal.jj_la1[119] = jj_gen;
                            }
                        }
                        JPortal.jj_consume_token(61);
                        inOrder = true;
                        break;
                    }
                    default: {
                        JPortal.jj_la1[120] = jj_gen;
                    }
                }
                block47 : switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                    case 42: 
                    case 67: 
                    case 91: {
                        switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                            case 42: {
                                JPortal.jj_consume_token(42);
                                break;
                            }
                            default: {
                                JPortal.jj_la1[121] = jj_gen;
                            }
                        }
                        switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                            case 91: {
                                JPortal.jj_consume_token(91);
                                forUpdate = true;
                                break block47;
                            }
                            case 67: {
                                JPortal.jj_consume_token(67);
                                forReadOnly = true;
                                break block47;
                            }
                        }
                        JPortal.jj_la1[122] = jj_gen;
                        JPortal.jj_consume_token(-1);
                        throw new ParseException();
                    }
                    default: {
                        JPortal.jj_la1[123] = jj_gen;
                    }
                }
                switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                    case 9: {
                        JPortal.jj_consume_token(9);
                        JPortal.proc.name = s = JPortal.jIdent();
                        break;
                    }
                    default: {
                        JPortal.jj_la1[124] = jj_gen;
                    }
                }
                if (JPortal.proc.name == null || JPortal.proc.name.trim().isEmpty()) {
                    JPortal.proc.name = "SelectOneBy";
                    for (String fname : JPortal.proc.fields) {
                        JPortal.proc.name = JPortal.proc.name + fname;
                    }
                }
                JPortal.proc.isSingle = true;
                table.buildSelectBy(proc, forUpdate, forReadOnly, inOrder, descending);
                JPortal.table.hasStdProcs = true;
                break;
            }
            case 72: {
                JPortal.jj_consume_token(72);
                block121: while (true) {
                    JPortal.jProcColumn();
                    switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                        case 131: 
                        case 132: {
                            continue block121;
                        }
                    }
                    break;
                }
                JPortal.jj_la1[125] = jj_gen;
                switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                    case 46: 
                    case 61: {
                        switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                            case 46: {
                                JPortal.jj_consume_token(46);
                                break;
                            }
                            default: {
                                JPortal.jj_la1[126] = jj_gen;
                            }
                        }
                        JPortal.jj_consume_token(61);
                        inOrder = true;
                        break;
                    }
                    default: {
                        JPortal.jj_la1[127] = jj_gen;
                    }
                }
                block69 : switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                    case 42: 
                    case 67: 
                    case 91: {
                        switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                            case 42: {
                                JPortal.jj_consume_token(42);
                                break;
                            }
                            default: {
                                JPortal.jj_la1[128] = jj_gen;
                            }
                        }
                        switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                            case 91: {
                                JPortal.jj_consume_token(91);
                                forUpdate = true;
                                break block69;
                            }
                            case 67: {
                                JPortal.jj_consume_token(67);
                                forReadOnly = true;
                                break block69;
                            }
                        }
                        JPortal.jj_la1[129] = jj_gen;
                        JPortal.jj_consume_token(-1);
                        throw new ParseException();
                    }
                    default: {
                        JPortal.jj_la1[130] = jj_gen;
                    }
                }
                switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                    case 9: {
                        JPortal.jj_consume_token(9);
                        JPortal.proc.name = s = JPortal.jIdent();
                        break;
                    }
                    default: {
                        JPortal.jj_la1[131] = jj_gen;
                    }
                }
                block82 : switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                    case 62: {
                        JPortal.jj_consume_token(62);
                        switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                            case 122: {
                                JPortal.jOutputType();
                                break;
                            }
                            default: {
                                JPortal.jj_la1[132] = jj_gen;
                            }
                        }
                        while (true) {
                            switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                                case 131: 
                                case 132: {
                                    break;
                                }
                                default: {
                                    JPortal.jj_la1[133] = jj_gen;
                                    break block82;
                                }
                            }
                            JPortal.jField();
                            if (JPortal.proc.isSProc) {
                                if (proc.hasInput(JPortal.field.name)) {
                                    field = proc.getInput(JPortal.field.name);
                                } else {
                                    JPortal.proc.inputs.addElement(field);
                                }
                                JPortal.field.isOut = true;
                                continue;
                            }
                            if (proc.hasOutput(JPortal.field.name)) {
                                if (JPortal.proc.extendsStd) continue;
                                logger.warn(JPortal.proc.name + " field " + JPortal.field.name + " already present as output");
                                continue;
                            }
                            if (JPortal.proc.extendsStd) {
                                JPortal.proc.useStd = false;
                                isStdProc = false;
                            }
                            if (!JPortal.field.isNull) {
                                JPortal.field.isNull = table.hasFieldAsNull(JPortal.field.name);
                            }
                            JPortal.proc.outputs.addElement(field);
                        }
                    }
                    default: {
                        JPortal.jj_la1[134] = jj_gen;
                    }
                }
                if (JPortal.proc.name == null || JPortal.proc.name.trim().isEmpty()) {
                    JPortal.proc.name = "SelectBy";
                    for (String fname : JPortal.proc.fields) {
                        JPortal.proc.name = JPortal.proc.name + fname;
                    }
                }
                table.buildSelectBy(proc, forUpdate, forReadOnly, inOrder, descending);
                JPortal.table.hasStdProcs = true;
                break;
            }
            case 71: {
                JPortal.jj_consume_token(71);
                block91 : switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                    case 46: 
                    case 61: {
                        switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                            case 46: {
                                JPortal.jj_consume_token(46);
                                break;
                            }
                            default: {
                                JPortal.jj_la1[135] = jj_gen;
                            }
                        }
                        JPortal.jj_consume_token(61);
                        inOrder = true;
                        block124: while (true) {
                            switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                                case 131: 
                                case 132: {
                                    break;
                                }
                                default: {
                                    JPortal.jj_la1[136] = jj_gen;
                                    break block124;
                                }
                            }
                            JPortal.jOrderColumn();
                        }
                        switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                            case 35: {
                                JPortal.jj_consume_token(35);
                                descending = true;
                                break block91;
                            }
                        }
                        JPortal.jj_la1[137] = jj_gen;
                        break;
                    }
                    default: {
                        JPortal.jj_la1[138] = jj_gen;
                    }
                }
                block103 : switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                    case 42: 
                    case 67: 
                    case 91: {
                        switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                            case 42: {
                                JPortal.jj_consume_token(42);
                                break;
                            }
                            default: {
                                JPortal.jj_la1[139] = jj_gen;
                            }
                        }
                        switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                            case 91: {
                                JPortal.jj_consume_token(91);
                                forUpdate = true;
                                break block103;
                            }
                            case 67: {
                                JPortal.jj_consume_token(67);
                                forReadOnly = true;
                                break block103;
                            }
                        }
                        JPortal.jj_la1[140] = jj_gen;
                        JPortal.jj_consume_token(-1);
                        throw new ParseException();
                    }
                    default: {
                        JPortal.jj_la1[141] = jj_gen;
                    }
                }
                if (JPortal.table.hasBigXML) {
                    logger.warn("proc SelectAll is invalid with BigXML field");
                    break;
                }
                JPortal.proc.name = "SelectAll";
                if (inOrder) {
                    JPortal.proc.name = JPortal.proc.name + "Sorted";
                }
                if (forUpdate) {
                    JPortal.proc.name = JPortal.proc.name + "Upd";
                } else if (forReadOnly) {
                    JPortal.proc.name = JPortal.proc.name + "ReadOnly";
                }
                table.buildSelectAll(proc, forUpdate, forReadOnly, inOrder, descending);
                JPortal.table.hasStdProcs = true;
                break;
            }
            case 23: {
                JPortal.jj_consume_token(23);
                JPortal.proc.name = "Count";
                table.buildCount(proc);
                break;
            }
            case 39: {
                JPortal.jj_consume_token(39);
                if (!JPortal.table.hasPrimaryKey) {
                    logger.warn("proc Exists requires a primary key");
                    break;
                }
                JPortal.proc.name = "Exists";
                table.buildExists(proc);
                break;
            }
            case 54: {
                JPortal.jj_consume_token(54);
                if (!JPortal.table.hasPrimaryKey) {
                    logger.warn("proc Merge requires a primary key");
                    break;
                }
                if (JPortal.table.hasSequence) {
                    logger.warn("proc Merge cannot be used on a table with a sequence");
                    break;
                }
                JPortal.proc.name = "Merge";
                table.buildMerge(proc);
                break;
            }
            default: {
                JPortal.jj_la1[142] = jj_gen;
                JPortal.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        block125: while (true) {
            switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                case 60: {
                    break;
                }
                default: {
                    JPortal.jj_la1[143] = jj_gen;
                    break block125;
                }
            }
            JPortal.jj_consume_token(60);
            block126: while (true) {
                s = JPortal.jString();
                JPortal.proc.options.addElement(s);
                switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                    case 128: {
                        continue block126;
                    }
                }
                break;
            }
            JPortal.jj_la1[144] = jj_gen;
        }
    }

    public static final void jNewProc() throws ParseException {
        String s;
        boolean isStdProc = false;
        boolean forUpdate = false;
        boolean forReadOnly = false;
        boolean inOrder = false;
        boolean descending = false;
        JPortal.proc.name = s = JPortal.jIdent();
        switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
            case 70: {
                JPortal.jj_consume_token(70);
                switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                    case 122: {
                        JPortal.jj_consume_token(122);
                        JPortal.jj_consume_token(83);
                        JPortal.jj_consume_token(125);
                        JPortal.proc.isStd = true;
                        break;
                    }
                    default: {
                        JPortal.jj_la1[145] = jj_gen;
                    }
                }
                switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                    case 48: {
                        JPortal.jj_consume_token(48);
                        switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                            case 122: {
                                JPortal.jInputType();
                                break;
                            }
                            default: {
                                JPortal.jj_la1[146] = jj_gen;
                            }
                        }
                        JPortal.proc.extendsStd = true;
                        JPortal.proc.useStd = true;
                        isStdProc = true;
                        block94: while (true) {
                            JPortal.jField();
                            if (proc.hasInput(JPortal.field.name)) {
                                logger.warn(JPortal.proc.name + " field " + JPortal.field.name + " already present as input");
                            } else {
                                if (JPortal.proc.extendsStd && !proc.hasOutput(JPortal.field.name)) {
                                    JPortal.proc.useStd = false;
                                    isStdProc = false;
                                }
                                if (!JPortal.field.isNull) {
                                    JPortal.field.isNull = table.hasFieldAsNull(JPortal.field.name);
                                }
                                JPortal.field.isIn = true;
                                JPortal.proc.inputs.addElement(field);
                            }
                            switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                                case 131: 
                                case 132: {
                                    continue block94;
                                }
                            }
                            break;
                        }
                        JPortal.jj_la1[147] = jj_gen;
                        break;
                    }
                    default: {
                        JPortal.jj_la1[148] = jj_gen;
                    }
                }
                block20 : switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                    case 62: {
                        JPortal.jj_consume_token(62);
                        switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                            case 122: {
                                JPortal.jOutputType();
                                break;
                            }
                            default: {
                                JPortal.jj_la1[149] = jj_gen;
                            }
                        }
                        while (true) {
                            switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                                case 131: 
                                case 132: {
                                    break;
                                }
                                default: {
                                    JPortal.jj_la1[150] = jj_gen;
                                    break block20;
                                }
                            }
                            JPortal.jPackageField();
                            if (JPortal.proc.isSProc) {
                                if (proc.hasInput(JPortal.field.name)) {
                                    field = proc.getInput(JPortal.field.name);
                                } else {
                                    JPortal.proc.inputs.addElement(field);
                                }
                                JPortal.field.isOut = true;
                                continue;
                            }
                            if (proc.hasOutput(JPortal.field.name)) {
                                if (JPortal.proc.extendsStd) continue;
                                logger.warn(JPortal.proc.name + " field " + JPortal.field.name + " already present as output");
                                continue;
                            }
                            if (JPortal.proc.extendsStd) {
                                JPortal.proc.useStd = false;
                                isStdProc = false;
                            }
                            if (!JPortal.field.isNull) {
                                JPortal.field.isNull = table.hasFieldAsNull(JPortal.field.name);
                            }
                            JPortal.proc.outputs.addElement(field);
                        }
                    }
                    default: {
                        JPortal.jj_la1[151] = jj_gen;
                    }
                }
                switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                    case 81: 
                    case 111: {
                        JPortal.jOldCode();
                        break;
                    }
                    default: {
                        JPortal.jj_la1[152] = jj_gen;
                        JPortal.jNewCode();
                    }
                }
                table.buildSelectFrom(proc, table);
                JPortal.proc.useStd = true;
                isStdProc = true;
                break;
            }
            case 75: {
                JPortal.jj_consume_token(75);
                block96: while (true) {
                    JPortal.jProcColumn();
                    switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                        case 131: 
                        case 132: {
                            continue block96;
                        }
                    }
                    break;
                }
                JPortal.jj_la1[153] = jj_gen;
                block35 : switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                    case 42: 
                    case 67: 
                    case 91: {
                        switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                            case 42: {
                                JPortal.jj_consume_token(42);
                                break;
                            }
                            default: {
                                JPortal.jj_la1[154] = jj_gen;
                            }
                        }
                        switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                            case 91: {
                                JPortal.jj_consume_token(91);
                                forUpdate = true;
                                break block35;
                            }
                            case 67: {
                                JPortal.jj_consume_token(67);
                                forReadOnly = true;
                                break block35;
                            }
                        }
                        JPortal.jj_la1[155] = jj_gen;
                        JPortal.jj_consume_token(-1);
                        throw new ParseException();
                    }
                    default: {
                        JPortal.jj_la1[156] = jj_gen;
                    }
                }
                JPortal.proc.isSingle = true;
                table.buildSelectBy(proc, forUpdate, forReadOnly, inOrder, descending);
                JPortal.table.hasStdProcs = true;
                break;
            }
            case 72: {
                JPortal.jj_consume_token(72);
                block97: while (true) {
                    JPortal.jProcColumn();
                    switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                        case 131: 
                        case 132: {
                            continue block97;
                        }
                    }
                    break;
                }
                JPortal.jj_la1[157] = jj_gen;
                block48 : switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                    case 46: 
                    case 61: {
                        switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                            case 46: {
                                JPortal.jj_consume_token(46);
                                break;
                            }
                            default: {
                                JPortal.jj_la1[158] = jj_gen;
                            }
                        }
                        JPortal.jj_consume_token(61);
                        inOrder = true;
                        block98: while (true) {
                            switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                                case 131: 
                                case 132: {
                                    break;
                                }
                                default: {
                                    JPortal.jj_la1[159] = jj_gen;
                                    break block98;
                                }
                            }
                            JPortal.jOrderColumn();
                        }
                        switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                            case 35: {
                                JPortal.jj_consume_token(35);
                                descending = true;
                                break block48;
                            }
                        }
                        JPortal.jj_la1[160] = jj_gen;
                        break;
                    }
                    default: {
                        JPortal.jj_la1[161] = jj_gen;
                    }
                }
                block60 : switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                    case 42: 
                    case 67: 
                    case 91: {
                        switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                            case 42: {
                                JPortal.jj_consume_token(42);
                                break;
                            }
                            default: {
                                JPortal.jj_la1[162] = jj_gen;
                            }
                        }
                        switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                            case 91: {
                                JPortal.jj_consume_token(91);
                                forUpdate = true;
                                break block60;
                            }
                            case 67: {
                                JPortal.jj_consume_token(67);
                                forReadOnly = true;
                                break block60;
                            }
                        }
                        JPortal.jj_la1[163] = jj_gen;
                        JPortal.jj_consume_token(-1);
                        throw new ParseException();
                    }
                    default: {
                        JPortal.jj_la1[164] = jj_gen;
                    }
                }
                block70 : switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                    case 62: {
                        JPortal.jj_consume_token(62);
                        switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                            case 122: {
                                JPortal.jOutputType();
                                break;
                            }
                            default: {
                                JPortal.jj_la1[165] = jj_gen;
                            }
                        }
                        while (true) {
                            switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                                case 131: 
                                case 132: {
                                    break;
                                }
                                default: {
                                    JPortal.jj_la1[166] = jj_gen;
                                    break block70;
                                }
                            }
                            JPortal.jField();
                            if (JPortal.proc.isSProc) {
                                if (proc.hasInput(JPortal.field.name)) {
                                    field = proc.getInput(JPortal.field.name);
                                } else {
                                    JPortal.proc.inputs.addElement(field);
                                }
                                JPortal.field.isOut = true;
                                continue;
                            }
                            if (proc.hasOutput(JPortal.field.name)) {
                                if (JPortal.proc.extendsStd) continue;
                                logger.warn(JPortal.proc.name + " field " + JPortal.field.name + " already present as output");
                                continue;
                            }
                            if (JPortal.proc.extendsStd) {
                                JPortal.proc.useStd = false;
                                isStdProc = false;
                            }
                            if (!JPortal.field.isNull) {
                                JPortal.field.isNull = table.hasFieldAsNull(JPortal.field.name);
                            }
                            JPortal.proc.outputs.addElement(field);
                        }
                    }
                    default: {
                        JPortal.jj_la1[167] = jj_gen;
                    }
                }
                table.buildSelectBy(proc, forUpdate, forReadOnly, inOrder, descending);
                JPortal.table.hasStdProcs = true;
                break;
            }
            case 32: {
                JPortal.jj_consume_token(32);
                block100: while (true) {
                    JPortal.jProcColumn();
                    switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                        case 131: 
                        case 132: {
                            continue block100;
                        }
                    }
                    break;
                }
                JPortal.jj_la1[168] = jj_gen;
                table.buildDeleteBy(proc);
                JPortal.table.hasStdProcs = true;
                break;
            }
            case 92: {
                JPortal.jj_consume_token(92);
                block101: while (true) {
                    JPortal.jProcColumn();
                    switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                        case 131: 
                        case 132: {
                            continue block101;
                        }
                    }
                    break;
                }
                JPortal.jj_la1[169] = jj_gen;
                JPortal.proc.isUpdate = true;
                table.buildUpdateFor(proc);
                JPortal.table.hasStdProcs = true;
                break;
            }
            case 93: {
                JPortal.jj_consume_token(93);
                block102: while (true) {
                    JPortal.jProcUpdateByColumn();
                    switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                        case 131: 
                        case 132: {
                            continue block102;
                        }
                    }
                    break;
                }
                JPortal.jj_la1[170] = jj_gen;
                switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                    case 42: {
                        JPortal.jj_consume_token(42);
                        block103: while (true) {
                            JPortal.jProcColumn();
                            switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                                case 131: 
                                case 132: {
                                    continue block103;
                                }
                            }
                            break;
                        }
                        JPortal.jj_la1[171] = jj_gen;
                        break;
                    }
                    default: {
                        JPortal.jj_la1[172] = jj_gen;
                    }
                }
                JPortal.proc.isUpdate = true;
                table.buildUpdateBy(proc);
                JPortal.table.hasStdProcs = true;
                break;
            }
            default: {
                JPortal.jj_la1[173] = jj_gen;
                JPortal.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public static final void jProcColumn() throws ParseException {
        String s = JPortal.jIdent();
        if (!table.hasField(s)) {
            logger.warn(JPortal.proc.name + " field " + s + " not present in table");
        } else if (proc.hasFields(s)) {
            logger.warn(JPortal.proc.name + " field " + s + " already present");
        } else if (proc.hasUpdateFields(s)) {
            logger.warn(JPortal.proc.name + " field " + s + " cannot be set as well, already present as input");
        } else {
            JPortal.proc.fields.addElement(s);
        }
    }

    public static final void jOrderColumn() throws ParseException {
        String s = JPortal.jIdent();
        if (!table.hasField(s)) {
            logger.warn(JPortal.proc.name + " field " + s + " not present in table");
        } else if (proc.hasOrders(s)) {
            logger.warn(JPortal.proc.name + " field " + s + " already present");
        } else {
            JPortal.proc.orderFields.addElement(s);
        }
    }

    public static final void jProcUpdateByColumn() throws ParseException {
        String s = JPortal.jIdent();
        if (!table.hasField(s)) {
            logger.warn(JPortal.proc.name + " field " + s + " not present in table");
        } else if (proc.hasUpdateFields(s)) {
            logger.warn(JPortal.proc.name + " field " + s + " already present");
        } else {
            JPortal.proc.updateFields.addElement(s);
        }
    }

    public static final String jComment() throws ParseException {
        Token t = JPortal.jj_consume_token(115);
        String s = t.image;
        while (s.indexOf(42) == 0) {
            s = s.substring(1);
        }
        int n = s.indexOf(13);
        if (n == -1 && (n = s.indexOf(10)) == -1) {
            n = s.length() - 1;
        }
        if ("" != null) {
            return s.substring(0, n);
        }
        throw new IllegalStateException("Missing return statement in function");
    }

    public static final void jRowCount() throws ParseException {
        JPortal.jj_consume_token(122);
        int n = JPortal.jNumber();
        JPortal.jj_consume_token(125);
        JPortal.proc.noRows = n;
    }

    public static final void jUserProc() throws ParseException {
        String s;
        boolean isStdProc = false;
        JPortal.proc.name = s = JPortal.jIdent();
        Line l1 = new Line(Misc.generateProcNameComment(proc));
        JPortal.proc.lines.addElement(l1);
        switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
            case 122: {
                JPortal.jj_consume_token(122);
                JPortal.jj_consume_token(83);
                JPortal.jj_consume_token(125);
                JPortal.proc.extendsStd = true;
                JPortal.proc.useStd = true;
                isStdProc = true;
                for (int i = 0; i < JPortal.table.fields.size(); ++i) {
                    JPortal.proc.outputs.addElement(JPortal.table.fields.elementAt(i));
                }
                break;
            }
            default: {
                JPortal.jj_la1[174] = jj_gen;
            }
        }
        block43: while (true) {
            switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                case 115: {
                    break;
                }
                default: {
                    JPortal.jj_la1[175] = jj_gen;
                    break block43;
                }
            }
            s = JPortal.jComment();
            JPortal.proc.comments.addElement(s);
        }
        block44: while (true) {
            switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                case 60: {
                    break;
                }
                default: {
                    JPortal.jj_la1[176] = jj_gen;
                    break block44;
                }
            }
            JPortal.jj_consume_token(60);
            block45: while (true) {
                s = JPortal.jString();
                JPortal.proc.options.addElement(s);
                switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                    case 128: {
                        continue block45;
                    }
                }
                break;
            }
            JPortal.jj_la1[177] = jj_gen;
        }
        block12 : switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
            case 48: {
                JPortal.jj_consume_token(48);
                switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                    case 122: {
                        JPortal.jInputType();
                        break;
                    }
                    default: {
                        JPortal.jj_la1[178] = jj_gen;
                    }
                }
                while (true) {
                    switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                        case 131: 
                        case 132: {
                            break;
                        }
                        default: {
                            JPortal.jj_la1[179] = jj_gen;
                            break block12;
                        }
                    }
                    JPortal.jField();
                    if (proc.hasInput(JPortal.field.name)) {
                        logger.warn(JPortal.proc.name + " field " + JPortal.field.name + " already present as input");
                        continue;
                    }
                    if (JPortal.proc.extendsStd && !proc.hasOutput(JPortal.field.name)) {
                        JPortal.proc.useStd = false;
                        isStdProc = false;
                    }
                    if (!JPortal.field.isNull) {
                        JPortal.field.isNull = table.hasFieldAsNull(JPortal.field.name);
                    }
                    JPortal.field.isIn = true;
                    JPortal.proc.inputs.addElement(field);
                }
            }
            default: {
                JPortal.jj_la1[180] = jj_gen;
            }
        }
        block21 : switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
            case 47: {
                JPortal.jj_consume_token(47);
                switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                    case 122: {
                        JPortal.jOutputType();
                        break;
                    }
                    default: {
                        JPortal.jj_la1[181] = jj_gen;
                    }
                }
                while (true) {
                    switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                        case 131: 
                        case 132: {
                            break;
                        }
                        default: {
                            JPortal.jj_la1[182] = jj_gen;
                            break block21;
                        }
                    }
                    JPortal.jField();
                    if (proc.hasInput(JPortal.field.name)) {
                        logger.warn(JPortal.proc.name + " field " + JPortal.field.name + " already present as input");
                        continue;
                    }
                    if (proc.hasOutput(JPortal.field.name)) {
                        if (JPortal.proc.extendsStd) continue;
                        logger.warn(JPortal.proc.name + " field " + JPortal.field.name + " already present as output");
                        continue;
                    }
                    if (JPortal.proc.extendsStd) {
                        JPortal.proc.useStd = false;
                        isStdProc = false;
                        JPortal.proc.isProc = true;
                    }
                    if (!JPortal.field.isNull) {
                        JPortal.field.isNull = table.hasFieldAsNull(JPortal.field.name);
                    }
                    JPortal.field.isIn = true;
                    JPortal.field.isOut = true;
                    JPortal.proc.inputs.addElement(field);
                    if (JPortal.proc.isSProc) continue;
                    JPortal.proc.outputs.addElement(field);
                }
            }
            default: {
                JPortal.jj_la1[183] = jj_gen;
            }
        }
        block30 : switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
            case 62: {
                JPortal.jj_consume_token(62);
                switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                    case 122: {
                        JPortal.jOutputType();
                        break;
                    }
                    default: {
                        JPortal.jj_la1[184] = jj_gen;
                    }
                }
                while (true) {
                    switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                        case 131: 
                        case 132: {
                            break;
                        }
                        default: {
                            JPortal.jj_la1[185] = jj_gen;
                            break block30;
                        }
                    }
                    JPortal.jField();
                    if (JPortal.proc.isSProc) {
                        if (proc.hasInput(JPortal.field.name)) {
                            field = proc.getInput(JPortal.field.name);
                        } else {
                            JPortal.proc.inputs.addElement(field);
                        }
                        JPortal.field.isOut = true;
                        continue;
                    }
                    if (proc.hasOutput(JPortal.field.name)) {
                        if (JPortal.proc.extendsStd) continue;
                        logger.warn(JPortal.proc.name + " field " + JPortal.field.name + " already present as output");
                        continue;
                    }
                    if (JPortal.proc.extendsStd) {
                        JPortal.proc.useStd = false;
                        isStdProc = false;
                    }
                    if (!JPortal.field.isNull) {
                        JPortal.field.isNull = table.hasFieldAsNull(JPortal.field.name);
                    }
                    JPortal.proc.outputs.addElement(field);
                }
            }
            default: {
                JPortal.jj_la1[186] = jj_gen;
            }
        }
        if (isStdProc) {
            JPortal.table.hasStdProcs = true;
        }
        switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
            case 81: 
            case 111: {
                JPortal.jOldCode();
                break;
            }
            default: {
                JPortal.jj_la1[187] = jj_gen;
                JPortal.jNewCode();
            }
        }
    }

    public static final void jOldCode() throws ParseException {
        block12: {
            switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                case 81: {
                    JPortal.jj_consume_token(81);
                    JPortal.proc.isSql = true;
                    break;
                }
                default: {
                    JPortal.jj_la1[188] = jj_gen;
                }
            }
            JPortal.jj_consume_token(111);
            block10: while (true) {
                switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                    case 128: 
                    case 131: 
                    case 132: {
                        break;
                    }
                    default: {
                        JPortal.jj_la1[189] = jj_gen;
                        break block12;
                    }
                }
                switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                    case 128: {
                        JPortal.jLine();
                        Line l1 = new Line(line);
                        JPortal.proc.lines.addElement(l1);
                        continue block10;
                    }
                    case 131: 
                    case 132: {
                        String s = JPortal.jIdent();
                        Integer size = JPortal.jOptSize();
                        Line l2 = new Line(s, true);
                        JPortal.proc.lines.addElement(l2);
                        if (proc.hasDynamic(s)) continue block10;
                        if (JPortal.proc.extendsStd) {
                            JPortal.proc.useStd = false;
                        }
                        JPortal.proc.dynamics.addElement(s);
                        JPortal.proc.dynamicSizes.addElement(size);
                        continue block10;
                    }
                }
                break;
            }
            JPortal.jj_la1[190] = jj_gen;
            JPortal.jj_consume_token(-1);
            throw new ParseException();
        }
        JPortal.jj_consume_token(113);
    }

    public static final void jNewCode() throws ParseException {
        block3: while (true) {
            switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                case 139: {
                    break;
                }
                default: {
                    JPortal.jj_la1[191] = jj_gen;
                    break block3;
                }
            }
            Token t = JPortal.jj_consume_token(139);
            String s = JPortal.parseDynamics(t.image.trim() + " ");
            if (s.length() <= 0) continue;
            Line line = new Line(s);
            JPortal.proc.lines.addElement(line);
        }
    }

    public static final Integer jOptSize() throws ParseException {
        int n = 256;
        switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
            case 122: {
                JPortal.jj_consume_token(122);
                n = JPortal.jNumber();
                JPortal.jj_consume_token(125);
                break;
            }
            default: {
                JPortal.jj_la1[192] = jj_gen;
            }
        }
        if ("" != null) {
            return new Integer(n);
        }
        throw new IllegalStateException("Missing return statement in function");
    }

    public static final void jInputType() throws ParseException {
        if (JPortal.jj_2_3(2)) {
            JPortal.jj_consume_token(122);
            JPortal.jj_consume_token(56);
            JPortal.jj_consume_token(125);
            JPortal.proc.isMultipleInput = true;
        } else if (JPortal.jj_2_4(2)) {
            JPortal.jj_consume_token(122);
            int n = JPortal.jNumber();
            JPortal.jj_consume_token(125);
            JPortal.proc.noRows = n;
            JPortal.proc.isMultipleInput = true;
        } else if (JPortal.jj_2_5(2)) {
            JPortal.jj_consume_token(122);
            JPortal.jj_consume_token(83);
            for (int i = 0; i < JPortal.table.fields.size(); ++i) {
                JPortal.proc.inputs.addElement(JPortal.table.fields.elementAt(i));
            }
            JPortal.jj_consume_token(125);
        } else {
            JPortal.jj_consume_token(-1);
            throw new ParseException();
        }
    }

    public static final void jOutputType() throws ParseException {
        if (JPortal.jj_2_6(2)) {
            JPortal.jj_consume_token(122);
            JPortal.jj_consume_token(80);
            JPortal.proc.isSingle = true;
            switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                case 83: {
                    JPortal.jj_consume_token(83);
                    for (int i = 0; i < JPortal.table.fields.size(); ++i) {
                        JPortal.proc.outputs.addElement(JPortal.table.fields.elementAt(i));
                    }
                    break;
                }
                default: {
                    JPortal.jj_la1[193] = jj_gen;
                }
            }
            JPortal.jj_consume_token(125);
        } else if (JPortal.jj_2_7(2)) {
            JPortal.jj_consume_token(122);
            JPortal.jj_consume_token(80);
            JPortal.proc.isSingle = true;
            switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                case 91: {
                    JPortal.jj_consume_token(91);
                    JPortal.proc.hasUpdates = true;
                    break;
                }
                default: {
                    JPortal.jj_la1[194] = jj_gen;
                }
            }
            JPortal.jj_consume_token(125);
        } else if (JPortal.jj_2_8(2)) {
            JPortal.jj_consume_token(122);
            int n = JPortal.jNumber();
            JPortal.jj_consume_token(125);
            JPortal.proc.noRows = n;
        } else if (JPortal.jj_2_9(2)) {
            JPortal.jj_consume_token(122);
            JPortal.jj_consume_token(83);
            for (int i = 0; i < JPortal.table.fields.size(); ++i) {
                JPortal.proc.outputs.addElement(JPortal.table.fields.elementAt(i));
            }
            switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                case 80: {
                    JPortal.jj_consume_token(80);
                    JPortal.proc.isSingle = true;
                    break;
                }
                default: {
                    JPortal.jj_la1[195] = jj_gen;
                }
            }
            JPortal.jj_consume_token(125);
        } else {
            JPortal.jj_consume_token(-1);
            throw new ParseException();
        }
    }

    public static final void jOldData() throws ParseException {
        JPortal.jj_consume_token(112);
        proc = new Proc();
        JPortal.proc.isData = true;
        block3: while (true) {
            switch (jj_ntk == -1 ? JPortal.jj_ntk_f() : jj_ntk) {
                case 128: {
                    break;
                }
                default: {
                    JPortal.jj_la1[196] = jj_gen;
                    break block3;
                }
            }
            JPortal.jLine();
            Line l1 = new Line(line);
            JPortal.proc.lines.addElement(l1);
        }
        JPortal.jj_consume_token(114);
    }

    public static final void jNewData() throws ParseException {
        Token t = JPortal.jj_consume_token(142);
        proc = new Proc();
        JPortal.proc.isData = true;
        Line l1 = new Line(t.image.trim());
        JPortal.proc.lines.addElement(l1);
        while (JPortal.jj_2_10(2)) {
            t = JPortal.jj_consume_token(142);
            Line l2 = new Line(t.image.trim());
            JPortal.proc.lines.addElement(l2);
        }
    }

    public static final void jIdlCode() throws ParseException {
        Token t = JPortal.jj_consume_token(145);
        proc = new Proc();
        JPortal.proc.isIdlCode = true;
        Line l1 = new Line(t.image.trim());
        JPortal.proc.lines.addElement(l1);
        while (JPortal.jj_2_11(2)) {
            t = JPortal.jj_consume_token(145);
            Line l2 = new Line(t.image.trim());
            JPortal.proc.lines.addElement(l2);
        }
    }

    private static boolean jj_2_1(int xla) {
        jj_la = xla;
        jj_scanpos = token;
        jj_lastpos = token;
        try {
            boolean bl = !JPortal.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            JPortal.jj_save(0, xla);
        }
    }

    private static boolean jj_2_2(int xla) {
        jj_la = xla;
        jj_scanpos = token;
        jj_lastpos = token;
        try {
            boolean bl = !JPortal.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            JPortal.jj_save(1, xla);
        }
    }

    private static boolean jj_2_3(int xla) {
        jj_la = xla;
        jj_scanpos = token;
        jj_lastpos = token;
        try {
            boolean bl = !JPortal.jj_3_3();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            JPortal.jj_save(2, xla);
        }
    }

    private static boolean jj_2_4(int xla) {
        jj_la = xla;
        jj_scanpos = token;
        jj_lastpos = token;
        try {
            boolean bl = !JPortal.jj_3_4();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            JPortal.jj_save(3, xla);
        }
    }

    private static boolean jj_2_5(int xla) {
        jj_la = xla;
        jj_scanpos = token;
        jj_lastpos = token;
        try {
            boolean bl = !JPortal.jj_3_5();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            JPortal.jj_save(4, xla);
        }
    }

    private static boolean jj_2_6(int xla) {
        jj_la = xla;
        jj_scanpos = token;
        jj_lastpos = token;
        try {
            boolean bl = !JPortal.jj_3_6();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            JPortal.jj_save(5, xla);
        }
    }

    private static boolean jj_2_7(int xla) {
        jj_la = xla;
        jj_scanpos = token;
        jj_lastpos = token;
        try {
            boolean bl = !JPortal.jj_3_7();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            JPortal.jj_save(6, xla);
        }
    }

    private static boolean jj_2_8(int xla) {
        jj_la = xla;
        jj_scanpos = token;
        jj_lastpos = token;
        try {
            boolean bl = !JPortal.jj_3_8();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            JPortal.jj_save(7, xla);
        }
    }

    private static boolean jj_2_9(int xla) {
        jj_la = xla;
        jj_scanpos = token;
        jj_lastpos = token;
        try {
            boolean bl = !JPortal.jj_3_9();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            JPortal.jj_save(8, xla);
        }
    }

    private static boolean jj_2_10(int xla) {
        jj_la = xla;
        jj_scanpos = token;
        jj_lastpos = token;
        try {
            boolean bl = !JPortal.jj_3_10();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            JPortal.jj_save(9, xla);
        }
    }

    private static boolean jj_2_11(int xla) {
        jj_la = xla;
        jj_scanpos = token;
        jj_lastpos = token;
        try {
            boolean bl = !JPortal.jj_3_11();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            JPortal.jj_save(10, xla);
        }
    }

    private static boolean jj_3R_92() {
        return JPortal.jj_scan_token(62);
    }

    private static boolean jj_3_3() {
        if (JPortal.jj_scan_token(122)) {
            return true;
        }
        return JPortal.jj_scan_token(56);
    }

    private static boolean jj_3_4() {
        if (JPortal.jj_scan_token(122)) {
            return true;
        }
        return JPortal.jj_3R_70();
    }

    private static boolean jj_3R_105() {
        return JPortal.jj_3R_76();
    }

    private static boolean jj_3R_83() {
        Token xsp;
        if (JPortal.jj_scan_token(43)) {
            return true;
        }
        if (JPortal.jj_3R_100()) {
            return true;
        }
        do {
            xsp = jj_scanpos;
        } while (!JPortal.jj_3R_100());
        jj_scanpos = xsp;
        return false;
    }

    private static boolean jj_3_5() {
        if (JPortal.jj_scan_token(122)) {
            return true;
        }
        return JPortal.jj_scan_token(83);
    }

    private static boolean jj_3R_85() {
        if (JPortal.jj_scan_token(52)) {
            return true;
        }
        return JPortal.jj_3R_101();
    }

    private static boolean jj_3R_100() {
        return JPortal.jj_3R_106();
    }

    private static boolean jj_3_6() {
        if (JPortal.jj_scan_token(122)) {
            return true;
        }
        return JPortal.jj_scan_token(80);
    }

    private static boolean jj_3R_93() {
        return JPortal.jj_3R_102();
    }

    private static boolean jj_3R_78() {
        Token xsp;
        if (JPortal.jj_scan_token(75)) {
            return true;
        }
        if (JPortal.jj_3R_95()) {
            return true;
        }
        do {
            xsp = jj_scanpos;
        } while (!JPortal.jj_3R_95());
        jj_scanpos = xsp;
        return false;
    }

    private static boolean jj_3R_106() {
        Token xsp = jj_scanpos;
        if (JPortal.jj_3R_109()) {
            jj_scanpos = xsp;
            if (JPortal.jj_3R_110()) {
                jj_scanpos = xsp;
                if (JPortal.jj_3R_111()) {
                    jj_scanpos = xsp;
                    if (JPortal.jj_3R_112()) {
                        jj_scanpos = xsp;
                        if (JPortal.jj_3R_113()) {
                            jj_scanpos = xsp;
                            if (JPortal.jj_3R_114()) {
                                return true;
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private static boolean jj_3R_109() {
        return JPortal.jj_scan_token(7);
    }

    private static boolean jj_3_7() {
        if (JPortal.jj_scan_token(122)) {
            return true;
        }
        return JPortal.jj_scan_token(80);
    }

    private static boolean jj_3R_79() {
        Token xsp;
        if (JPortal.jj_scan_token(72)) {
            return true;
        }
        if (JPortal.jj_3R_96()) {
            return true;
        }
        do {
            xsp = jj_scanpos;
        } while (!JPortal.jj_3R_96());
        jj_scanpos = xsp;
        return false;
    }

    private static boolean jj_3R_101() {
        return JPortal.jj_3R_76();
    }

    private static boolean jj_3R_94() {
        return JPortal.jj_3R_103();
    }

    private static boolean jj_3R_110() {
        return JPortal.jj_scan_token(31);
    }

    private static boolean jj_3_8() {
        if (JPortal.jj_scan_token(122)) {
            return true;
        }
        return JPortal.jj_3R_70();
    }

    private static boolean jj_3R_95() {
        return JPortal.jj_3R_104();
    }

    private static boolean jj_3R_111() {
        return JPortal.jj_scan_token(49);
    }

    private static boolean jj_3_9() {
        if (JPortal.jj_scan_token(122)) {
            return true;
        }
        return JPortal.jj_scan_token(83);
    }

    private static boolean jj_3R_96() {
        return JPortal.jj_3R_104();
    }

    private static boolean jj_3R_112() {
        return JPortal.jj_scan_token(70);
    }

    private static boolean jj_3R_113() {
        return JPortal.jj_scan_token(91);
    }

    private static boolean jj_3R_102() {
        Token xsp = jj_scanpos;
        if (JPortal.jj_3R_107()) {
            jj_scanpos = xsp;
        }
        return JPortal.jj_scan_token(111);
    }

    private static boolean jj_3R_107() {
        return JPortal.jj_scan_token(81);
    }

    private static boolean jj_3R_114() {
        return JPortal.jj_scan_token(38);
    }

    private static boolean jj_3R_86() {
        if (JPortal.jj_scan_token(98)) {
            return true;
        }
        return JPortal.jj_3R_76();
    }

    private static boolean jj_3R_76() {
        Token xsp = jj_scanpos;
        if (JPortal.jj_3R_88()) {
            jj_scanpos = xsp;
            if (JPortal.jj_3R_89()) {
                return true;
            }
        }
        return false;
    }

    private static boolean jj_3R_88() {
        return JPortal.jj_scan_token(131);
    }

    private static boolean jj_3R_69() {
        if (JPortal.jj_3R_76()) {
            return true;
        }
        Token xsp = jj_scanpos;
        if (JPortal.jj_3R_77()) {
            jj_scanpos = xsp;
            if (JPortal.jj_3R_78()) {
                jj_scanpos = xsp;
                if (JPortal.jj_3R_79()) {
                    jj_scanpos = xsp;
                    if (JPortal.jj_3R_80()) {
                        jj_scanpos = xsp;
                        if (JPortal.jj_3R_81()) {
                            jj_scanpos = xsp;
                            if (JPortal.jj_3R_82()) {
                                return true;
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private static boolean jj_3R_80() {
        Token xsp;
        if (JPortal.jj_scan_token(32)) {
            return true;
        }
        if (JPortal.jj_3R_97()) {
            return true;
        }
        do {
            xsp = jj_scanpos;
        } while (!JPortal.jj_3R_97());
        jj_scanpos = xsp;
        return false;
    }

    private static boolean jj_3_2() {
        return JPortal.jj_3R_69();
    }

    private static boolean jj_3R_89() {
        return JPortal.jj_scan_token(132);
    }

    private static boolean jj_3R_84() {
        if (JPortal.jj_scan_token(51)) {
            return true;
        }
        return JPortal.jj_3R_76();
    }

    private static boolean jj_3R_81() {
        Token xsp;
        if (JPortal.jj_scan_token(92)) {
            return true;
        }
        if (JPortal.jj_3R_98()) {
            return true;
        }
        do {
            xsp = jj_scanpos;
        } while (!JPortal.jj_3R_98());
        jj_scanpos = xsp;
        return false;
    }

    private static boolean jj_3R_77() {
        if (JPortal.jj_scan_token(70)) {
            return true;
        }
        Token xsp = jj_scanpos;
        if (JPortal.jj_3R_90()) {
            jj_scanpos = xsp;
        }
        xsp = jj_scanpos;
        if (JPortal.jj_3R_91()) {
            jj_scanpos = xsp;
        }
        xsp = jj_scanpos;
        if (JPortal.jj_3R_92()) {
            jj_scanpos = xsp;
        }
        xsp = jj_scanpos;
        if (JPortal.jj_3R_93()) {
            jj_scanpos = xsp;
            if (JPortal.jj_3R_94()) {
                return true;
            }
        }
        return false;
    }

    private static boolean jj_3R_68() {
        Token xsp = jj_scanpos;
        if (JPortal.jj_3R_71()) {
            jj_scanpos = xsp;
            if (JPortal.jj_3R_72()) {
                jj_scanpos = xsp;
                if (JPortal.jj_3R_73()) {
                    jj_scanpos = xsp;
                    if (JPortal.jj_3R_74()) {
                        jj_scanpos = xsp;
                        if (JPortal.jj_3R_75()) {
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    private static boolean jj_3R_71() {
        return JPortal.jj_3R_83();
    }

    private static boolean jj_3R_82() {
        Token xsp;
        if (JPortal.jj_scan_token(93)) {
            return true;
        }
        if (JPortal.jj_3R_99()) {
            return true;
        }
        do {
            xsp = jj_scanpos;
        } while (!JPortal.jj_3R_99());
        jj_scanpos = xsp;
        return false;
    }

    private static boolean jj_3R_90() {
        return JPortal.jj_scan_token(122);
    }

    private static boolean jj_3R_97() {
        return JPortal.jj_3R_104();
    }

    private static boolean jj_3R_72() {
        return JPortal.jj_3R_84();
    }

    private static boolean jj_3R_91() {
        return JPortal.jj_scan_token(48);
    }

    private static boolean jj_3_10() {
        return JPortal.jj_scan_token(142);
    }

    private static boolean jj_3R_98() {
        return JPortal.jj_3R_104();
    }

    private static boolean jj_3R_103() {
        Token xsp;
        do {
            xsp = jj_scanpos;
        } while (!JPortal.jj_3R_108());
        jj_scanpos = xsp;
        return false;
    }

    private static boolean jj_3R_73() {
        return JPortal.jj_3R_85();
    }

    private static boolean jj_3_1() {
        return JPortal.jj_3R_68();
    }

    private static boolean jj_3R_108() {
        return JPortal.jj_scan_token(139);
    }

    private static boolean jj_3R_74() {
        return JPortal.jj_3R_86();
    }

    private static boolean jj_3R_104() {
        return JPortal.jj_3R_76();
    }

    private static boolean jj_3R_99() {
        return JPortal.jj_3R_105();
    }

    private static boolean jj_3R_75() {
        return JPortal.jj_3R_87();
    }

    private static boolean jj_3_11() {
        return JPortal.jj_scan_token(145);
    }

    private static boolean jj_3R_87() {
        if (JPortal.jj_scan_token(24)) {
            return true;
        }
        return JPortal.jj_3R_76();
    }

    private static boolean jj_3R_70() {
        return JPortal.jj_scan_token(127);
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x400000, 0, 0, 0, 0, 0, 0x40480000, 0, 0x40480000, 0, 0, 0x40480000, 0, 0x40480000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 405077248, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x1000000, 0, 0, -2147483520, 0, -2147483520, 0, 0, 0, 0, 0, 0, 0, 0x100000, Integer.MIN_VALUE, 0x100000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x830000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 512, 0, 0, 0, 0, 0, 0, 512, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x830000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[]{256, 0, Integer.MIN_VALUE, 0x40002000, 0x40002000, 8192, 0, 0, 0, 0, 0, 0, 8192, 0, 0, 0, 0, 0, 0, 0, 0, 0x10000000, 0, 0, 0, 0xC000000, 0x4000000, 0xC000000, 0, 0, 0xC000000, 0x4000000, 0xC000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 528, 0, 10752528, 0, 0x100000, 0, 0, 0, 0x100000, 0, 0, 0x100000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 131072, 0, 4, 0, 0x180800, 0, 0, 131136, 0, 131136, 0x10000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x10000000, 0, 0, 0, 0, 0, 0x40000000, 0, 0, 0, 0, 0, 4325510, 0, 0, 0, 0, 0, 0, 1024, 0, 1024, 0, 16384, 0x20004000, 1024, 0, 1024, 0, 0, 16384, 0x20004000, 1024, 0, 1024, 0, 0, 0, 0x40000000, 16384, 0, 8, 0x20004000, 1024, 0, 1024, 4325510, 0x10000000, 0, 0, 0, 0, 65536, 0, 0, 0x40000000, 0, 0, 1024, 0, 1024, 0, 16384, 0, 8, 0x20004000, 1024, 0, 1024, 0, 0, 0x40000000, 0, 0, 0, 0, 1024, 1, 0, 0, 0x10000000, 0, 0, 0, 65536, 0, 0, 32768, 0, 0, 0x40000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    }

    private static void jj_la1_init_2() {
        jj_la1_2 = new int[]{0, 0, 0, 0, 0, 0x100000, 0, 32, Integer.MIN_VALUE, 0, 0, 0, 0x100000, 262148, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 48275456, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 0, 128, 0, 0x8000000, 0, 0, 0, 0, 0, 0x8000040, 0, 0x8000040, 0, 0, 0x4000002, 0, 0x4000002, 0, 0, 0, 0, 0, 0x8000000, 0, 0, 0, 0, 0x1000000, 0, 0, 0, 0, 0, 262148, 0, 1207966080, 0, 262148, 16, 0, 0, 0, 0, 0x8000008, 0x8000008, 0, 0, 0, 0, 0x8000008, 0x8000008, 0, 0, 0, 0, 0, 0x8000008, 0x8000008, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x8000008, 0x8000008, 1207966080, 0, 0, 0, 0, 0, 0, 0, 0, 0, 131072, 0, 0, 0x8000008, 0x8000008, 0, 0, 0, 0, 0, 0, 0x8000008, 0x8000008, 0, 0, 0, 0, 0, 0, 0, 0, 805308736, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 131072, 131072, 0, 0, 0, 0, 524288, 0x8000000, 65536, 0};
    }

    private static void jj_la1_init_3() {
        jj_la1_3 = new int[]{0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 65536, 64, 0, 0x2000000, 0x4000000, 0x4000000, 0, 524288, 0, 0, 0, 0x4000000, 0, 0, 0, 524288, 0x4000000, 0, 0, 0, 524288, -2046820352, 0x5000000, 0x5000000, -2046820352, 0x1000000, -2046820352, -2046820352, 0x1000000, -2046820352, -2046820352, 0x1000000, 0x5000000, 0x5000000, 0x5000000, 0x5000000, -2046820352, -2046820352, -2046820352, 0, 0x6000000, 8388667, 0x4000000, 0, 0x400000, 0, 0x6000000, 0, 0x400000, 0, Integer.MIN_VALUE, -2046820352, -2046820352, 0x400000, 0, 0, 32640, 0, 0, 0, 0, 0, 0, 0, 0, 32640, 4, 0x400000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x4000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32768, 0, 0, 0, 0, 0, 65536, 65536, 0, 0x4000000, 0x4000000, 0x4000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x4000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x4000000, 0x4000000, 0, 0, 0x4000000, 0, 0, 32768, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x4000000, 0, 0, 0, 0, 0, 0, 0, 0, 0x4000000, 524288, 0, 0, 0x4000000, 0, 0, 0x4000000, 0, 0, 0x4000000, 0, 0, 32768, 0, 0, 0, 0, 0x4000000, 0, 0, 0, 0};
    }

    private static void jj_la1_init_4() {
        jj_la1_4 = new int[]{0, 1, 0, 0, 0, 0, 0, 0, 0, 262144, 25, 24, 0, 147456, 0, 24, 0, 0, 0, 0, 0, 0, 1, 24, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 24, 0, 0, 0, 24, 24, 0, 0, 0, 24, 1, 0, 24, 24, 24, 24, 24, 24, 24, 24, 0, 0, 0, 24, 0, 24, 0, 0, 1, 0, 24, 0, 24, 0, 0, 0, 0, 0, 0, 1, 24, 24, 0, 24, 0, 0, 2048, 1, 0, 24, 24, 147456, 147456, 0, 0, 0, 0, 0, 0, 0, 24, 0, 0, 0, 0, 0, 0, 24, 0, 0, 0, 0, 0, 0, 0, 24, 0, 0, 24, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 24, 0, 0, 24, 0, 0, 24, 0, 0, 0, 24, 0, 24, 0, 0, 0, 0, 0, 0, 24, 0, 24, 24, 24, 24, 0, 0, 0, 0, 0, 1, 0, 24, 0, 0, 24, 0, 0, 24, 0, 0, 0, 25, 25, 2048, 0, 0, 0, 0, 1};
    }

    public JPortal(InputStream stream) {
        this(stream, null);
    }

    public JPortal(InputStream stream, String encoding) {
        int i;
        if (jj_initialized_once) {
            System.out.println("ERROR: Second call to constructor of static parser.  ");
            System.out.println("\t   You must either use ReInit() or set the JavaCC option STATIC to false");
            System.out.println("\t   during parser generation.");
            throw new IllegalStateException();
        }
        jj_initialized_once = true;
        try {
            jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
        token_source = new JPortalTokenManager(jj_input_stream);
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (i = 0; i < 197; ++i) {
            JPortal.jj_la1[i] = -1;
        }
        for (i = 0; i < jj_2_rtns.length; ++i) {
            JPortal.jj_2_rtns[i] = new JJCalls();
        }
    }

    public static void ReInit(InputStream stream) {
        JPortal.ReInit(stream, null);
    }

    public static void ReInit(InputStream stream, String encoding) {
        int i;
        try {
            jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
        JPortalTokenManager.ReInit(jj_input_stream);
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (i = 0; i < 197; ++i) {
            JPortal.jj_la1[i] = -1;
        }
        for (i = 0; i < jj_2_rtns.length; ++i) {
            JPortal.jj_2_rtns[i] = new JJCalls();
        }
    }

    public JPortal(Reader stream) {
        int i;
        if (jj_initialized_once) {
            System.out.println("ERROR: Second call to constructor of static parser. ");
            System.out.println("\t   You must either use ReInit() or set the JavaCC option STATIC to false");
            System.out.println("\t   during parser generation.");
            throw new IllegalStateException();
        }
        jj_initialized_once = true;
        jj_input_stream = new SimpleCharStream(stream, 1, 1);
        token_source = new JPortalTokenManager(jj_input_stream);
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (i = 0; i < 197; ++i) {
            JPortal.jj_la1[i] = -1;
        }
        for (i = 0; i < jj_2_rtns.length; ++i) {
            JPortal.jj_2_rtns[i] = new JJCalls();
        }
    }

    public static void ReInit(Reader stream) {
        int i;
        if (jj_input_stream == null) {
            jj_input_stream = new SimpleCharStream(stream, 1, 1);
        } else {
            jj_input_stream.ReInit(stream, 1, 1);
        }
        if (token_source == null) {
            token_source = new JPortalTokenManager(jj_input_stream);
        }
        JPortalTokenManager.ReInit(jj_input_stream);
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (i = 0; i < 197; ++i) {
            JPortal.jj_la1[i] = -1;
        }
        for (i = 0; i < jj_2_rtns.length; ++i) {
            JPortal.jj_2_rtns[i] = new JJCalls();
        }
    }

    public JPortal(JPortalTokenManager tm) {
        int i;
        if (jj_initialized_once) {
            System.out.println("ERROR: Second call to constructor of static parser. ");
            System.out.println("\t   You must either use ReInit() or set the JavaCC option STATIC to false");
            System.out.println("\t   during parser generation.");
            throw new IllegalStateException();
        }
        jj_initialized_once = true;
        token_source = tm;
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (i = 0; i < 197; ++i) {
            JPortal.jj_la1[i] = -1;
        }
        for (i = 0; i < jj_2_rtns.length; ++i) {
            JPortal.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(JPortalTokenManager tm) {
        int i;
        token_source = tm;
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (i = 0; i < 197; ++i) {
            JPortal.jj_la1[i] = -1;
        }
        for (i = 0; i < jj_2_rtns.length; ++i) {
            JPortal.jj_2_rtns[i] = new JJCalls();
        }
    }

    private static Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = token;
        token = JPortal.token.next != null ? JPortal.token.next : (JPortal.token.next = token_source.getNextToken());
        jj_ntk = -1;
        if (JPortal.token.kind == kind) {
            ++jj_gen;
            if (++jj_gc > 100) {
                jj_gc = 0;
                for (int i = 0; i < jj_2_rtns.length; ++i) {
                    JJCalls c = jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return token;
        }
        token = oldToken;
        jj_kind = kind;
        throw JPortal.generateParseException();
    }

    private static boolean jj_scan_token(int kind) {
        if (jj_scanpos == jj_lastpos) {
            --jj_la;
            if (JPortal.jj_scanpos.next == null) {
                jj_scanpos = JPortal.jj_scanpos.next = token_source.getNextToken();
                jj_lastpos = JPortal.jj_scanpos.next;
            } else {
                jj_lastpos = jj_scanpos = JPortal.jj_scanpos.next;
            }
        } else {
            jj_scanpos = JPortal.jj_scanpos.next;
        }
        if (jj_rescan) {
            int i = 0;
            Token tok = token;
            while (tok != null && tok != jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                JPortal.jj_add_error_token(kind, i);
            }
        }
        if (JPortal.jj_scanpos.kind != kind) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            throw jj_ls;
        }
        return false;
    }

    public static final Token getNextToken() {
        token = JPortal.token.next != null ? JPortal.token.next : (JPortal.token.next = token_source.getNextToken());
        jj_ntk = -1;
        ++jj_gen;
        return token;
    }

    public static final Token getToken(int index) {
        Token t = token;
        for (int i = 0; i < index; ++i) {
            if (t.next == null) {
                t.next = token_source.getNextToken();
            }
            t = t.next;
        }
        return t;
    }

    private static int jj_ntk_f() {
        jj_nt = JPortal.token.next;
        if (jj_nt == null) {
            JPortal.token.next = token_source.getNextToken();
            jj_ntk = JPortal.token.next.kind;
            return jj_ntk;
        }
        jj_ntk = JPortal.jj_nt.kind;
        return jj_ntk;
    }

    private static void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == jj_endpos + 1) {
            JPortal.jj_lasttokens[JPortal.jj_endpos++] = kind;
        } else if (jj_endpos != 0) {
            jj_expentry = new int[jj_endpos];
            for (int i = 0; i < jj_endpos; ++i) {
                JPortal.jj_expentry[i] = jj_lasttokens[i];
            }
            for (int[] oldentry : jj_expentries) {
                if (oldentry.length != jj_expentry.length) continue;
                boolean isMatched = true;
                for (int i = 0; i < jj_expentry.length; ++i) {
                    if (oldentry[i] == jj_expentry[i]) continue;
                    isMatched = false;
                    break;
                }
                if (!isMatched) continue;
                jj_expentries.add(jj_expentry);
                break;
            }
            if (pos != 0) {
                jj_endpos = pos;
                JPortal.jj_lasttokens[JPortal.jj_endpos - 1] = kind;
            }
        }
    }

    public static ParseException generateParseException() {
        int i;
        jj_expentries.clear();
        boolean[] la1tokens = new boolean[147];
        if (jj_kind >= 0) {
            la1tokens[JPortal.jj_kind] = true;
            jj_kind = -1;
        }
        for (i = 0; i < 197; ++i) {
            if (jj_la1[i] != jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) != 0) {
                    la1tokens[32 + j] = true;
                }
                if ((jj_la1_2[i] & 1 << j) != 0) {
                    la1tokens[64 + j] = true;
                }
                if ((jj_la1_3[i] & 1 << j) != 0) {
                    la1tokens[96 + j] = true;
                }
                if ((jj_la1_4[i] & 1 << j) == 0) continue;
                la1tokens[128 + j] = true;
            }
        }
        for (i = 0; i < 147; ++i) {
            if (!la1tokens[i]) continue;
            jj_expentry = new int[1];
            JPortal.jj_expentry[0] = i;
            jj_expentries.add(jj_expentry);
        }
        jj_endpos = 0;
        JPortal.jj_rescan_token();
        JPortal.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[jj_expentries.size()][];
        for (int i2 = 0; i2 < jj_expentries.size(); ++i2) {
            exptokseq[i2] = jj_expentries.get(i2);
        }
        return new ParseException(token, exptokseq, tokenImage);
    }

    public static final boolean trace_enabled() {
        return trace_enabled;
    }

    public static final void enable_tracing() {
    }

    public static final void disable_tracing() {
    }

    private static void jj_rescan_token() {
        jj_rescan = true;
        for (int i = 0; i < 11; ++i) {
            try {
                JJCalls p = jj_2_rtns[i];
                do {
                    if (p.gen <= jj_gen) continue;
                    jj_la = p.arg;
                    jj_scanpos = p.first;
                    jj_lastpos = p.first;
                    switch (i) {
                        case 0: {
                            JPortal.jj_3_1();
                            break;
                        }
                        case 1: {
                            JPortal.jj_3_2();
                            break;
                        }
                        case 2: {
                            JPortal.jj_3_3();
                            break;
                        }
                        case 3: {
                            JPortal.jj_3_4();
                            break;
                        }
                        case 4: {
                            JPortal.jj_3_5();
                            break;
                        }
                        case 5: {
                            JPortal.jj_3_6();
                            break;
                        }
                        case 6: {
                            JPortal.jj_3_7();
                            break;
                        }
                        case 7: {
                            JPortal.jj_3_8();
                            break;
                        }
                        case 8: {
                            JPortal.jj_3_9();
                            break;
                        }
                        case 9: {
                            JPortal.jj_3_10();
                            break;
                        }
                        case 10: {
                            JPortal.jj_3_11();
                        }
                    }
                } while ((p = p.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        jj_rescan = false;
    }

    private static void jj_save(int index, int xla) {
        JJCalls p = jj_2_rtns[index];
        while (p.gen > jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = jj_gen + xla - jj_la;
        p.first = token;
        p.arg = xla;
    }

    static {
        parser_initialised = false;
        fieldsNullByDefault = false;
        isLiteral = false;
        literal = "";
        jj_initialized_once = false;
        jj_la1 = new int[197];
        JPortal.jj_la1_init_0();
        JPortal.jj_la1_init_1();
        JPortal.jj_la1_init_2();
        JPortal.jj_la1_init_3();
        JPortal.jj_la1_init_4();
        jj_2_rtns = new JJCalls[11];
        jj_rescan = false;
        jj_gc = 0;
        jj_ls = new LookaheadSuccess();
        jj_expentries = new ArrayList<int[]>();
        jj_kind = -1;
        jj_lasttokens = new int[100];
        trace_enabled = false;
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends IllegalStateException {
        private LookaheadSuccess() {
        }
    }
}

