/*
 * Decompiled with CFR 0.152.
 */
package net.sf.extcos.internal;

import java.util.HashSet;
import java.util.Set;
import net.sf.extcos.filter.Connector;
import net.sf.extcos.filter.MultiplexingConnector;
import net.sf.extcos.resource.Resource;
import net.sf.extcos.util.Assert;
import net.sf.extcos.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMultiplexingConnector
implements MultiplexingConnector {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    protected Set<Connector> connectors = new HashSet<Connector>();

    @Override
    public void addConnector(Connector connector) {
        try {
            Assert.notNull(connector, IllegalArgumentException.class, "connector must not be null");
            this.connectors.add(connector);
            if (this.logger.isTraceEnabled()) {
                this.logger.trace(StringUtils.append("successfully added connector ", connector));
            }
        }
        catch (IllegalArgumentException e) {
            this.logger.debug("couldn't add connector", e);
        }
    }

    @Override
    public void merge(Connector connector) {
        this.addConnector(connector);
    }

    @Override
    public void connect(Resource resource) {
        if (this.connectors.isEmpty()) {
            this.logger.debug("can't connect: no connectors are set");
            return;
        }
        this.doConnect(resource);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(StringUtils.append("successfully dispatched resource ", resource));
        }
    }

    protected abstract void doConnect(Resource var1);
}

