/*
 * Decompiled with CFR 0.152.
 */
package net.sf.extcos.internal;

import java.util.HashMap;
import java.util.Map;
import net.sf.extcos.internal.AbstractChainedConnector;
import net.sf.extcos.resource.Resource;
import net.sf.extcos.util.StringUtils;

public class ConjunctiveChainedConnector
extends AbstractChainedConnector {
    private final Map<Resource, Integer> waitingResources = new HashMap<Resource, Integer>();

    @Override
    public void connect(Resource resource) {
        if (this.connector == null) {
            this.logger.debug("can't connect: parent connector is not set");
            return;
        }
        if (!this.waitingResources.keySet().contains(resource)) {
            this.waitingResources.put(resource, 1);
            if (this.logger.isTraceEnabled()) {
                this.logger.trace(StringUtils.append("added resource ", resource, " to waiting resources"));
            }
        } else {
            int count = this.waitingResources.get(resource) + 1;
            if (count == this.childCount) {
                this.connector.connect(resource);
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace(StringUtils.append("successfully dispatched resource ", resource));
                }
            } else if (count < this.childCount) {
                this.waitingResources.put(resource, count + 1);
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace(StringUtils.append("increased the received count for resource ", resource));
                }
            } else {
                this.logger.debug(StringUtils.append("received resource ", resource, " more often than expected"));
            }
        }
    }
}

