/*
 * Decompiled with CFR 0.152.
 */
package net.sf.extcos.internal;

import java.util.Set;
import net.sf.extcos.filter.Connector;
import net.sf.extcos.filter.ResultSetProvider;
import net.sf.extcos.internal.AbstractFilterObjectsBuilder;
import net.sf.extcos.internal.ConjunctiveChainedConnector;
import net.sf.extcos.internal.FilterObjects;
import net.sf.extcos.internal.ImplementingResourceMatcher;
import net.sf.extcos.internal.StandardMultiplexingConnector;
import net.sf.extcos.internal.StandardResultSetProvider;
import net.sf.extcos.selector.ImplementingTypeFilter;
import net.sf.extcos.selector.TypeFilter;
import net.sf.extcos.util.Assert;

public class ImplementingFilterObjectsBuilder
extends AbstractFilterObjectsBuilder {
    private final ResultSetProvider provider = new StandardResultSetProvider();

    @Override
    public void buildFilterObjects(TypeFilter filter, Connector connector) {
        Assert.notNull(filter, Assert.iae());
        Assert.isTrue(filter instanceof ImplementingTypeFilter, Assert.iae());
        Assert.notNull(connector, Assert.iae());
        Set<Class<?>> interfaces = ((ImplementingTypeFilter)filter).getInterfaces();
        if (interfaces.size() > 1) {
            ConjunctiveChainedConnector conjunction = new ConjunctiveChainedConnector();
            conjunction.setParentConnector(connector);
            conjunction.setChildCount(interfaces.size());
            connector = conjunction;
        }
        for (Class<?> interfaze : interfaces) {
            ImplementingResourceMatcher matcher = new ImplementingResourceMatcher(interfaze);
            if (this.buildContext.isRegistered(matcher)) {
                FilterObjects fo = this.buildContext.getFilterObjects(matcher);
                fo.getResourceDispatcher().addConnector(connector);
                continue;
            }
            StandardMultiplexingConnector dispatcher = new StandardMultiplexingConnector();
            dispatcher.addConnector(connector);
            FilterObjects filterObjects = this.createFilterObjects(dispatcher, matcher, this.provider);
            this.buildContext.register(filterObjects);
        }
        if (connector instanceof ConjunctiveChainedConnector) {
            this.buildContext.register(filter, (ConjunctiveChainedConnector)connector);
        }
    }
}

