/*
 * Decompiled with CFR 0.152.
 */
package net.sf.extcos.internal;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Set;
import net.sf.extcos.collection.RandomPollingSet;
import net.sf.extcos.exception.ConcurrentInspectionException;
import net.sf.extcos.exception.StateChangedException;
import net.sf.extcos.filter.MatchingChainedFilter;
import net.sf.extcos.filter.MultiplexingConnector;
import net.sf.extcos.filter.ResourceMatcher;
import net.sf.extcos.internal.AbstractChainedFilter;
import net.sf.extcos.internal.RandomPollingArraySet;
import net.sf.extcos.resource.Resource;
import net.sf.extcos.util.Assert;
import net.sf.extcos.util.StringUtils;

public class MatchingChainedFilterImpl
extends AbstractChainedFilter
implements MatchingChainedFilter {
    private final RandomPollingSet<Resource> waitingResources = new RandomPollingArraySet<Resource>();
    private Iterator<Resource> resources;
    private ResourceMatcher resourceMatcher;

    @Override
    public void setResourceMatcher(ResourceMatcher resourceMatcher) {
        try {
            Assert.notNull(resourceMatcher, IllegalArgumentException.class, "resourceMatcher must not be null");
            this.resourceMatcher = resourceMatcher;
            if (this.logger.isTraceEnabled()) {
                this.logger.trace(StringUtils.append("successfully set resource matcher to ", resourceMatcher));
            }
        }
        catch (IllegalArgumentException e) {
            this.logger.debug("couldn't set resource matcher", e);
        }
    }

    @Override
    protected Iterable<Resource> filter(Iterator<Resource> resources, Set<Resource> resultSet) {
        this.resources = resources;
        if (this.resourceMatcher == null) {
            this.logger.warn("resource matcher is not set, hence no filtering will take place");
            while (this.hasNextResource()) {
                try {
                    resultSet.add(this.nextResource());
                }
                catch (StateChangedException e) {}
            }
            return resultSet;
        }
        while (this.hasNextResource()) {
            Resource resource = null;
            try {
                resource = this.nextResource();
            }
            catch (StateChangedException e) {
                continue;
            }
            try {
                if (!this.resourceMatcher.matches(resource)) continue;
                resultSet.add(resource);
            }
            catch (ConcurrentInspectionException e) {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("concurrent resource access", e);
                }
                this.waitingResources.add(resource);
            }
        }
        return resultSet;
    }

    @Override
    protected void filter(Iterator<Resource> resources, MultiplexingConnector resourceDispatcher) {
        this.resources = resources;
        if (this.resourceMatcher == null) {
            this.logger.warn("resource matcher is not set, hence no filtering will take place");
            while (this.hasNextResource()) {
                Resource resource = null;
                try {
                    resource = this.nextResource();
                }
                catch (StateChangedException e) {
                    continue;
                }
                resourceDispatcher.connect(resource);
            }
        } else {
            while (this.hasNextResource()) {
                Resource resource = null;
                try {
                    resource = this.nextResource();
                }
                catch (StateChangedException e) {
                    continue;
                }
                try {
                    if (!this.resourceMatcher.matches(resource)) continue;
                    resourceDispatcher.connect(resource);
                }
                catch (ConcurrentInspectionException e) {
                    if (this.logger.isTraceEnabled()) {
                        this.logger.trace("concurrent resource access", e);
                    }
                    this.waitingResources.add(resource);
                }
            }
        }
    }

    @Override
    protected Iterable<Resource> filter(Iterator<Resource> resources, MultiplexingConnector resourceDispatcher, Set<Resource> resultSet) {
        this.resources = resources;
        if (this.resourceMatcher == null) {
            this.logger.warn("resource matcher is not set, hence no filtering will take place");
            while (this.hasNextResource()) {
                Resource resource = null;
                try {
                    resource = this.nextResource();
                }
                catch (StateChangedException e) {
                    continue;
                }
                resourceDispatcher.connect(resource);
                resultSet.add(resource);
            }
            return resultSet;
        }
        while (this.hasNextResource()) {
            Resource resource = null;
            try {
                resource = this.nextResource();
            }
            catch (StateChangedException e) {
                continue;
            }
            try {
                if (!this.resourceMatcher.matches(resource)) continue;
                resourceDispatcher.connect(resource);
                resultSet.add(resource);
            }
            catch (ConcurrentInspectionException e) {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("concurrent resource access", e);
                }
                this.waitingResources.add(resource);
            }
        }
        return resultSet;
    }

    private boolean hasNextResource() {
        return this.resources.hasNext() || this.waitingResources.size() > 0;
    }

    private Resource nextResource() {
        if (this.resources.hasNext() && this.waitingResources.size() > 0) {
            Random prng = new Random();
            if (prng.nextBoolean()) {
                return this.resources.next();
            }
            return this.waitingResources.pollRandom();
        }
        if (this.resources.hasNext()) {
            return this.resources.next();
        }
        if (this.waitingResources.size() > 0) {
            return this.waitingResources.pollRandom();
        }
        throw new NoSuchElementException("there are no more resources");
    }
}

