/*
 * Decompiled with CFR 0.152.
 */
package bbd.jportal2;

import bbd.jportal2.SingleFileCompiler;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectCompiler {
    private static final Logger logger = LoggerFactory.getLogger(ProjectCompiler.class);
    private List<String> inputDirs = new ArrayList<String>();
    private List<String> inputFiles = new ArrayList<String>();
    private List<String> builtin = new ArrayList<String>();
    private List<String> compilerFlags = new ArrayList<String>();
    private List<String> builtinSIProcessors = new ArrayList<String>();
    private List<String> templateBasedSIProcessors = new ArrayList<String>();
    private List<String> builtinPostProcessors = new ArrayList<String>();
    private List<String> templateBasedPostProcessors = new ArrayList<String>();
    private List<String> templateLocations = new ArrayList<String>();

    public void addInputDirs(List<String> listOfInputDirs) {
        this.inputDirs.addAll(listOfInputDirs);
    }

    public void addInputDir(String inputDir) {
        this.inputDirs.add(inputDir);
    }

    public void addInputFiles(List<String> inputFiles) {
        this.inputFiles.addAll(inputFiles);
    }

    public void addInputFile(String inputFile) {
        this.inputFiles.add(inputFile);
    }

    public int compileAll() throws Exception {
        ArrayList<String> allInputFiles = new ArrayList<String>();
        this.addAllInputDirsToList(allInputFiles);
        this.addAllInputFilesToList(allInputFiles);
        if (this.compilerFlags.size() == 0) {
            logger.info("No compiler getFlags detected.");
        }
        int rc = 0;
        if (this.builtinSIProcessors.size() == 0 && this.templateBasedSIProcessors.size() == 0) {
            logger.error("No generators were specified!");
            logger.error("You need to specify at least one builtin generator (using --generator) or one template-based generator (using --template-generator).");
            rc = 1;
        }
        if (rc == 0) {
            SingleFileCompiler sfCompiler = new SingleFileCompiler();
            for (String filename : allInputFiles) {
                if ("si".compareTo(FilenameUtils.getExtension(filename)) != 0) continue;
                logger.info("Generating for SI File: " + filename);
                rc |= sfCompiler.compile(filename, this.compilerFlags, this.builtinSIProcessors, this.templateBasedSIProcessors, this.builtinPostProcessors, this.templateBasedPostProcessors, this.templateLocations);
            }
        }
        return rc;
    }

    private void addAllInputFilesToList(List<String> listToAddTo) {
        listToAddTo.addAll(this.inputFiles);
    }

    private void addAllInputDirsToList(List<String> listToAddTo) {
        for (String inputDir : this.inputDirs) {
            ArrayList<String> listOfFiles = new ArrayList<String>();
            this.directoryToList(inputDir, listOfFiles);
            listToAddTo.addAll(listOfFiles);
        }
    }

    private void directoryToList(String inputDir, List<String> outList) {
        File folder = new File(inputDir);
        if (!folder.isDirectory()) {
            logger.warn("{} is not a directory! Ignoring it...", (Object)inputDir);
            return;
        }
        File[] listOfFiles = folder.listFiles();
        if (listOfFiles == null) {
            logger.warn("{} is an empty directory! Ignoring it...", (Object)inputDir);
            return;
        }
        for (File file : listOfFiles) {
            if (file.isDirectory()) {
                this.directoryToList(file.toString(), outList);
                continue;
            }
            if (!file.isFile()) continue;
            Path path = Paths.get(inputDir, file.getName());
            outList.add(path.toString());
        }
    }

    public void addCompilerFlags(List<String> compilerFlags) {
        this.compilerFlags.addAll(compilerFlags);
    }

    public void addBuiltinSIProcessors(List<String> builtinSIProcessors) {
        this.builtinSIProcessors.addAll(builtinSIProcessors);
    }

    public void addBuiltinSIProcessor(String builtInSIProcessor) {
        this.builtinSIProcessors.add(builtInSIProcessor);
    }

    public void addTemplateBasedSIProcessors(List<String> templateBasedSIProcessors) {
        this.templateBasedSIProcessors.addAll(templateBasedSIProcessors);
    }

    public void addTemplateBasedSIProcessor(String templateBasedSIProcessor) {
        this.templateBasedSIProcessors.add(templateBasedSIProcessor);
    }

    public void addBuiltinPostProcessors(List<String> builtinPostProcessors) {
        this.builtinSIProcessors.addAll(builtinPostProcessors);
    }

    public void addBuiltinPostProcessor(String builtInPostProcessor) {
        this.builtinSIProcessors.add(builtInPostProcessor);
    }

    public void addTemplateBasedPostProcessors(List<String> templateBasedPostProcessors) {
        this.templateBasedPostProcessors.addAll(templateBasedPostProcessors);
    }

    public void addTemplateBasedPostProcessor(String templateBasedPostProcessor) {
        this.templateBasedPostProcessors.add(templateBasedPostProcessor);
    }

    public void addTemplateLocations(List<String> templateLocations) {
        this.templateLocations.addAll(templateLocations);
    }

    public void addTemplateLocation(String templateLocation) {
        this.templateLocations.add(templateLocation);
    }
}

