/*
 * Decompiled with CFR 0.152.
 */
package net.sf.extcos.internal;

import net.sf.extcos.filter.ChainedConnector;
import net.sf.extcos.filter.Connector;
import net.sf.extcos.filter.MultiplexingConnector;
import net.sf.extcos.internal.StandardMultiplexingConnector;
import net.sf.extcos.util.Assert;
import net.sf.extcos.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractChainedConnector
implements ChainedConnector {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    protected Connector connector;
    protected int childCount;

    @Override
    public void setChildCount(int childCount) {
        try {
            Assert.greaterThan(childCount, 1, Assert.iae(), StringUtils.append("childCount must at least be 2, but was ", childCount));
            this.childCount = childCount;
            if (this.logger.isTraceEnabled()) {
                this.logger.trace(StringUtils.append("successfully set childCount to ", childCount));
            }
        }
        catch (IllegalArgumentException e) {
            this.logger.debug("couldn't set childCount", e);
        }
    }

    @Override
    public void setParentConnector(Connector connector) {
        try {
            Assert.notNull(connector, Assert.iae(), "connector must not be null");
            this.connector = connector;
            if (this.logger.isTraceEnabled()) {
                this.logger.trace(StringUtils.append("successfully set parent connector to ", connector));
            }
        }
        catch (IllegalArgumentException e) {
            this.logger.debug("couldn't set parent connector", e);
        }
    }

    @Override
    public Connector getParentConnector() {
        return this.connector;
    }

    @Override
    public void merge(Connector connector) {
        try {
            Assert.notNull(connector, Assert.iae(), "connector must not be null");
            if (this.connector instanceof MultiplexingConnector) {
                ((MultiplexingConnector)this.connector).merge(connector);
            } else {
                StandardMultiplexingConnector tmp = new StandardMultiplexingConnector();
                tmp.addConnector(this.connector);
                tmp.addConnector(connector);
                this.connector = tmp;
            }
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("successfully merged parent connectors");
            }
        }
        catch (IllegalArgumentException e) {
            this.logger.debug("couldn't merge parent connectors", e);
        }
    }
}

