/*
 * Decompiled with CFR 0.152.
 */
package net.sf.extcos.internal;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import net.sf.extcos.collection.BlacklistAwareIterator;
import net.sf.extcos.collection.BlacklistAwareSet;
import net.sf.extcos.collection.IteratorCreationListener;
import net.sf.extcos.internal.ArraySet;
import net.sf.extcos.internal.BlacklistAwareSetImpl;
import net.sf.extcos.internal.RandomPollingArraySet;
import net.sf.extcos.resource.Resource;

public class BlacklistManager {
    private static BlacklistManager instance;
    private final ConcurrentSkipListSet<SoftReference<BlacklistAwareSet<Resource>>> managedSets = new ConcurrentSkipListSet();
    private final ReferenceQueue<BlacklistAwareSet<Resource>> setReferenceQueue = new ReferenceQueue();
    private final ConcurrentSkipListSet<SoftReference<BlacklistAwareIterator<Resource>>> managedIterators = new ConcurrentSkipListSet();
    private final ReferenceQueue<BlacklistAwareIterator<Resource>> iteratorReferenceQueue = new ReferenceQueue();

    private BlacklistManager() {
    }

    public static BlacklistManager getInstance() {
        if (instance == null) {
            instance = new BlacklistManager();
        }
        return instance;
    }

    public synchronized void blacklist(Resource resource) {
        this.blacklistOnIterators(resource);
        this.blacklistOnSets(resource);
    }

    private void blacklistOnIterators(Resource resource) {
        Iterator<SoftReference<BlacklistAwareIterator<Resource>>> iteratorIterator = this.managedIterators.iterator();
        while (iteratorIterator.hasNext()) {
            SoftReference<BlacklistAwareIterator<Resource>> reference = iteratorIterator.next();
            BlacklistAwareIterator<Resource> iterator = reference.get();
            if (iterator == null || reference.isEnqueued()) {
                iteratorIterator.remove();
                continue;
            }
            iterator.addToBlacklist(resource);
        }
    }

    private void blacklistOnSets(Resource resource) {
        Iterator<SoftReference<BlacklistAwareSet<Resource>>> setIterator = this.managedSets.iterator();
        while (setIterator.hasNext()) {
            SoftReference<BlacklistAwareSet<Resource>> reference = setIterator.next();
            BlacklistAwareSet<Resource> iterator = reference.get();
            if (iterator == null || reference.isEnqueued()) {
                setIterator.remove();
                continue;
            }
            iterator.addToBlacklist(resource);
        }
    }

    public Set<Resource> newResultSet() {
        RandomPollingArraySet resources = new RandomPollingArraySet();
        ArraySet blacklist = new ArraySet();
        BlacklistAwareSetImpl<Resource> set = new BlacklistAwareSetImpl<Resource>(resources, blacklist);
        set.setIteratorCreationListener(new IteratorCreationListener<Resource>(){

            @Override
            public void created(BlacklistAwareIterator<Resource> iterator) {
                BlacklistManager.this.manageIterator(iterator);
            }
        });
        this.managedSets.add(new SoftReference<BlacklistAwareSet<Resource>>(set, this.setReferenceQueue));
        return set;
    }

    private void manageIterator(BlacklistAwareIterator<Resource> iterator) {
        this.managedIterators.add(new SoftReference<BlacklistAwareIterator<Resource>>(iterator, this.iteratorReferenceQueue));
    }
}

