/*
 * Decompiled with CFR 0.152.
 */
package net.sf.extcos.internal;

import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Random;
import net.sf.extcos.collection.RandomPollingSet;
import net.sf.extcos.exception.UnsuccessfulOperationException;
import net.sf.extcos.internal.ArraySet;

public class RandomPollingArraySet<E>
extends ArraySet<E>
implements RandomPollingSet<E> {
    private static final long serialVersionUID = -5304262039454673339L;

    public RandomPollingArraySet() {
    }

    public RandomPollingArraySet(int initialCapacity) {
        super(initialCapacity);
    }

    public RandomPollingArraySet(Collection<? extends E> c) {
        super(c);
    }

    @Override
    public Iterator<E> iterator() {
        RandomPollingArraySet workingCopy = new RandomPollingArraySet();
        for (int i = 0; i < this.size(); ++i) {
            workingCopy.add(this.get(i));
        }
        Itr itr = new Itr();
        itr.workingCopy = workingCopy;
        return itr;
    }

    @Override
    public E pollRandom() {
        int size = this.size();
        if (size == 0) {
            throw new UnsuccessfulOperationException();
        }
        if (size == 1) {
            return this.remove(0);
        }
        Random prng = new Random();
        double d = prng.nextDouble() * (double)size;
        return this.remove((int)d == size ? size - 1 : (int)Math.floor(d));
    }

    private class Itr
    implements Iterator<E> {
        private RandomPollingArraySet<E> workingCopy;

        private Itr() {
        }

        @Override
        public boolean hasNext() {
            return this.workingCopy.size() > 0;
        }

        @Override
        public E next() {
            if (this.hasNext()) {
                return this.workingCopy.pollRandom();
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

