/*
 * Decompiled with CFR 0.152.
 */
package net.sf.extcos.internal;

import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.extcos.classgeneration.ClassGenerationListener;
import net.sf.extcos.exception.ConcurrentInspectionException;
import net.sf.extcos.resource.Resource;
import net.sf.extcos.spi.AnnotationMetadata;
import net.sf.extcos.spi.ResourceAccessor;
import net.sf.extcos.spi.ResourceType;
import net.sf.extcos.util.Assert;
import net.sf.extcos.util.StringUtils;

public class URLResource
implements Resource {
    private final URL resourceUrl;
    private final ResourceType resourceType;
    private ResourceAccessor resourceAccessor;
    private final Object inspectionMutex = new Object();
    private boolean inspected;
    private final List<ClassGenerationListener> listeners = new ArrayList<ClassGenerationListener>();
    private final Map<Class<? extends Annotation>, AnnotationMetadata> metadataCache = new HashMap<Class<? extends Annotation>, AnnotationMetadata>();

    public URLResource(ResourceType resourceType, URL resouceUrl) {
        Assert.notNull(resourceType, IllegalArgumentException.class);
        Assert.notNull(resouceUrl, IllegalArgumentException.class);
        this.resourceType = resourceType;
        this.resourceUrl = resouceUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AnnotationMetadata getAnnotationMetadata(Class<? extends Annotation> annotation) throws ConcurrentInspectionException {
        this.acquireLock();
        try {
            if (this.metadataCache.containsKey(annotation)) {
                AnnotationMetadata annotationMetadata = this.metadataCache.get(annotation);
                return annotationMetadata;
            }
            AnnotationMetadata metadata = this.getResourceAccessor().getAnnotationMetadata(annotation);
            this.metadataCache.put(annotation, metadata);
            AnnotationMetadata annotationMetadata = metadata;
            return annotationMetadata;
        }
        finally {
            this.releaseLock();
        }
    }

    @Override
    public void generateAndDispatchClass() {
        Class<?> clazz = this.getResourceAccessor().generateClass();
        for (ClassGenerationListener listener : this.listeners) {
            listener.classGenerated(clazz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasInterface(Class<?> interfaze) throws ConcurrentInspectionException {
        this.acquireLock();
        try {
            boolean bl = this.getResourceAccessor().hasInterface(interfaze);
            return bl;
        }
        finally {
            this.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSubclassOf(Class<?> clazz) throws ConcurrentInspectionException {
        this.acquireLock();
        try {
            boolean bl = this.getResourceAccessor().isSubclassOf(clazz);
            return bl;
        }
        finally {
            this.releaseLock();
        }
    }

    private ResourceAccessor getResourceAccessor() {
        if (this.resourceAccessor == null) {
            this.resourceAccessor = this.resourceType.getResourceAccessor();
            this.resourceAccessor.setResourceUrl(this.resourceUrl);
        }
        return this.resourceAccessor;
    }

    @Override
    public void addClassGenerationListener(ClassGenerationListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void acquireLock() throws ConcurrentInspectionException {
        Object object = this.inspectionMutex;
        synchronized (object) {
            if (this.inspected) {
                throw new ConcurrentInspectionException(this.toString());
            }
            this.inspected = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseLock() {
        Object object = this.inspectionMutex;
        synchronized (object) {
            this.inspected = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isClass() throws ConcurrentInspectionException {
        this.acquireLock();
        try {
            boolean bl = this.getResourceAccessor().isClass();
            return bl;
        }
        finally {
            this.releaseLock();
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.resourceUrl == null ? 0 : this.resourceUrl.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        URLResource other = (URLResource)obj;
        return !(this.resourceUrl == null ? other.resourceUrl != null : !this.resourceUrl.equals(other.resourceUrl));
    }

    public String toString() {
        return StringUtils.append("URL [", this.resourceUrl, "]");
    }
}

