/*
 * Decompiled with CFR 0.152.
 */
package net.sf.extcos.selector.annotation;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import net.sf.extcos.selector.annotation.ArgumentMapping;
import net.sf.extcos.selector.annotation.ArgumentMappingJunction;
import net.sf.extcos.spi.AnnotationMetadata;
import net.sf.extcos.util.Assert;

public class ArgumentMappingDisjunction
implements ArgumentMappingJunction {
    private final Set<ArgumentMapping> mappings;

    public ArgumentMappingDisjunction(ArgumentMapping ... mappings) {
        Assert.notEmpty(mappings, IllegalArgumentException.class);
        this.mappings = new HashSet<ArgumentMapping>(Arrays.asList(mappings));
    }

    @Override
    public boolean isSetIn(AnnotationMetadata annotation) {
        for (ArgumentMapping mapping : this.mappings) {
            if (!mapping.isSetIn(annotation)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<ArgumentMapping> getMappings() {
        return this.mappings;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.mappings == null ? 0 : ((Object)this.mappings).hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ArgumentMappingDisjunction other = (ArgumentMappingDisjunction)obj;
        return !(this.mappings == null ? other.mappings != null : !((Object)this.mappings).equals(other.mappings));
    }
}

