/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.transfer.dependencies.collect.internal;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.shared.transfer.dependencies.DependableCoordinate;
import org.apache.maven.shared.transfer.dependencies.collect.CollectorResult;
import org.apache.maven.shared.transfer.dependencies.collect.DependencyCollector;
import org.apache.maven.shared.transfer.dependencies.collect.DependencyCollectorException;
import org.apache.maven.shared.transfer.dependencies.collect.internal.Invoker;
import org.apache.maven.shared.transfer.dependencies.collect.internal.Maven31CollectorResult;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.ArtifactTypeRegistry;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.collection.DependencyCollectionException;

@Component(role=DependencyCollector.class, hint="maven31")
class Maven31DependencyCollector
implements DependencyCollector {
    @Requirement
    private RepositorySystem repositorySystem;
    @Requirement
    private ArtifactHandlerManager artifactHandlerManager;

    Maven31DependencyCollector() {
    }

    @Override
    public CollectorResult collectDependencies(ProjectBuildingRequest buildingRequest, Dependency root) throws DependencyCollectorException {
        ArtifactTypeRegistry typeRegistry = (ArtifactTypeRegistry)Invoker.invoke(RepositoryUtils.class, "newArtifactTypeRegistry", ArtifactHandlerManager.class, (Object)this.artifactHandlerManager);
        CollectRequest request = new CollectRequest();
        request.setRoot(Maven31DependencyCollector.toDependency(root, typeRegistry));
        return this.collectDependencies(buildingRequest, request);
    }

    @Override
    public CollectorResult collectDependencies(ProjectBuildingRequest buildingRequest, DependableCoordinate root) throws DependencyCollectorException {
        ArtifactHandler artifactHandler = this.artifactHandlerManager.getArtifactHandler(root.getType());
        String extension = artifactHandler != null ? artifactHandler.getExtension() : null;
        DefaultArtifact aetherArtifact = new DefaultArtifact(root.getGroupId(), root.getArtifactId(), root.getClassifier(), extension, root.getVersion());
        CollectRequest request = new CollectRequest();
        request.setRoot(new org.eclipse.aether.graph.Dependency((Artifact)aetherArtifact, null));
        return this.collectDependencies(buildingRequest, request);
    }

    @Override
    public CollectorResult collectDependencies(ProjectBuildingRequest buildingRequest, Model root) throws DependencyCollectorException {
        ArtifactHandler artifactHandler = this.artifactHandlerManager.getArtifactHandler(root.getPackaging());
        String extension = artifactHandler != null ? artifactHandler.getExtension() : null;
        DefaultArtifact aetherArtifact = new DefaultArtifact(root.getGroupId(), root.getArtifactId(), extension, root.getVersion());
        CollectRequest request = new CollectRequest();
        request.setRoot(new org.eclipse.aether.graph.Dependency((Artifact)aetherArtifact, null));
        ArtifactTypeRegistry typeRegistry = (ArtifactTypeRegistry)Invoker.invoke(RepositoryUtils.class, "newArtifactTypeRegistry", ArtifactHandlerManager.class, (Object)this.artifactHandlerManager);
        ArrayList<org.eclipse.aether.graph.Dependency> aetherDependencies = new ArrayList<org.eclipse.aether.graph.Dependency>(root.getDependencies().size());
        for (Dependency mavenDependency : root.getDependencies()) {
            aetherDependencies.add(Maven31DependencyCollector.toDependency(mavenDependency, typeRegistry));
        }
        request.setDependencies(aetherDependencies);
        if (root.getDependencyManagement() != null) {
            ArrayList<org.eclipse.aether.graph.Dependency> aetherManagerDependencies = new ArrayList<org.eclipse.aether.graph.Dependency>(root.getDependencyManagement().getDependencies().size());
            for (Dependency mavenDependency : root.getDependencyManagement().getDependencies()) {
                aetherManagerDependencies.add(Maven31DependencyCollector.toDependency(mavenDependency, typeRegistry));
            }
            request.setManagedDependencies(aetherManagerDependencies);
        }
        return this.collectDependencies(buildingRequest, request);
    }

    private CollectorResult collectDependencies(ProjectBuildingRequest buildingRequest, CollectRequest request) throws DependencyCollectorException {
        RepositorySystemSession session = (RepositorySystemSession)Invoker.invoke(buildingRequest, "getRepositorySession");
        List aetherRepositories = (List)Invoker.invoke(RepositoryUtils.class, "toRepos", List.class, buildingRequest.getRemoteRepositories());
        request.setRepositories(aetherRepositories);
        try {
            return new Maven31CollectorResult(this.repositorySystem.collectDependencies(session, request));
        }
        catch (DependencyCollectionException e) {
            throw new DependencyCollectorException(e.getMessage(), e);
        }
    }

    private static org.eclipse.aether.graph.Dependency toDependency(Dependency root, ArtifactTypeRegistry typeRegistry) throws DependencyCollectorException {
        Class[] argClasses = new Class[]{Dependency.class, ArtifactTypeRegistry.class};
        Object[] args = new Object[]{root, typeRegistry};
        return (org.eclipse.aether.graph.Dependency)Invoker.invoke(RepositoryUtils.class, "toDependency", argClasses, args);
    }
}

