/*
 * Decompiled with CFR 0.152.
 */
package net.sf.extcos.internal;

import java.io.Serializable;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.RandomAccess;
import java.util.Set;
import net.sf.extcos.exception.UnsuccessfulOperationException;

public class ArraySet<E>
extends AbstractSet<E>
implements Serializable,
Cloneable,
RandomAccess {
    private static final long serialVersionUID = 6518404858591999463L;
    private ArrayList<E> list;

    public ArraySet() {
        this.list = new ArrayList();
    }

    public ArraySet(int initialCapacity) {
        this.list = new ArrayList(initialCapacity);
    }

    public ArraySet(Collection<? extends E> c) {
        if (c instanceof Set) {
            this.list = new ArrayList<E>(c);
        } else {
            this.list = new ArrayList(c.size() / 2);
            for (E name : c) {
                try {
                    this.add(name);
                }
                catch (IllegalArgumentException e) {}
            }
            this.list.trimToSize();
        }
    }

    @Override
    public boolean add(E element) {
        if (element == null) {
            throw new IllegalArgumentException();
        }
        if (this.contains(element)) {
            return false;
        }
        return this.list.add(element);
    }

    public void add(int index, E element) {
        if (element == null) {
            throw new IllegalArgumentException();
        }
        if (this.contains(element)) {
            throw new UnsuccessfulOperationException();
        }
        this.list.add(index, element);
    }

    @Override
    public boolean contains(Object element) {
        if (element == null) {
            throw new IllegalArgumentException();
        }
        return this.list.contains(element);
    }

    @Override
    public Iterator<E> iterator() {
        return this.list.iterator();
    }

    @Override
    public int size() {
        return this.list.size();
    }

    public void trimToSize() {
        this.list.trimToSize();
    }

    public void ensureCapacity(int minCapacity) {
        this.list.ensureCapacity(minCapacity);
    }

    public int indexOf(E element) {
        if (element == null) {
            throw new IllegalArgumentException();
        }
        return this.list.indexOf(element);
    }

    public ArraySet<E> clone() {
        try {
            ArraySet set = (ArraySet)super.clone();
            set.list = new ArrayList<E>(this.list);
            return set;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.list.toArray(a);
    }

    public E get(int index) {
        return this.list.get(index);
    }

    public E set(int index, E element) {
        if (element == null) {
            throw new IllegalArgumentException();
        }
        if (this.contains(element)) {
            throw new UnsuccessfulOperationException();
        }
        return this.list.set(index, element);
    }

    public E remove(int index) {
        E element = this.list.remove(index);
        this.trimToSize();
        return element;
    }

    @Override
    public boolean remove(Object element) {
        if (element == null) {
            throw new IllegalArgumentException();
        }
        boolean success = this.list.remove(element);
        this.trimToSize();
        return success;
    }

    @Override
    public void clear() {
        this.list.clear();
        this.trimToSize();
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean changed = false;
        for (E name : c) {
            try {
                changed |= this.add(name);
            }
            catch (IllegalArgumentException e) {}
        }
        return changed;
    }

    public boolean addAll(int index, Collection<? extends E> c) {
        boolean changed = false;
        ArraySet<E> set = new ArraySet<E>(c);
        if (set.size() > 0) {
            for (E e2 : set) {
                try {
                    this.add(index, e2);
                    changed = true;
                    ++index;
                }
                catch (UnsuccessfulOperationException e) {}
            }
        }
        return changed;
    }

    public boolean replace(E oldElement, E newElement) {
        E result;
        if (oldElement == null || newElement == null) {
            throw new IllegalArgumentException();
        }
        boolean changed = false;
        int index = this.indexOf(oldElement);
        if (index > -1 && (result = this.set(index, newElement)).equals(oldElement)) {
            changed = true;
        }
        return changed;
    }
}

