/*
 * Decompiled with CFR 0.152.
 */
package net.sf.extcos.selector;

import java.util.Set;
import net.sf.extcos.internal.ArraySet;
import net.sf.extcos.internal.EnumBasedReturning;
import net.sf.extcos.internal.Returning;
import net.sf.extcos.selector.DirectReturning;
import net.sf.extcos.selector.ReturningSelector;
import net.sf.extcos.selector.StoreBinding;
import net.sf.extcos.selector.StoreReturning;
import net.sf.extcos.spi.ResourceResolver;
import net.sf.extcos.util.Assert;

public class ForwardingBuilder {
    private final Set<ResourceResolver> resourceResolvers = new ArraySet<ResourceResolver>();
    private final Set<StoreBinding> storeBindings = new ArraySet<StoreBinding>();
    private final ReturningSelector returningSelector = new ReturningSelector();
    private DirectReturning returning = new EnumBasedReturning(Returning.ALL);
    private boolean calledAndStore;
    private boolean calledReturning;
    private boolean calledUsing;

    public ForwardingBuilder using(ResourceResolver ... resourceResolvers) {
        Assert.state(this.firstEntry() && !this.calledUsing);
        Assert.notEmpty(resourceResolvers, Assert.iae());
        ResourceResolver[] resourceResolverArray = resourceResolvers;
        int n = resourceResolvers.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceResolver resourceResolver = resourceResolverArray[n2];
            this.resourceResolvers.add(resourceResolver);
            ++n2;
        }
        this.calledUsing = true;
        return this;
    }

    public ReturningSelector andStore(StoreBinding ... bindings) {
        Assert.state(this.firstEntry());
        Assert.notEmpty(bindings, Assert.iae());
        StoreBinding[] storeBindingArray = bindings;
        int n = bindings.length;
        int n2 = 0;
        while (n2 < n) {
            StoreBinding storeBinding = storeBindingArray[n2];
            this.storeBindings.add(storeBinding);
            ++n2;
        }
        this.calledAndStore = true;
        return this.returningSelector;
    }

    public void returning(DirectReturning returning) {
        Assert.state(this.firstEntry());
        Assert.notNull(returning, Assert.iae());
        this.returning = returning;
        this.calledReturning = true;
    }

    public Set<ResourceResolver> getResourceResolvers() {
        return this.resourceResolvers;
    }

    public Set<StoreBinding> getStoreBindings() {
        return this.storeBindings;
    }

    public StoreReturning getReturning() {
        if (this.calledAndStore) {
            return this.returningSelector.getStoreReturning();
        }
        return this.returning;
    }

    private boolean firstEntry() {
        return !this.calledAndStore && !this.calledReturning;
    }
}

