/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.shade.resource;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.LinkedList;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import org.apache.maven.plugins.shade.relocation.Relocator;
import org.apache.maven.plugins.shade.resource.ResourceTransformer;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.WriterFactory;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.XmlStreamWriter;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.codehaus.plexus.util.xml.Xpp3DomWriter;

public class PluginXmlResourceTransformer
implements ResourceTransformer {
    private List<Xpp3Dom> mojos = new LinkedList<Xpp3Dom>();
    public static final String PLUGIN_XML_PATH = "META-INF/maven/plugin.xml";

    @Override
    public boolean canTransformResource(String resource) {
        return PLUGIN_XML_PATH.equals(resource);
    }

    @Override
    public void processResource(String resource, InputStream is, List<Relocator> relocators) throws IOException {
        Xpp3Dom newDom;
        try {
            BufferedInputStream bis = new BufferedInputStream(is){

                @Override
                public void close() throws IOException {
                }
            };
            XmlStreamReader reader = ReaderFactory.newXmlReader(bis);
            newDom = Xpp3DomBuilder.build(reader);
        }
        catch (Exception e) {
            throw (IOException)new IOException("Error parsing plugin.xml in " + is).initCause(e);
        }
        if (newDom.getChild("mojos") == null) {
            return;
        }
        for (Xpp3Dom mojo : newDom.getChild("mojos").getChildren("mojo")) {
            Xpp3Dom requirements;
            Xpp3Dom configuration;
            String impl = PluginXmlResourceTransformer.getValue(mojo, "implementation");
            impl = this.getRelocatedClass(impl, relocators);
            PluginXmlResourceTransformer.setValue(mojo, "implementation", impl);
            Xpp3Dom parameters = mojo.getChild("parameters");
            if (parameters != null) {
                for (Xpp3Dom parameter : parameters.getChildren()) {
                    String type = PluginXmlResourceTransformer.getValue(parameter, "type");
                    type = this.getRelocatedClass(type, relocators);
                    PluginXmlResourceTransformer.setValue(parameter, "type", type);
                }
            }
            if ((configuration = mojo.getChild("configuration")) != null) {
                for (Xpp3Dom configurationEntry : configuration.getChildren()) {
                    String implementation = PluginXmlResourceTransformer.getAttribute(configurationEntry, "implementation");
                    implementation = this.getRelocatedClass(implementation, relocators);
                    PluginXmlResourceTransformer.setAttribute(configurationEntry, "implementation", implementation);
                }
            }
            if ((requirements = mojo.getChild("requirements")) != null && requirements.getChildCount() > 0) {
                for (Xpp3Dom requirement : requirements.getChildren()) {
                    String requiredRole = PluginXmlResourceTransformer.getValue(requirement, "role");
                    requiredRole = this.getRelocatedClass(requiredRole, relocators);
                    PluginXmlResourceTransformer.setValue(requirement, "role", requiredRole);
                }
            }
            this.mojos.add(mojo);
        }
    }

    @Override
    public void modifyOutputStream(JarOutputStream jos) throws IOException {
        byte[] data = this.getTransformedResource();
        jos.putNextEntry(new JarEntry(PLUGIN_XML_PATH));
        IOUtil.copy(data, (OutputStream)jos);
        this.mojos.clear();
    }

    @Override
    public boolean hasTransformedResource() {
        return !this.mojos.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] getTransformedResource() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(4096);
        XmlStreamWriter writer = WriterFactory.newXmlWriter(baos);
        try {
            Xpp3Dom dom = new Xpp3Dom("plugin");
            Xpp3Dom componentDom = new Xpp3Dom("mojos");
            dom.addChild(componentDom);
            for (Xpp3Dom mojo : this.mojos) {
                componentDom.addChild(mojo);
            }
            Xpp3DomWriter.write(writer, dom);
            ((Writer)writer).close();
            writer = null;
        }
        finally {
            IOUtil.close(writer);
        }
        return baos.toByteArray();
    }

    private String getRelocatedClass(String className, List<Relocator> relocators) {
        if (className != null && className.length() > 0 && relocators != null) {
            for (Relocator relocator : relocators) {
                if (!relocator.canRelocateClass(className)) continue;
                return relocator.relocateClass(className);
            }
        }
        return className;
    }

    private static String getValue(Xpp3Dom dom, String element) {
        Xpp3Dom child = dom.getChild(element);
        return child != null && child.getValue() != null ? child.getValue() : "";
    }

    private static void setValue(Xpp3Dom dom, String element, String value) {
        Xpp3Dom child = dom.getChild(element);
        if (child == null || value == null || value.length() <= 0) {
            return;
        }
        child.setValue(value);
    }

    private static String getAttribute(Xpp3Dom dom, String attribute) {
        return dom.getAttribute(attribute) != null ? dom.getAttribute(attribute) : "";
    }

    private static void setAttribute(Xpp3Dom dom, String attribute, String value) {
        String attr = dom.getAttribute(attribute);
        if (attr == null || value == null || value.length() <= 0) {
            return;
        }
        dom.setAttribute(attribute, value);
    }
}

